<?php

/**
 * init.form7000.php - Send Reservation Modification Request Email
 * Job: 7000
 * Function: 52 (Reservation: Tabs)
 */

require_once(__DIR__ . '/functions.persona.php');
require_once(__DIR__ . '/functions.mail.php');

$resId = isset($_SERVER['argv'][1]) ? $_SERVER['argv'][1] : 0;
$send = isset($_SERVER['argv'][2]) ? $_SERVER['argv'][2] : 0;

if (!$resId) {
    exit('Missing reservation ID parameter');
}

$userId = $_SESSION['userid'];
$userEmail = getContactDetails($userId)['email_address'];
/**
 * If the user is linked to an agent then the agency name will be displayed otherwise
 * the user's name will be displayed.
 */
$contactName = agentName(getAgent($userId));
$principalName = $_SESSION['principal_name'];
$principalEmail = $_SESSION['principal_email'];
$resOfficeId = $lDB->get("SELECT rf_res_office_id FROM rf_default", 4);
$emailPopupTelephone = getDefPhoneNumber($resOfficeId);
$faxNumber = getFaxNumber($resOfficeId);

$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/email_popup_external.htm");

$GLOBALS['temp']['formAction'] = "/reservation.php?7000+$resId+1";
$GLOBALS['temp']['emailTo'] = "Property Admin";
$GLOBALS['temp']['emailFrom'] = $userEmail;
$GLOBALS['temp']['emailSubject'] = "$contactName - Modification request for reservation $resId";
$GLOBALS['temp']['hasAttachment'] = "collapse";
$GLOBALS['temp']['auto_cc_class'] = "";
$GLOBALS['temp']['auto_cc'] = "";
$GLOBALS['temp']['emailBody'] = "";
$GLOBALS['temp']['princName'] = $principalName;
$GLOBALS['temp']['resOffTel'] = $emailPopupTelephone;
$GLOBALS['temp']['fax'] = $faxNumber;

if ($send) {
    $to = $principalEmail;
    $from = $userEmail;
    $cc = $_POST['mail_cc'];
    $subject = $_POST['mail_subj'];
    $body = $_POST['mail_body'];
    $hasCC = !empty($cc);
    $validCC = filter_var($cc, FILTER_VALIDATE_EMAIL);
    $headers = "From: ".$contactName."<$from>\r\n";

    if (!empty($subject) && !empty($body) && (!$hasCC || ($hasCC && $validCC))) {
        if ($hasCC) {
            $to .= ', ' . $cc;
        }

        $error = email($from, $to, $subject, $headers, $body, 0, 0, $resId, $contactName);
		if (!$error) {
            $flagModRequest = "UPDATE rv_reservation
            SET rv_mod_request_yn = 1, rv_mod_request_date = NOW()
            WHERE rv_reservation_ix = '$resId'";
            $lDB->put($flagModRequest);
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Your email has been sent.');} window.close();</script></body></html>";
		} else {
			echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
		}
    } else {
        echo "<script language=\"javascript\">if(opener && !opener.closed){opener.openMessage('Error sending email!');} window.close();</script></body></html>";
    }
}