<?php
/*
 * $Id: init.form71.php,v 1.11 2011-05-17 14:08:34 light Exp $
 *
 * $Log: init.form71.php,v $
 * Revision 1.11  2011-05-17 14:08:34  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.10  2008-08-21 14:52:56  light
 * Bug #6513 - Access control
 *
 * Revision 1.9  2007-07-24 13:26:00  gregs
 * Bug #6031 - Cannot save user access changes
 *
 * Revision 1.8  2007-02-07 18:22:26  light
 * Bug #5579 - New System Cache
 *
 * Revision 1.7  2006-11-08 14:19:31  light
 * Bug #5579 - New System Cache
 *
 * Revision 1.6  2004-11-22 08:42:46  light
 * Copy REL_3_2_3 -> HEAD
 *
 * Revision 1.4.54.1  2004/10/20 11:03:15  light
 * Fixes to access control / etc
 *
 * Revision 1.4  2004/04/20 07:59:15  tvdspuy
 * bug # 1862
 *
 * Revision 1.3  2004/02/20 10:12:46  light
 * Cleaned up code
 *
 */

/**
 * Form 71 - Access control properties/accommodation popup
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/access_prop.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

if(isMasterDB() && checkJob(148)) {
	$GLOBALS['temp']['allowSave'] = "button";
	$GLOBALS['temp']['buttonCloseName'] = "Cancel";
	$allowEdit = true;
} else {
	$GLOBALS['temp']['allowSave'] = "collapse";
	$GLOBALS['temp']['buttonCloseName'] = "Close";
	$allowEdit = false;
}

#--------------------------------------------
# Get all selection filters/parameters
#--------------------------------------------
$jobid = $_SERVER['argv'][0];
$sc_group_id = $_SERVER['argv'][1];
$accommAccess = $_SERVER['argv'][2];
$propAccess = $_SERVER['argv'][3];
$closeonsave = $_SERVER['argv'][4];

$GLOBALS['temp']['sc_group_id'] = $sc_group_id;

$accommValues = explode(":",$accommAccess);
$propValues = explode(":",$propAccess);

$result = $GLOBALS['lDB'] -> get("SELECT sc_grp_code, sc_grp_desc FROM sc_group WHERE sc_group_id = '$sc_group_id'",1);
$GLOBALS['temp']['sc_grp_code'] = $result['sc_grp_code'];
$GLOBALS['temp']['sc_grp_desc'] = $result['sc_grp_desc'];

####################################
# Get list of authorized properties
####################################
$propArray = $GLOBALS['lDB'] -> get("
	SELECT
		ac_accomm_type.pr_business_id,
		ac_accomm_type.ac_accomm_type_inactive_yn,
		pr_business.pr_bus_inactive_yn,
		sc_accomm.sc_group_id
	FROM
		sc_accomm
		INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
		INNER JOIN pr_business ON ac_accomm_type.pr_business_id = pr_business.pr_business_id
	GROUP BY
		ac_accomm_type.pr_business_id,
		ac_accomm_type.ac_accomm_type_inactive_yn,
		pr_business.pr_bus_inactive_yn,
		sc_accomm.sc_group_id
	HAVING
		ac_accomm_type.ac_accomm_type_inactive_yn=0
		AND pr_business.pr_bus_inactive_yn=0
		AND sc_accomm.sc_group_id='$sc_group_id'
",2);
$propRows = sizeof($propArray);

#####################################
# Get list of authorized accomm types
#####################################
$accommArray = $GLOBALS['lDB'] -> get("
	SELECT
		sc_accomm.ac_accomm_type_id,
		ac_accomm_type.pr_business_id
	FROM
		sc_accomm
		INNER JOIN ac_accomm_type ON sc_accomm.ac_accomm_type_id = ac_accomm_type.ac_accomm_type_ix
	WHERE
		sc_accomm.sc_group_id='$sc_group_id'
	ORDER BY
		ac_accomm_type.pr_business_id,
		ac_accomm_type.ac_accomm_sequence
",2);
$accommRows = sizeof($accommArray);

# Get an array properties this group can access
# (single dimension used to search for match in 'all properties' array)
$propIds = array();
for($i=0; $i<$propRows; $i++) {
   array_push($propIds,$propArray[$i][0]);
}

# Get an array accomm types this group can access
# (single dimension used to search for match in 'all accomm types' array)
$accommIds = array();
for($i=0; $i<$accommRows; $i++) {
   array_push($accommIds,$accommArray[$i][0]);
}

# Get ordered list of all accomm types
$accommAll = array();
$propertyNameSaved = "";
foreach($GLOBALS['property_id'] as $propid) {
	$propertyName = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$propid'",4);
	$tempacc = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_type_ix,
			ac_accomm_desc,
			ac_accomm_type_inactive_yn
		FROM
			ac_accomm_type
		WHERE
			pr_business_id = '$propid'
		ORDER BY
			ac_accomm_sequence
	",2);

	foreach($tempacc as $accomm) {
		$item = array();
		$item['property_id'] = $propid;
		$item['ac_accomm_id'] = $accomm['ac_accomm_type_ix'];
		$item['ac_accomm_desc'] = $accomm['ac_accomm_desc'];
		if($accomm['ac_accomm_type_inactive_yn'] == "0") {
			$item['accommClass'] = "";
		} else {
			$item['accommClass'] = "txtg";
		}
		if($propertyName != $propertyNameSaved) {
			$item['property_name'] = $propertyName;
		} else {
			$item['property_name'] = "";
		}
		$propertyNameSaved = $propertyName;

		if(in_array($accomm['ac_accomm_type_ix'],$accommIds)) {
			$item['checked'] = " checked";
			$item['value'] = "1";
		} else {
			$item['checked'] = "";
			$item['value'] = "0";
		}
		if(in_array($propid,$propIds)) {
			$item['prop_checked'] = " checked";
		} else {
			$item['prop_checked'] = "";
		}
		array_push($accommAll,$item);
	}
}

#---------------------------------------------------------------------#
# End of Data Access code                                             #
#---------------------------------------------------------------------#

#---------------------------------------------------------------------#
# End of Mike's SQL code                                              #
# $group_details contains array of rows for display                   #
#---------------------------------------------------------------------#

if($jobid == 163) {
	$userAccessAuditTrail = new AuditTrail($sc_group_id,TYPE_USERACCESS);
	for($j=0; $j<sizeof($accommAll); $j++) {
		if(in_array($accommAll[$j]['property_id'],$propValues)) {
			$accommAll[$j]['prop_checked'] = " checked";
		} else {
			$accommAll[$j]['prop_checked'] = "";
		}
	}
	for($i=1; $i<=(sizeof($accommValues)-1); $i++) {
		switch ($accommValues[$i-1]) {
		case "0":
			$level = 0;
			$accommAll [$i-1]['checked'] = "";
			break;
		case "1":
			$level = 1;
			$accommAll [$i-1]['checked'] = "checked";
			break;
		default:
			$level = 0;
			$accommAll [$i-1]['checked'] = "";
			break;
		}

		# Check is a record already exists
		$ac_accomm_type_id = $accommAll[$i-1]['ac_accomm_id'];
		$recordExists = $GLOBALS['lDB'] -> get("SELECT COUNT(*) FROM sc_accomm WHERE ac_accomm_type_id = '$ac_accomm_type_id' AND sc_group_id = '$sc_group_id'",4);

		# If a record exists and level = none (0) then delete record
		#    else insert record
		$groupSQL = "";
		if (checkJob(148)) {
			if($recordExists) {
				if($level == 0) {
					$list = $GLOBALS['lDB']->get("select sc_accomm_id from sc_accomm where ac_accomm_type_id = '$ac_accomm_type_id' AND sc_group_id = '$sc_group_id'",3);
					foreach ($list as $sc_accomm) {
						$GLOBALS['lDB']->put("DELETE FROM sc_accomm WHERE sc_accomm_id = '$sc_accomm'");
						$userAccessAuditTrail->addDetail(
							$accommAll[$i-1]['ac_accomm_desc'] . ": Selected",
							$accommAll[$i-1]['ac_accomm_desc'] . ": Deselected",
							"sc_group_id",
							"sc_group_id",
							3,
							"useraccess",
							"sc_accomm.sc_group_id"
						);
					}
				}
			} else {
				if($level > 0) {
					$GLOBALS['lDB']->put("INSERT INTO sc_accomm (ac_accomm_type_id, sc_group_id) VALUES ('$ac_accomm_type_id', '$sc_group_id')");
					$userAccessAuditTrail->addDetail(
							$accommAll[$i-1]['ac_accomm_desc'] . ": Deselected",
							$accommAll[$i-1]['ac_accomm_desc'] . ": Selected",
							"sc_group_id",
							"sc_group_id",
							1,
							"useraccess",
							"sc_accomm.sc_group_id"
						);
				}
			}
		}
	}
	$adUseraccessId = $userAccessAuditTrail->save("User Access (Prop and Accomm)");
}

if ($closeonsave == "1") {
   echo "<body onload='opener.reloadPage(); window.close();'></body>";
   die();
}

# Generate HTML output
$rows = "";
$propHTML = Join("",File(__DIR__ . "/../../../public/html/access_prop_row.htm"));
$accommHTML = Join("",File(__DIR__ . "/../../../public/html/access_prop_accomm_row.htm"));
foreach($accommAll as $accomm) {
	if($allowEdit) {
		$accomm['editDisable'] = "";
	} else {
		$accomm['editDisable'] = "disabled";
	}
	if($accomm['property_name'] != "") {
		$rows .= showpage($accomm,$propHTML);
	} else {
		$rows .= showpage($accomm,$accommHTML);
	}
}
$GLOBALS['temp']['rows'] = $rows;

/* Clear out the cache */
cacheClear();
