<?php
/*
 * $Id: init.form72.php,v 1.9 2011-05-17 14:08:34 light Exp $
 *
 * $Log: init.form72.php,v $
 * Revision 1.9  2011-05-17 14:08:34  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.8  2007-07-07 14:58:18  light
 * Fixed the access control to ignore inactive users
 *
 * Revision 1.7  2007-02-07 18:22:26  light
 * Bug #5579 - New System Cache
 *
 * Revision 1.6  2006-11-08 14:19:31  light
 * Bug #5579 - New System Cache
 *
 * Revision 1.5  2004-11-22 08:42:46  light
 * Copy REL_3_2_3 -> HEAD
 *
 * Revision 1.2.54.1  2004/10/20 11:03:15  light
 * Fixes to access control / etc
 *
 * Revision 1.2  2004/02/20 10:12:46  light
 * Cleaned up code
 *
 */

/**
 * Form 72 - Access control user list popup
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/access_users.htm");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],4,"");

if(isMasterDB() && checkJob(148)) {
	$GLOBALS['temp']['allowAddUser'] = "";
	$GLOBALS['temp']['allowRemoveUser'] = "";
	$allowEdit = true;
} else {
	$GLOBALS['temp']['allowAddUser'] = "disabled";
	$GLOBALS['temp']['allowRemoveUser'] = "disabled";
	$allowEdit = false;
}
#--------------------------------------------
# Get all selection filters/parameters
#--------------------------------------------
$jobid = $_SERVER['argv'][0];
$sc_group_id = $_SERVER['argv'][1];
$userAccess = $_SERVER['argv'][2];
$action = $_SERVER['argv'][3];

$GLOBALS['temp']['sc_group_id'] = $sc_group_id;

$userValues = explode(":",$userAccess);

$result = $GLOBALS['lDB'] -> get("SELECT sc_grp_code, sc_grp_desc FROM sc_group WHERE sc_group_id = '$sc_group_id'",1);
$GLOBALS['temp']['sc_grp_code'] = $result['sc_grp_code'];
$GLOBALS['temp']['sc_grp_desc'] = $result['sc_grp_desc'];

#---------------------------------------------------------------------#
# Start of Data access code                                           #
#---------------------------------------------------------------------#

# Input parameter for test purposes

#######################################
# Get list of other (unallocated) users
#######################################

$otherSql = "
	SELECT
		pr_user.pr_user_id,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first,
		pr_user.pr_user_inactive_yn
	FROM
		pr_user
		LEFT JOIN sc_user ON pr_user.pr_user_id = sc_user.pr_user_id
		LEFT JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
		INNER JOIN pr_persona ON pr_user.pr_user_id = pr_persona.pr_persona_ix
	WHERE
		sc_group.sc_group_id IS NULL
		AND pr_persona.pr_persona_inactive_yn = '0'
		AND pr_user.pr_user_inactive_yn = '0'
	ORDER BY
		pr_persona.pr_name_last,
		pr_persona.pr_name_first
";

#
# Get the record set
#
$otherArray = array();
$otherArray = $GLOBALS['lDB'] -> get ($otherSql,2);
$otherRows = sizeof($otherArray);

#######################
#  Set up result array
#######################

$usersOther = array();
####################################################
#  LOOP thru other users to obtain relationship data
####################################################

for ($i = 0; $i < $otherRows; $i++) {
	$usersOther[$i]['pr_user_id']  = $otherArray[$i][0];
	$pr_user_id = $otherArray[$i][0];
	$usersOther[$i]['pr_name_last']  = $otherArray[$i] [1];
	$usersOther[$i]['pr_name_first']  = $otherArray[$i] [2];
	if($usersOther[$i]['pr_name_first'] != ""){
		$usersOther[$i]['user_name'] = $usersOther[$i]['pr_name_last'] . ", " . $usersOther[$i]['pr_name_first'];
	} else {
		$usersOther[$i]['user_name'] = $usersOther[$i]['pr_name_last'];
	}

	##########################
	#  Identify relationships
	##########################
	
	$linkSql = "
		SELECT
			pr_persona.pr_name_last,
			pr_link.rf_link_type_id
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_link.pr_link_to = pr_persona.pr_persona_ix
		WHERE
			pr_link.pr_link_from='$pr_user_id'";

	##################
	#  Get record set
	##################
	$otherLinkArray = $GLOBALS['lDB'] -> get($linkSql,"1");
	$linkName = $otherLinkArray[0];
	$linkType = $otherLinkArray[1];
	$usersOther[$i]['linkName'] = $linkName;
	if($linkName != "0") {
		$usersOther[$i]['user_name'] = $usersOther[$i]['user_name']." (".$linkName.")";
	}
	$usersOther[$i]['linkType'] = $linkType;
}

##############################
# Get list of allocated users
##############################

$allocSql = "
	SELECT
		pr_user.pr_user_id,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first,
		pr_user.pr_user_inactive_yn
	FROM
		pr_user
		INNER JOIN sc_user ON pr_user.pr_user_id = sc_user.pr_user_id
		INNER JOIN pr_persona ON pr_user.pr_user_id = pr_persona.pr_persona_ix
	WHERE
		sc_user.sc_group_id = '$sc_group_id'
		AND pr_persona.pr_persona_inactive_yn = '0'
		AND pr_user.pr_user_inactive_yn = '0'
		AND pr_persona.pr_sys_code < 6
	ORDER BY
		pr_persona.pr_name_last,
		pr_persona.pr_name_first
";

#####################
# Get the record set
#####################
$allocArray = array();
$allocArray = $GLOBALS['lDB'] -> get ($allocSql,"2");
$allocRows = sizeof($allocArray);

######################
#  Set up result array
######################
$usersAlloc = array();

####################################################
#  LOOP thru alloc users to obtain relationship data
####################################################
for ($i = 0; $i < $allocRows; $i++) {
	$usersAlloc[$i]['pr_user_id']  = $allocArray[$i][0];
	$pr_user_id = $allocArray[$i][0];
	$usersAlloc[$i]['pr_name_last']  = $allocArray[$i] [1];
	$usersAlloc[$i]['pr_name_first']  = $allocArray[$i] [2];
	if($usersAlloc[$i]['pr_name_first'] != "") {
		$usersAlloc[$i]['user_name'] = $usersAlloc[$i]['pr_name_last'] . ", " . $usersAlloc[$i]['pr_name_first'];
	} else {
		$usersAlloc[$i]['user_name'] = $usersAlloc[$i]['pr_name_last'];
	}

	##########################
	#  Identify relationships
	##########################
	$linkSql = "
		SELECT
			pr_persona.pr_name_last,
			pr_link.rf_link_type_id
		FROM
			pr_link
			INNER JOIN pr_persona ON pr_link.pr_link_to = pr_persona.pr_persona_ix
		WHERE
			pr_link.pr_link_from='$pr_user_id'";
	
	##################
	#  Get record set
	##################
	$allocLinkArray = $GLOBALS['lDB'] -> get($linkSql,"1");
	$linkName = $allocLinkArray[0];
	$linkType = $allocLinkArray[1];
	$usersAlloc[$i]['linkName'] = $linkName;
	if($linkName != "0") {
		$usersAlloc[$i]['user_name'] = $usersAlloc[$i]['user_name']." (".$linkName.")";
	}
	$usersAlloc[$i]['linkType'] = $linkType;
}

#---------------------------------------------------------------------#
# End of Data Access code                                             #
#---------------------------------------------------------------------#

#---------------------------------------------------------------------#
# End of Mike's SQL code                                              #
# $group_details contains array of rows for display                   #
#---------------------------------------------------------------------#

switch ($jobid) {
	case 165:
		if (checkJob(148)) {
			for($i=0; $i<(sizeof($userValues)-1); $i++) {
				# Check is a record already exists
				$pr_user_id = $userValues[$i];

				# If a record exists and level = none (0) then delete record
				#    else insert record
				$sc_user_id_list = $GLOBALS['lDB']->get("
					SELECT
						sc_user_id
					FROM
						sc_user
					WHERE
						pr_user_id = '$pr_user_id'
				",3);
				foreach($sc_user_id_list as $sc_user_id) {
					$GLOBALS['lDB']->put("DELETE FROM sc_user WHERE sc_user_id = '$sc_user_id'");
				}

				if($action) {
					$GLOBALS['lDB']->put("INSERT INTO sc_user (pr_user_id, sc_group_id) VALUES ('$pr_user_id', '$sc_group_id')");
				}
			}
			# Reload the popup with new values
			echo "<body onload=\"window.location='/reservation.php?164+$sc_group_id'\"></body>";
		}
		break;
}

# Generate HTML output
$GLOBALS['temp']['rows'] = "";
$rowsout = "";
$temphtml = Join("",File(__DIR__ . "/../../../public/html/access_users_row_unalloc.htm"));
for($i = 0; $i < $otherRows; $i++) {
	$row_array = $usersOther[$i];
	if($allowEdit) {
		$row_array['disableEdit'] = "";
	} else {
		$row_array['disableEdit'] = "disabled";
	}
	$row = showpage($row_array,$temphtml);
	$rowsout .= $row;
}

# Generate HTML output
$GLOBALS['temp']['rows1'] = "";
$rowsout1 = "";
	$temphtml = Join("",File(__DIR__ . "/../../../public/html/access_users_row_alloc.htm"));
for($i = 0; $i < $allocRows; $i++) {
	$row_array = $usersAlloc[$i];
	if($allowEdit) {
		$row_array['disableEdit'] = "";
	} else {
		$row_array['disableEdit'] = "disabled";
	}
	$row = showpage($row_array,$temphtml);
	$rowsout1 .= $row;
}

$GLOBALS['temp']['rows'] = $rowsout;
$GLOBALS['temp']['rows1'] = $rowsout1;

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);

/* Clear out the cache */
cacheClear();
