<?php
/**
 * init.form73.php - The property maintenance form
 * Job: 166, 167, 168, 169, 170, 171
 * Function: 61 (Business structure)
*/

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

$GLOBALS['bypassAddCheck'] = true;
if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/property_details.htm");
	$fields = array (
		"pr_persona_ix",
		"pr_name_last",
		"pr_title_id",
		"pr_name_suffix_id",
		"pr_email",
		"pr_persona_link_id",
		"pr_persona_fwd_id",
		"pr_corr_addr_line1",
		"pr_corr_addr_line2",
		"pr_corr_addr_line3",
		"pr_corr_post_office_id",
		"pr_corr_country_id",
		"pr_corr_post_code",
		"pr_corr_city",
		"pr_phys_addr_line1",
		"pr_phys_addr_line2",
		"pr_phys_addr_line3",
		"pr_phys_post_office_id",
		"pr_phys_country_id",
		"pr_phys_post_code",
		"pr_phys_city",
		"pr_web_addr",
		"pr_org_yn",
		"rf_comms_preference_id",
		"pr_persona_inactive_yn"
	);
	$ident = array("pr_name_last");
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"pr_persona",$fields,"pr_persona_ix = '$record'","","",$ident);
}

$record = $_SERVER['argv'][1];
$parent = $_SERVER['argv'][2];
if ($parent == "") {
	if ($record != "") {
		$parent = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$record'",4);
	}
}
$GLOBALS['temp']['parent'] = $parent;
$invNumber = $_SERVER['argv'][3];
$newPrefix = $_SERVER['argv'][4];
$saveAction = ($_SERVER['argv'][5] == 1) ? 'Saveclose' : 'Save';

if ($invNumber != "") {
	$fnCount = $GLOBALS['lDB']->get("
		SELECT
			COUNT(fn_invoice.fn_invoice_id) AS count_fn_invoice_id
		FROM
			fn_invoice
			INNER JOIN fn_folio ON fn_folio.fn_invoice_id = fn_invoice.fn_invoice_ix
		WHERE
			fn_folio.pr_business_id = '$record'
			AND fn_invoice.fn_invoice_prefix = '$newPrefix'
	",4);

	$rsUpdateInnerHTML = array();
	$rsUpdateValue = array();

	if ($fnCount > "0") {
		$maxInvNumber = $GLOBALS['lDB']->get("
			SELECT
				MAX(fn_invoice.fn_invoice_id)
			FROM
				fn_invoice
				INNER JOIN fn_folio ON fn_folio.fn_invoice_id = fn_invoice.fn_invoice_ix
			WHERE
				fn_folio.pr_business_id = '$record'
				AND fn_invoice.fn_invoice_prefix = '$newPrefix'
		",4);
		if ($invNumber <= $maxInvNumber) {
			$rsUpdateVar = array();
			$rsUpdateVar["parent.validInvNumber"] = "\"\";";
			$rsFuncList = array("parent.openMessage","'Please enter a start invoice number greater than $maxInvNumber'");
			echo rsOutput($rsUpdateInnerHTML,$rsUpdateValue,$rsUpdateVar,$rsFuncList);
         
		} else {
			$rsUpdateVar = array();
			$rsUpdateVar["parent.validInvNumber"] = "\"$invNumber\";";
			$rsFuncList = array("parent.buttonPress","'".$saveAction."'");
			echo rsOutput($rsUpdateInnerHTML,$rsUpdateValue,$rsUpdateVar,$rsFuncList);
		}
	} else {
		$rsUpdateVar = array();
		$rsUpdateVar["parent.validInvNumber"] = "\"$invNumber\";";
		$rsFuncList = array("parent.buttonPress","'".$saveAction."'");
		echo rsOutput($rsUpdateInnerHTML,$rsUpdateValue,$rsUpdateVar,$rsFuncList);
	}
	die();
}

$GLOBALS['temp']['abbrvList'] = join(":|:",$GLOBALS['lDB']->get("
	SELECT
		pr_bus_name_short
	FROM
		pr_business
	WHERE
		pr_business_id <> '$record'
",3));

$GLOBALS['autovar'] = "1";   # argv index that will be updated with the autoincrement ID after an insert
$GLOBALS[$form]->Get($action);

if ($record != "" || $action == "3" && $action != "1") {
	$table = $GLOBALS[$form]->TableList[0];
	$GLOBALS[$table]->Refresh($_SERVER['argv'][1],$action);
}

$GLOBALS['form73_pr_persona_pr_org_yn']->SetValue(1);

if ($record != "") {
	$GLOBALS['temp']['record'] = (string) $record;
} else {
	$GLOBALS['temp']['record'] = "null";
}

if ($action != "2" || !isset($GLOBALS['temp']['saveclose']) || $GLOBALS['temp']['saveclose'] == "") {
	$GLOBALS['temp']['saveclose'] = "0";
}
if (isset($_POST['saveclose']) && $_POST['saveclose'] == "1") {
	$GLOBALS['temp']['saveclose'] = "1";
}

if ($pmode == "0") {
	$GLOBALS['temp']['hasUnInvFolio'] = "false";
	if (!empty($record) && $lDB->get("
		SELECT
			COUNT(*)
		FROM               
			fn_folio
			LEFT JOIN fn_invoice ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
		WHERE
			fn_invoice.fn_folio_id is NULL
			AND fn_folio.pr_business_id = '$record'
	",4) > "0") $GLOBALS['temp']['hasUnInvFolio'] = "true";
}

// Get logo files
$principal_id = $_SESSION['principal_id'];

$logoFilenameM = "top_client_mkg";
$currId = $record;
while($currId != "0" && trim($currId) != "" && $logoFilenameM == "top_client_mkg") {
	$prefix = strtolower($GLOBALS['lDB']->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$currId'",4));
	$fileName = $prefix . '_mkg';
	$potentialFilename = imageFile($fileName);
	if (!empty($potentialFilename)) {
		$logoFilenameM = $potentialFilename;
	}
	$parentId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
	$currId = $parentId;
}

if ($logoFilenameM == "top_client_mkg") {
	// Couldn't find a prefix image. Look for the default with all possible extensions.
	$logoFilenameM = imageFile($logoFilenameM, false);
}
   
$logoFilenameF = "top_client_fin";
$currId = $record;
while($currId != "0" && trim($currId) != "" && $logoFilenameF == "top_client_fin") {
	$prefix = strtolower($GLOBALS['lDB']->get("SELECT pr_bus_name_short FROM pr_business WHERE pr_business_id = '$currId'",4));
	$fileName = $prefix . '_fin';
	$potentialFilename = imageFile($fileName);
	if (!empty($potentialFilename)) {
		$logoFilenameF = $potentialFilename;
	}
	$parentId = $GLOBALS['lDB']->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
	$currId = $parentId;
}

if ($logoFilenameF == "top_client_fin") {
	// Couldn't find a prefix image. Look for the default with all possible extensions.
	$logoFilenameF = imageFile($logoFilenameF, false);
}

$GLOBALS['temp']['logoFilenameM'] = $logoFilenameM;
$GLOBALS['temp']['logoFilenameF'] = $logoFilenameF;
$GLOBALS['temp']['logoURLM'] = $GLOBALS['http'].$GLOBALS['images_dir']."/".$GLOBALS['principal_id']."/$logoFilenameM";
$GLOBALS['temp']['logoURLF'] = $GLOBALS['http'].$GLOBALS['images_dir']."/".$GLOBALS['principal_id']."/$logoFilenameF";
# In case we want to re-activate this record, and ALL it's children.
if ($pmode == "1") {
	$inactiveFlag = "0";
	$temp = $GLOBALS['lDB']->get("SELECT pr_bus_inactive_yn FROM pr_business WHERE pr_business_id = '$record'",1);
	if ($temp[0] != "0" && $temp[0] != "") {
		$inactiveFlag = "1";
	}
	if ($GLOBALS['form73_pr_persona_pr_persona_inactive_yn']->Value != "0" && $_POST['inactiveFlag'] == "0") {
		if ($inactiveFlag != "0" || $GLOBALS['form73_pr_persona_pr_persona_inactive_yn']->Value != "0") {
			propCanDelete($record);
			$GLOBALS['lDB']->put("UPDATE ac_accomm_type SET ac_accomm_type_inactive_yn = '0' WHERE ac_accomm_type_ix in ('".join("','",$GLOBALS['accommChildList2B'])."')");
			$GLOBALS['lDB']->put("UPDATE pr_business SET pr_bus_inactive_yn  = '0' WHERE pr_business_id in ('".join("','",$GLOBALS['propChildList2B'])."')");
			$GLOBALS['lDB']->put("UPDATE pr_persona SET pr_persona_inactive_yn = '0' WHERE pr_persona_ix in ('".join("','",$GLOBALS['propChildList2B'])."')");
		} else {
			$inactiveFlag = "1";
		}
		$GLOBALS['form73_pr_persona_pr_persona_inactive_yn']->SetValue($inactiveFlag);
	} else {
		$GLOBALS['form73_pr_persona_pr_persona_inactive_yn']->SetValue(isset($_POST['inactiveFlag'])?$_POST['inactiveFlag']:"");
	}
}
if ($pmode == "0") {
	$actVal = "0";
	$inActVal = "1";
	$inactiveFlag = $GLOBALS['form73_pr_persona_pr_persona_inactive_yn']->Value;
	if ($action != "2") {
		$temp = $GLOBALS['lDB']->get("SELECT pr_bus_inactive_yn FROM pr_business WHERE pr_business_id = '$record'",1);
		if ($temp[0] != "0" && $temp[0] != "") {
			$inactiveFlag = "1";
		}
	}

	$GLOBALS[$form]->AddField("inactiveFlag","inactiveFlag",$inactiveFlag,1);
	$actFlag = "inactiveFlag";
	if ($GLOBALS[$actFlag]->Value == $actVal || $action == "2") {
		$GLOBALS[$actFlag]->Value = $actVal;
		$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
		$hidelist = array($actFlag);
	} else {
		if ($record == "" && $action == "1") {
			$GLOBALS['temp']['actInd'] = " style=\"display:none\"";
		} else {
			$GLOBALS[$actFlag]->Value = $inActVal;
			$GLOBALS['temp']['actInd'] = "";
		}
	}
	$GLOBALS[$actFlag]->Select(array("$inActVal-Inactive","$actVal-Active"));
	$GLOBALS[$actFlag]->StyleType = "small";
}

# Get record name
$temp = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$record'",1);
$GLOBALS['temp']['pr_name_last'] = $temp[0];
if($GLOBALS['temp']['pr_name_last'] == "0") { $GLOBALS['temp']['pr_name_last'] = ""; }
# Get parent name
$temp = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$parent'",1);
$GLOBALS['temp']['parent_name'] = $temp[0];

# Display/hide notes icon
$GLOBALS['temp']['nflag'] = "noNotes";
$nflag = $GLOBALS['lDB']->get("SELECT pr_bus_memo_cal,pr_bus_memo_info FROM pr_business WHERE pr_business_id = '$record'",1);
if ((trim(strlen($nflag[0])) > 0 || trim(strlen($nflag[1])) > 0) && $action != "2") {
	$GLOBALS['temp']['nflag'] = "notes";
}

# Display/hide users icon
$GLOBALS['temp']['uflag'] = "noUsers";
$uflag = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		pr_link
		INNER JOIN pr_user ON pr_link.pr_link_from = pr_user.pr_user_id
		INNER JOIN pr_persona ON pr_user.pr_user_id = pr_persona.pr_persona_ix
	WHERE
		rf_link_type_id = 'RS1'
		AND pr_link_to = '$record'
	ORDER BY
		pr_name_last
",1);
if ($uflag[0] > 0) {
	$GLOBALS['temp']['uflag'] = "users";
}

$prefixList = $GLOBALS['lDB']->get("SELECT pr_bus_inv_prefix FROM pr_business WHERE pr_business_id <> '$record'",3);
$prefixJS = "";
$prefixJSCount = 0;
foreach($prefixList as $prefixItem) {
	if(trim($prefixItem) != "") {
		$prefixJS .= "prefixArray[".$prefixJSCount."] = '".t_encodeOverlib($prefixItem)."';\n";
		$prefixJSCount++;
	}
}
$GLOBALS['temp']['prefixList'] = $prefixJS;

$default_statutory_labels = $GLOBALS['lDB']->get("SELECT rf_statutory_label_1, rf_statutory_label_2, rf_statutory_label_3 FROM rf_default",1);

// Added for pr_bus_property_yn checkbox
$sql="
	SELECT
		pr_bus_property_yn,
		pr_bus_name_short,
		pr_bus_home_curr_id,
		pr_bus_billing_yn,
		pr_bus_statutory_1,
		pr_bus_statutory_2,
		pr_bus_statutory_3,
		pr_bus_statutory_label_1,
		pr_bus_statutory_label_2,
		pr_bus_statutory_label_3,
		pr_bus_wetu_id,
		pr_bus_inv_future_ind,
		pr_bus_inv_prefix,
		pr_bus_inv_number,		
		pr_bus_opt_accomm,
		pr_bus_opt_bank,
		pr_bus_opt_cca,
		pr_bus_opt_date,
		pr_bus_opt_special,
		pr_bus_opt_special_note,
		pr_bus_opt_tax,
		pr_bus_opt_tax_table,
		pr_bus_opt_tax_table_gl,
		pr_bus_opt_tax_table_rate,
		pr_bus_opt_tax_table_total,
		pr_bus_opt_terms,
		pr_bus_opt_terms_bus,
		pr_bus_prop_curr_id,
		pr_bus_billing_prop_yn,
		pr_bus_proforma_tax_ind
	FROM
		pr_business
	WHERE
		pr_business_id = '$record'
";
$isProp = $GLOBALS['lDB']->get($sql,1);
$GLOBALS['temp']['isPropYN'] = "";

// Action overview (because this is not documented anywhere else):
// 0: List Records
// 1: Display Record
// 2: Add Record
// 3: Edit Record
// 4: Delete Record

// pmode overview:
// 0: Display Form / Confirmation
// 1: Add / Update / Delete Record DB

// This page does strange things.
// It loads this code twice: once to save the main fields, as specified in the $GLOBALS[$form] $fields array at the top,
// then a second time to save the "secondary" values, such as the property currency.
// It somehow fails to store the pr_bus_prop_curr_id to the DB, so we do it here explicitly, on the second run
if (
	$pmode == 0 &&
	$action == 3 &&
	!empty($record) &&
	isset($_POST['pr_bus_prop_curr_id']) &&
	(
		!isset($isProp['pr_bus_prop_curr_id']) ||
		$isProp['pr_bus_prop_curr_id'] != $_POST['pr_bus_prop_curr_id']
	)
) {
	$GLOBALS['lDB']->put("
		UPDATE pr_business SET
			pr_bus_prop_curr_id = '" . $_POST['pr_bus_prop_curr_id'] . "'
		WHERE
			pr_business_id = '$record'
	");
	$isProp['pr_bus_prop_curr_id'] = $_POST['pr_bus_prop_curr_id'];
}

if (isset($_POST['pr_bus_prop_curr_id'])) {
    $isProp['pr_bus_prop_curr_id'] = $_POST['pr_bus_prop_curr_id'];
}

if (isset($isProp['pr_bus_property_yn']) && $isProp['pr_bus_property_yn'] == "1") {
	$GLOBALS['temp']['isPropYN'] = " checked";
}
$GLOBALS['temp']['hideHC'] = " class=\"collapse\"";

if ($action == "1") {
	$GLOBALS['temp']['isPropYN'] .= " disabled";
}

$isBilling = $isProp['pr_bus_billing_yn'];
$isBillingProp = $isProp['pr_bus_billing_prop_yn'];

$GLOBALS['temp']['invUnitNoneSelected'] = "";
$GLOBALS['temp']['invUnitResPropSelected'] = "";
$GLOBALS['temp']['invUnitResSelected'] = "";
$GLOBALS['temp']['invUnitPropSelected'] = "";
if(!$isBilling && !$isBillingProp) { $GLOBALS['temp']['invUnitNoneSelected'] = "selected"; }
if($isBilling && $isBillingProp) { $GLOBALS['temp']['invUnitResPropSelected'] = "selected"; }
if($isBilling && !$isBillingProp) { $GLOBALS['temp']['invUnitResSelected'] = "selected"; }
if(!$isBilling && $isBillingProp) { $GLOBALS['temp']['invUnitPropSelected'] = "selected"; }

$GLOBALS['temp']['pr_bus_opt_accomm'] = $isProp['pr_bus_opt_accomm'];
$GLOBALS['temp']['pr_bus_opt_bank'] = $isProp['pr_bus_opt_bank'];
$GLOBALS['temp']['pr_bus_opt_cca'] = $isProp['pr_bus_opt_cca'];
$GLOBALS['temp']['pr_bus_opt_date'] = $isProp['pr_bus_opt_date'];
$GLOBALS['temp']['sp_special_desc'] = $isProp['pr_bus_opt_special'];
$GLOBALS['temp']['sp_special_note'] = $isProp['pr_bus_opt_special_note'];
$GLOBALS['temp']['pr_bus_opt_tax'] = $isProp['pr_bus_opt_tax'];
$GLOBALS['temp']['pr_bus_opt_tax_table'] = $isProp['pr_bus_opt_tax_table'];
$GLOBALS['temp']['pr_bus_opt_tax_table_gl'] = $isProp['pr_bus_opt_tax_table_gl'];
$GLOBALS['temp']['pr_bus_opt_tax_table_rate'] = $isProp['pr_bus_opt_tax_table_rate'];
$GLOBALS['temp']['pr_bus_opt_tax_table_total'] = $isProp['pr_bus_opt_tax_table_total'];
$GLOBALS['temp']['pr_bus_opt_terms'] = $isProp['pr_bus_opt_terms'];
$GLOBALS['temp']['pr_bus_opt_terms_bus'] = $isProp['pr_bus_opt_terms_bus'];
   
$force_property = "0";
if (!$GLOBALS['lDB']->count("ac_accomm_type","pr_business_id",$record,0) && $record != "") {
	$force_property = "1";
	if ($action != "1" && $pmode == "0") {
		$GLOBALS['temp']['isPropYN'] .= " disabled";
	}
}

$GLOBALS['temp']['disabled'] = ""; // Used to disable HTML elements if the server is a property environment or it's set to slave.
if(isMasterDB()) {
	if($GLOBALS['isPropServer']) {
		$GLOBALS['temp']['disabled'] = " disabled";
	}
} else {
	$GLOBALS['temp']['disabled'] = " disabled";
}

$GLOBALS[$form]->AddField("pr_bus_home_curr_id","pr_bus_home_curr_id",$isProp['pr_bus_home_curr_id'],0);

$allowGLCurrency = "1";
$invoices = $lDB->get("SELECT COUNT(*) FROM fn_invoice WHERE pr_business_id = '$record'",4);
if($invoices > 0) {
	$GLOBALS['pr_bus_home_curr_id']->IsDisabled = "1";
	$allowGLCurrency = "0";
}
$GLOBALS['temp']['allowGLCurrency'] = $allowGLCurrency;

if ($pmode != "1") {
	$GLOBALS[$form]->AddField("pr_bus_name_short","pr_bus_name_short",$isProp['pr_bus_name_short'],0);
	$GLOBALS['pr_bus_name_short']->Size = "5";
	$GLOBALS['pr_bus_name_short']->Length = "5";

	$GLOBALS[$form]->AddField("pr_bus_statutory_1","pr_bus_statutory_1",$isProp['pr_bus_statutory_1'],0);
	$GLOBALS['pr_bus_statutory_1']->Width = "130";
	$GLOBALS['pr_bus_statutory_1']->Length = "50";
	$GLOBALS['pr_bus_statutory_1']->StyleType = "txt";

	$GLOBALS[$form]->AddField("pr_bus_statutory_2","pr_bus_statutory_2",$isProp['pr_bus_statutory_2'],0);
	$GLOBALS['pr_bus_statutory_2']->Width = "130";
	$GLOBALS['pr_bus_statutory_2']->Length = "50";
	$GLOBALS['pr_bus_statutory_2']->StyleType = "txt";

	$GLOBALS[$form]->AddField("pr_bus_statutory_3","pr_bus_statutory_3",$isProp['pr_bus_statutory_3'],0);
	$GLOBALS['pr_bus_statutory_3']->Width = "130";
	$GLOBALS['pr_bus_statutory_3']->Length = "50";
	$GLOBALS['pr_bus_statutory_3']->StyleType = "txt";

	$pr_bus_statutory_label_1_value = !empty($isProp['pr_bus_statutory_label_1']) ? $isProp['pr_bus_statutory_label_1'] : $default_statutory_labels['rf_statutory_label_1'];
	$GLOBALS[$form]->AddField("pr_bus_statutory_label_1","pr_bus_statutory_label_1",$pr_bus_statutory_label_1_value,0);
	$GLOBALS['pr_bus_statutory_label_1']->Width = "130";
	$GLOBALS['pr_bus_statutory_label_1']->Length = "50";
	$GLOBALS['pr_bus_statutory_label_1']->StyleType = !empty($isProp['pr_bus_statutory_label_1']) ? "txt" : "txti txtg";

	$pr_bus_statutory_label_2_value = !empty($isProp['pr_bus_statutory_label_2']) ? $isProp['pr_bus_statutory_label_2'] : $default_statutory_labels['rf_statutory_label_2'];
	$GLOBALS[$form]->AddField("pr_bus_statutory_label_2","pr_bus_statutory_label_2",$pr_bus_statutory_label_2_value,0);
	$GLOBALS['pr_bus_statutory_label_2']->Width = "130";
	$GLOBALS['pr_bus_statutory_label_2']->Length = "50";
	$GLOBALS['pr_bus_statutory_label_2']->StyleType = !empty($isProp['pr_bus_statutory_label_2']) ? "txt" : "txti txtg";

	$pr_bus_statutory_label_3_value = !empty($isProp['pr_bus_statutory_label_3']) ? $isProp['pr_bus_statutory_label_3'] : $default_statutory_labels['rf_statutory_label_3'];
	$GLOBALS[$form]->AddField("pr_bus_statutory_label_3","pr_bus_statutory_label_3",$pr_bus_statutory_label_3_value,0);
	$GLOBALS['pr_bus_statutory_label_3']->Width = "130";
	$GLOBALS['pr_bus_statutory_label_3']->Length = "50";
	$GLOBALS['pr_bus_statutory_label_3']->StyleType = !empty($isProp['pr_bus_statutory_label_3']) ? "txt" : "txti txtg";

	$GLOBALS[$form]->AddField("rf_statutory_label_1","rf_statutory_label_1",$default_statutory_labels['rf_statutory_label_1'],0);
	$GLOBALS['rf_statutory_label_1']->IsHidden = "1";
	$GLOBALS[$form]->AddField("rf_statutory_label_2","rf_statutory_label_2",$default_statutory_labels['rf_statutory_label_2'],0);
	$GLOBALS['rf_statutory_label_2']->IsHidden = "1";
	$GLOBALS[$form]->AddField("rf_statutory_label_3","rf_statutory_label_3",$default_statutory_labels['rf_statutory_label_3'],0);
	$GLOBALS['rf_statutory_label_3']->IsHidden = "1";

	$pr_bus_wetu_id_value = $isProp['pr_bus_wetu_id'];
	$GLOBALS[$form]->AddField("pr_bus_wetu_id","pr_bus_wetu_id",$pr_bus_wetu_id_value,0);
	$GLOBALS['pr_bus_wetu_id']->Width = "130";
	$GLOBALS['pr_bus_wetu_id']->Length = "50";
	$GLOBALS['pr_bus_wetu_id']->StyleType = "txt";



	$GLOBALS[$form]->AddField("pr_bus_inv_future_ind","pr_bus_inv_future_ind",$isProp['pr_bus_inv_future_ind'],0);
	$GLOBALS['pr_bus_inv_future_ind']->Select(array(":|:","0:|:Same as default","1:|:Yes","2:|:No"));
	$GLOBALS['pr_bus_inv_future_ind']->Width = "110";
	

	$GLOBALS[$form]->AddField("pr_bus_home_curr_id","pr_bus_home_curr_id",$isProp['pr_bus_home_curr_id'],0);
	$sql = "
		SELECT
			rf_currency_ix,
			IF(rf_currency_inactive_yn <> '0',CONCAT('* ',rf_currency_name),rf_currency_name) as rf_currency_name
		FROM
			rf_currency
		WHERE
			rf_currency_inactive_yn = '0'
			OR (
				rf_currency_inactive_yn <> '0'
				AND rf_currency_ix = '".$GLOBALS['pr_bus_home_curr_id']->Value."'
			)
		ORDER BY
			rf_currency_name
	";
	$GLOBALS['pr_bus_home_curr_id']->Select(combolist($GLOBALS['lDB'],$sql,"0:|:"));
	$GLOBALS['pr_bus_home_curr_id']->Width = "110";

	$GLOBALS[$form]->AddField("pr_bus_prop_curr_id","pr_bus_prop_curr_id",$isProp['pr_bus_prop_curr_id'],0);
	$sql = "
		SELECT
			rf_currency_ix,
			IF(rf_currency_inactive_yn <> '0',CONCAT('* ',rf_currency_name),rf_currency_name) as rf_currency_name
		FROM
			rf_currency
		WHERE
			rf_currency_inactive_yn = '0'
			OR (
				rf_currency_inactive_yn <> '0'
				AND rf_currency_ix = '".$GLOBALS['pr_bus_prop_curr_id']->Value."'
			)
		ORDER BY
			rf_currency_name
	";
	$GLOBALS['pr_bus_prop_curr_id']->Select(combolist($GLOBALS['lDB'],$sql,"0:|:"));
	$GLOBALS['pr_bus_prop_curr_id']->Width = "150";
	

	$GLOBALS[$form]->AddField("pr_bus_inv_prefix","pr_bus_inv_prefix",$isProp['pr_bus_inv_prefix'],0);
	$GLOBALS['tagList']['pr_bus_inv_prefix'] = $GLOBALS['pr_bus_inv_prefix'];

	$GLOBALS[$form]->AddField("startInvNum","startInvNum","",0);
	$GLOBALS['tagList']['startInvNum'] = $GLOBALS['startInvNum'];

	$GLOBALS[$form]->AddField("pr_bus_inv_number","pr_bus_inv_number",$isProp['pr_bus_inv_number'],0);
	$GLOBALS['tagList']['pr_bus_inv_number'] = $GLOBALS['pr_bus_inv_number'];

	$GLOBALS['temp']['pr_bus_billing_yn'] = $isBilling;
	$GLOBALS['temp']['pr_bus_billing_prop_yn'] = $isBillingProp;

	$GLOBALS[$form]->AddField("pr_bus_proforma_tax_ind","pr_bus_proforma_tax_ind",$isProp['pr_bus_proforma_tax_ind'],0);
	$GLOBALS['pr_bus_proforma_tax_ind']->Select(array(":|:","0:|:Same as default","1:|:Yes","2:|:No"));
	$GLOBALS['pr_bus_proforma_tax_ind']->Width = "130";

} else {
	if ($action == "3") {
		$pr_bus_name_short = isset($_POST['pr_bus_name_short']) ? $_POST['pr_bus_name_short'] : "";
		$GLOBALS[$form]->AddField("pr_bus_name_short","pr_bus_name_short",$pr_bus_name_short,0);
		$pr_bus_property_yn = "1";
		if ($force_property != "1") {
			$pr_bus_property_yn = isset($_POST['pr_bus_property_yn']) ? $_POST['pr_bus_property_yn'] : "0";
		}
		$pr_bus_billing_yn = isset($_POST['pr_bus_billing_yn']) ? $_POST['pr_bus_billing_yn'] : "0";
		$pr_bus_billing_prop_yn = isset($_POST['pr_bus_billing_prop_yn']) ? $_POST['pr_bus_billing_prop_yn'] : "0";
        $pr_bus_wetu_id = isset($_POST['pr_bus_wetu_id']) ? $_POST['pr_bus_wetu_id'] : "";

        if ($pr_bus_billing_yn != "1" && $pr_bus_billing_prop_yn != "1") {
			$pr_bus_statutory_1 = "";
			$pr_bus_statutory_2 = "";
			$pr_bus_statutory_3 = "";
			$pr_bus_statutory_label_1 = "";
			$pr_bus_statutory_label_2 = "";
			$pr_bus_statutory_label_3 = "";
			$pr_bus_home_curr_id = "0";
			$pr_bus_prop_curr_id = "0";
            if (isset($_POST['pr_bus_prop_curr_id'])) {
                $pr_bus_prop_curr_id = $_POST['pr_bus_prop_curr_id'];
            }
		} else {
			$pr_bus_statutory_1 = isset($_POST['pr_bus_statutory_1']) ? $_POST['pr_bus_statutory_1'] : "";
			$pr_bus_statutory_2 = isset($_POST['pr_bus_statutory_2']) ? $_POST['pr_bus_statutory_2'] : "";
			$pr_bus_statutory_3 = isset($_POST['pr_bus_statutory_3']) ? $_POST['pr_bus_statutory_3'] : "";
			$pr_bus_statutory_label_1 = isset($_POST['pr_bus_statutory_label_1']) && $_POST['pr_bus_statutory_label_1'] != $default_statutory_labels['rf_statutory_label_1'] ? $_POST['pr_bus_statutory_label_1'] : "";
			$pr_bus_statutory_label_2 = isset($_POST['pr_bus_statutory_label_2']) && $_POST['pr_bus_statutory_label_2'] != $default_statutory_labels['rf_statutory_label_2'] ? $_POST['pr_bus_statutory_label_2'] : "";
			$pr_bus_statutory_label_3 = isset($_POST['pr_bus_statutory_label_3']) && $_POST['pr_bus_statutory_label_3'] != $default_statutory_labels['rf_statutory_label_3'] ? $_POST['pr_bus_statutory_label_3'] : "";

			if (isset($_POST['pr_bus_home_curr_id'])){
				$pr_bus_home_curr_id = $_POST['pr_bus_home_curr_id'];	
			} else {
				$pr_bus_home_curr_id = "0";
			}
			
			if (isset($_POST['pr_bus_prop_curr_id'])){
				$pr_bus_prop_curr_id = $_POST['pr_bus_prop_curr_id'];	
			} else {
				$pr_bus_prop_curr_id = "0";
			}
		}

		$pr_bus_inv_future_ind = isset($_POST['pr_bus_inv_future_ind']) ? $_POST['pr_bus_inv_future_ind'] : "";
		$pr_bus_inv_prefix = isset($_POST['pr_bus_inv_prefix']) ? $_POST['pr_bus_inv_prefix'] : "";
		$pr_bus_inv_number = isset($_POST['pr_bus_inv_number']) ? $_POST['pr_bus_inv_number'] : "";
		if(isset($_POST['pr_bus_opt_accomm'])) { $pr_bus_opt_accomm = "1"; } else { $pr_bus_opt_accomm = "0";}
		if(isset($_POST['pr_bus_opt_bank'])) { $pr_bus_opt_bank = "1"; } else { $pr_bus_opt_bank = "0";}
		if(isset($_POST['pr_bus_opt_cca'])) { $pr_bus_opt_cca = "1"; } else { $pr_bus_opt_cca = "0";}
		if(isset($_POST['pr_bus_opt_date'])) { $pr_bus_opt_date = "1"; } else { $pr_bus_opt_date = "0";}
		if(isset($_POST['sp_special_desc'])) { $pr_bus_opt_special = "1"; } else { $pr_bus_opt_special = "0";}
		if(isset($_POST['sp_special_note'])) { $pr_bus_opt_special_note = "1"; } else { $pr_bus_opt_special_note = "0";}
		if(isset($_POST['pr_bus_opt_tax'])) { $pr_bus_opt_tax = "1"; } else { $pr_bus_opt_tax = "0";}
		if(isset($_POST['pr_bus_opt_tax_table'])) { $pr_bus_opt_tax_table = "1"; } else { $pr_bus_opt_tax_table = "0";}
		if(isset($_POST['pr_bus_opt_tax_table_gl'])) { $pr_bus_opt_tax_table_gl = "1"; } else { $pr_bus_opt_tax_table_gl = "0";}
		if(isset($_POST['pr_bus_opt_tax_table_rate'])) { $pr_bus_opt_tax_table_rate = "1"; } else { $pr_bus_opt_tax_table_rate = "0";}
		if(isset($_POST['pr_bus_opt_tax_table_total'])) { $pr_bus_opt_tax_table_total = "1"; } else { $pr_bus_opt_tax_table_total = "0";}
		if(isset($_POST['pr_bus_opt_terms'])) {$pr_bus_opt_terms = "1";} else { $pr_bus_opt_terms = "0";}
		if(isset($_POST['pr_bus_opt_terms_bus'])) {$pr_bus_opt_terms_bus = "1";} else { $pr_bus_opt_terms_bus = "0";}

		if(isset($_POST['pr_bus_proforma_tax_ind'])) {
			$pr_bus_proforma_tax_ind = $_POST['pr_bus_proforma_tax_ind'];
		} else {
			$pr_bus_proforma_tax_ind = "0";
		}

		$GLOBALS[$form]->AddField("pr_bus_prop_curr_id","pr_bus_prop_curr_id",$pr_bus_prop_curr_id,0);
		$GLOBALS[$form]->AddField("pr_bus_statutory_1","pr_bus_statutory_1",$pr_bus_statutory_1,0);
		$GLOBALS[$form]->AddField("pr_bus_statutory_2","pr_bus_statutory_2",$pr_bus_statutory_2,0);
		$GLOBALS[$form]->AddField("pr_bus_statutory_3","pr_bus_statutory_3",$pr_bus_statutory_3,0);
		$pr_bus_statutory_label_1_value = !empty($pr_bus_statutory_label_1) ? $pr_bus_statutory_label_1 : $default_statutory_labels['rf_statutory_label_1'];
		$pr_bus_statutory_label_2_value = !empty($pr_bus_statutory_label_2) ? $pr_bus_statutory_label_2 : $default_statutory_labels['rf_statutory_label_2'];
		$pr_bus_statutory_label_3_value = !empty($pr_bus_statutory_label_3) ? $pr_bus_statutory_label_3 : $default_statutory_labels['rf_statutory_label_3'];
		$pr_bus_wetu_id_value = $pr_bus_wetu_id;
		$GLOBALS[$form]->AddField("pr_bus_statutory_label_1","pr_bus_statutory_label_1",$pr_bus_statutory_label_1_value,0);
		$GLOBALS[$form]->AddField("pr_bus_statutory_label_2","pr_bus_statutory_label_2",$pr_bus_statutory_label_2_value,0);
		$GLOBALS[$form]->AddField("pr_bus_statutory_label_3","pr_bus_statutory_label_3",$pr_bus_statutory_label_3_value,0);
		$GLOBALS[$form]->AddField("pr_bus_wetu_id","pr_bus_wetu_id",$pr_bus_wetu_id_value,0);
		$GLOBALS[$form]->AddField("pr_bus_inv_prefix","pr_bus_inv_prefix",$pr_bus_inv_prefix,0);
		$GLOBALS['tagList']['pr_bus_inv_prefix'] = $GLOBALS['pr_bus_inv_prefix'];
		$GLOBALS[$form]->AddField("startInvNum","startInvNum","",0);
		$GLOBALS['tagList']['startInvNum'] = $GLOBALS['startInvNum'];

		// When updating this remember to update init.form76.php as well.
		$glCurrency = "";
		if($allowGLCurrency == "1") {
			$glCurrency = "pr_bus_home_curr_id = '$pr_bus_home_curr_id',";
		}
        if (isset($_POST['pr_bus_prop_curr_id'])) {
            $pr_bus_prop_curr_id = $_POST['pr_bus_prop_curr_id'];
        }
		$GLOBALS['lDB']->put("
			UPDATE pr_business SET
				pr_bus_statutory_1 = '$pr_bus_statutory_1',
				pr_bus_statutory_2 = '$pr_bus_statutory_2',
				pr_bus_statutory_3 = '$pr_bus_statutory_3',
				pr_bus_statutory_label_1 = '$pr_bus_statutory_label_1',
				pr_bus_statutory_label_2 = '$pr_bus_statutory_label_2',
				pr_bus_statutory_label_3 = '$pr_bus_statutory_label_3',
				pr_bus_wetu_id = '$pr_bus_wetu_id',
				pr_bus_billing_yn = '$pr_bus_billing_yn',
				pr_bus_billing_prop_yn = '$pr_bus_billing_prop_yn',
				$glCurrency
				pr_bus_prop_curr_id = '$pr_bus_prop_curr_id',
				pr_bus_property_yn = '$pr_bus_property_yn',
				pr_bus_name_short = '$pr_bus_name_short',
				pr_bus_inv_future_ind = '$pr_bus_inv_future_ind',
				pr_bus_inv_prefix = '$pr_bus_inv_prefix',
				pr_bus_inv_number = '$pr_bus_inv_number',
				pr_bus_opt_accomm = '$pr_bus_opt_accomm',
				pr_bus_opt_bank = '$pr_bus_opt_bank',
				pr_bus_opt_cca = '$pr_bus_opt_cca',
				pr_bus_opt_date = '$pr_bus_opt_date',
				pr_bus_opt_special = '$pr_bus_opt_special',
				pr_bus_opt_special_note = '$pr_bus_opt_special_note',
				pr_bus_opt_tax = '$pr_bus_opt_tax',
				pr_bus_opt_tax_table = '$pr_bus_opt_tax_table',
				pr_bus_opt_tax_table_gl = '$pr_bus_opt_tax_table_gl',
				pr_bus_opt_tax_table_rate = '$pr_bus_opt_tax_table_rate',
				pr_bus_opt_tax_table_total = '$pr_bus_opt_tax_table_total',
				pr_bus_opt_terms = '$pr_bus_opt_terms',
				pr_bus_opt_terms_bus = '$pr_bus_opt_terms_bus',
				pr_bus_proforma_tax_ind = '$pr_bus_proforma_tax_ind'
			WHERE
				pr_business_id = '$record'
		");
	}
}

// End pr_bus_property_yn add

// Added for inactive contact

$GLOBALS['can_delete'] = "1";
$GLOBALS['temp']['del_error'] = "The default settings has this property setup as either the principal or the reservations office.";
$GLOBALS['temp']['can_delete'] = $GLOBALS['can_delete'];


// End add for inactive contact

$table = $GLOBALS[$form]->TableList[0];
array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_corr_post_office_id");
array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_phys_post_office_id");
array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_persona_link_id");

if ($action != 2) {
	$temp = $GLOBALS['lDB']->get("SELECT pr_org_yn FROM pr_persona WHERE pr_persona_ix = '$record'",1);
	if ($temp[0] == "1") {
		$checked_record = "1";
	}
} else {
	$GLOBALS['form73_pr_persona_pr_persona_db']->SetValue($dbcode);
	$GLOBALS['form73_pr_persona_pr_persona_link_id']->SetValue("0");
}

if ((isset($_POST['persona_type']) && $_POST['persona_type'] == "1") || (isset($persona_type) && $persona_type == "1")) {
	$checked_record = "1";
}

$GLOBALS['form73_pr_persona_pr_corr_country_id']->Class = 3;
$sql = "
	SELECT
		rf_country_ix,
		IF(rf_country_inactive <> '0',CONCAT('* ',rf_country_name),rf_country_name) as rf_country_name,
		rf_country_code
	FROM
		rf_country
	WHERE
		rf_country_inactive = '0'
		OR (
			rf_country_inactive <> '0'
			AND rf_country_ix = '".$GLOBALS['form73_pr_persona_pr_corr_country_id']->Value."'
		)
	ORDER BY
		rf_country_name
";
$GLOBALS['form73_pr_persona_pr_corr_country_id']->Select = combolist($GLOBALS['lDB'],$sql,"0:|:");

$GLOBALS['form73_pr_persona_pr_phys_country_id']->Class = 3;
$sql = "
	SELECT
		rf_country_ix,
		IF(rf_country_inactive <> '0',CONCAT('* ',rf_country_name),rf_country_name) as rf_country_name,
		rf_country_code
	FROM
		rf_country
	WHERE
		rf_country_inactive = '0'
		OR (
			rf_country_inactive <> '0'
			AND rf_country_ix = '".$GLOBALS['form73_pr_persona_pr_phys_country_id']->Value."'
		)
	ORDER BY
		rf_country_name
";
$GLOBALS['form73_pr_persona_pr_phys_country_id']->Select = combolist($GLOBALS['lDB'],$sql,"0:|:");

$GLOBALS['form73_pr_persona_pr_name_suffix_id']->Class = 3;
$sql = "SELECT rf_name_suffix_db,rf_name_suffix_id,rf_suffix_desc FROM rf_name_suffix order by rf_suffix_desc";
$GLOBALS['form73_pr_persona_pr_name_suffix_id']->Select = combolist($GLOBALS['lDB'],$sql,"RR0-");

$GLOBALS['form73_pr_persona_pr_title_id']->Class = 3;
$sql = "SELECT rf_title_db,rf_title_id,rf_title_desc FROM rf_title ORDER BY rf_title_id";
$GLOBALS['form73_pr_persona_pr_title_id']->Select = combolist($GLOBALS['lDB'],$sql,"RR0-");

$GLOBALS['form73_pr_persona_rf_comms_preference_id']->Class = 3;
$sql = "SELECT rf_comms_preference_db,rf_comms_preference_id,rf_comms_desc FROM rf_comms_preference WHERE rf_comms_inactive_yn = '0' ORDER BY rf_comms_desc";
$GLOBALS['form73_pr_persona_rf_comms_preference_id']->Select = combolist($GLOBALS['lDB'],$sql);

$GLOBALS['form73_pr_persona_pr_persona_ix']->Class = 8;

if($GLOBALS['form73_pr_persona_pr_corr_post_code']->Value == "0") { $GLOBALS['form73_pr_persona_pr_corr_post_code']->Value = ""; }
if($GLOBALS['form73_pr_persona_pr_phys_post_code']->Value == "0") { $GLOBALS['form73_pr_persona_pr_phys_post_code']->Value = ""; }

$null = $dbcode."0";

$GLOBALS['temp']['link_alt'] = "Link Address";
$GLOBALS['temp']['link_img'] = "bLink";
$link_name = "No Linked Address";
$GLOBALS['temp']['link_var'] = "1";
if ($GLOBALS['form73_pr_persona_pr_persona_link_id']->Value != "0" && $GLOBALS['form73_pr_persona_pr_persona_link_id']->Value != "") {
	$GLOBALS['temp']['link_alt'] = "Remove Link";
	$GLOBALS['temp']['link_var'] = "0";
	$GLOBALS['temp']['link_img'] = "bRemLink";
	$persona = $GLOBALS['form73_pr_persona_pr_persona_link_id']->Value;
	$temp = $GLOBALS['lDB']->get("SELECT pr_name_last, pr_name_first FROM pr_persona WHERE pr_persona_ix = '$persona'",1);
	$link_name = $temp[0];
	if ($temp[1] != "") {
		$link_name .= ", ".$temp[1];
	}
}
$GLOBALS[$form]->AddField("link_id","link_id",$link_name,"0");


if ($pmode == "0") {
	$isdel = $GLOBALS['lDB']->get("SELECT pr_persona_inactive_yn FROM pr_persona WHERE pr_persona_ix = '$record'",1);
	$GLOBALS['temp']['delcss'] = "";
	if ($isdel[0] != -1) {
		$GLOBALS['temp']['delcss'] = " style=\"display: none\"";
	}
	if ($action == 4 || $action == 2) {
		$GLOBALS['temp']['delcss'] = " style=\"display: none\"";
	}


	if ($action != 2 && $action != 4) {
		$temp2 = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_phone WHERE pr_persona_id = '$record'",1);
		$GLOBALS['temp']['morenums'] = $temp2[0];
	} else {
		$GLOBALS['temp']['morenums'] = "0";
	}

	$telcount = $GLOBALS['temp']['morenums'];
	if ($telcount > 5) {
		$telcount = 6;
	}
	if ($telcount < 0) {
		$telcount = 0;
	}
	$GLOBALS['temp']['opentelephone'] = '<img class="imgLink" id="tels" name="tels" onclick="buttonPress(\'openTelephone\');" border="0" src="/resource/Resrequest/Application/public/img/tel_' . $telcount . '.gif" alt="" />';
	
	$GLOBALS['temp']['defnum'] = "";
	$GLOBALS['temp']['defnum2'] = "0";
	if ($action != "1") {
		$GLOBALS['temp']['telmode'] = "769";
	} else {
		$GLOBALS['temp']['telmode'] = "768";
	}
	$phone = "";
	if ($record != "") {
		$temp = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_phone WHERE pr_persona_id = '$record' AND pr_default_yn = '1'",1);
		if ($temp[0] != "0") {
			$temp1 = $GLOBALS['lDB']->get("SELECT pr_phone_number, pr_phone_ix FROM pr_phone WHERE pr_persona_id = '$record' AND pr_default_yn = '1'",1);
			$phone = $temp1[0];
			$phone_id = $temp1[1];
			$GLOBALS['temp']['defnum'] = "reservation.php?".$GLOBALS['temp']['telmode']."+".$record."+".$phone_id;
			$GLOBALS['temp']['defnum2'] = $phone_id;
		}
	}
	if ($action != 2 && $action != 4) {
		$GLOBALS[$form]->AddField("phone_default","phone_default",$phone,0);
	} else {
		$GLOBALS[$form]->AddField("phone_default","phone_default","",0);
	}
	$GLOBALS['phone_default']->Size = "25";
} else {
	$newphone = isset($_POST['phone_default'])?$_POST['phone_default']:"";
	$GLOBALS[$form]->AddField("phone_default","phone_default",$newphone,0);
	$temp = $GLOBALS['lDB']->get("SELECT COUNT(*) FROM pr_phone WHERE pr_persona_id = '$record' AND pr_default_yn = '1'",1);
	if ($temp[0] != "0") {
		$temp1 = $GLOBALS['lDB']->get("SELECT pr_phone_number FROM pr_phone WHERE pr_persona_id = '$record' AND pr_default_yn = '1'",1);
		$oldphone = $temp1[0];
		if ($newphone != $oldphone) {
			$sql = "UPDATE pr_phone SET pr_phone_number = '$newphone' WHERE pr_persona_id = '$record' and pr_default_yn = '1'";
			$GLOBALS['lDB']->put($sql);
		}
	} else {
		if ($newphone != "") {
			$GLOBALS['lDB']->put("
				INSERT INTO pr_phone (
					pr_phone_db,
					pr_phone_number,
					pr_persona_id,
					pr_default_yn,
					rf_phone_type_id
				) VALUES (
					'$dbcode',
					'$newphone',
					'$record',
					'1',
					'RS3'
				)
			");
			$key = $GLOBALS['lDB']->insert_id;
		}
	}
}

// Added for bank details

$GLOBALS['temp']['rows'] = "";
$GLOBALS['temp']['bankCount'] = "0";
if ($action != "2" && $pmode == "0") {
	$banks = $GLOBALS['lDB']->get("
		SELECT
			pr_bus_bank.pr_bus_bank_ix as pr_bus_bank_ix,
			rf_bank.rf_bank_name,
			rf_bank.rf_bank_acc_name,
			rf_currency.rf_currency_symbol,
			rf_bank.rf_bank_ind
		FROM
			pr_bus_bank
			INNER JOIN rf_bank ON pr_bus_bank.rf_bank_id = rf_bank.rf_bank_ix
			INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rf_bank.rf_currency_id
		WHERE
			pr_bus_bank.pr_business_id = '$record'			
		ORDER BY
			rf_bank.rf_bank_name,
			rf_bank.rf_bank_acc_name,
			rf_currency.rf_currency_symbol
	",2);
	$GLOBALS['temp']['bankCount'] = sizeof($banks);

	# Move to output array
	$bankList = array();
	$HTML = __DIR__ . "/../../../public/html/property_bank_rows.htm";
	$rowHtml = Join("",File($HTML));
	$found = "0";
	for ($i = 0; $i < sizeof($banks); $i++){
		$bankList['bankId'] = $banks[$i]['pr_bus_bank_ix'];
		if(trim($banks[$i]['rf_bank_name']) != "") {
			$bankList['bankName'] = $banks[$i]['rf_bank_name'];
		} else {
			$bankList['bankName'] = $banks[$i]['rf_bank_acc_name'];
		}
		$bankList['accName'] = t_encodeOverlib($banks[$i]['rf_bank_acc_name']);
		$bankList['currency'] = $banks[$i]['rf_currency_symbol'];
		$bankList['vis'] = "block";
		$bankList['grey'] = "txt";
		if ($action == "1" || $action == "2") {
			$bankList['vis'] = "none";
			$bankList['grey'] = "txtg";
		}

		# Add this line to each code table
		$GLOBALS['temp']['rows'] .= showpage($bankList,$rowHtml);
		$found++;
	}

	$GLOBALS['temp']['recordsFound'] = (string) $found;
}
if ($GLOBALS['temp']['rows'] == "") {
	$GLOBALS['temp']['rows'] = "<tr><td class=\"formBold\" height=\"20\" width=\"100%\">&nbsp;&nbsp;</td></tr>";
}


// End add for bank details

if ($action == "3" || $pmode == "1") {
	$GLOBALS[$form]->AddField("edit_view","edit_view","170","8");
}else {
	if ($action == "2") {
		$GLOBALS[$form]->AddField("edit_view","edit_view","166","8");
	} else {
		$GLOBALS[$form]->AddField("edit_view","edit_view","168","8");
	}
}

if ($action == "2" || $action == "3") {
	$GLOBALS[$form]->AddField("save_link","save_link","javascript:document.forms.form73.submit();","8");
} else {
	$GLOBALS[$form]->AddField("save_link","save_link","#","8");
}

if ($action == "3") {
	$GLOBALS[$form]->AddField("delete_link","delete_link","reservation.php?171+$record","8");
} else {
	$GLOBALS[$form]->AddField("delete_link","delete_link","reservation.php?170+$record#","8");
}

$hidelist = array("form73_pr_persona_pr_persona_link_id","form73_pr_persona_pr_org_yn"); 
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array("link_id");
$GLOBALS[$form]->Disable($disablelist);

if ($pmode == "0" && $action == "1") {
	$GLOBALS['tagList']['pr_bus_inv_prefix']->IsDisabled = "1";
	$GLOBALS['tagList']['startInvNum']->IsDisabled = "1";
}


// Determine whether to require billing information on this record or not
if ($pmode == "0") {
	$GLOBALS['temp']['billingParentName'] = "";
	$GLOBALS['temp']['billingParentPropName'] = "";
	if ($action == "2") {
		$GLOBALS['temp']['hasBillingParent'] = "false";
		if (hasBillingParent("",$parent)) {
			$GLOBALS['temp']['hasBillingParent'] = "true";
		}
		$GLOBALS['temp']['hasBillingPropParent'] = "false";
		if(hasBillingPropParent("",$parent)) {
			$GLOBALS['temp']['hasBillingPropParent'] = "true";
		}
		$GLOBALS['temp']['hasPropChildren'] = "false";
	} else {
		$GLOBALS['temp']['hasBillingParent'] = "false";
		if (hasBillingParent($record)) {
			$GLOBALS['temp']['billingParentName'] = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '".getBillingParent($record)."'",4);
			$GLOBALS['temp']['hasBillingParent'] = "true";
			$GLOBALS['temp']['hasPropChildren'] = "false";
		} else {
			$GLOBALS['temp']['hasPropChildren'] = "false";
			if (hasPropChildren($record)) {
				$GLOBALS['temp']['hasPropChildren'] = "true";
			}
		}
		$GLOBALS['temp']['hasBillingPropParent'] = "false";
		if(hasBillingPropParent($record)) {
			$GLOBALS['temp']['billingParentPropName'] = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '".getBillingPropParent($record)."'",4);
			$GLOBALS['temp']['hasBillingPropParent'] = "true";
		}
	}
	$GLOBALS['tagList']['bilParentName'] = "";
	if ($GLOBALS['temp']['hasBillingParent'] == "true") {
		$billingParent = getBillingParent($parent);
		$bilParentCurrency = $GLOBALS['lDB']->get("SELECT pr_bus_home_curr_id FROM pr_business WHERE pr_business_id = '$billingParent'",4);
		$GLOBALS['temp']['bilParentCurrency'] = "0";
		if ($bilParentCurrency != "0" && $bilParentCurrency != "") {
			$amax = sizeof($GLOBALS['pr_bus_home_curr_id']->Select);
			for ($a=0;$a<$amax;$a++) {
				$temp = explode(":|:",$GLOBALS['pr_bus_home_curr_id']->Select[$a]);
				$id = $temp[0];
				if ($id == $bilParentCurrency) {
					$GLOBALS['temp']['bilParentCurrency'] = (string) $a;
					break;
				}
			}
		}
		if ($action == "2") {
			$GLOBALS['tagList']['bilParentName'] = setNewParam("style","visibility:hidden");
			$GLOBALS['tagList']['bilParentName']->SetContent($GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$billingParent'",4));
		} else {
			$GLOBALS['tagList']['bilParentName'] = $GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '$billingParent'",4);
		}
	}
}


$tabcount="1";
$GLOBALS['form73_pr_persona_pr_name_last']->Size = "25";
$GLOBALS['form73_pr_persona_pr_name_last']->StyleType = "txt";
if (in_array("pr_bus_name_short",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['pr_bus_name_short']->Size = "5";
	$GLOBALS['pr_bus_name_short']->StyleType = "txt";
	$GLOBALS['pr_bus_name_short']->TabIndex = $tabcount++;
}
$GLOBALS['form73_pr_persona_pr_email']->Size = "25";
$GLOBALS['form73_pr_persona_pr_email']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_email']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_corr_addr_line1']->Width = "155";
$GLOBALS['form73_pr_persona_pr_corr_addr_line1']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_corr_addr_line2']->Width = "155";
$GLOBALS['form73_pr_persona_pr_corr_addr_line2']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_corr_addr_line3']->Width = "155";
$GLOBALS['form73_pr_persona_pr_corr_addr_line3']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_corr_country_id']->Width = "155";
$GLOBALS['form73_pr_persona_pr_corr_city']->Width = "155";
$GLOBALS['form73_pr_persona_pr_corr_city']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_corr_post_code']->Width = "155";
$GLOBALS['form73_pr_persona_pr_corr_post_code']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_phys_addr_line1']->Width = "155";
$GLOBALS['form73_pr_persona_pr_phys_addr_line1']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_phys_addr_line2']->Width = "155";
$GLOBALS['form73_pr_persona_pr_phys_addr_line2']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_phys_addr_line3']->Width = "155";
$GLOBALS['form73_pr_persona_pr_phys_addr_line3']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_phys_country_id']->Width = "155";
$GLOBALS['form73_pr_persona_pr_phys_city']->Width = "155";
$GLOBALS['form73_pr_persona_pr_phys_city']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_phys_post_code']->Width = "155";
$GLOBALS['form73_pr_persona_pr_phys_post_code']->StyleType = "txt";
$GLOBALS['edit_view']->Size = "";
//$GLOBALS['fwd_id']->Size = "12";
$GLOBALS['link_id']->Size = "25";
$GLOBALS['link_id']->StyleType = "txt";

$GLOBALS['form73_pr_persona_pr_name_last']->TabIndex = $tabcount++;
$tabcount++;

$GLOBALS['phone_default']->TabIndex = $tabcount++;
$GLOBALS['phone_default']->StyleType = "txt";
$GLOBALS['form73_pr_persona_pr_web_addr']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_web_addr']->Size = "25";
$GLOBALS['form73_pr_persona_pr_web_addr']->StyleType = "txt";
if (in_array("pr_bus_home_curr_id",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['pr_bus_home_curr_id']->TabIndex = $tabcount++;
}
if (in_array("pr_bus_prop_curr_id",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['pr_bus_prop_curr_id']->TabIndex = $tabcount++;
}
$tabcount++;
if (in_array("pr_bus_statutory_1",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['pr_bus_statutory_1']->TabIndex = $tabcount++;
}
if (in_array("pr_bus_statutory_2",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['pr_bus_statutory_2']->TabIndex = $tabcount++;
}
if (in_array("pr_bus_statutory_3",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['pr_bus_statutory_3']->TabIndex = $tabcount++;
}
if (in_array("pr_bus_statutory_label_1",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['pr_bus_statutory_label_1']->TabIndex = $tabcount++;
}
if (in_array("pr_bus_statutory_label_2",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['pr_bus_statutory_label_2']->TabIndex = $tabcount++;
}
if (in_array("pr_bus_statutory_label_3",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['pr_bus_statutory_label_3']->TabIndex = $tabcount++;
}
if (in_array("pr_bus_wetu_id",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['pr_bus_wetu_id']->TabIndex = $tabcount++;
}
if (in_array("pr_bus_inv_prefix",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['tagList']['pr_bus_inv_prefix'] = $GLOBALS['pr_bus_inv_prefix'];
	$GLOBALS['tagList']['pr_bus_inv_prefix']->TabIndex = $tabcount++;
}
if (in_array("startInvNum",$GLOBALS[$form]->FieldList)) {
	$GLOBALS['tagList']['startInvNum'] = $GLOBALS['startInvNum'];
	$GLOBALS['tagList']['startInvNum']->TabIndex = $tabcount++;
}


$tabcount++;
$tabcount++;
$GLOBALS['form73_pr_persona_pr_corr_addr_line1']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_corr_addr_line2']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_corr_addr_line3']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_corr_country_id']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_corr_city']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_corr_post_code']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_phys_addr_line1']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_phys_addr_line2']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_phys_addr_line3']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_phys_country_id']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_phys_city']->TabIndex = $tabcount++;
$GLOBALS['form73_pr_persona_pr_phys_post_code']->TabIndex = $tabcount++;
$GLOBALS['edit_view']->TabIndex = "";
//$GLOBALS['fwd_id']->TabIndex = "";

if ($GLOBALS['form73_pr_persona_pr_persona_link_id']->Value != "0" && $action != "2") {
	$linked_record = $GLOBALS['form73_pr_persona_pr_persona_link_id']->Value;
	$temp = $GLOBALS['lDB']->get("
		SELECT
			pr_corr_addr_line1,
			pr_corr_addr_line2,
			pr_corr_addr_line3,
			pr_corr_post_office_id,
			pr_corr_country_id,
			pr_corr_post_code,
			pr_phys_addr_line1,
			pr_phys_addr_line2,
			pr_phys_addr_line3,
			pr_phys_post_office_id,
			pr_phys_country_id,
			pr_phys_post_code,
			pr_corr_city,
			pr_phys_city
		FROM
			pr_persona
		WHERE
			pr_persona_ix = '$linked_record'
	",1);

	$GLOBALS['form73_pr_persona_pr_corr_addr_line1']->Value = $temp[0];
	$GLOBALS['form73_pr_persona_pr_corr_addr_line2']->Value = $temp[1];
	$GLOBALS['form73_pr_persona_pr_corr_addr_line3']->Value = $temp[2];
	$GLOBALS['form73_pr_persona_pr_corr_post_office_id']->Value = $temp[3];
	$GLOBALS['form73_pr_persona_pr_corr_country_id']->Value = $temp[4];
	$GLOBALS['form73_pr_persona_pr_corr_post_code']->Value = $temp[5];
	$GLOBALS['form73_pr_persona_pr_phys_addr_line1']->Value = $temp[6];
	$GLOBALS['form73_pr_persona_pr_phys_addr_line2']->Value = $temp[7];
	$GLOBALS['form73_pr_persona_pr_phys_addr_line3']->Value = $temp[8];
	$GLOBALS['form73_pr_persona_pr_phys_post_office_id']->Value = $temp[9];
	$GLOBALS['form73_pr_persona_pr_phys_country_id']->Value = $temp[10];
	$GLOBALS['form73_pr_persona_pr_phys_post_code']->Value = $temp[11];
	$GLOBALS['form73_pr_persona_pr_corr_city']->Value = $temp[12];
	$GLOBALS['form73_pr_persona_pr_phys_city']->Value = $temp[13];

	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_corr_addr_line1");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_corr_addr_line2");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_corr_addr_line3");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_corr_post_office_id");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_corr_country_id");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_corr_post_code");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_phys_addr_line1");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_phys_addr_line2");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_phys_addr_line3");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_phys_post_office_id");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_phys_country_id");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_phys_post_code");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_corr_city");
	array_push($GLOBALS[$table]->Keys,"form73_pr_persona_pr_phys_city");


	$disablelist = array(
		"form73_pr_persona_pr_corr_addr_line1",
		"form73_pr_persona_pr_corr_addr_line2",
		"form73_pr_persona_pr_corr_addr_line3",
		"form73_pr_persona_pr_corr_post_office_id",
		"form73_pr_persona_pr_corr_country_id",
		"form73_pr_persona_pr_corr_city",
		"form73_pr_persona_pr_corr_post_code",
		"form73_pr_persona_pr_phys_addr_line1",
		"form73_pr_persona_pr_phys_addr_line2",
		"form73_pr_persona_pr_phys_addr_line3",
		"form73_pr_persona_pr_phys_post_office_id",
		"form73_pr_persona_pr_phys_country_id",
		"form73_pr_persona_pr_phys_post_code",
		"form73_pr_persona_pr_phys_city"
	);
	$GLOBALS[$form]->Disable($disablelist);
}

// Start Access Control Toolbar Setup
$newr = 166;
$edit = 168;
$view = 170;
$dele = 171;
$sedit = 169;
$snewr = 167;

$pgJOBS = array();
$pgJOBS['view'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['add'] = "0";
if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}
$pgJOBS['edit'] = "0";
if (checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
}
$pgJOBS['saveclose'] = "0";
if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
	$pgJOBS['saveclose'] = "1";
}
if ($action == "2" || $action == "4") {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($dele)) {
		$pgJOBS['del'] = "1";
	}
}
$pgJOBS['ext'] = "1";

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"$pgJOBS[add]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"$pgJOBS[edit]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"$pgJOBS[del]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"$pgJOBS[save]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSaveclose\" value=\"$pgJOBS[saveclose]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobExit\" value=\"$pgJOBS[ext]\">\n";
// End Access Control Toolbar Setup

$notejobid = "181";
if (checkjob("182")) {
	$notejobid = "182";
}
$GLOBALS['temp']['resnotejob'] = "reservation.php?$notejobid+$record+$parent";
$GLOBALS['temp']['delrecord'] = "reservation.php?171+$record+$parent";
$GLOBALS['temp']['propUserjob'] = "reservation.php?531+$record+$parent";
$GLOBALS['temp']['propRatesJob'] = "reservation.php?623+$record";
$GLOBALS['temp']['showhideLink'] = "";

switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['showhideLink'] = " style=\"visibility:hidden\"";
	break;
case (2) : // Add Record
	$GLOBALS[$form]->Arguments = "167++".$parent;
	if ($pmode == "0") {
		$_SERVER['argv'][1] = "";
		$record = "";
	}
	$GLOBALS['mode'] = "new";
	break;
case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = "169+".$record;
	$GLOBALS['temp']['resnotejob'] = "reservation.php?182+$record+$parent";
	$GLOBALS['temp']['propUserjob'] = "reservation.php?532+$record";
	$GLOBALS['temp']['propRatesJob'] = "reservation.php?623+$record";
	$GLOBALS['mode'] = "edit";
	break;
case (4) : // Delete Record
	if (propCanDelete($record) && accommCanDelete()) {
		$doDelList = $GLOBALS['lDB']->get("SELECT ac_accomm_type_ix FROM ac_accomm_type WHERE ac_accomm_type_ix in ('".join("','",$GLOBALS['accommChildList2B'])."')",2);
		foreach($doDelList as $delItem){
			$GLOBALS['lDB']->put("DELETE FROM ac_accomm_type WHERE ac_accomm_type_ix = '$delItem[0]'",1);
		}
		$doDelList = $GLOBALS['lDB']->get("SELECT pr_persona_ix FROM pr_persona WHERE pr_persona_ix in ('".join("','",$GLOBALS['propChildList2B'])."')",2);
		foreach($doDelList as $delItem){
			$GLOBALS['lDB']->put("DELETE FROM pr_persona WHERE pr_persona_ix = '$delItem[0]'",1);
		}
		$doDelList = $GLOBALS['lDB']->get("SELECT pr_business_id FROM pr_business WHERE pr_business_id in ('".join("','",$GLOBALS['propChildList2B'])."')",2);
		foreach($doDelList as $delItem){
			$GLOBALS['lDB']->put("DELETE FROM pr_business WHERE pr_business_id = '$delItem[0]'",1);
		}
		$GLOBALS[$form]->FormHTML .= str_replace("</body>","<script>windowClose();</script></body>",$GLOBALS[$form]->FormHTML);
	} else {
		$GLOBALS['lDB']->put("
			UPDATE ac_accomm_type SET
				ac_accomm_type_inactive_yn = '1',
				ac_accomm_type_inactive_date = '".date("Y-m-d")."'
			WHERE
				ac_accomm_type_ix in ('".join("','",$GLOBALS['accommChildList2B'])."')
		");
		$GLOBALS['lDB']->put("UPDATE pr_business SET pr_bus_inactive_yn  = '1' WHERE pr_business_id in ('".join("','",$GLOBALS['propChildList2B'])."')");
		$GLOBALS['lDB']->put("UPDATE pr_persona SET pr_persona_inactive_yn = '1' WHERE pr_persona_ix in ('".join("','",$GLOBALS['propChildList2B'])."')");
		redirectTo(" ./reservation.php?168+".$record);
	}
	break;
}

if ($action == "2" && $pmode == "0") {
	$GLOBALS['temp']['propRatesJob'] = "#";
	$GLOBALS['temp']['propUserjob'] = "#";
	$GLOBALS['temp']['resnotejob'] = "#";
}
$isProp = "0";
if ($action != "2") {
	$isProp = $GLOBALS['lDB']->get("SELECT pr_bus_property_yn FROM pr_business WHERE pr_business_id = '$record'",4);
}
if ($isProp == "0") {
	$GLOBALS['temp']['propRatesJob'] = "#";
}

if ($pmode != "1" && isset($_POST['saveclose']) && $_POST['saveclose'] == "1") {
	$GLOBALS[$form]->FormHTML .= str_replace("</body>","<script>windowClose();</script></body>",$GLOBALS[$form]->FormHTML);
}

if (!checkJob(623) && !$GLOBALS['isPropServer']) {
	require_once(__DIR__ . "/class.template.php");
	require_once(__DIR__ . "/functions.template.php");
	$GLOBALS['tagList']['rateTab'] = blankObject();
	$GLOBALS['tagList']['rateTab']->setContent("&nbsp;");
}

