<?php

/*
 * $Id: init.form74.php,v 1.17 2011-08-25 10:29:47 light Exp $
 *
 * $Log: init.form74.php,v $
 * Revision 1.17  2011-08-25 10:29:47  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.16  2011-05-30 12:50:04  light
 * Bug #7609 - General system speed (on larger databases)
 *
 * Revision 1.15  2011-05-17 14:08:34  light
 * Bug #7585 - PHP5 fixes
 *
 * Revision 1.14  2010-10-04 16:46:59  light
 * Bug #7301 - Rates phase 1 - Search & Replace
 *
 * Revision 1.13  2010-01-11 17:00:52  light
 * Bug #6983 - GENREP: Business structure display across all reports
 *
 * Revision 1.12  2008-08-24 17:47:35  light
 * Bug #6514 - Business Structure - Accommodation popup
 *
 * Revision 1.11  2007-11-06 12:48:06  light
 * Bug #6232 - Business structure enhancements
 *
 * Revision 1.10  2007-04-19 13:53:46  gregs
 * Formatting
 *
 *
 */
 
/**
 * init.form74.php - Business Structure property tree
 * Job: 172
 * Function: 61
 */

$_SERVER['argv'] = array_pad($_SERVER['argv'],5,"");

if (!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"",__DIR__ . "/../../../public/html/property_tree.htm");
}

// Get all selection filters/parameters ---------------------------------------
$jobid = $_SERVER['argv'][0];

if ( sizeof($_SERVER['argv']) > 1 ) {
	$record			= $_SERVER['argv'][1];
	$parent			= $_SERVER['argv'][2];
	$direction	= $_SERVER['argv'][3];
	$accomm			= $_SERVER['argv'][4];
} else {
	$record = $parent = $direction = $accomm = "";
}

/************** [START] Temporary code to fix business structure ****************************************/

$username = $lDB->get("SELECT pr_user_name FROM pr_user WHERE pr_user_id= '".$GLOBALS['userid']."'", 4);
if(strtolower($username) == "censysad") {
	$GLOBALS['temp']['showFix'] = "";
} else {
	$GLOBALS['temp']['showFix'] = " style=\"visibility: hidden;\"";
}

$GLOBALS['temp']['open_and_close_out_rooms_class'] = "buttonG";
$GLOBALS['temp']['open_and_close_out_rooms_disabled'] = "disabled";
if(isset($GLOBALS['jobLevelArray'][1026]) && $GLOBALS['jobLevelArray'][1026] > 5) {
	$GLOBALS['temp']['open_and_close_out_rooms_class'] = "button";
	$GLOBALS['temp']['open_and_close_out_rooms_disabled'] = "onclick=\"window.location = 'reservation.php?1026';\"";
}

function get_prop_array ($record=0,$type=0,$flag=0) {
	global $lDB;
	global $dbcode;
	$array = array();
	if ($type == "0") {
		if ($record != $dbcode."0") {
			$name = trim($lDB->get("
				SELECT
					pr_name_last
				FROM
					pr_persona
				WHERE
					pr_persona_ix = '$record'
			", 4));
		} else {
			$name = "Properties";
		}
		# get children (see if accomms exist, if so just get accomms, else just get properties)
		$sep = "-";
		if ($flag == "1") {
			$sep = "&|&";
		}
		$array[0] = $record.$sep.$name;
		if ($lDB->count("ac_accomm_type","pr_business_id",$record,"0")) {
			$temp = $lDB->get("
				SELECT
				   pr_business_id
				FROM
				   pr_business
				WHERE
				   pr_business_parent = '$record'
				ORDER BY
				   pr_business_sequence
			", 3);
			cleanse($temp);
			# for each child property, push to array, then recurse
			$j = 1;
			foreach($temp as $child) {
				$array[$j] = get_prop_array($child,0,$flag);
				$j++;
			}
		} 
	} 
	return $array;
}

function fix_prop_sequence($item) {
	global $lDB;

	static $seq = 1;
	if(is_array($item)) {
		foreach($item as $val) fix_prop_sequence($val);
	} else {
		$explode = explode("&|&",$item);
		$lDB->put("
				UPDATE 
					pr_business 
				SET 
					pr_business_sequence = '" . $seq . "' 
				WHERE 
					pr_business_id = '" . $explode[0] . "'
			");
			$seq =$seq+1;
	}
}
if($record == "fix") {
	$prop_hierarchy = get_prop_array(0,0,1);

	foreach($prop_hierarchy as $key=>$item) {
		if($key == 0) {
			continue;
		}
		fix_prop_sequence($item);
	}
}
/************** [END] Temporary code to fix business structure ****************************************/

$GLOBALS['temp']['canAdd'] = " style=\"visibility: hidden;\"";

if ( checkJob(608) && checkJob(166) ) {
	$GLOBALS['temp']['canAdd'] = "";
}

$GLOBALS['temp']['canEdit']				= " style=\"visibility: hidden;\"";
$GLOBALS['temp']['propPopupJob']	= "";

if ( checkJob(170) || $GLOBALS['isPropServer'] ) {
	$GLOBALS['temp']['propPopupJob'] = "170";
	if ( checkJob(168) ) {
		$GLOBALS['temp']['propPopupJob'] = "168";
	}
	$GLOBALS['temp']['canEdit'] = "";
}

$GLOBALS['temp']['canMove']				= " style=\"visibility: hidden;\"";
$GLOBALS['temp']['accomPopupJob']	= "";

if ( checkJob(174) || $GLOBALS['isPropServer'] ) {
	$GLOBALS['temp']['accomPopupJob'] = "174";
	if ( checkJob(175) ) {
		$GLOBALS['temp']['accomPopupJob'] = "175";
	}
}

$GLOBALS['temp']['canDel'] = " style=\"visibility: hidden;\"";
$level = checkJob(172,2);

if ( $level != false ) {
	if ( $level > 6 ) {
		$GLOBALS['temp']['canDel'] = "";
	}

	if ( $level > 5 ) {
		$GLOBALS['temp']['canMove'] = "";
	}
}

// Delete property and associated persona and accomm records ------------------
if ( $record == "del" ) {
	$record = $_SERVER['argv'][2];

	if ( $_SERVER['argv'][3] == "1" ) {
		db_ac_accomm_type_delete($record);
		if (accommCanDelete($record) ) {
			$roomList = $lDB->get("
				SELECT 
					ac_accomm_room_ix
				FROM 
					ac_accomm_room 
				WHERE 
					ac_accomm_room.ac_accomm_type_id = '$record'
			",3);

			$attrList = $lDB->get("
				SELECT 
					ac_accomm_room_attr_ix 
				FROM 
					ac_accomm_room_attr 
				WHERE 
					ac_accomm_room_attr.ac_accomm_type_id = '$record'
			",3);

			$blockList = $lDB->get("
				SELECT 
					ac_accomm_block_ix
				FROM 
					ac_accomm_block 
				WHERE 
					ac_accomm_block.ac_accomm_type_id = '$record'
			",3);
				
			$roomBlockList = $lDB->get("
				SELECT 
					ac_accomm_room_block_ix
				FROM 
					ac_accomm_room_block 
				WHERE 
					ac_accomm_room_block.ac_accomm_room_id IN ('" . join("','",$roomList) . "') 
					OR 
					ac_accomm_room_block.ac_accomm_block_id IN ('" . join("','",$blockList) . "')
			",3);

			foreach ( $roomList as $item ) {
				$lDB->put("
					DELETE FROM 
						ac_accomm_room 
					WHERE 
						ac_accomm_room_ix = '$item'
				");
			}

			foreach ( $attrList as $item ) {
				$lDB->put("
					DELETE FROM 
						ac_accomm_room_attr 
					WHERE 
						ac_accomm_room_attr_ix = '$item'
				");
			}

			foreach ( $blockList as $item ) {
				$lDB->put("
					DELETE FROM 
						ac_accomm_block 
					WHERE 
						ac_accomm_block_ix = '$item'
				");
			}

			foreach ( $roomBlockList as $item ) {
				$lDB->put("
					DELETE FROM 
						ac_accomm_room_block 
					WHERE 
						ac_accomm_room_block_ix = '$item'
				");
			}
		}
	} else {
		if ( propCanDelete($record) && accommCanDelete() ) {
			$doDelList = $lDB->get("
				SELECT 
					ac_accomm_type_ix
				FROM 
					ac_accomm_type 
				WHERE 
					ac_accomm_type_ix IN ('" . join("','",$GLOBALS['accommChildList2B']) . "')
			",2);

			foreach ( $doDelList as $delItem ) {
				$lDB->put("
					DELETE FROM 
						ac_accomm_type 
					WHERE 
						ac_accomm_type_ix = '" . $delItem[0] . "'
				");

				$list = $lDB->get("
					SELECT 
						rt_rate_ix
					FROM 
						rt_rate 
					WHERE 
						ac_accomm_type_id = '" . $delItem[0] . "'
				",3);

				foreach ( $list as $accomm_rate ) {
					$lDB->put("
						DELETE FROM 
							rt_rate 
						WHERE 
							rt_rate_ix = '$accomm_rate'
					");
				}
			}

			$doDelList = $lDB->get("
				SELECT 
					pr_persona_ix
				FROM 
					pr_persona 
				WHERE 
					pr_persona_ix IN ('" . join("','",$GLOBALS['propChildList2B']) . "')
			",2);

			foreach ( $doDelList as $delItem ) {
				$lDB->put("
					DELETE FROM 
						pr_persona 
					WHERE 
						pr_persona_ix = '" . $delItem[0] . "'
				");
			}

			$doDelList = $lDB->get("
				SELECT 
					pr_business_id,
					pr_business_sequence
				FROM 
					pr_business 
				WHERE 
					pr_business_id IN ('" . join("','",$GLOBALS['propChildList2B']) . "')
			",2);
			
			foreach ( $doDelList as $delItem ) {
				$lDB->put("
					DELETE FROM 
						pr_business 
					WHERE 
						pr_business_id = '" . $delItem[0] . "'
				");
				
				$pr_business_ids = $lDB->get("
					SELECT
						pr_business_id
					FROM
						pr_business
					WHERE 
						pr_business_sequence > '" . $delItem['pr_business_sequence'] . "'
				", 3);
				foreach($pr_business_ids as $pr_business_id) {
					$lDB->put ("
						UPDATE 
							pr_business
						SET
							pr_business_sequence = pr_business_sequence-1
						WHERE 
							pr_business_id = '" . $pr_business_id . "'
					");
				}
			}

		} else {
			$currentDate = date("Y-m-d");
			$lDB->put("
				UPDATE 
					ac_accomm_type 
				SET 
					ac_accomm_type_inactive_yn = '1',
					ac_accomm_type_inactive_date = '" . $currentDate . "' 
				WHERE 
					ac_accomm_type_ix IN ('" . join("','",$GLOBALS['accommChildList2B']) . "')
			");

			$lDB->put("
				UPDATE 
					pr_business 
				SET 
					pr_bus_inactive_yn  = '1' 
				WHERE 
					pr_business_id IN ('" . join("','",$GLOBALS['propChildList2B']) . "')
			");

			$lDB->put("
				UPDATE 
					pr_persona 
				SET 
					pr_persona_inactive_yn = '1' 
				WHERE 
					pr_persona_ix IN ('" . join("','",$GLOBALS['propChildList2B']) . "')
			");
		}
	}
}
	
if ( $direction ) {
	// Get the maximum prop sequence number in order to check if this record is 
	// already last -------------------------------------------------------------
	$maxProp = $lDB->get("
		SELECT 
			pr_business_sequence 
		FROM 
			pr_business 
		WHERE 
			pr_business_parent = '" . $parent . "' 
		ORDER BY 
			pr_business_sequence DESC 
		LIMIT 1
	",4);
	
	// Get the minimum prop sequence number in order to check if this record is
	// already at the top --------------------------------------------------------
	$minProp = $lDB->get("
		SELECT 
			pr_business_sequence 
		FROM 
			pr_business 
		WHERE 
			pr_business_parent = '" . $parent . "' 
		ORDER BY 
			pr_business_sequence ASC 
		LIMIT 1
	",4);

	// Get the maximum accomm sequence number in order to check if this record is
	// already last -------------------------------------------------------------
	$maxAccomm = $lDB->get("
		SELECT 
			ac_accomm_sequence 
		FROM 
			ac_accomm_type 
		WHERE 
			pr_business_id = '" . $parent . "' 
		ORDER BY 
			ac_accomm_sequence DESC 
		LIMIT 1
	",4);
	
	// Get the minimum sequence number in order to check if this record is already
	// at the top ----------------------------------------------------------------
	$minAccomm = $lDB->get("
		SELECT 
			ac_accomm_sequence 
		FROM 
			ac_accomm_type 
		WHERE 
			pr_business_id = '" . $parent . "' 
		ORDER BY 
			ac_accomm_sequence ASC 
		LIMIT 1
	",4);
	
	switch ( $direction ) {
		case "up":
			// Check we have a sequence number and this record is not already at the top
			if ( !$accomm ) {
				$mySeq = $lDB->get("
					SELECT 
						pr_business_sequence 
					FROM 
						pr_business 
					WHERE 
						pr_business_id = '" . $record . "'
				",4);
				
				if ( $mySeq != $minProp ) {
					$upRec = $lDB->get("
						SELECT 
							pr_business_id,
							pr_business_sequence 
						FROM 
							pr_business 
						WHERE 
							pr_business_sequence < '" . $mySeq . "' 
							AND 
							pr_business_parent = '" . $parent . "' 
						ORDER BY 
							pr_business_sequence DESC 
						LIMIT 1
					",1);

					if ( $upRec[0] != "0" || $upRec[0] != "" ) {
						$lDB->put("
							UPDATE 
								pr_business 
							SET 
								pr_business_sequence = '" . $mySeq . "' 
							WHERE 
								pr_business_id = '" . $upRec[0] . "'
						"); 
						$newSeq = (int)$upRec[1];
						$newSeq = updateSequence($record, $upRec[1]);
						
						$list = $lDB->get("SELECT pr_business_id FROM pr_business WHERE pr_business_parent = '" . $parent . "' AND pr_business_sequence > '" . $upRec[1] . "' ORDER BY pr_business_sequence ",3);
						
						if(is_array($list) && !empty($list)) {
							foreach($list as $item) {
								$newSeq = updateSequence($item, $newSeq);
							}
						}

					}
				}
			} else {
				$mySeq = $lDB->get("
					SELECT 
						ac_accomm_sequence 
					FROM 
						ac_accomm_type 
					WHERE 
						ac_accomm_type_ix = '$record'
				",4);

				if ( $mySeq != $minAccomm ) {
					$upRec = $lDB->get("
						SELECT 
							ac_accomm_type_ix,
							ac_accomm_sequence 
						FROM 
							ac_accomm_type 
						WHERE 
							ac_accomm_sequence < '" . $mySeq . "' 
						AND 
							pr_business_id = '" . $parent . "' 
						ORDER BY 
							ac_accomm_sequence DESC 
						LIMIT 1
				",1);

				if ( $upRec[0] != "0" || $upRec[0] != "" ) {
					$lDB->put("
						UPDATE 
							ac_accomm_type 
						SET 
							ac_accomm_sequence = '" . $mySeq . "' 
						WHERE 
							ac_accomm_type_ix = '" . $upRec[0] . "'
					");

					$lDB->put("
						UPDATE 
							ac_accomm_type 
						SET 
							ac_accomm_sequence = '" . $upRec[1] . "' 
						WHERE 
							ac_accomm_type_ix = '" . $record . "'
					");
				}
			}
		}
		break;

		case "down":
			if ( !$accomm ) {
				$mySeq = $lDB->get("
					SELECT 
						pr_business_sequence 
					FROM 
						pr_business 
					WHERE 
						pr_business_id = '" . $record . "'
				",4);

				if ( $mySeq != $maxProp ) {
					$upRec = $lDB->get("
						SELECT 
							pr_business_id,
							pr_business_sequence 
						FROM 
							pr_business 
						WHERE 
							pr_business_sequence > '" . $mySeq . "' 
						AND 
							pr_business_parent = '" . $parent . "' 
						ORDER BY 
							pr_business_sequence ASC 
						LIMIT 1
					",1);

					if ( $upRec[0] != "0" || $upRec[0] != "" ) {
						$lDB->put("
							UPDATE 
								pr_business 
							SET 
								pr_business_sequence = '" . $upRec[1] . "' 
							WHERE 
								pr_business_id = '" . $record . "'
						");

						$newSeq = updateSequence($upRec[0], $mySeq);
						
						$list = $lDB->get("SELECT pr_business_id FROM pr_business WHERE pr_business_parent = '" . $parent . "' AND pr_business_sequence > '" . $mySeq . "' ",3);
						
						if(is_array($list) && !empty($list)) {
							foreach($list as $item) {
								$newSeq = updateSequence($item, $newSeq);
							}
						}
					}
				}
			} else {
				$mySeq = $lDB->get("
					SELECT 
						ac_accomm_sequence 
					FROM 
						ac_accomm_type 
					WHERE 
						ac_accomm_type_ix = '$record'
				",4);

				if ( $mySeq != $maxAccomm ) {
					$upRec = $lDB->get("
						SELECT 
							ac_accomm_type_ix,
							ac_accomm_sequence 
						FROM 
							ac_accomm_type 
						WHERE 
							ac_accomm_sequence > '" . $mySeq . "' 
						AND 
							pr_business_id = '" . $parent . "' 
						ORDER BY 
							ac_accomm_sequence ASC 
						LIMIT 1
					",1);

					if ( $upRec[0] != "0" || $upRec[0] != "" ) {
						$lDB->put("
							UPDATE 
								ac_accomm_type 
							SET 
								ac_accomm_sequence = '" . $mySeq . "' 
							WHERE 
								ac_accomm_type_ix = '" . $upRec[0] . "'
						");

						$lDB->put("
							UPDATE 
								ac_accomm_type 
							SET 
								ac_accomm_sequence = '" . $upRec[1] . "' 
							WHERE 
								ac_accomm_type_ix = '" . $record . "'
						");
					}
				}
			}
			break;
	}
}

// Generate HTML output -------------------------------------------------------
$GLOBALS['temp']['rows'] = "";

$rowsout = "";

function viewRecurArray($array,$n=1,$start="") {
	global $lDB;
	if ( $start != "" ) {
		$start .= "_";
	}
	$start .= $n;

	if ( preg_match("/_/",$start) ) {
		$temp = explode("_",$start);
		$count = sizeof($temp);
	} else {
		$count = 1;
	}

	if ( !array_key_exists('maxcount',$GLOBALS) ) {
		$GLOBALS['maxcount'] = 0;
	}

	if ( $count > $GLOBALS['maxcount'] ) {
		$GLOBALS['maxcount'] = $count;
	}

	$mout = "";
	for ( $i = 1; $i < sizeof($array); $i++ ) {
		if ( gettype($array) == "array" ) {
			$mout .= viewRecurArray($array[$i],$i,$start);
		}
	}

	$colspan = $GLOBALS['maxcount'] - $count + 1;

	$out = "";
	if ( $colspan != "1" ) {
		$out .= "<span class=\"head\">\n";
	}

	for ( $i = 0; $i < $count; $i++ ) {
		if ( $i + 1 == $count ) {
			$temp	= explode("&|&",$array[0]);
			$id		= $temp[0];
			$text	= $temp[1];

			if ( array_key_exists(2,$temp) ) {
				$is_accomm = $temp[2];
			} else {
				$is_accomm = "";
			}

			// Check if this node is an accommodation type -----------------------------
			if ( $is_accomm == "ACC" ) {
				$src="/resource/Resrequest/Application/public/img/property_expanded.gif";
				$is_accomm = "1";
				$style = "txt";
			} else {
				$src="/resource/Resrequest/Application/public/img/property_expanded.gif";
				$is_accomm = "0";
			}

			$disallowDelete = "0";
			$isInvRes = $isInvProp = false;
			if ( !$is_accomm ) {
				$sqlResult = false;
				if ($id !== "0"){
					$sqlResult = $lDB->get("
						SELECT 
							pr_business_parent,
							pr_bus_property_yn,
							pr_bus_billing_yn,
							pr_bus_billing_prop_yn
						FROM 
							pr_business 
						WHERE 
							pr_business_id = '" . $id . "'
					",1);

					if ($sqlResult['pr_bus_billing_yn'] == 1) $isInvRes = true;
					if ($sqlResult['pr_bus_billing_prop_yn'] == 1) $isInvProp = true;

					$business_parent = $sqlResult[0];
				} else {
					$business_parent = 0;
				}

				if ( $sqlResult !== false && array_key_exists(1,$sqlResult) ) {
					$pr_bus_property_yn = $sqlResult[1];
				} else {
					$pr_bus_property_yn = "0";
				}

				if ( $pr_bus_property_yn ) {
					$style = "txtb";
				} else {
					$style = "txtbbr";
				}

				$temp = $lDB->get("
					SELECT 
						pr_bus_inactive_yn 
					FROM 
						pr_business 
					WHERE 
						pr_business_id = '" . $id . "'
				",1);

				if ( $temp[0] == "0" ) {
					$inA = "";
					$inB = "";
				} else {
					$inA = "<i>";
					$inB = "</i>";
				}
			} else {
				$temp = $lDB->get("
					SELECT 
						pr_business_id,
						ac_accomm_type_inactive_yn 
					FROM 
						ac_accomm_type 
					WHERE 
						ac_accomm_type_ix = '" . $id . "'
				",1);
				$resCheck = $lDB->get("
					SELECT
						COUNT(*)
					FROM
						rv_reservation_item
						INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
					WHERE
						rv_reservation_item.ac_accomm_type_id = '$id'
						AND rv_reservation_item.rv_item_date_depart >= '".date("Y-m-d")."'
						AND (
							rv_reservation.rf_reservation_status_id = '30'
							OR (
								rv_reservation.rf_reservation_status_id = '20'
								AND rv_reservation.rv_provision_expiry_date <= '" . date("Y-m-d") . "'
							)
						)
				",4);
				$roomCheck = $lDB->get("
					SELECT
						COUNT(*)
					FROM
						rv_res_item_group
						INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
						INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
						INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
					WHERE
						ac_accomm_room.ac_accomm_type_id = '$id'
						AND rv_reservation_item.rv_item_date_depart >= '".date("Y-m-d")."'
						AND (
							rv_reservation.rf_reservation_status_id = '30'
							OR (
								rv_reservation.rf_reservation_status_id = '20'
								AND rv_reservation.rv_provision_expiry_date <= '" . date("Y-m-d") . "'
							)
						)
				",4);
				if($resCheck > 0 || $roomCheck > 0) {
					$disallowDelete = "1";
				}

				$pr_bus_property_yn = "0";
				$business_parent = $temp[0];

				if ( $temp[1] == "0" ) {
					$inA = "";
					$inB = "";
				} else {
					$inA = "<i>";
					$inB = "</i>";
				}
			}

			$out .= "<span id=\"folder" . $start . "\" selectable=\"no\" class=\"" . $style . "\" onclick=\"\" style=\"position: relative;\">";
			//$out .= "<img src=" . $src . " border=\"0\" id=\"img" . $start . "\" onclick=\"change('img" . $start . "')\" alt=\"\" />";

			if ( $count != 1 ) {

				$indicator = $hover = array();
				$style = $gridElemColor = "";

				if ($pr_bus_property_yn) {
					$gridElemColor = "gridElemBlue";
					$hover[] = "Property";
					$indicator[] = "Property";
				}

				if ($isInvRes || $isInvProp) {
					$gridElemColor = "gridElemRed";
					$invoicingFor = array();
					if ($isInvRes) $invoicingFor[] = "Res";
					if ($isInvProp) $invoicingFor[] = "Prop";
					$hover[] = "Invoicing unit for " . join(", ", $invoicingFor);;
					$indicator[] = "Inv: " . join(", ", $invoicingFor);
				}

				$out .= "&nbsp;&nbsp;";

				if (!$is_accomm) {
					$out .= "<i class=\"material-icons expandCollapseCircles gridElem\" id=\"tree" . $start . "Icon\" style=\"cursor: pointer\" onclick=\"toggleTree('tree" . $start . "');\">remove_circle</i>";
				}

				$out .= "
					<input type=\"radio\" id=\"select_$is_accomm\_$id\" name=\"select\" value=\"" . $id . "\" onclick=\"nodeSelected('" . $id . "','" . $business_parent . "','" . $pr_bus_property_yn . "','" . $is_accomm . "','$disallowDelete')\" title=\"" . trim(join(', ', $hover)) . "\" class=\"busRadio\" tree=\"" . $start . "\"/>
					<input type=\"hidden\" id=\"" . $id . "\" value=\"" . $business_parent . "\" />
					<label for=\"select_$is_accomm\_$id\" class=\"" . $gridElemColor . "\" title=\"" . trim(join(', ', $hover)) . "\">
						&nbsp;&nbsp;" . $inA . $text . $inB . "
					</label>
					<span style=\"color: #777; font-size: smaller; margin-left: 10px;\" class=\"gridElem\">" . trim(join(", ", $indicator)) . "</span>
					</span><br />\n";
			} else {
				$out .= "&nbsp;&nbsp;&nbsp;&nbsp;" . $inA . $text . $inB . "</span><br />\n";
			}
		}
	}

	if ( $colspan != "1" ) {
		$out .= "</span>\n";
		$out .= "<span class=\"subhead\" id=\"tree" . $start . "\" style=\"display: block;\">" . $mout . "</span>\n";
  }
  return $out;
}

$hierarchy = recurse_array(0,0,1);
$rowsout = viewRecurArray($hierarchy);

$GLOBALS['temp']['rows'] = $rowsout;

$hidelist = array();
$GLOBALS[$form]->Hide($hidelist);

$disablelist = array();
$GLOBALS[$form]->Disable($disablelist);

function updateSequence($record, $newSeq) {
	global $lDB;
	$lDB->put("
		UPDATE 
			pr_business 
		SET 
			pr_business_sequence = '" . $newSeq . "' 
		WHERE 
			pr_business_id = '" . $record . "'
	");
	
	$newSeq = $newSeq + 1;

	$list = $lDB->get("
		SELECT 
			pr_business_id 
		FROM 
			pr_business 
		WHERE 
			pr_business_parent = '" . $record . "'
	", 3);

	if(is_array($list) && !empty($list)) {
		foreach($list as $item) {
			$lDB->put("
				UPDATE 
					pr_business 
				SET 
					pr_business_sequence = '" . $newSeq . "' 
				WHERE 
					pr_business_id = '" . $item . "'
			");
			$newSeq = $newSeq +1;
		}
	}
	return $newSeq;
}
