<?php
/**
 * init.form77.php - Accommodation setup popup
 * Job: 174, 175, 176, 606, 607, 608 
 * Function: 61 (Business structure) 
*/

$_SERVER['argv'] = array_pad($_SERVER['argv'],6,"");

if (!array_key_exists($form, $GLOBALS)) {
	$GLOBALS[$form] = "";
}

// Job Numbers
$newr = 608;
$edit = 175;
$view = 174;
$dele = 606;
$sedit = 176;
$snewr = 607;

$record = $_SERVER['argv'][1];
$GLOBALS['passthrurecord'] = (isset($GLOBALS['passthrurecord']) ? $GLOBALS['passthrurecord'] : "");

$ajaxAction = $_SERVER['argv'][5];

$resCheck = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_reservation_item
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	WHERE
		rv_reservation_item.ac_accomm_type_id = '$record'
		AND rv_reservation_item.rv_item_date_depart >= '".date("Y-m-d")."'
		AND (
			rv_reservation.rf_reservation_status_id = '30'
			OR (
				rv_reservation.rf_reservation_status_id = '20'
				AND rv_reservation.rv_provision_expiry_date <= '" . date("Y-m-d") . "'
			)
		)
",4);
$roomCheck = $GLOBALS['lDB']->get("
	SELECT
		COUNT(*)
	FROM
		rv_res_item_group
		INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
		INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
	WHERE
		ac_accomm_room.ac_accomm_type_id = '$record'
		AND rv_reservation_item.rv_item_date_depart >= '".date("Y-m-d")."'
		AND (
			rv_reservation.rf_reservation_status_id = '30'
			OR (
				rv_reservation.rf_reservation_status_id = '20'
				AND rv_reservation.rv_provision_expiry_date <= '" . date("Y-m-d") . "'
			)
		)
",4);
if($resCheck > 0 || $roomCheck > 0) {
	$GLOBALS['temp']['resCheck'] = "1";
} else {
	$GLOBALS['temp']['resCheck'] = "0";
}
if($ajaxAction != "") {

	if($ajaxAction == "1") {
		$fromDate = useDate("from",$_POST['blockFromDate']);
		$toDate = useDate("to",$_POST['blockToDate']);
		// Add one day to the to date. This is required for the overbooking popup to function correctly
		$toDateArray = explode("-",$toDate['jsDate']);
		$finalToDate = date("Y-m-d",mktime(0,0,0,$toDateArray[1],$toDateArray[2]+1,$toDateArray[0]));
		$finalToDateLess = date("Y-m-d",mktime(0,0,0,$toDateArray[1],$toDateArray[2]-1,$toDateArray[0]));

		if (isset( $_POST['roomType']) && $_POST['roomType'] == "all" ) {
			$roomArray = $GLOBALS['lDB']->get("SELECT ac_accomm_room_ix FROM ac_accomm_room WHERE ac_accomm_type_id = '" . $record . "'",3);
		} else {
			if ( trim($_POST['roomsIds'] != "") ) {
				$roomArray = explode(":",$_POST['roomsIds']);
			} else {
				$roomArray = array();
			}
		}

		$allowUpdate = true;
		$allowUpdateStock = true;

		if ( sizeof($roomArray) > 0 ) {
			// Check for an overbooking at the room level
			foreach($roomArray as $item) {
				$resCount = $GLOBALS['lDB']->get("
					SELECT
						COUNT(*)
					FROM
						rv_res_item_group
						INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
					WHERE
						rv_res_item_group.ac_accomm_room_id = '$item'
						AND (
							(
								rv_reservation_item.rv_item_date_arrive >= '$fromDate[jsDate]'
								AND rv_reservation_item.rv_item_date_arrive < '$toDate[jsDate]'
							) OR (
								rv_reservation_item.rv_item_date_depart > '$fromDate[jsDate]'
								AND rv_reservation_item.rv_item_date_depart <= '$toDate[jsDate]'
							)
						)
				",4);
				if($resCount > 0) {
					$allowUpdate = false;
				}
			}
			// Check for an overbooking at the availability level
			$stock = new Stock($record,$fromDate['jsDate'],$finalToDateLess,false,false,false,false,join(":",$roomArray));
			$avail = $stock->ToAvailability();

			foreach($avail as $item) {
				if($item - sizeof($roomArray) < 0) {
					$allowUpdateStock = false;
					$GLOBALS['temp']['denyFromDate'] = $fromDate['jsDate'];
					$GLOBALS['temp']['denyToDate'] = $toDate['jsDate'];
				}
			}

			if($allowUpdate == false) {
				$GLOBALS['temp']['denyRoomList'] = join(":",$roomArray);
				$GLOBALS['temp']['denyFromDate'] = $fromDate['jsDate'];
				$GLOBALS['temp']['denyToDate'] = $toDate['jsDate'];
				$allowUpdateStock = true;
			}
		}

		if($allowUpdate) {
			echo "true\n";
		} else {
			echo "false\n";
		}

		if($allowUpdateStock) {
			echo "true\n";
		} else {
			echo "false\n";
		}

		echo $fromDate['jsDate'] . "\n";
		echo $finalToDate . "\n";
		//echo $toDate['jsDate'] . "\n";
		echo join(":",$roomArray) . "\n";
	}
	die();
}

$GLOBALS['bypassAddCheck'] = true;

$GLOBALS['autovar'] = "1";
if ($record != "") {
	$GLOBALS['passthrurecord'] = $record;
} else {
	if ($action != "2") {
		$record = $GLOBALS['passthrurecord'];
		if ($_SERVER['argv'][1] == "") {
			$_SERVER['argv'][1] = $record;
		}
	}
}

$parent = $_SERVER['argv'][2];
$panel = $_SERVER['argv'][3];



// We're deleting an image
if(isset($_POST['imagesDelete'])) {
	$principal_id = substr($lDB->name, 8);

	$images = json_decode($_POST['imagesDelete'], true);

	foreach ($images as $image) {
		$image_filename = $lDB->get("
			SELECT
				ac_accomm_image.ac_accomm_image_filename
			FROM
				ac_accomm_image
			WHERE
				ac_accomm_image.ac_accomm_image_ix = '".$image['id']."'
		",4);
		
		if (!empty($image_filename)) {
			$target = '../images/'.$principal_id.'/business_structure/'.$parent.'/'.$record.'/'.$image_filename;
			unlink($target);
			$result = delete_accomm_image($image['id']);
		}
	}

	$imageData = json_encode( get_accomm_image_listing_data($parent, $record) );
	echo "<script language=\"javascript\">parent.reloadImageListing('".$imageData."');</script>";
	echo "<script language=\"javascript\">parent.imageDeleteResultPopupShow(1);</script>"; // Success

	die();
}

// We're uploading an image
if(isset($_POST['imageUploadType'])) {
	$principal_id = substr($lDB->name, 8);
	$image_description = $_POST['imageDescription'];

	if (!is_dir('../images')) {
		if (!mkdir('../images', 0777, true)) {
			echo "<script language=\"javascript\">parent.imageUploadResultPopupShow(0);</script>";
			die();
		}
	}
	if (!is_dir('../images/'.$principal_id)) {
		if (!mkdir('../images/'.$principal_id, 0777, true)) {
			echo "<script language=\"javascript\">parent.imageUploadResultPopupShow(0);</script>";
			die();
		}
	}
	if (!is_dir('../images/'.$principal_id.'/business_structure')) {
		if (!mkdir('../images/'.$principal_id.'/business_structure', 0777, true)) {
			echo "<script language=\"javascript\">parent.imageUploadResultPopupShow(0);</script>";
			die();
		}
	}
	if (!is_dir('../images/'.$principal_id.'/business_structure/'.$parent)) {
		if (!mkdir('../images/'.$principal_id.'/business_structure/'.$parent, 0777, true)) {
			echo "<script language=\"javascript\">parent.imageUploadResultPopupShow(0);</script>";
			die();
		}
	}
	if (!is_dir('../images/'.$principal_id.'/business_structure/'.$parent.'/'.$record)) {
		if (!mkdir('../images/'.$principal_id.'/business_structure/'.$parent.'/'.$record, 0777, true)) {
			echo "<script language=\"javascript\">parent.imageUploadResultPopupShow(0);</script>";
			die();
		}
	}
	$image_filename = basename($_FILES['imageUploadFile']['name']);
	$image_filename = strtolower(preg_replace(array('/[^\w\(\).-]/i','/(_)\1+/'),'_',$image_filename));
	$image_filename = date("Y-m-d_H-i-s").'_'.str_replace(" ", "_", $image_filename);
	$target_path = '../images/'.$principal_id.'/business_structure/'.$parent.'/'.$record.'/'.$image_filename;

	if(move_uploaded_file($_FILES['imageUploadFile']['tmp_name'], $target_path)) {
		$ac_accomm_image_db = insert_accomm_uploaded_image($image_filename, $image_description, $record);
		$imageData = json_encode( get_accomm_image_listing_data($parent, $record) );
		echo "<script language=\"javascript\">parent.imageUploadResultPopupShow(1);</script>"; // Success
		echo "<script language=\"javascript\">parent.reloadImageListing('".$imageData."');</script>";
		
	} else {
		echo "<script language=\"javascript\">parent.imageUploadResultPopupShow(0);</script>"; // Failure
	}
	die();
}

$GLOBALS['temp']['record'] = $record;
$GLOBALS['temp']['parent'] = $parent;
$GLOBALS['temp']['panel'] = $panel;
$GLOBALS['temp']['allowUpdate'] = "true";
if(isset($_SESSION['allowUpdate'])) {
	$GLOBALS['temp']['allowUpdate'] = $_SESSION['allowUpdate'];
	session_restart();
	unset($_SESSION['allowUpdate']);
	session_write_close();
}
$GLOBALS['temp']['allowUpdateStock'] = "true";
if(isset($_SESSION['allowUpdateStock'])) {
	$GLOBALS['temp']['allowUpdateStock'] = $_SESSION['allowUpdateStock'];
	session_restart();
	unset($_SESSION['allowUpdateStock']);
	session_write_close();
}

$GLOBALS['temp']['nameList'] = t_encodeHTMLField(join(":|:",$GLOBALS['lDB']->get("
	SELECT
		ac_accomm_desc
	FROM
		ac_accomm_type
	WHERE
		pr_business_id = '$parent'
		AND ac_accomm_type_ix <> '$record'
",3)));
$GLOBALS['temp']['abbrvList'] = t_encodeHTMLField(join(":|:",$GLOBALS['lDB']->get("
	SELECT
		ac_accomm_name_short
	FROM
		ac_accomm_type
	WHERE
		pr_business_id = '$parent'
		AND ac_accomm_type_ix <> '$record'
",3)));

if (!is_object($GLOBALS[$form])) {
	if($panel == "" || $panel == "0") {
		$GLOBALS[$form] = new Form("form77","",__DIR__ . "/../../../public/html/property_accomm.htm");
	} elseif ($panel == "1") {
		$GLOBALS[$form] = new Form("form77","",__DIR__ . "/../../../public/html/property_acc_rooms.htm");
	} elseif ($panel == "2") {
		$GLOBALS[$form] = new Form("form77","",__DIR__ . "/../../../public/html/property_block.htm");
	}
	$fields = array(
		"ac_accomm_type_ix",
		"ac_accomm_desc",
		"ac_accomm_name_short",
		"ac_accomm_wetu_id",
		"ac_accomm_no_of_units",
		"ac_accomm_capacity",
		"ac_accomm_note",
		"ac_accomm_sequence",
		"pr_business_id",
		"ac_accomm_max_capacity",
		"ac_accomm_max_adults",
		"ac_accomm_max_child_age",
		"ac_accomm_type_inactive_yn"
	);
	$ident = array("ac_accomm_desc");
	$GLOBALS[$form]->AddTable($GLOBALS['lDB'],"ac_accomm_type",$fields,"ac_accomm_type_ix = '$record'","","",$ident);
}
$GLOBALS[$form]->Get($action);

// Refresh the table ??TOBIE, WHAT IS THIS??
$table = $GLOBALS[$form]->TableList[0];

if ($record != "" || $action == "3" && $action != "1") {
	$GLOBALS[$table]->Refresh($record,$action);
}

// If record is being saved, lookup required data ??TOBIE, WHAT IS THIS??
if ($action == "2") {
	if ($pmode == "0") {
		# get the highest seq number for this accomm's prop
		$temp = $GLOBALS['lDB']->get("SELECT MAX(ac_accomm_sequence)+1 FROM ac_accomm_type WHERE pr_business_id = '$parent'",4);
		$GLOBALS['form77_ac_accomm_type_ac_accomm_sequence']->SetValue($temp);

		# set the parent Id
		$GLOBALS['form77_ac_accomm_type_pr_business_id']->SetValue($parent);
	}
	# force the dbcode
	$GLOBALS['form77_ac_accomm_type_ac_accomm_type_db']->SetValue($dbcode);
}

// Set title
$GLOBALS['temp']['parent_name'] = t_encodeHTMLField($GLOBALS['lDB']->get("
	SELECT
		pr_name_last
	FROM
		pr_persona
		INNER JOIN ac_accomm_type ON ac_accomm_type.pr_business_id = pr_persona.pr_persona_ix
	WHERE
		ac_accomm_type_ix = '$record'
",4));
$GLOBALS['temp']['accomm_desc'] = t_encodeHTMLField($GLOBALS['form77_ac_accomm_type_ac_accomm_desc']->Value);
if($action == 2) {
	$GLOBALS['temp']['accomm_desc'] = "[NEW]";
	$GLOBALS['temp']['parent_name'] = t_encodeHTMLField($GLOBALS['lDB']->get("SELECT pr_name_last FROM pr_persona WHERE pr_persona_ix = '".$_SERVER['argv'][2]."'",4));
}

// Inactive record dropdown
$actVal = "0";
$inActVal = "1";
$actFlag = "form77_ac_accomm_type_ac_accomm_type_inactive_yn";
$hidelist = array();
if ($GLOBALS[$actFlag]->Value == $actVal || $action == "2") {
	$GLOBALS[$actFlag]->Value = $actVal;
	$GLOBALS['temp']['actInd'] = " style=\"display: none\"";
	$hidelist = array($actFlag);
} else {
	if ($record == "" && $action == "1") {
		$GLOBALS['temp']['actInd'] = " style=\"display: none\"";
	} else {
		$GLOBALS[$actFlag]->Value = $inActVal;
		$GLOBALS['temp']['actInd'] = "";
	}
}
$GLOBALS[$actFlag]->Select(array("$inActVal-Inactive","$actVal-Active"));
$GLOBALS[$actFlag]->StyleType = "txts";

array_push($hidelist,"form77_ac_accomm_type_ac_accomm_sequence");
array_push($hidelist,"form77_ac_accomm_type_pr_business_id");

$disablelist = array();

// Set fields
$GLOBALS['form77_ac_accomm_type_ac_accomm_no_of_units']->TabIndex = 2;
$GLOBALS['form77_ac_accomm_type_ac_accomm_no_of_units']->StyleType = "txtr";
$GLOBALS['form77_ac_accomm_type_ac_accomm_capacity']->TabIndex = 4;
$GLOBALS['form77_ac_accomm_type_ac_accomm_capacity']->StyleType = "txtr";
$GLOBALS['form77_ac_accomm_type_ac_accomm_max_capacity']->StyleType = "txtr";
$GLOBALS['form77_ac_accomm_type_ac_accomm_max_capacity']->TabIndex = 6;
$GLOBALS['form77_ac_accomm_type_ac_accomm_max_adults']->StyleType = "txtr";
$GLOBALS['form77_ac_accomm_type_ac_accomm_max_adults']->TabIndex = 7;
$GLOBALS['form77_ac_accomm_type_ac_accomm_max_child_age']->StyleType = "txtr";
$GLOBALS['form77_ac_accomm_type_ac_accomm_max_child_age']->TabIndex = 8;
$GLOBALS['form77_ac_accomm_type_ac_accomm_max_adults']->Width = 80;
$GLOBALS['form77_ac_accomm_type_ac_accomm_max_child_age']->Width = 80;
$GLOBALS['form77_ac_accomm_type_ac_accomm_max_capacity']->Width = 80;
$GLOBALS['form77_ac_accomm_type_ac_accomm_capacity']->Width = 80;
if($panel == "" || $panel == "0") {
	$GLOBALS['form77_ac_accomm_type_ac_accomm_desc']->TabIndex = 1;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_desc']->Size = 25;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_desc']->StyleType = "txt";
	$GLOBALS['form77_ac_accomm_type_ac_accomm_name_short']->TabIndex = 3;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_name_short']->StyleType = "txt";
	$GLOBALS['form77_ac_accomm_type_ac_accomm_wetu_id']->TabIndex = 4;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_wetu_id']->StyleType = "txt";
	$GLOBALS['form77_ac_accomm_type_ac_accomm_note']->TabIndex = 5;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_note']->StyleType = "txt";
	$GLOBALS['form77_ac_accomm_type_ac_accomm_note']->Size = 35;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_note']->Rows = 6;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_note']->Cols = 75;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_no_of_units']->IsReadonly = true;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_capacity']->IsReadonly = true;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_max_capacity']->IsReadonly = true;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_max_adults']->IsReadonly = true;
	$GLOBALS['form77_ac_accomm_type_ac_accomm_max_child_age']->IsReadonly = true;
} elseif ($panel == "1") {
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_desc");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_name_short");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_wetu_id");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_note");
} elseif ($panel == "2") {
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_desc");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_name_short");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_wetu_id");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_note");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_no_of_units");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_capacity");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_max_capacity");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_max_adults");
	array_push($hidelist,"form77_ac_accomm_type_ac_accomm_max_child_age");
}

$GLOBALS[$form]->Hide($hidelist);
$GLOBALS[$form]->Disable($disablelist);

if ($dbcode[0] == "W") {
	$imageHtml = get_accomm_image_listing_html($parent, $record);
	$GLOBALS['temp']['image_html'] = $imageHtml;
	$GLOBALS['temp']['meta_data_images_display'] = "";
	$GLOBALS['temp']['meta_data_images_display_grey_out'] = "";
	$GLOBALS['temp']['meta_data_images_display_offline_message'] = "";
} else {
	$GLOBALS['temp']['meta_data_images_display'] = "display:none;";
	$GLOBALS['temp']['meta_data_images_display_grey_out'] = "color:#777;";
	$GLOBALS['temp']['meta_data_images_display_offline_message'] = "Images are only available on WA or WB environments";
}

// Start Access Control Toolbar Setup
$pgJOBS = array();
$pgJOBS['add'] = "0";
$pgJOBS['edit'] = "0";
$pgJOBS['view'] = "0";
$pgJOBS['saveclose'] = "0";
$pgJOBS['del'] = "0";
$pgJOBS['save'] = "0";
if (checkJob($view)) {
	$pgJOBS['view'] = "1";
}

if (checkJob($newr)) {
	$pgJOBS['add'] = "1";
}

if (checkJob($edit)) {
	$pgJOBS['edit'] = "1";
}

if ($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
	$pgJOBS['saveclose'] = "1";
}
if ($action == "2" || $action == "4" || $record == null) {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if (checkJob($dele)) {
		$pgJOBS['del'] = "1";
	}
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobNew\" value=\"$pgJOBS[add]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobEdit\" value=\"$pgJOBS[edit]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobDelete\" value=\"$pgJOBS[del]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"$pgJOBS[save]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSaveclose\" value=\"$pgJOBS[saveclose]\">\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobExit\" value=\"1\">\n";
// End Access Control Toolbar Setup

$tabJob = "174";
if(checkjob(175)) {
	$tabJob = "175";
}
$GLOBALS['temp']['tabJob'] = $tabJob;

// Action switch
switch ($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['new_record'] = "reservation.php?$newr";
	$GLOBALS['temp']['edit_view'] = "175";
	$GLOBALS['temp']['save_record'] = "#";
	$GLOBALS['temp']['del_record'] = "#";
	// $GLOBALS['temp']['inactive_check'] .= " disabled";
	break;
case (2) : // Add Record
	$GLOBALS[$form]->Arguments = $snewr."++".$parent;
	$GLOBALS['temp']['new_record'] = "reservation.php?$newr";
	$GLOBALS['temp']['edit_view'] = "#";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "#";
	$GLOBALS['mode'] = "new";
	break;
case (3) : // Edit Record
	$GLOBALS[$form]->Arguments = "$sedit+$record+$parent+$panel";
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['new_record'] = "reservation.php?$newr";
	$GLOBALS['temp']['edit_view'] = "174";
	$GLOBALS['temp']['save_record'] = "document.forms[0].submit()";
	$GLOBALS['temp']['del_record'] = "reservation.php?".$dele."+".$record;
	break;
case (4) : // Delete Record
	if(!db_ac_accomm_type_delete($record)) {
		redirectTo(" ./reservation.php?".$view."+".$_SERVER['argv'][1]);
	}
	break;
}

// Add rooms
if($pmode == "1" && (isset($_POST['addUnits']) && $_POST['addUnits'] != "") && (isset($_POST['addStart']) && $_POST['addStart'] != "") && (isset($_POST['roomComponentsIds']) && $_POST['roomComponentsIds'] != "")) {
	// Find highest numbered room
	$highest = $GLOBALS['lDB']->get("
		SELECT
			max(ac_desc+0) as highest
		FROM
			ac_accomm_room
		WHERE
			ac_desc > 0
			AND ac_accomm_type_id = '$record'
	",4);
	$componentArray = explode(":",$_POST['roomComponentsIds']);

	$start = $_POST['addStart'];
	$num = $_POST['addUnits'];
	if($start < $highest) {
		$start = $highest+1;
	}
	for($count = $start; $count < ($start + $num); $count++) {
		$ac_accomm_room_id = db_ac_accomm_room_insert($record,$count);
		if($_POST['roomComponentsIds'] != "none") {
			foreach($componentArray as $item) {
				db_ac_accomm_room_attr_insert($ac_accomm_room_id,$item);
			}
		}
	}
}

if($pmode == "1" && (isset($_POST['attrAdd']) && $_POST['attrAdd'] != "") || (isset($_POST['attrRemove']) && $_POST['attrRemove'] != "")) {
	if(trim($_POST['attrAdd']) != "") {
		$addArray = explode("+",$_POST['attrAdd']);
		foreach($addArray as $item) {
			list($ac_accomm_room_id,$rt_component_id) = explode(":",$item);
			db_ac_accomm_room_attr_insert($ac_accomm_room_id,$rt_component_id);
		}
	}
	if(trim($_POST['attrRemove']) != "") {
		$removeArray = explode("+",$_POST['attrRemove']);
		foreach($removeArray as $item) {
			list($ac_accomm_room_id,$rt_component_id) = explode(":",$item);
			db_ac_accomm_room_attr_delete_by_all($ac_accomm_room_id,$rt_component_id);
		}
	}
}
if ($pmode == "1" && isset($_POST['nameChange']) && $_POST['nameChange'] != "") {
	$nameList = explode("+",$_POST['nameChange']);
	foreach($nameList as $item) {
		db_ac_accomm_room_set_desc($item,$_POST[$item."_name"]);
	}
}

if($pmode == "1" && isset($_POST['deleteRoomId']) && $_POST['deleteRoomId'] != "") {
	db_ac_accomm_room_delete($_POST['deleteRoomId']);
}

if($pmode == "1" && isset($_POST['roomType']) && $_POST['roomType'] != "" && isset($_POST['blockFromDate']) && $_POST['blockFromDate'] != "" && isset($_POST['blockToDate']) && $_POST['blockToDate'] != "" && ((isset($_POST['editBlockId']) && $_POST['editBlockId'] != "") || (isset($_POST['addBlock']) && $_POST['addBlock'] != ""))) {
	// Add room block
	$fromDate = useDate("from",$_POST['blockFromDate']);
	$toDate = useDate("to",$_POST['blockToDate']);
	if($_POST['roomType'] == "all") {
		$roomArray = $GLOBALS['lDB']->get("SELECT ac_accomm_room_ix FROM ac_accomm_room WHERE ac_accomm_type_id = '$record'",3);
	} else {
		if(trim($_POST['roomsIds'] != "")) {
			$roomArray = explode(":",$_POST['roomsIds']);
		} else {
			$roomArray = array();
		}
	}
	$allowUpdate = true;
	$allowUpdateStock = true;
	if(sizeof($roomArray) > 0) {
		// Check for an overbooking at the room level
		foreach($roomArray as $item) {
			$resCount = $GLOBALS['lDB']->get("
				SELECT
					COUNT(*)
				FROM
					rv_res_item_group
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				WHERE
					rv_res_item_group.ac_accomm_room_id = '$item'
					AND (
						(
							rv_reservation_item.rv_item_date_arrive >= '$fromDate[jsDate]'
							AND rv_reservation_item.rv_item_date_arrive < '$toDate[jsDate]'
						) OR (
							rv_reservation_item.rv_item_date_depart > '$fromDate[jsDate]'
							AND rv_reservation_item.rv_item_date_depart <= '$toDate[jsDate]'
						)
					)
			",4);
			if($resCount > 0) {
				$allowUpdate = false;
			}
		}
		if($allowUpdate == false) {
			$GLOBALS['temp']['denyRoomList'] = join(":",$roomArray);
			$GLOBALS['temp']['denyFromDate'] = $fromDate['jsDate'];
			$GLOBALS['temp']['denyToDate'] = $toDate['jsDate'];
			$allowUpdateStock = true;
		}
	}
	// Remove old
	if($allowUpdate && $allowUpdateStock) {
		if($_POST['editBlockId'] != "") {
			db_ac_accomm_room_block_delete_by_block($_POST['editBlockId']);
		}
		if(sizeof($roomArray > 0)) {
			$ac_accomm_block_id = db_ac_accomm_block_insert($record,$fromDate['jsDate'],$toDate['jsDate'],$_POST['blockReason'],$_POST['blockType']);
			foreach($roomArray as $ac_accomm_room_id) {
				db_ac_accomm_room_block_insert($ac_accomm_block_id,$ac_accomm_room_id);
			}
			$resList = $GLOBALS['lDB']->get("
				SELECT
					COUNT(*)
				FROM
					rv_reservation
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
					INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
				WHERE
					rv_res_item_group.ac_accomm_room_id = '$item'
			",4);
		}
	} else {
		if(!$allowUpdate) {
			session_set("allowUpdate","false");
		}
		if(!$allowUpdateStock) {
			session_set("allowUpdateStock","false");
		}
	}
}

if($pmode == "1" && isset($_POST['deleteBlockId']) && $_POST['deleteBlockId'] != "") {
	db_ac_accomm_room_block_delete_by_block($_POST['deleteBlockId']);
}

if($pmode == "1" && (isset($_POST['saveclose']) && $_POST['saveclose'] == 1)){
	$tmpHTML = explode("<body",$GLOBALS[$form]->FormHTML);
	$GLOBALS[$form]->FormHTML = $tmpHTML[0] .= "<body onload=\"windowClose();\"></body>";
}

// Generate room listing
if($panel == "" || $panel == "0") {
	$compArray = $GLOBALS['lDB']->get("
		SELECT
			DISTINCT rt_component.rt_component_desc
		FROM
			ac_accomm_room_attr
			INNER JOIN rt_component ON  ac_accomm_room_attr.rt_component_id = rt_component.rt_component_ix
		WHERE
			ac_accomm_room_attr.ac_accomm_type_id = '$record'
	",3);
	$rows = "";
	foreach($compArray as $item) {
		$rows .= "
			<tr>
				<td height=\"17\" class=\"txtg\">&nbsp;$item</td>
			</tr>
		";
	}
	$GLOBALS['temp']['rows'] = $rows;
	$roomArray = $GLOBALS['lDB']->get("
		SELECT
			ac_desc,
			ac_accomm_room_ix
		FROM
			ac_accomm_room
		WHERE
			ac_accomm_type_id = '$record'
			AND ac_accomm_room_inactive_yn = '0'
		ORDER BY
			(ac_desc+0),ac_desc
	",2);
	$GLOBALS['temp']['numUnits'] = sizeof($roomArray);
}
if($panel == "1") {
	$attrStart = $_SERVER['argv'][4];
	$highest = $GLOBALS['lDB']->get("
		SELECT
			max(ac_desc+0) as highest
		FROM
			ac_accomm_room
		WHERE
			ac_desc > 0
			AND ac_accomm_type_id = '$record'
	",4) + 1;
	$GLOBALS['temp']['roomMax'] = $highest;
	// Get attribute listing
	$compArray = $GLOBALS['lDB']->get("SELECT DISTINCT rt_component_id FROM ac_accomm_room_attr WHERE ac_accomm_type_id = '$record' ORDER BY rt_component_id",3);
	if($attrStart == "" || $attrStart == "0") {
		$attrStart = 1;
	}
	if($attrStart > sizeof($compArray)) {
		$attrStart = sizeof($compArray);
	}
	$GLOBALS['temp']['btnFirstClass'] = "button txtg";
	$GLOBALS['temp']['disableFirst'] = "disabled";
	$GLOBALS['temp']['btnPrevClass'] = "button txtg";
	$GLOBALS['temp']['disablePrev'] = "disabled";
	$GLOBALS['temp']['btnNextClass'] = "button txtg";
	$GLOBALS['temp']['disableNext'] = "disabled";
	$GLOBALS['temp']['btnLastClass'] = "button txtg";
	$GLOBALS['temp']['disableLast'] = "disabled";
	if($attrStart > 1) {
		$GLOBALS['temp']['btnFirstClass'] = "button";
		$GLOBALS['temp']['btnPrevClass'] = "button";
		$GLOBALS['temp']['disableFirst'] = "";
		$GLOBALS['temp']['disablePrev'] = "";
	}
	if( ($attrStart + 4) < sizeof($compArray)) {
		$GLOBALS['temp']['btnNextClass'] = "button";
		$GLOBALS['temp']['btnLastClass'] = "button";
		$GLOBALS['temp']['disableNext'] = "";
		$GLOBALS['temp']['disableLast'] = "";
	}
	$GLOBALS['temp']['attrStart'] = $attrStart;
	$GLOBALS['temp']['attrMax'] = ((floor(sizeof($compArray) / 5)) * 5) + 1;
	if(sizeof($compArray)-$attrStart+1 > 5) {
		$maxComp = 5;
	} else {
		$maxComp = sizeof($compArray)-$attrStart+1;
	}
	if(sizeof($compArray) <1) {
		$maxComp = 0;
	}
	$roomArray = $GLOBALS['lDB']->get("
		SELECT
			ac_desc,
			ac_accomm_room_ix,
			ac_accomm_room_inactive_yn
		FROM
			ac_accomm_room
		WHERE
			ac_accomm_type_id = '$record'
		ORDER BY
			(ac_desc+0),ac_desc
	",2);
	$GLOBALS['temp']['numUnits'] = $GLOBALS['lDB']->get("
		SELECT
			COUNT(ac_accomm_room_ix)
		FROM
			ac_accomm_room
		WHERE
			ac_accomm_type_id = '$record'
			AND ac_accomm_room_inactive_yn = '0'
	",4);
	$headingHTML = Join("", file(__DIR__ . "/../../../public/html/property_acc_rooms_heading.htm"));
	if($action == 1) {
		$headingHTML = str_replace("!selAllDisable!"," disabled ",
			str_replace("!clrAllDisable!"," disabled ",
			str_replace("!delAllDisable!"," disabled ",$headingHTML)));
	} else {
		$headingHTML = str_replace("!selAllDisable!","",
			str_replace("!clrAllDisable!","",
			str_replace("!delAllDisable!","",$headingHTML)));
	}
	$heading = "";
	for($count=1; $count <= 5; $count++) {
		if($attrStart + $count - 1 <= sizeof($compArray) && sizeof($compArray) > 0) {
			if($attrStart > 1) {
				$GLOBALS['temp']['btnFirstClass'] = "button";
				$GLOBALS['temp']['btnPrevClass'] = "button";
			}
			$compName = $GLOBALS['lDB']->get("SELECT rt_component_desc FROM rt_component WHERE rt_component_ix = '".$compArray[$attrStart + $count - 2]."'",4);
			$confirm = "true";
			$checkRes = $GLOBALS['lDB']->get("
				SELECT
					COUNT(DISTINCT rv_reservation.rv_reservation_ix)
				FROM
					rv_reservation
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
					INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
					INNER JOIN ac_accomm_room_attr ON ac_accomm_room_attr.ac_accomm_room_id = rv_res_item_group.ac_accomm_room_id
				WHERE
					rv_reservation.rv_date_depart > '".date("Y-m-d")."'
					AND ac_accomm_room_attr.rt_component_id = '".$compArray[$attrStart + $count - 2]."'
					AND rv_reservation_item.ac_accomm_type_id = '$record'
			",4);
			if($checkRes != "0") {
				$confirm = "true";
			} else {
				$confirm = "false";
			}
			$heading .=
				str_replace("!rt_component_desc!",$compName,
				str_replace("!num!",$count,
				str_replace("!hideHead!","",
				str_replace("!confirm!",$confirm,$headingHTML))));
		} else {
			$heading .= str_replace("!hideHead!","class=\"collapse\"",
				str_replace("!hideRow!","class=\"collapse\"",
				str_replace("!num!",$count,
				str_replacE("!confirm!","true",$headingHTML))));
		}
	}
	$GLOBALS['temp']['heading'] = $heading;
	$rowHTML = Join("", file(__DIR__ . "/../../../public/html/property_acc_rooms_row.htm"));
	if($action == 1) {
		$checkDisable = " disabled ";
		$GLOBALS['temp']['addRoomsDisable'] = " visibility: hidden;";
		$GLOBALS['temp']['setupAttributesDisable'] = " visibility: hidden;";
	} else {
		$checkDisable = "";
		$GLOBALS['temp']['addRoomsDisable'] = "";
		$GLOBALS['temp']['setupAttributesDisable'] = "";
	}
	if(sizeof($roomArray) == 0) {
		$GLOBALS['temp']['setupAttributesDisable'] = " visibility: hidden;";
	}
	$checkHTML = "<input type=\"checkbox\" id=\"!id!\" name=\"!id!\" onclick=\"setComp(this,'!roomId!','!compId!');\" !checked! $checkDisable>";
	$rows = "";
	$activeRoomList = "";
	$inactiveRoomList = "";
	foreach($roomArray as $item) {
		if($item['ac_accomm_room_inactive_yn'] == "1") {
			if($inactiveRoomList != "") {
				$inactiveRoomList .= ":";
			}
			$inactiveRoomList .= $item['ac_accomm_room_ix'];
			$rowClass = "collapse";
		} else {
			if($activeRoomList != "") {
				$activeRoomList .= ":";
			}
			$activeRoomList .= $item['ac_accomm_room_ix'];
			$rowClass = "expand";
		}
		if($action == 1) {
			$nameDisable = " readonly ";
			$deleteRoomDisable = " visibility: hidden; ";
		} else {
			$nameDisable = "";
			$deleteRoomDisable = "";
		}
		$currDate = date("Y-m-d");
		$resList = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_res_item_group.ac_accomm_room_id = '$item[ac_accomm_room_ix]'
				AND (
					rv_reservation.rv_date_arrive >= '$currDate'
					OR rv_reservation.rv_date_depart > '$currDate'
				)
		",4);
		if($resList > "0") {
			$hasReservation = "";
		} else {
			$hasReservation = 'visibility: hidden;';
		}
		$currResList = $GLOBALS['lDB']->get("
			SELECT
				COUNT(*)
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_res_item_group.ac_accomm_room_id = '$item[ac_accomm_room_ix]'
				AND (
					rv_reservation_item.rv_item_date_arrive >= '$currDate'
					OR rv_reservation_item.rv_item_date_depart > '$currDate'
				)
		",4);
		$allowDelete = "true";
		if($currResList > 0) {
			$allowDelete = "false";
		}
		$row = str_replace("!ac_desc!",$item['ac_desc'],
			str_replace("!roomId!",$item['ac_accomm_room_ix'],
			str_replace("!rowClass!",$rowClass,
			str_replace("!nameDisable!",$nameDisable,
			str_replace("!deleteRoomDisable!",$deleteRoomDisable,
			str_replace("!allowDelete!",$allowDelete,
			str_replace("!hasReservation!",$hasReservation,$rowHTML)))))));
		$activeComp = $GLOBALS['lDB']->get("SELECT rt_component_id FROM ac_accomm_room_attr WHERE ac_accomm_room_id = '$item[ac_accomm_room_ix]'",3);
		for($count=1; $count <= $maxComp; $count++) {
			if(in_array($compArray[$attrStart + $count-2],$activeComp)) {
				$checked = "checked";
			} else {
				$checked = "";
			}
			$check = str_replace("!id!",$item['ac_accomm_room_ix']."_".$count,
				str_replace("!checked!",$checked,
				str_replace("!roomId!",$item['ac_accomm_room_ix'],
				str_replace("!compId!",$compArray[$attrStart + $count - 2],$checkHTML))));
			$row = str_replace("!checkBox$count!",$check,$row);
		}
		if($maxComp < 5) {
			for($count=$maxComp; $count <= 5; $count++ ){
				$row = str_replace("!checkBox$count!",
					str_replace("!checked!","style=\"visibility:hidden\"",
					str_replace("!id!",$item['ac_accomm_room_ix']."_".$count,$checkHTML)),$row);
			}
		}
		$rows .= $row;
	}
	$GLOBALS['temp']['activeRoomList'] = $activeRoomList;
	$GLOBALS['temp']['inactiveRoomList'] = $inactiveRoomList;
	if(sizeof($roomArray) > 0) {
		$GLOBALS['temp']['rows'] = $rows;
	} else {
		$GLOBALS['temp']['rows'] = "<tr><td>&nbsp;</td><td class=\"bl\" colspan=5 valign=\"top\">&nbsp;No rooms setup</td><td class=\"bl\">&nbsp;</td></tr>";
	}
}
if($panel == "2") {
	if($action == 1) {
		$GLOBALS['temp']['addDisable'] = " visibility: hidden; ";
		$GLOBALS['temp']['roomDisable'] = " disabled ";
	} else {
		$GLOBALS['temp']['addDisable'] = "";
		$GLOBALS['temp']['roomDisable'] = "";
	}
	$rowHTML = Join("", file(__DIR__ . "/../../../public/html/property_block_row.htm"));
	$fromDate = useDate("from","");
	$toDate = useDate("to",date("Y-m-d",time()+86400)); // one day afer today

	$blockArray = $GLOBALS['lDB']->get("
		SELECT
			ac_accomm_block_ix as id,
			ac_start_date,
			ac_end_date,
			ac_reason,
			ac_type_ind
		FROM
			ac_accomm_block
		WHERE
			ac_accomm_type_id = '$record'
		ORDER BY
			ac_type_ind,
			ac_start_date DESC,
			ac_end_date DESC
	",2);
	$rows = "";
	foreach($blockArray as $item) {
		$roomArray = $GLOBALS['lDB']->get("
			SELECT
				ac_accomm_room.ac_desc
			FROM
				ac_accomm_room_block
				INNER JOIN ac_accomm_room ON ac_accomm_room_block.ac_accomm_room_id = ac_accomm_room.ac_accomm_room_ix
			WHERE
				ac_accomm_room_block.ac_accomm_block_id = '$item[id]'
		",3);
		$roomList = join(", ",$roomArray);
		$roomArray2 = $GLOBALS['lDB']->get("
			SELECT
				ac_accomm_room.ac_accomm_room_ix
			FROM
				ac_accomm_room_block
				INNER JOIN ac_accomm_room ON ac_accomm_room_block.ac_accomm_room_id = ac_accomm_room.ac_accomm_room_ix
			WHERE
				ac_accomm_room_block.ac_accomm_block_id = '$item[id]'
		",3);
		$roomIdList = join(":",$roomArray2);
		$roomListFull = "";
		foreach($roomArray2 as $key2=>$item2) {
			$compArray = $GLOBALS['lDB']->get("
				SELECT
					rt_component_desc
				FROM
					ac_accomm_room_attr
					INNER JOIN rt_component ON rt_component.rt_component_ix = ac_accomm_room_attr.rt_component_id
				WHERE
					ac_accomm_room_attr.ac_accomm_room_id = '$item2'
			",3);
			$compList = join(", ",$compArray);
			if($roomListFull != "") {
				$roomListFull .= ", ";
			}
			$roomListFull .= $roomArray[$key2];
			if(trim($compList) != "") {
				$roomListFull .=  " (".$compList.")";
			}
		}
		if($action == 1) {
			$deleteDisable = " visibility: hidden; ";
		} else {
			$deleteDisable = "";
		}
		$nights =  (date(strtotime($item['ac_end_date']) - strtotime($item['ac_start_date']))) / 86400;
		$row = str_replace("!dateRange!",chng_date($item['ac_start_date'],"-") . " to " . chng_date($item['ac_end_date'],"-"),
			str_replace("!roomList!",$roomList,
			str_replace("!nights!",$nights,
			str_replace("!reason!",$item['ac_reason'],
			str_replace("!type!",($item['ac_type_ind']==1?"Static":"Dynamic"),
			str_replace("!typeInd!",$item['ac_type_ind'],
			str_replace("!id!",$item['id'],
			str_replace("!fromDate!",$item['ac_start_date'],
			str_replace("!toDate!",$item['ac_end_date'],
			str_replace("!roomIds!",$roomIdList,
			str_replace("!roomListFull!",$roomListFull,
			str_replace("!deleteDisable!",$deleteDisable,$rowHTML))))))))))));
		$rows .= $row;
	}
	$GLOBALS['temp']['rows'] = $rows;
}

if ($pmode == "0") {
	$calDateLimit = $GLOBALS['lDB']->get("select rf_date_res_limit from rf_default",4);
	$temp = explode("-",$calDateLimit);
	$GLOBALS['temp']['calDateResLimit'] = $calDateLimit;
	$GLOBALS['temp']['calDateResLimitNice'] = chng_date($calDateLimit,"-");
}
