<?php
 
/**
 * init.form86.php - Reservation Item components (Detail)
 * Job: 186, 187, 188
 * Function: 52
 */

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form,"","");
}

$_SERVER['argv'] = array_pad($_SERVER['argv'],7,"");

$GLOBALS['autovar'] = "2";

$jobID = $_SERVER['argv'][0];

$closeonload = false;
// If we are saving then get variance and comm_ind from URL
if ( $jobID == "188" ) {
	$varianceAmt = $_SERVER['argv'][3];
	$comm_ind = $_SERVER['argv'][4];
	
	$closeonload = $_SERVER['argv'][6];
}

$resId = $GLOBALS['lDB']->get("SELECT rv_reservation_id FROM rv_reservation_item WHERE rv_reservation_item_ix = '$record'",4);

if($pmode == "0" && $_SERVER['argv'][6] == "regen") {
	regenBilling($resId);
}

$record = $_SERVER['argv'][1];
$GLOBALS['record'] = $record;
$GLOBALS['record2'] = (string) $_SERVER['argv'][2];

if($GLOBALS['record2'] == "") {
	$GLOBALS['record2'] = "0";
}

$record2 = $GLOBALS['record2'];

$GLOBALS['temp']['itemID'] = $record;
$GLOBALS['temp']['compID'] = $record2;

// Get the details for this reservation item ----------------------------------
$itemDetails = getItemDetails($record);
$components = getResItemCost($record);
$rateGroups = $GLOBALS['lDB']->get("
	SELECT 
		rt_rate_group.rt_rate_group_desc,
		rv_res_item_rate_grp.rv_res_item_rate_grp_count
	FROM 
		rv_res_item_rate_grp
		INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_rate_grp.rt_rate_group_id
	WHERE 
		`rv_reservation_item_id` = '$record'
		AND rt_rate_group.rt_rate_group_sys_code != 1
",2);
$rateGroupRows = "";
foreach ($rateGroups as $rateGroup){
	$rateGroupRows .= "
		<tr>
			<td width=\"80%\">".$rateGroup['rt_rate_group_desc']."</td>
			<td width=\"20%\">".$rateGroup['rv_res_item_rate_grp_count']."</td>
		</tr>
	";
}
$GLOBALS['temp']['rateGroupRows'] = $rateGroupRows;

$temp = array();
foreach ($components as $component) {
	$cId = $component['rt_component_id'];
	$temp[$cId] = $component;
}
$components = $temp;

$compList = array($record2);
if($record2 != "0" && $record2 != "") {
	$component = $components[$record2];
	$componentSelected = true;
} else {
	$component = array();
	$component['rt_component_desc'] = "No component selected";
	$componentSelected = false;
}
$GLOBALS['temp']['description'] = t_encodeHTMLField($component['rt_component_desc']);

$GLOBALS['temp']['nights'] = (string)$itemDetails['noNights'];
$GLOBALS['temp']['invoice_currency'] = (string)$itemDetails['invoice_currency'];
$GLOBALS['temp']['rate_currency'] = (string)$itemDetails['rate_currency'];
$GLOBALS['temp']['exchRate'] = $itemDetails['exchRate'];


# If we are saving use the passed value, else use the DB value
if($jobID == "188") {
	$GLOBALS['temp']['variance_amt'] = $varianceAmt;
	$GLOBALS['temp']['variance_perc'] = 0;
	//$commYN = $commisionableYN;
	# Save previous commYN (rv_item_comp_comm_yn) value for UPDATE
} else {
	if($componentSelected) {
		$GLOBALS['temp']['variance_amt'] = $component['discAmt'];
		$GLOBALS['temp']['variance_perc'] =  $component['discPerc'];
	} else {
		$GLOBALS['temp']['variance_amt'] = "";
		$GLOBALS['temp']['variance_perc'] =  "";
	}
	//$commYN = $component['rv_item_comp_comm_yn'];
}

if($GLOBALS['temp']['variance_perc'] == 0) {
	$GLOBALS['temp']['variance_amt'] = "0";
} else {
	$GLOBALS['temp']['variance_amt'] = (string)((float)(isset($GLOBALS['temp']['rate'])?$GLOBALS['temp']['rate']:0) * ((float)$GLOBALS['temp']['variance_perc'] / 100));
}


$GLOBALS['temp']['rooms'] = $itemDetails['rv_item_accomm_count'];

$units = "";
$chargeType = "";
if($componentSelected) {
	$chargeType = $component['rv_item_comp_freq_ind'];
	$GLOBALS['temp']['variance_perc'] = $component['discPerc'];
}

$GLOBALS['temp']['comp_freq'] = "";
$GLOBALS['temp']['variance_amt'] = "";
$GLOBALS['temp']['compAmount'] = "";
$GLOBALS['temp']['rate'] = "";	

if($chargeType == "1") {
	$GLOBALS['temp']['comp_freq'] = "Per Night (".$component['rv_item_comp_freq_factor'].")";
	$GLOBALS['temp']['variance_amt'] = $component['rvItemCompDisc'] / $itemDetails['noNights'];
	$GLOBALS['temp']['compAmount'] = (string)$component['compAmt'] / $itemDetails['noNights'];
	$GLOBALS['temp']['rate'] = (string)($component['rvItemCompRate'] * $itemDetails['exchRate']) / $itemDetails['noNights'];

} elseif ($chargeType == "2") {
	$GLOBALS['temp']['comp_freq'] = "Per Stay";
	$GLOBALS['temp']['variance_amt'] = $component['rvItemCompDisc'];
	$GLOBALS['temp']['compAmount'] = (string)$component['compAmt'];
	$GLOBALS['temp']['rate'] = (string)($component['rvItemCompRate'] * $itemDetails['exchRate']);
}
// Commission

$commissionLabel = commissionLabel();
$GLOBALS['temp']['commissionLabel'] = $commissionLabel;

switch(isset($component['rv_item_comp_comm_ind'])?$component['rv_item_comp_comm_ind']:0) {
case 0;
	$commOptions = "
		  <option value=\"0\">Not " . $commissionLabel . "able</option>
		  <option value=\"1\">Calculate</option>
		  <option value=\"2\">Calc & deduct</option>
		  <option value=\"3\">Calc & deduct All</option>
	";	
	break;
case 1;
	$commOptions = "
		  <option value=\"0\">Not " . $commissionLabel . "able</option>
		  <option value=\"1\" selected>Calculate</option>
		  <option value=\"2\">Calc & deduct</option>
		  <option value=\"3\">Calc & deduct All</option>			  
	";		
	break;
case 2;
	$commOptions = "
		  <option value=\"0\">Not " . $commissionLabel . "able</option>
		  <option value=\"1\" >Calculate</option>
		  <option value=\"2\" selected>Calc & deduct</option>
		  <option value=\"3\">Calc & deduct All</option>			  
	";		
	break;
case 3;
	$commOptions = "
		  <option value=\"0\">Not " . $commissionLabel . "able</option>
		  <option value=\"1\">Calculate</option>
		  <option value=\"2\">Calc & deduct</option>		
		  <option value=\"3\" selected>Calc & Deduct All</option>
	";			
	break;
}

$GLOBALS['temp']['commSelect'] = "
	<select id=\"commInd\" name=\"commInd\" !commYNDisabled!>
	$commOptions
	</select>
	
";


$GLOBALS['temp']['units'] = (string)$units;

// Start Access Control Toolbar Setup
$view = 186;
if(db_sc_group_get_user_setting("sc_grp_res_ovr_variance_yn") == "1" && canEditReservation($resId)) {
	$edit = 187;
} else {
	$edit = 186;
}
$dele = false;

$pgJOBS = array();
$pgJOBS['view'] = "0";
if(checkJob($view)) {
	$pgJOBS['view'] = "1";
}
$pgJOBS['edit'] = "0";

$trfFlag = $GLOBALS['lDB']->get("SELECT rv_reservation_item_trf_yn FROM rv_reservation_item WHERE rv_reservation_item_ix = '$record'",4);
$recordDB = $GLOBALS['lDB']->get("
	 SELECT
		rv_reservation_item_db
	 FROM
		rv_reservation_item
	 WHERE
		rv_reservation_item_ix = '$record'
",4);
$canEdit = (canEditDB($recordDB) || ($trfFlag == "0" && $recordDB == $GLOBALS['dbcode'])) && (isMasterDB() || $GLOBALS['dbcode'][0] != "W");

if($canEdit) {	
	$pgJOBS['edit'] = "1";
}
$pgJOBS['save'] = "0";
$pgJOBS['saveclose'] = "0";
if($action == "2" || $action == "3") {
	$pgJOBS['save'] = "1";
	$pgJOBS['saveclose'] = "1";
}
if ($action == "2" || $action == "4") {
	$pgJOBS['edit'] = "0";
}
if ($action == "3") {
	$pgJOBS['edit'] = $pgJOBS['view'];
	if(checkJob($dele)) {
		$pgJOBS['del'] = "1";
	}
}
$pgJOBS['ext'] = "1";

global $compIsInvoiced;
if($pmode == "0") {
	$compIsInvoiced = false;
	if($lDB->get("
		SELECT
			COUNT(*)
		FROM
			rv_reservation_item
			INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
			INNER JOIN fn_invoice ON fn_invoice.fn_folio_id = fn_folio.fn_folio_ix
		WHERE
			rv_reservation_item.rv_reservation_item_ix = '$record'
			AND fn_invoice.fn_invoice_ix IS NOT NULL
			AND fn_inv_status_ind != 8
	",4)) $compIsInvoiced = true;

	if($compIsInvoiced || !$canEdit) {
		if($action != "1") redirectTo("reservation.php?186+".$record."+".$record2);

		$pgJOBS['edit'] = "0";
		$pgJOBS['save'] = "0";
		$pgJOBS['saveclose'] = "0";

		$GLOBALS['tagList']['resetButton'] = setNewParam("style","visibility:hidden");
	}
}

$GLOBALS['temp']['pgJobs'] = "<input type=\"hidden\" id=\"pgJobEdit\" value=\"".$pgJOBS['edit']."\" />\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSave\" value=\"".$pgJOBS['save']."\" />\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobSaveclose\" value=\"".$pgJOBS['saveclose']."\" />\n";
$GLOBALS['temp']['pgJobs'] .= "<input type=\"hidden\" id=\"pgJobExit\" value=\"".$pgJOBS['ext']."\" />\n";

// End Access Control Toolbar Setup

# Close window if "Save & Close" button pressed
$GLOBALS['temp']['loadpop'] = "";
if($closeonload == "1") {
	$GLOBALS['temp']['loadpop'] = ";windowClose();";
}

switch($action) {
case (0) : // List Records
	break;
case (1) : // Display Record
	$GLOBALS['temp']['viewjob'] = "186";
	$GLOBALS['temp']['editjob'] = "187";

	# Setup the links for the toolbar
	$GLOBALS['mode'] = "display";
	$GLOBALS['temp']['edit_view'] = "reservation.php?".$edit."+".$record."+".$_SERVER['argv'][2];
	$GLOBALS['temp']['save_record'] = "#";

	$GLOBALS['temp']['discAmtDisabled'] = "disabled";
	$GLOBALS['temp']['discPercDisabled'] = "disabled";
	$GLOBALS['temp']['commYNDisabled'] = "disabled";
	break;

case (3) : // Edit Record
	$GLOBALS['mode'] = "edit";
	$GLOBALS['temp']['edit_view'] = "reservation.php?".$view."+".$record."+".$_SERVER['argv'][2];

	$GLOBALS['temp']['discAmtDisabled'] = "";
	$GLOBALS['temp']['discPercDisabled'] = "";
	$GLOBALS['temp']['commYNDisabled'] = "";
	# If we are saving then save the changes
	if ($pmode == "1") {
		$list = $GLOBALS['lDB']->get("
			SELECT
				rv_res_item_comp_ix,
				rv_item_comp_rate,
				rv_reservation.rv_exchg_rate
			FROM
				rv_res_item_comp
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_res_item_comp.rv_reservation_item_id = '$record'
				AND rt_component_id IN ('".join("','",$compList)."')
		",2);
		foreach($list as $item) {
			$GLOBALS['lDB']->put("
				UPDATE rv_res_item_comp SET
					rv_item_comp_var = '$varianceAmt',
					rv_item_comp_edit_yn = '1',
					rv_item_comp_comm_ind = '$comm_ind'
				WHERE rv_res_item_comp_ix = '".$item['rv_res_item_comp_ix']."'
			");

			$rg_list = $GLOBALS['lDB']->get("
				SELECT
					rv_res_item_comp_rate_grp.rv_res_item_comp_rate_grp_ix,
					rv_res_item_comp_rate_grp.rv_item_comp_rate_grp_rate
				FROM
					rv_res_item_comp_rate_grp
					INNER JOIN rt_rate_group ON rt_rate_group.rt_rate_group_ix = rv_res_item_comp_rate_grp.rt_rate_group_id
				WHERE
					rv_res_item_comp_rate_grp.rv_res_item_comp_id = '".$item['rv_res_item_comp_ix']."'
				ORDER BY
					rt_rate_group.rt_rate_group_class ASC
			",2);			
			
			// Save variances for each rate group
			if ($item['rv_item_comp_rate'] != 0){
				$variancePerc = ($varianceAmt / ($item['rv_item_comp_rate'] * $item['rv_exchg_rate'])) * 100;

				$runningTotal = 0;
				$lastKey = sizeof($rg_list) - 1;
				foreach($rg_list as $key=>$rate_group){
					if($key != $lastKey) { 
						$rg_variance = ($rate_group['rv_item_comp_rate_grp_rate'] * $item['rv_exchg_rate'] * $variancePerc) / 100;
						$runningTotal += db_round($rg_variance,2);
					} else {
						$rg_variance = $varianceAmt - $runningTotal;
					}
					db_rv_res_item_comp_rate_grp_set_variance($rate_group['rv_res_item_comp_rate_grp_ix'], $rg_variance);
				}
			} else {
				// Zero amount, so we just assign all to first rate group (ordering means this is invariably units)
				db_rv_res_item_comp_rate_grp_set_variance($rg_list[0]['rv_res_item_comp_rate_grp_ix'], $varianceAmt);
			}
			specialsAutoApply($resId);

		}

	}
	break;
}

$pluscount = substr_count($GLOBALS[$form]->Arguments,"+");
$GLOBALS[$form]->name = $form;
$GLOBALS[$form]->Arguments = $jobID."+".$record."+".$record2;

// Set the form start tag containing the submit action
$GLOBALS['temp']['formstart'] = "<form name=\"" . $GLOBALS[$form]->name . "\" action=\"" . $GLOBALS[$form]->TargetPage . "?" . $GLOBALS[$form]->Arguments . "\" method=\"" . $GLOBALS[$form]->Method . "\" enctype=\"" . $GLOBALS[$form]->Enctype . "\">\n";

// Set the form submit tag and required hidden fields
$GLOBALS['temp']['formsubmit'] = "<input type=\"hidden\" name=\"action\" value=\"" . $action . "\" />\n
	<input type=\"hidden\" id=\"mode\" value=\"" . $GLOBALS['mode'] . "\" />\n
	<input type=\"hidden\" name=\"record\" value=\"" . $record . "\" />\n
	<input type=\"hidden\" name=\"record2\" value=\"" . $record2 . "\" />\n
	<input type=\"hidden\" name=\"jobid\" value=\"\" />\n
	<input type=\"hidden\" name=\"inputchange\" />\n
	<input type=\"hidden\" id=\"closeonload\" />\n
	</form>\n";

if ($pmode == "1") {
	recalcTotals($resId,4);
	ammendReservation($resId,"Components");
}

