<?php

require_once(__DIR__ . '/functions.mail.php');

function processMessage($message) {
    $validHtml = false;
    $htmlBody = '';

    // Check if message is HTML
    libxml_use_internal_errors(true);
    $dom = new DOMDocument;
    $dom->loadHTML($message);

    if (libxml_get_last_error() === false) {
        $bodies = $dom->getElementsByTagName('body');
        if ($bodies->length === 1) {
            $body = $bodies->item(0);
            for ($i = 0; $i < $body->childNodes->length; $i++) {
                $body->removeChild($body->childNodes->item($i));
            }
            $htmlBody = $dom->saveHTML($body);
            $validHtml = true;
        }
    }
    libxml_use_internal_errors(false);

    if ($validHtml) {
        return $htmlBody;
    } else {
        return str_replace("\n","<br>",$message);
    }
}