<?php
use MaglLegacyApplication\Application\MaglLegacy;

require_once(__DIR__ . '/functions.pdf.php');

if(!isset($GLOBALS[$form])) {
	$GLOBALS[$form] = new Form($form, "", __DIR__ . "/../../../public/html/doc.htm");
}

$GLOBALS['mode'] = "display";
$GLOBALS['temp']['edit_view'] = "#";
$GLOBALS['temp']['save_record'] = "#";
$GLOBALS['temp']['del_record'] = "#";

$principal_id = $_SESSION['principal_id'];
$logoFilename = 'top_client_mkg.jpg';
$dateFormat = 'd F Y';

require_once('db.rv_registration_card.php');
require_once('db.rv_registration_card_obj_data.php');

$application = MaglLegacy::getInstance()->getApplication();
$em = $application->getServiceManager()->get('EnterpriseEntityManager');

if (empty($_SERVER['argv'][1])) {
	die('Invalid registration card.');
}

$registrationCardId = $_SERVER['argv'][1];

if (!db_rv_registration_card_exists($registrationCardId)) {
	die('Invalid registration card.');
}

$guestFields = db_rv_registration_card_obj_data_by_rv_registration_card_id($registrationCardId, [1,2]);
$objData = db_rv_registration_card_obj_data_by_rv_registration_card_id($registrationCardId, 3, true);
$registrationCard = db_rv_registration_card_get_by_id($registrationCardId);

$indemnityMessage = $registrationCard['rv_registration_card_indemnity_message'];

$tripDetails = [
	[
		'label' => 'Your reservation number',
		'value' => $registrationCard['rv_reservation_id'],
	],
	[
		'label' => 'Arrival',
		'value' => (new \DateTime($registrationCard['rv_item_date_arrive']))->format($dateFormat),
	],
	[
		'label' => 'Departure',
		'value' => (new \DateTime($registrationCard['rv_item_date_depart']))->format($dateFormat),
	],
	[
		'label' => 'Property',
		'value' => $objData['property_name']['value'],
	],
	[
		'label' => 'Accommodation',
		'value' => $objData['accommodation_type_desc']['value'],
	]
];

$pdf = new PDF("\t",'P','mm','A4',false);

$leftColumnX = 5;
$rightColumnX = 115;

// BEGIN page 1 left column
$pdf->SetX($leftColumnX);
if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/$logoFilename")) {
	require_once(__DIR__ . '/functions.imageset.php');
	$logoWidth = imagesetLogoSizeOverride("checkinRegistrationCardPdfLogoWidthOverride", "23");
	$pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFilename",5, 5, 0, $logoWidth);
}

$checkInDate = (new \DateTime($registrationCard['ad_create_date']))->format($dateFormat);

$pdf->SetXY($leftColumnX, 40);
$pdf->SetFont('Arial','I',9);
$pdf->MultiCell(100, 4, "Thank you. Your online check in, received on {$checkInDate}, is successfully completed with the details below. Please bring your identification with you to complete your check in on arrival!");


$y = 65; // Guest fields start Y
$fieldCount = count($guestFields);
foreach ($guestFields as $index => $field) {
	$pdf->SetFont('Arial','B',10);
	$pdf->SetXY($leftColumnX, $y);
	$pdf->Cell(40, 5, $field['label'], 0, 0);

	if ($field['label'] === 'Birthdate') {
		$field['value'] = (new \DateTime($field['value']))->format($dateFormat);
	}

	$pdf->SetFont('Arial','',10);
	$pdf->Cell(60, 5, $field['value'], 0, 0, 'R');
	$pdf->Line(6, $y + 5, 105, $y + 5);

	if ($index === $fieldCount - 1) {
		$y += 15;
	} else {
		$y += 10;
	}

	$pdf->SetY($y);
}

// END page 1 left column
// BEGIN page 1 right column
$pdf->SetFont('Arial','B',16);
$pdf->setXY(-45, $y = 15);
$pdf->Cell(40, 7, 'Your Registration Card', 0, 1, 'R');
$pdf->SetFont('Arial','', 10);
$pdf->setX(-45);
$pdf->Cell(40, 5, 'It is our pleasure to confirm your registration details below.', 0, 0, 'R');


$pdf->setXY($rightColumnX -5, 55);
$pdf->SetFillColor(201, 37, 48);
$pdf->Cell(2, 83, '', 0, 0, 'R', 1);

$pdf->setXY($rightColumnX, 58);
$pdf->SetFont('Arial','B', 15);
$pdf->Cell(50, 6, 'Your trip details', 0, 1);
$pdf->setX($rightColumnX);
$pdf->SetFont('Arial','', 8);
$pdf->MultiCell(80, 3, 'Your booking may be part of a circuit. Check in is specific to the itinerary below.');


$y = 75; // Res details start Y
$fieldCount = count($tripDetails);
foreach ($tripDetails as $index => $field) {
	$pdf->SetFont('Arial','B',10);
	$pdf->SetXY($rightColumnX, $y);
	$pdf->Cell(40, 5, $field['label'], 0, 0);

	$pdf->SetFont('Arial','',10);
	$pdf->Cell(50, 5, $field['value'], 0, 0, 'R');
	$pdf->Line($rightColumnX + 1, $y + 5, $rightColumnX + 90, $y + 5);

	if ($index === $fieldCount - 1) {
		$y += 15;
	} else {
		$y += 10;
	}

	$pdf->SetY($y);
}

// END page 1 right column

// BEGIN page 2
$pdf->AddPage();
$pdf->SetX(5);
$pdf->SetAutoPageBreak(TRUE,5);
if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/$logoFilename")) {
	$pdf->Image("$GLOBALS[images_dir_on_disk]/".$principal_id."/$logoFilename",5, 5, 0, 23);
}

$pdf->SetFont('Arial','B',16);
$pdf->setXY(-45, $y = 15);
$pdf->Cell(40, 7, 'Indemnity Agreement', 0, 1, 'R');
$pdf->SetFont('Arial','', 8.5);
$pdf->setX(-45);
$pdf->Cell(40, 5, 'During the check in process you accepted the indemnity agreement below.', 0, 0, 'R');

$pdf->setXY(5, 40);

if (!empty($registrationCard['rv_registration_card_indemnity_message_yn'])) {
	$pdf->MultiCell(200, 4.5, $indemnityMessage, 0);
}

$y = 225;
$pdf->SetFont('Arial','B',10);
$pdf->SetXY($leftColumnX, $y);
$pdf->Cell(40, 5, 'Signature:', 0, 0);
$pdf->Line($leftColumnX + 1, $y + 5, $leftColumnX + 84, $y + 5);

$y += 10;

$pdf->SetXY($leftColumnX, $y);
$pdf->Cell(40, 5, 'Check in date:', 0, 0);

$pdf->SetFont('Arial','',10);
$pdf->Cell(45, 5, $checkInDate, 0, 0, 'R');
$pdf->Line($leftColumnX + 1, $y + 5, $leftColumnX + 84, $y + 5);


$pdf->SetY(-52);
$y = $pdf->GetY();
$pdf->SetXY($leftColumnX, $y += 10);
$pdf->SetFont('Arial','B', 8);
$pdf->Cell(40, 5, 'For information contact us:', 0, 1);
$pdf->SetX($leftColumnX);
$pdf->SetFont('Arial','', 8);
$pdf->Cell(40, 4, $GLOBALS['principal_name'], 0, 1);
$pdf->SetX($leftColumnX);
$pdf->Cell(40, 4, 'Our telephone ' . $objData['res_office_phone_number']['value'], 0, 1);
$pdf->SetX($leftColumnX);

if (!empty($objData['consultant_name_last']['value'])) {
	$consultantNameFirst = $objData['consultant_name_first']['value'];
	$consultantNameLast = $objData['consultant_name_last']['value'];

	$consultantName = trim("$consultantNameFirst $consultantNameLast");
	$pdf->Cell(40, 4, $consultantName, 0, 1);
	$pdf->SetX($leftColumnX);
}

if (empty($objData['consultant_email']['value'])) {
	$pdf->Cell(40, 4, $objData['res_office_email']['value'], 0, 1);
} else {
	$pdf->Cell(40, 4, $objData['consultant_email']['value'], 0, 1);
}

// END page 2

$pdf->Output();
