<?php

/*
 * $Id: legend_avail.php,v 1.2 2012-08-20 16:08:41 light Exp $
 *
 * $Log: legend_avail.php,v $
 * Revision 1.2  2012-08-20 16:08:41  light
 * Bug #7951 - BROWSER: Google Chrome Compliance
 *
 * Revision 1.1  2011-12-22 12:46:29  light
 * Bug #7575 - Customisation of step 2 & 3 on public calendar
 *
 *
 */

/**
 * legend_avail.php - Legend popup for the availability calendar
 */

require_once(__DIR__ . '/class.mysqldb.php');
require_once(__DIR__ . '/inc.setup.php');
require_once(__DIR__ . '/functions.system.php');
require_once(__DIR__ . '/ac_logon.php');

session_write_close();

global $domain;

$GLOBALS['temp']['customHTML'] = "";
$GLOBALS['temp']['customCSS'] = "";
if ($userStatusId == "0") {
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/legend_avail.htm")) {
		$GLOBALS['temp']['customHTML'] = showpage($GLOBALS['temp'],join("",file(__DIR__ . "/../images/$principal_id/legend_avail.htm")));
	}

	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/styles/legend_avail.css")) {
		$indexCSS = "<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/legend_avail.css\" type=\"text/css\" />";
	} else {
		$indexCSS = "";
	}
	$GLOBALS['temp']['customCSS'] = "
		<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />
		$indexCSS
	";

	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Don't include anything extra if it's a V3+ imageset
		$GLOBALS['temp']['customHTML'] = "";
		$GLOBALS['temp']['customCSS'] = "";
	}
}


?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html>
	<head>
		<title>Availability Legend</title>
		
		<link rel="stylesheet" href="/resource/Resrequest/Application/public/css/sys.css" type="text/css" />
		<link rel="stylesheet" href="/resource/Resrequest/Application/public/css/cal.css" type="text/css" />
		<?=$GLOBALS['temp']['customCSS']?>
		
		<script type="text/javascript" src="/resource/Resrequest/Application/public/include/js/system.js"></script>
		<script type="text/javascript">
			// <![CDATA[

			function initialisePage() {
				windowResize(400,280);

				try {
					opener.document.body.setCapture();
				} catch(e) {}

				window.focus();
			}

			function closePage() {
				try {
					opener.document.body.releaseCapture();
				} catch(e) {}
				window.close();
			}
			// ]]>
		</script>
	</head>

	<body onload="initialisePage()" class="colLt" style="overflow:hidden;">

		<div class="colDk bb txtb" style="height: 25px; line-height: 25px;">&nbsp;Availability Legend</div>
		
		<div style="padding: 10px;">
			<table width="100%" border="0" cellspacing="0" cellpadding="2" summary="">
				<col width="20" />
				<col />
				<col width="20" />
				<col />
				<tr>
					<td align="center"><div class="blkBord" style="width: 25px; height: 19px; background-color: #fff;"></div></td>
					<td>Space available</td>
					<td align="center"><div class="blkBord" style="width: 25px; height: 19px; background-color: #fff; line-height: 19px;">2</div></td>
					<td>Number of rooms available</td>
				</tr>
				<tr>
					<td align="center"><div class="blkBord legRed" style="width: 25px; height: 19px; line-height: 19px;"></div></td>
					<td>Full (waitlist only)</td>
					<td align="center"><div class="blkBord legWkEnd"  style="width: 25px; height: 19px; line-height: 19px;"></div></td>
					<td>Weekends</td>
				</tr>
				<tr>
					<td align="center"><div class="blkBord" style="width: 25px; height: 19px; background-color: #fff; line-height: 19px;">*</div></td>
					<td>Includes provisional reservations</td>
					<td align="center"><div class="bAll colWh txts" style="width: 25px; height: 19px; line-height: 19px;">TBA</div></td>
					<td>Rate to be advised</td>
				</tr>
				<tr>
					<td align="center"><div class="blkBord legBlock" style="width: 25px; height: 19px;"></div></td>
					<td>Blocked (no rooms available)</td>
					<td align="center"><div class="blkBord legGreen" style="width: 25px; height: 19px;"></div></td>
					<td>In progress</td>
				</tr>
				<tr>
					<td align="center"><div class="blkBord legOrange" style="width: 25px; height: 19px;"></div></td>
					<td>Due for check in</td>
					<td align="center"><div class="blkBord legBlue" style="width: 25px; height: 19px;"></div></td>
					<td>Checked in</td>
				</tr>
				<tr>
					<td align="center"><div class="blkBord legPurple" style="width: 25px; height: 19px;"></div></td>
					<td>Early departure</td>
					<td align="center"><div class="blkBord" style="width: 25px; height: 19px; background: url(/resource/Resrequest/Application/public/img/button_pattern.gif);"></div></td>
					<td>Not applicable</td>
				</tr>
				<tr>
					<td align="center"><div class="blkBord calIndicator1" style="width: 25px; height: 19px; background-color: #fff;"></div></td>
					<td>Allocations present</td>
					<td align="center"><div class="blkBord calIndicator4" style="width: 25px; height: 19px; background-color: #fff;"></div></td>
					<td>Wait listed reservations present</td>
				</tr>
				<tr>
					<td align="center"><div class="blkBord calIndicator16" style="width: 25px; height: 19px; background-color: #fff;"></div></td>
					<td>MinLOS present</td>
				</tr>
			</table>
		</div>

		<div class="colDk bt" style="text-align: center; padding: 5px; height: 100%;"><input type="button" onclick="closePage()" class="button" style="width: 60px;" value="Close" /></div>

		<?=$GLOBALS['temp']['customHTML']?>
	</body>
</html>
