<?php
$includeDirectory = __DIR__ . "/../";
require_once($includeDirectory . '/core/class.page.php');
require_once($includeDirectory . '/core/class.script.php');

/**
 * Redirect to Reservations Management Dashboard SPA
 */
class DashboardPage extends Page
{
  const ARGUMENT_SIGNATURE = ['jobId'];
  protected $scripts = [ ];
  protected $globalsAccept = [ ];
  protected $globalsSet = [ ];
  
  public function __construct(
    $_argumentsAccept
  ) {
    parent::__construct(
      null,
      $_argumentsAccept,
      self::ARGUMENT_SIGNATURE
    );
    // Write to $GLOBALS those that should be set for this class
    $this->handleHistory();
  }

  public function open() {
    Page::redirect("/app/dashboard");
  }

  public function openTab($tab) {
    Page::redirect("/app/dashboard?tab={$tab}");
  }

  public function handleArguments() {}
}
