<?php
$includeDirectory = __DIR__ . "/../";
// Form Generation Class used on every php page
require_once($includeDirectory . '/class.form.php');
require_once($includeDirectory . '/class.mysqldb.php');
// Allow automatic db interaction for the forms
require_once($includeDirectory . '/class.mysqlfield.php');
require_once($includeDirectory . '/class.mysqltable.php');
require_once($includeDirectory . '/functions.template.php');
require_once($includeDirectory . '/functions.cache.php');
require_once($includeDirectory . '/functions.system.php');
require_once($includeDirectory . '/functions.php');
require_once($includeDirectory . '/functions.reservation.php');
// Database Connection, customised setup and config file
require_once($includeDirectory . '/inc.setup.php');
// Access Control Results
require_once($includeDirectory . '/ac_logon.php');
// Globally required arrays (e.g. array of all properties)
require_once($includeDirectory . '/inc.globalarrays.php');
// Debug class to send debug messages to popup window
require_once($includeDirectory . '/inc.debug.php');
// This class *must* be included before the session is opened!
require_once($includeDirectory . '/PDF/pdf.php');
require_once($includeDirectory . '/db.notifications.php');

require_once($includeDirectory . '/core/class.page.php');
require_once($includeDirectory . '/core/class.script.php');
require_once($includeDirectory . '/functions.imageset.php');

use MaglLegacyApplication\Application\MaglLegacy;

/**
 * Generate the top contents/header for Enterprise
 */
class TopContentsPage extends Page
{
  const TEMPLATE_FILES = [
    "internal"=>['name'=> self::TEMPLATE_FILES_DIRECTORY."top_contents_new.htm"],
    "external"=>['name'=> self::TEMPLATE_FILES_DIRECTORY."public_top_contents.htm"]
  ];
  const ARGUMENT_SIGNATURE = [
      'width', // how wide, as a css attribute, the content should be
      'nojs', // don't load javascript
      'nocss', // don't load css
      'partial', // don't include the top and bottom html/body content
      'script' // only output the contents of the requested js file
    ];
  // Scripts will be handled in this sequence
  protected $scripts = [ ];
  protected $width = "770px";
  protected $fullDomAdded = false;

  protected $sysUrl;
  protected $chpass;
  protected $hideReqRec;
  protected $reqCount;
  protected $waitlistCount;
  protected $totalModCount;
  protected $modReqCount;
  protected $totalModReqCount;
  protected $notificationPopupAllowed;
  protected $notificationPopupShow;
  protected $lastResIdArrayJs = "";
  protected $lastResJobArrayJs = "";
  protected $lastResNameArrayJs = "";
  protected $lastContactIdArrayJs = "";
  protected $lastContactJobArrayJs = "";
  protected $lastContactNameArrayJs = "";
  protected $allowQuickSearch;
  protected $autoCheck;
  protected $refreshTransfer;
  protected $reportURL;
  protected $reportProfile;
  protected $globalsAccept = [
    'CHECKJOBOVERRIDE'=>"",
    'custom_yn'=>"",
    'data_synch_mthd'=>"",
    'DTdir'=>"",
    'DTprotocol'=>"",
    'DTremoteHostOverride'=>"",
    'DTremoteHostWA'=>"",
    'DTremoteHostWB'=>"",
    'DTremotePrincipalOverride'=>"",
    'DTrequireOnline'=>"",
    'EUServer'=>"",
    'JobArray'=>"",
    'PrincID'=>"",
    'SAServer'=>"",
    'USServer'=>"",
    'accessProperties'=>"",
    'accommArray'=>"",
    'accommArray2'=>"",
    'allAccommCount'=>"",
    'allBusinessParents'=>"",
    'allowArchive'=>"",
    'anonUserID'=>"",
    'api'=>"",
    'archive'=>"",
    'bypassAddCheck'=>"",
    'cacheMem'=>"",
    'cacheMemShared'=>"",
    'cacheMemSharedConnected'=>"",
    'cacheRoot'=>"",
    'cacheTomorrow'=>"",
    'calAgentId'=>"",
    'ceilingnum'=>"",
    'censys_email'=>"",
    'checkLicence'=>"",
    'client'=>"",
    'cords'=>"",
    'curlSettingsDT'=>"",
    'dbName'=>"",
    'dbUpgradeInProcess'=>"",
    'dbVersion'=>"",
    'db_rv_extra_error'=>"",
    'dbcode'=>"",
    'debug'=>"",
    'debugDomain'=>"",
    'debugEcho'=>"",
    'debugEnabled'=>"",
    'domain'=>"",
    'enableIXfields'=>"",
    'envWebOverride'=>"",
    'environment'=>"",
    'environment_id'=>"",
    'errors'=>"",
    'firstname'=>"",
    'flagChngs'=>"",
    'flagDels'=>"",
    'forwardHistory'=>"",
    'funLevelArray'=>"",
    'groupArray'=>"",
    'help_dir'=>"",
    'help_dir_on_disk'=>"",
    'history'=>"",
    'html_dir'=>"",
    'html_dir_on_disk'=>"",
    'http'=>"",
    'https_enabled'=>"",
    'images_dir'=>"",
    'images_dir_on_disk'=>"",
    'incrementSequence'=>"",
    'info_dir'=>"",
    'info_dir_on_disk'=>"",
    'isConsultant'=>"",
    'isPopup'=>"",
    'isPropServer'=>"",
    'isPublic'=>"",
    'isWebServer'=>"",
    'is_an_agent'=>"",
    'ixTableList'=>"",
    'job'=>"",
    'jobLevelArray'=>"",
    'lDB'=>"",
    'lastname'=>"",
    'lastupdate'=>"",
    'limit_yn'=>"",
    'menu_system'=>"",
    'online_images_dir'=>"",
    'popupDebug'=>"",
    'pr_agent_link'=>"",
    'pr_business_link'=>"",
    'pr_name_fist'=>"",
    'pr_name_last'=>"",
    'pr_sys_code'=>"",
    'pr_user_id'=>"",
    'princName'=>"",
    'principal_id'=>"",
    'principal_name'=>"",
    'principal_name_short'=>"",
    'propArray'=>"",
    'propArray2'=>"",
    'propArray3'=>"",
    'property_access'=>"",
    'property_id'=>"",
    'property_tree'=>"",
    'propstr'=>"",
    'pubGroupID'=>"",
    'record'=>"",
    'record2'=>"",
    'remoteDbCode'=>"",
    'rf_db_env_type_ind'=>"",
    'rf_sys_db_me_id'=>"",
    'sc_group_id'=>"",
    'sc_grp_alloc_ind'=>"",
    'sc_grp_avail_limit'=>"",
    'sc_grp_avail_limit_yn'=>"",
    'sc_grp_desc'=>"",
    'securitygroup'=>"",
    'server'=>"",
    'sessionServer'=>"",
    'showProv'=>"",
    'showScriptSpeed'=>"",
    'showScriptSpeedLoc'=>"",
    'support'=>"",
    'system'=>"",
    'systemVersion'=>"",
    'systemVersionRaw'=>"",
    'tagList'=>"",
    'tempCPC'=>"",
    'timezone'=>"",
    'trHTML'=>"",
    'trOverlib'=>"",
    'trTables'=>"",
    'trText'=>"",
    'trdDestEcho'=>"",
    'trdStayConnected'=>"",
    'userArray'=>"",
    'userStatusId'=>"",
    'userid'=>"",
    'username'=>"",
    'versionDir'=>"",
    'wizResId'=>"",
  ];
  protected $globalsSet = [
    'isPopup'=>"",
    'bypassAddCheck'=>"",
    'username'=>"",
    'securitygroup'=>"",
    'ceilingnum'=>"",
    'firstname'=>"",
    'lastname'=>"",
    'lastupdate'=>"",
    'email'=>"",
    'faxnumber'=>"",
    'defaultnumber'=>"",
    'pr_corr_addr_line1'=>"",
    'pr_corr_addr_line2'=>"",
    'pr_corr_addr_line3'=>"",
    'pr_corr_city'=>"",
    'pr_email'=>"",
    'pr_corr_post_code'=>"",
    'rf_country_name'=>"",
  ];
  
  public function __construct(
    $_argumentsAccept,
    $_internal,
    $_partial = null
  ) {
    if ($_internal) {
      $_fileName = self::TEMPLATE_FILES['internal']['name']; 
    } else {
      $_fileName = self::TEMPLATE_FILES['external']['name']; 
    }
    $this->setTitle("ResRequest Header");
    parent::__construct(
      $_fileName,
      $_argumentsAccept,
      self::ARGUMENT_SIGNATURE,
      $this->globalsAccept
    );
    $partial = $_partial !== null ? $_partial : false;
    // if partial is passed as argument override constructor parameter
    $partial = !empty($this->getArgument('partial')) ? true : $partial;

    $this->setPartial($partial);

    $width = !empty($this->getArgument('width')) ? $this->getArgument('width') : $this->width;
    $this->setWidth($width);
    $this->setupGlobals();
    // Write to $GLOBALS those that should be set for this class
    $this->setGlobals($this->globalsSet);
    $this->dataSetup();
    $this->setScripts([
      // CSS
      new Script(self::LEGACY_DIRECTORY . "/../../../public/css/sys.css", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "css/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/css/quick_menu.css", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "css/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/tooltipster/css/tooltipster.bundle.min.css", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/tooltipster/css/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-shadow.min.css", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/tooltipster/css/plugins/tooltipster/sideTip/themes/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/css/notifications.css", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "css/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/css/select2.min.css", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "css/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/css/daterangepicker.min.css", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "css/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/css/tail.datetime-harx-light.min.css", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "css/", Script::SCRIPT_POSITION_TOP),
      // Javascript
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/jquery.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/jquery.autocomplete.min.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/system.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/ajax.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/json2.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/tooltipster/js/tooltipster.bundle.min.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/tooltipster/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/notifications.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/events.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/toolbar.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/select2.full.min.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/moment.min.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/daterangepicker.min.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/tail.datetime-full.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/profiles.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/menu.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/rsClient.js", Script::SCRIPT_INLINE_FALSE, Script::URL_BASE . "include/js/", Script::SCRIPT_POSITION_TOP),
      new Script(self::LEGACY_DIRECTORY . "/../../../public/include/js/top_contents.js", Script::SCRIPT_INLINE_FALSE, "/top_contents.php?+nojs+nocss+partial+top_contents.js", Script::SCRIPT_POSITION_BOTTOM, Script::SCRIPT_REQUIRES_INTERPOLATION_TRUE),
    ]);
    $this->interpolate($this->getData());
  }

  protected function dataSetup() {
    $application = MaglLegacy::getInstance()->getApplication();
    $serviceManager = $application->getServiceManager();
    $chartContainerService = $serviceManager->get("Resrequest\Application\Chart\ChartContainer");

    $data = [];
    $data['dashboardsAllowed'] = $chartContainerService->hasDashboardsAccess();

    // Check if we must filter occupancy calendar results to single agent
    $data['isPublic'] = "0";
    if ($this->getGlobal('pubGroupID') == $this->getGlobal('securitygroup')) {
       $data['isPublic'] = "1";
    }
    $data['AgnLink'] = "0";
    if ($this->getGlobal('pr_agent_link') != "0") {
       $data['AgnLink'] = "1";
    }
    $data['BizLink'] = "0";
    if ($this->getGlobal('pr_business_link') != "0") {
       $data['BizLink'] = "1";
    }
    if(
      $data['isPublic'] == "0" 
      && $data['BizLink'] == "0"
      && $data['AgnLink'] == "1"
    ) {
       $filterOccCalByAgent = "1";
    } else {
       $filterOccCalByAgent = "0";
    }

    $data['dbcode'] = $this->getGlobal('dbcode');
    $data['dbstatus'] = "slave";
    if (isMasterDB("1")) {
       $data['dbstatus'] = "master";
    }
    $data['SecurityGroup'] = "var SecurityGroup = '".rawurlencode($this->getGlobal('securitygroup'))."';";
    $data['CeilingNum'] = "var CeilingNum = '".rawurlencode($this->getGlobal('ceilingnum'))."';";
    $data['FirstName'] = "var FirstName = '".rawurlencode($this->getGlobal('firstname'))."';";
    $data['firstN'] = $this->getGlobal('firstname');
    $data['LastName'] = "var LastName = '".rawurlencode($this->getGlobal('lastname'))."';";
    $data['lastN'] = $this->getGlobal('lastname');
    $data['UserName'] = "var UserName = '".rawurlencode($this->getGlobal('username'))."';";
    $data['username'] = $this->getGlobal('username');
    $lastupdateArray = explode(" ",$this->getGlobal('lastupdate'));
    $data['LastUpdate'] = "var LastUpdate = '".chng_date($lastupdateArray[0],"-")." ".$this->lastUpdateDateTime[1]."';";
    $data['LastUpdateDash'] = "var LastUpdateDash = '".$this->getGlobal('lastupdate')."';";
    $data['genDateVal'] = "var genDateVal = '".chng_date($this->currentDate,"-")." ".$this->currentTime."';";
    $data['PrincipalID'] = "var PrincipalID = '".$this->getGlobal('principal_id')."';";
    $data['PrincipalName1'] = "var PrincipalName = '".rawurlencode($this->getGlobal('principal_name'))."';";
    $data['PrincipalEmail'] = "var PrincipalEmail = '".rawurlencode($this->getGlobal('principal_email'))."';";
    $data['PrincipalPhone'] = "var PrincipalPhone = '".rawurlencode($this->getGlobal('principal_phone'))."';";
    $data['PrincipalAddr1'] = "var PrincipalAddr1 = '".rawurlencode($this->getGlobal('principal_addr1'))."';";
    $data['PrincipalAddr2'] = "var PrincipalAddr2 = '".rawurlencode($this->getGlobal('principal_addr2'))."';";
    $data['PrincipalAddr3'] = "var PrincipalAddr3 = '".rawurlencode($this->getGlobal('principal_addr3'))."';";
    $data['PrincipalCity'] = "var PrincipalCity = '".rawurlencode($this->getGlobal('principal_city'))."';";
    $data['PrincipalPostcode'] = "var PrincipalPostcode = '".rawurlencode($this->getGlobal('principal_postcode'))."';";
    $data['PrincipalFax'] = "var PrincipalFax = '".rawurlencode($this->getGlobal('principal_fax'))."';";
    $data['CensysEmail'] = "var CensysEmail = '".rawurlencode($this->getGlobal('censys_email'))."';";
    $data['Server'] = "var Server = '".$this->getGlobal('http').$this->getGlobal('server')."';";
    $data['Domain'] = "var Domain = '".$this->getGlobal('domain')."';";
    $data['Email'] = "var Email = '".rawurlencode($this->getGlobal('pr_email'))."';";
    $data['Fax'] = "var Fax = '".rawurlencode($this->getGlobal('faxnumber'))."';";
    $data['PhoneNumber'] = "var PhoneNumber = '".rawurlencode($this->getGlobal('defaultnumber'))."';";
    $data['pr_corr_addr_line1'] = "var Addr1 = '".rawurlencode($this->getGlobal('pr_corr_addr_line1'))."';";
    $data['pr_corr_addr_line2'] = "var Addr2 = '".rawurlencode($this->getGlobal('pr_corr_addr_line2'))."';";
    $data['pr_corr_addr_line3'] = "var Addr2 = '".rawurlencode($this->getGlobal('pr_corr_addr_line3'))."';";
    $data['pr_corr_city'] = "var City = '".rawurlencode($this->getGlobal('pr_corr_city'))."';";
    $data['rf_country_name'] = "var Country = '".rawurlencode($this->getGlobal('rf_country_name'))."';";
    $data['pr_corr_post_code'] = "var PostCode = '".rawurlencode($this->getGlobal('pr_corr_post_code'))."';";
    $data['cn_prn_custom_yn'] = "var customYn = '".$this->getGlobal('custom_yn')."';";
    $data['AgentFilterID'] = "var AgentFilterID = '".$this->getGlobal('pr_agent_link')."';";
    $data['filterOccCalByAgent'] = "var filterOccCalByAgent = '".$filterOccCalByAgent."';";

    if($this->getGlobal('system') != "demo") {
      if(file_exists("{$this->getGlobal('images_dir_on_disk')}/{$this->getGlobal('principal_id')}/top_clientlogo.gif")) {
        $data['logoURL'] = $this->getGlobal('http').$this->getGlobal('images_dir')."/".$this->getGlobal('principal_id')."/top_clientlogo.gif";
        $data['LogoSrc'] = "var LogoSrc = '".$this->getGlobal('http').$this->getGlobal('images_dir')."/".$this->getGlobal('principal_id')."/top_clientlogo.gif';";
      } else {
        $data['logoURL'] = "//resource/Resrequest/Application/public/img/1x1.gif";
        $data['LogoSrc'] = "var LogoSrc = '/resource/Resrequest/Application/public/img/1x1.gif';";
      }
    } else {
      $data['logoURL'] = $this->getGlobal('http').$this->getGlobal('images_dir')."/demo/top_clientlogo.gif";
      $data['LogoSrc'] = "var LogoSrc = '".$this->getGlobal('http').$this->getGlobal('images_dir')."/demo/top_clientlogo.gif';";
    }
    $data['systemVersion'] = "var systemVersion = '{$_SESSION['systemVersion']}';";
    $data['dbVersion'] = "var dbVersion = '{$this->getGlobal('dbVersion')}';";
    $data['System'] = "var System = '{$this->getGlobal('system')}';";

    $data['archiveServer'] = $this->getGlobal('client').".".$this->getGlobal('server');

    if($this->getGlobal('archive') === false) {
      $data['logOffLabel'] = "Logoff";
      $data['logOffAction'] = "logOff()";
    } else {
      $data['logOffLabel'] = "Close";
      $data['logOffAction'] = "window.close()";
    }

    // Access Control Override (setting this in each form will take precedence over this default)
    $data['pgJobs'] = "<input type=\"hidden\" name=\"pgJobNew\" value=\"1\">\n";
    $data['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobOpen\" value=\"1\">\n";
    $data['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobEdit\" value=\"1\">\n";
    $data['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobDelete\" value=\"1\">\n";
    $data['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobSave\" value=\"1\">\n";
    $data['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobSaveclose\" value=\"1\">\n";

    $data['timezone'] = date("e");
    $data['currenttime'] = date("H:i:s");

    $timezone_offset = date('P')[0].((substr(date("P"), 1, 2) * 60) + substr(date("P"), 5, 2));
    $data['timezone_offset'] = $timezone_offset;

    $data['headerWidth'] = $this->width;
    $data['top_contents_bottom_bar_style'] = "headerBottomBarNormal";
    $data['top_contents_logo_circle'] = "#c9252f";
    $data['top_contents_hide_on_archive'] = "";
    $data['top_contents_spacer_size'] = "5%";
    $data['archive_click'] = "";
    $data['archive_image'] = "/resource/Resrequest/Application/public/img/icon_archive_inactive.gif";
    $data['archive_class'] = "collapse";
    $archiveMessage = "";
    if($this->getGlobal('archive') !== false) {
      $data['top_contents_bottom_bar_style'] = "headerBottomBarArchive";
      $data['top_contents_logo_circle'] = "#808080";
      $data['top_contents_hide_on_archive'] = "collapse";
      $data['top_contents_spacer_size'] = "15%";
      $data['archive_image'] = "/resource/Resrequest/Application/public/img/icon_archive_used.gif";
      $data['archive_class'] = "";
      $archiveMessage = "Already accessing an archive.";
    } else {
      if($this->getGlobal('allowArchive')) {
        $archiveCount = $this->getGlobal('lDB')->get("SELECT COUNT(*) FROM rf_archive",4);
        $data['archive_class'] = "";
        if($archiveCount > 0) {
          $data['archive_image'] = "/resource/Resrequest/Application/public/img/icon_archive_active.gif";
          $data['archive_click'] = "openPopup('reservation.php?1023',600,300);";
          $archiveMessage = "Click here to view archives.";
        } else {
          $archiveMessage = "No archives available.";
        }
      } else {
        $archiveMessage = "Access to archives denied.";
      }
    }
    if(!empty($archiveMessage)) {
      $data['archive_mouseover'] = "overlib('".t_encodeOverlib($archiveMessage)."');";
    } else {
      $data['archive_mouseover'] = "";
    }
    $data['menu_system'] = $this->getGlobal('menu_system');
    $data['censysEmail'] = $this->getGlobal('censys_email');
    $data['userName'] = $this->getGlobal('username');
    $data['princName'] = $this->getGlobal('principal_name');
    $data['sysUrl'] = $this->sysUrl;
    $data['chpass'] = $this->chpass;
    $data['reqCount'] = $this->reqCount;
    $data['waitlistCount'] = $this->waitlistCount;
    $data['modReqCount'] = $this->modReqCount;
    $data['notificationCount'] = $this->notificationCount;
    $data['notificationPopupShow'] = $this->notificationPopupShow;
    $data['notificationPopupAllowed'] = $this->notificationPopupAllowed;
    $data['hideReqRec'] = $this->hideReqRec;
    $this->reportURL = isset($_SESSION['reportURL']) ? $_SESSION['reportURL'] : "";
    $this->reportProfile = isset($_SESSION['reportProfile']) ? $_SESSION['reportProfile'] : "";
    $data['reportJob'] = substr($this->reportURL,16,strpos($this->reportURL,'+')-16);
    $data['reportURL'] = $this->reportURL;
    $data['reportProfile'] = $this->reportProfile;
    $data['lastResJobArray'] = "var lastResJobArray = new Array($this->lastResJobArrayJs)";
    $data['lastResIdArray'] = "var lastResIdArray = new Array($this->lastResIdArrayJs)";
    $data['lastResNameArray'] = "var lastResNameArray = new Array($this->lastResNameArrayJs)";
    $data['lastContactJobArray'] = "var lastContactJobArray = new Array($this->lastContactJobArrayJs)";
    $data['lastContactIdArray'] = "var lastContactIdArray = new Array($this->lastContactIdArrayJs)";
    $data['lastContactNameArray'] = "var lastContactNameArray = new Array($this->lastContactNameArrayJs)";
    $data['allowQuickSearch'] = $this->allowQuickSearch;
    $data['refreshTransfer'] = $this->refreshTransfer;
    $globalCSS = "
      <link rel=\"stylesheet\" href=\"".$this->getGlobal('http').$this->getGlobal('images_dir')."/{$this->getGlobal('principal_id')}/styles/global.css\" type=\"text/css\" />
    ";

    if (isV3Imageset($this->getGlobal('principal_id'))) {
      // Do not include imageset CSS if it's a V3+ imageset
      $globalCSS = "";
    }

    $data['globalCSS'] = $globalCSS;
    $data['width'] = $this->getWidth();
    $data['title'] = $this->width;
    $this->setData($data);
  }

  protected function setupGlobals() {
    $this->globalsSet['isPopup'] = false;
    $this->globalsSet['bypassAddCheck'] = false;
    $this->globalsSet['username'] = $this->getGlobal('lDB')->get("
      SELECT pr_user_name
      FROM pr_user
      WHERE pr_user_id = '{$this->getGlobal('userid')}'",
    4);
    $this->globalsSet['securitygroup'] = (integer)$this->getGlobal('sc_group_id');
    $this->globalsSet['ceilingnum'] = (integer)$this->getGlobal('sc_grp_avail_limit');
    $userDetailsSQL = "
      SELECT
        pr_name_first, pr_name_last, pr_email
      FROM
        pr_persona
      WHERE
        pr_persona_ix = '{$this->getGlobal('userid')}'";
    $userDetailsQuery = $this->getGlobal('lDB')->get($userDetailsSQL,1);
    $this->globalsSet['firstname'] = $userDetailsQuery['pr_name_first'];
    $this->globalsSet['lastname'] = $userDetailsQuery['pr_name_last'];
    $this->globalsSet['email'] = $userDetailsQuery['pr_email'];
    $this->globalsSet['faxnumber'] = $this->getGlobal('lDB')->get("
      SELECT pr_phone_number
      FROM pr_phone
      WHERE
        pr_persona_id = '{$this->getGlobal('userid')}'
        AND rf_phone_type_id = 'RS1'",
    4);
    $this->globalsSet['defaultnumber'] = $this->getGlobal('lDB')->get("
      SELECT pr_phone_number
      FROM pr_phone 
      WHERE pr_persona_id = '{$this->getGlobal('userid')}' AND pr_default_yn = '1'",
    4);
    $userDetails = getAddress($this->getGlobal('userid'));
    $this->globalsSet['pr_corr_addr_line1'] = $userDetails['pr_corr_addr_line1'];
    $this->globalsSet['pr_corr_addr_line2'] = $userDetails['pr_corr_addr_line2'];
    $this->globalsSet['pr_corr_addr_line3'] = $userDetails['pr_corr_addr_line3'];
    $this->globalsSet['pr_email'] = $userDetails['pr_email'];
    $this->globalsSet['pr_corr_city'] = $userDetails['pr_corr_city'];
    $this->globalsSet['rf_country_name'] = $userDetails['rf_country_name'];
    $this->globalsSet['pr_corr_post_code'] = $userDetails['pr_corr_post_code'];

    // Primary server environment
    if ($this->getGlobal('rf_db_env_type_ind') == "2") {
       // Use the latest successful transfer time initiated by the Reservations Office
      $transferCloseTimeSql="
        SELECT tc_trf_time_close
        FROM tc_transfer
        WHERE
          tc_transfer_db = '{$this->getGlobal('dbcode')}'
          AND sc_transfer_id IN ('52','1033','1054')
        ORDER BY tc_trf_time_close DESC
        LIMIT 1";
      $lastupdate = $this->getGlobal('lDB')->get($transferCloseTimeSql,4);
      // If is webserver and master, or when sync via replication use NOW();
      if ($this->getGlobal('data_synch_mthd') == "2"
        || ($this->getGlobal('dbcode')[0] == "W" && isMasterDB())) {
        $lastupdate = date("Y-m-d H:i:s");
      }
    } else {
       // Use the latest successful transfer time initiated by your property
      $transferCloseTimeSql="
        SELECT tc_trf_time_close
        FROM tc_transfer
        WHERE
          tc_transfer_db = '".$this->getGlobal('dbcode')."'
          AND sc_transfer_id IN ('52','1033','1054')
        ORDER BY tc_trf_time_close DESC
        LIMIT 1";
       $lastupdate =$this->getGlobal('lDB')->get($transferCloseTimeSql,4);
    }
    $this->globalsSet['lastupdate'] = empty($lastupdate) ? "0000-00-00 00:00:00" : $lastupdate;
    $this->lastUpdateDateTime = explode(" ",$this->globalsSet['lastupdate']);
    $this->currentDate = date("Y-m-d");
    $this->currentTime = date("H:i:s");

    $reservationOfficeSQL = "
      SELECT rf_res_office_id
      FROM rf_default
      WHERE rf_default_id = 1";
    $reservationOfficeQuery = $this->getGlobal('lDB')->get($reservationOfficeSQL,1);
    $this->globalsSet['rf_res_office_id'] = $reservationOfficeQuery[0];
    $reservationOfficeEmailSQL = "
      SELECT
        /*0*/ pr_email,
        /*1*/ pr_corr_addr_line1,
        /*2*/ pr_corr_addr_line2,
        /*3*/ pr_corr_addr_line3,
        /*4*/ pr_corr_city,
        /*5*/ pr_corr_post_code
     FROM
        pr_persona
     WHERE
        pr_persona_ix = '{$this->globalsSet['rf_res_office_id']}'";
    $reservationOfficeEmailQuery = $this->getGlobal('lDB')->get($reservationOfficeEmailSQL,1);
    $this->globalsSet['principal_email'] = $reservationOfficeEmailQuery[0];
    $this->globalsSet['principal_addr1'] = $reservationOfficeEmailQuery[1];
    $this->globalsSet['principal_addr2'] = $reservationOfficeEmailQuery[2];
    $this->globalsSet['principal_addr3'] = $reservationOfficeEmailQuery[3];
    $this->globalsSet['principal_city'] = $reservationOfficeEmailQuery[4];
    $this->globalsSet['principal_postcode'] = $reservationOfficeEmailQuery[5];
    $reservationOfficeDefaultPhoneNumberSQL = "
      SELECT pr_phone_number
      FROM pr_phone
      WHERE
        pr_persona_id = '{$this->globalsSet['rf_res_office_id']}'
      AND pr_default_yn = '1'";
    $reservationOfficeDefaultPhoneNumberQuery = $this->getGlobal('lDB')->get($reservationOfficeDefaultPhoneNumberSQL,1);
    $this->globalsSet['principal_phone'] = $reservationOfficeDefaultPhoneNumberQuery[0];
    $reservationOfficePhoneNumberSQL = "
      SELECT pr_phone_number
      FROM pr_phone
      WHERE
        pr_persona_id = '{$this->globalsSet['rf_res_office_id']}'
        AND rf_phone_type_id = 'RS1'";
    $reservationOfficePhoneNumberQuery = $this->getGlobal('lDB')->get($reservationOfficePhoneNumberSQL,1);
    $this->globalsSet['principal_fax'] = $reservationOfficePhoneNumberQuery[0];

    $principalWebAddressSQL = "
      SELECT pr_web_addr
      FROM pr_persona
      WHERE pr_persona_ix = '{$this->getGlobal('PrincID')}'";
    $principalWebAddressQuery = $GLOBALS['lDB']->get($principalWebAddressSQL,1);
    $this->sysUrl = strpos($principalWebAddressQuery[0], 'http') === false ? "http://".$principalWebAddressQuery[0] : $principalWebAddressQuery[0];
    $this->chpass = "";
    if (!isMasterDB() && $this->getGlobal('tempCPC') == "1") {
       $this->chpass = " style=\"display:none\"";
    }

    $this->hideReqRec = "";
    if (!checkJob(650) || $this->getGlobal('userStatusId') < "2") {
       $this->hideReqRec = "visibility:hidden;";
    }

    $this->reqCount = $this->getGlobal('lDB')->get("
      SELECT
        COUNT(*)
      FROM
        rv_reservation
      WHERE
        (
          rv_reservation.rv_consultant_id IS NULL
          OR rv_reservation.rv_consultant_id IN ('','0')
        )
        AND rv_reservation.rf_reservation_status_id != '25'
        AND rv_reservation.rf_reservation_status_id != '15'
        AND (
          rv_reservation.rf_reservation_status_id < '40'
          OR rv_reservation.rf_reservation_status_id = '95'
        )
        AND rv_reservation.rf_reservation_status_id IN ('0', '20', '30', '90')
    ",4);

    $this->waitlistCount = $this->getGlobal('lDB')->get("
      SELECT
        COUNT(*)
      FROM 
        rv_reservation
      WHERE
        rv_reservation.rf_reservation_status_id = '10'
    ",4);

    $this->totalModReqCount = $this->getGlobal('lDB')->get("
        SELECT COUNT(*)
        FROM rv_reservation
        WHERE rv_mod_request_yn = 1
    ", 4);

    $this->totalModCount = $this->getGlobal('lDB')->get("
        SELECT COUNT(*)
        FROM rv_reservation
        WHERE rv_mod_yn = 1
    ", 4);

    $this->modReqCount = $this->totalModReqCount + $this->totalModCount;

    // Notifications
    $notifications = db_notifications_get_count();
    $this->notificationCount = $notifications['count'];
    $this->notificationPopupAllowed = $notifications['showPopup'];
    if (
        ( isset($_SESSION['lastNotificationPopup']) && $_SESSION['lastNotificationPopup'] == $notifications['sessionId'] ) ||
        !$notifications['showPopup']
    ) {
        // The notification popup has already been shown for these notifications
        // OR user has turned off the popup
        $this->notificationPopupShow = 0;
    } else {
        // Change in notifications, the notification popup must be shown
        $this->notificationPopupShow = 1;
        $_SESSION['lastNotificationPopup'] = $notifications['sessionId'];
    }

    if(array_key_exists("lastResArray",$_SESSION) && is_array($_SESSION['lastResArray'])) {
      $lastResIdArray = $_SESSION['lastResArray'];
    } else {
      $lastResIdArray = array();
    }
    $lastResJobArray = array();
    $lastResNameArray = array();
    foreach($lastResIdArray as $resKey=>$resId) {
      if(canEditReservation($resId)) {
        $lastResJobArray[$resKey] = "2";
      } else {
        $lastResJobArray[$resKey] = "0";
      }
      $resName = $this->getGlobal('lDB')->get("SELECT rv_res_name FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
      $lastResNameArray[$resKey] = t_encodeOverlib($resName);
    }
    if(sizeof($lastResIdArray) > 0) {
      $this->lastResIdArrayJs = "'" . join("','",$lastResIdArray) . "'";
      $this->lastResJobArrayJs = "'" . join("','",$lastResJobArray) . "'";
      $this->lastResNameArrayJs = "'" . join("','",$lastResNameArray) . "'";
    }

    if(array_key_exists("lastContactArray",$_SESSION) && is_array($_SESSION['lastContactArray'])) {
      $lastContactIdArray = $_SESSION['lastContactArray'];
    } else {
      $lastContactIdArray = array();
    }
    $lastContactJobArray = array();
    $lastContactNameArray = array();
    foreach($lastContactIdArray as $contactKey=>$contactId) {
      if(canEditContact($contactId)) {
        $lastContactJobArray[$contactKey] = "45";	// edit mode
      } else {
        $lastContactJobArray[$contactKey] = "47";	// view mode
      }
      $contactName = trim($this->getGlobal('lDB')->get("SELECT CONCAT(pr_name_first, ' ', pr_name_last) FROM pr_persona WHERE pr_persona_ix = '$contactId'",4));
      if(strlen($contactName) > 24) {
        $contactName = substr($contactName,0,24) . "...";
      }
      $lastContactNameArray[$contactKey] = t_encodeOverlib($contactName);
    }
    if(sizeof($lastContactIdArray) > 0) {
      $this->lastContactIdArrayJs = "'" . join("','",$lastContactIdArray) . "'";
      $this->lastContactJobArrayJs = "'" . join("','",$lastContactJobArray) . "'";
      $this->lastContactNameArrayJs = "'" . join("','",$lastContactNameArray) . "'";
    }

    if(isset($GLOBALS['jobLevelArray'][248]) && $GLOBALS['jobLevelArray'][248] > 0) {
      $this->allowQuickSearch = "1";
    } else {
      $this->allowQuickSearch = "0";
    }

    $this->autoCheck = $GLOBALS['lDB']->get("SELECT rf_db_trf_auto_yn FROM rf_database WHERE rf_db_code = '$GLOBALS[dbcode]'",4);
    $this->refreshTransfer = "";
    if($this->autoCheck == "2") {
      $this->refreshTransfer = "refreshTransfer();";
    }

    $this->setGlobals($this->globalsSet);
  }

  public function setPartial($_partial) {
    if ($_partial === false && $this->fullDomAdded === false) {
      $htmlDocument = new File(self::TEMPLATE_FILES_DIRECTORY . "html_document.htm");
      $html = $htmlDocument->interpolate(
        [
          'scriptsHead' => "",
          'scriptsTop' => "",
          'scriptsBottom' => "",
        ]
      );
      $html = $htmlDocument->interpolate(
        [ 
          'title' => $this->getTitle(),
          'content' => $this->getContent() 
        ]
      );
      $this->fullDomAdded = true;
      $this->setContent($html);
    }
  }

  public function getScriptContent($_script) {
    $script = new Script(
      self::LEGACY_DIRECTORY . "/../../../public/include/js/$_script",
      Script::SCRIPT_INLINE_FALSE,
      Script::URL_BASE,
      Script::SCRIPT_POSITION_NONE,
      Script::SCRIPT_REQUIRES_INTERPOLATION_TRUE
    );
    $script->interpolate($this->getData());
    return $script->getContent();
  }

  public function handleArguments() {
    $arguments = $this->getArguments();
    if (!empty($arguments['script'])) {
      Script::setHeaders();
      echo($this->getScriptContent($arguments['script']));
      die();
    }
    if (!empty($arguments['nojs']) && !empty($arguments['nocss'])) {
      $this->setScripts([]);
    } else {
      if (!empty($arguments['nojs'])) {
        $scripts = $this->getScripts();
        foreach ($scripts as $key => $script) {
          if ($script->getExtension() === "js") {
            unset($scripts[$key]);
          } 
        }
        $this->setScripts($scripts);
      }
      if (!empty($arguments['nocss'])) {
        $scripts = $this->getScripts();
        foreach ($scripts as $key => $script) {
          if ($script->getExtension() === "css") {
            unset($scripts[$key]);
          } 
        }
        $this->setScripts($scripts);
      }
    }
    $echo = true;
    $this->render($echo);
  }

  public function setWidth($_width) {
    $this->width = $_width;
  }

  public function getWidth() {
    return $this->width;
  }
}
