<?php

/*
 * $Id: 3gdirectpay_api.func.php,v 1.2 2012-11-29 15:29:06 light Exp $
 *
 * $Log: 3gdirectpay_api.func.php,v $
 * Revision 1.2  2012-11-29 15:29:06  light
 * Bug #8081 - 3G Direct Pay
 *
 * Revision 1.1  2012-03-08 16:20:54  light
 * Bug #7596 - Online payment gateway interface: 3GDirect Interface
 *
 *
 */

require_once(__DIR__ . "/../../db.rv_payment_gateway.php");
require_once(__DIR__ . "/../../db.pg_acc_obj_data.php");
require_once(__DIR__ . "/../../functions.persona.php");

function directPayXMLPost($url, $xml) {
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);

	curl_setopt ($ch, CURLOPT_HTTPHEADER, Array("Content-Type: text/xml"));

	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);

	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); // ask for results to be returned
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

	$result = curl_exec($ch);
	curl_close($ch);
	return $result;
}

function directPayXMLParse($xmlString) {
	$xml = xml_parser_create();
	xml_parse_into_struct($xml, $xmlString, $items);
	xml_parser_free($xml);

	$results = array();
	foreach($items as $item){
		if($item['type'] == 'complete') {
			if(isset($item['value'])) {
				$value = $item['value'];
			} else {
				$value = false;
			}
			$results[$item['tag']][] = $value;
		}
	}

	return $results;
}

function directpayProcessReply($pg_account) {
	$token = $_SERVER['argv'][1];

	if ($token == "error") {
		$message = "Error processing payment transaction. You may try again or use one of the other options available below.";
		if (isset($_SERVER['argv'][2]) && !empty(isset($_SERVER['argv'][2]))) {
			$message .= "<br /><br />Details:<br />" . urldecode($_SERVER['argv'][2]);
		}
		return array(
			'id'=>"",
			'status' => DB_RV_PAYMENT_GATEWAY_ERROR,
			'amount'=> "",
			'message'=>$message,
			'log'=>""
		);
	}
	$companyId = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Company_Id");

	$xmlItems = array(
		'CompanyToken'=>$companyId,
		'TransactionToken'=>$token
	);

	$xmlTemplate = "<?xml version=\"1.0\" encoding=\"utf-8\"?>
		<API3G>
			<CompanyToken>!CompanyToken!</CompanyToken>
			<Request>verifyToken</Request>
			<TransactionToken>!TransactionToken!</TransactionToken>
		</API3G>
	";

	$tokenURL = "https://secure.3gdirectpay.com/API/v6/";

	$xmlSend = showpage($xmlItems,$xmlTemplate);
	$xmlResult = directPayXMLPost($tokenURL,$xmlSend);

	$results = array();
	if($xmlResult !== false) {
		$results = directPayXMLParse($xmlResult);
	}

	if(!array_key_exists("RESULT",$results) || !isset($results['RESULT'][0])) {
		$results['RESULT'][0] = "999";
		$status = DB_RV_PAYMENT_GATEWAY_ERROR;
		$message = "Error processing payment transaction. You may try again or use one of the other options available below.";
	} else {
		switch($results['RESULT'][0]) {
		case "000":
			$status = DB_RV_PAYMENT_GATEWAY_SUCCESS;
			$message = "Success";
			break;
		case "901":
			$status = DB_RV_PAYMENT_GATEWAY_DECLINED;
			$message = "Payment transaction declined.";
			break;
		default:
			$status = DB_RV_PAYMENT_GATEWAY_ERROR;
			$message = "Error processing payment transaction. You may try again or use one of the other options available below.";
			break;
		}
	}

	if($status == DB_RV_PAYMENT_GATEWAY_SUCCESS) {
		$amount = $results['TRANSACTIONAMOUNT'][0];
	} else {
		$amount = 0;
	}

	$logItems = array(
		'Result'=>"Result",
		'ResultExplanation'=>"Result Explanation",
		'CustomerName'=>"Customer Name",
		'CustomerCredit'=>"Credit Card Last 4 Digits",
		'CustomerCreditType'=>"Credit Card Type",
		'TransactionApproval'=>"Transaction Approval Number",
		'TransactionCurrency'=>"Transaction Currency",
		'TransactionAmount'=>"Transaction Amount",
		'FraudAlert'=>"Fraud Code",
		'FraudExplnation'=>"Fraud Code Explanation"
	);

	$log = array();
	foreach($logItems as $key=>$item) {
		$key = strtoupper($key);
		if(array_key_exists($key,$results) && isset($results[$key][0])) {
			$log[] = $item . ": " . $results[$key][0];
		}
	}
	$log = join("\n",$log);


	return array(
		'id'=>$token,
		'status'=>$status,
		'amount'=>$amount,
		'message'=>$message,
		'log'=>$log
	);
}

function directpayInit($pg_account) {
	global $lDB;

	$html = join("",file(__DIR__ . "/3gdirectpay.htm"));

	$companyId = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Company_Id");
	$serviceId = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Service_Id");
	$serviceDesc = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Service_Desc");

	$redirect_url = $GLOBALS['http']."$_SERVER[SERVER_NAME]/payment_gateway/3gdirectpay/redirect.php";
	// example redirect url: .../redirect.php?TransID=E2A31638-BF2B-472D-B667-293C47142B21&CCDapproval=4444444416&PnrID=RS49608&TransactionToken=E2A31638-BF2B-472D-B667-293C47142B21&CompanyRef=RS49608
	$back_url = $GLOBALS['http']."$_SERVER[SERVER_NAME]/payment_gateway/3gdirectpay/back.php";
	// example back url: .../back.php?TransactionToken=85B29600-8D95-4958-98EC-714552BAA2E9
	//debug($redirect_url,$back_url);
	//$return_url = $GLOBALS['http']."$_SERVER[SERVER_NAME]/reservation.php?1007";
	// example declined url: ...
	$declined_url = $GLOBALS['http']."$_SERVER[SERVER_NAME]/payment_gateway/3gdirectpay/declined.php";

	$xmlItems = array(
		'CompanyToken'=>$companyId,
		'PaymentCurrency'=>$pg_account['pg_acc_currency_code'],
		'PaymentAmount'=>$pg_account['amount'],
		'ServiceDescription'=>$serviceDesc,
		'ServiceType'=>$serviceId,
		'ServiceDate'=>$pg_account['date'],
		'CompanyRef'=>$pg_account['reference'],
		'RedirectURL'=>$redirect_url,
		'BackURL'=>$back_url,
		'DeclinedURL'=>$declined_url
	);

	$reservations = $lDB->get("SELECT DISTINCT rv_reservation_id FROM fn_folio WHERE fn_folio_ix IN ('".join("','",$pg_account['folios'])."')",3);
	if(sizeof($reservations) == 1) {
		$rv_reservation_id = $reservations[0];
	} else {
		$rv_reservation_id = "";
	}

	if(!empty($rv_reservation_id)) {
		if(isset($_SESSION['wizResContact']) && array_key_exists($rv_reservation_id,$_SESSION['wizResContact'])) {
			$xmlItems = array_merge($xmlItems,$_SESSION['wizResContact'][$rv_reservation_id]);
		} else {
			$contact = $lDB->get("
				SELECT
					pr_persona.pr_persona_ix,
					pr_persona.pr_name_last,
					pr_persona.pr_name_first,
					pr_persona.pr_email,
					pr_persona.pr_corr_addr_line1,
					pr_persona.pr_corr_addr_line2,
					pr_persona.pr_corr_addr_line3,
					pr_persona.pr_corr_city,
					pr_persona.pr_corr_post_code
				FROM
					rv_reservation
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_corr_persona_id
				WHERE
					rv_reservation.rv_reservation_ix = '".$lDB->escape($rv_reservation_id)."'
			",1);
			$phone = getDefPhoneNumber($contact['pr_persona_ix']);
			$phone = preg_replace("/[^0-9]/", "", $phone);
			$phone = substr($phone, 0, 20);

			$xmlItems = array_merge($xmlItems,array(
				'first_name'=>$contact['pr_name_first'],
				'last_name'=>$contact['pr_name_last'],
				'email'=>$contact['pr_email'],
				'phone'=>$phone,
				'address'=>$contact['pr_corr_addr_line1'],
				'city'=>$contact['pr_corr_city'],
				'code'=>$contact['pr_corr_post_code']
			));
		}
	} else {
		$xmlItems = array_merge($xmlItems,array(
			'first_name'=>"",
			'last_name'=>"",
			'email'=>"",
			'phone'=>"",
			'address'=>"",
			'city'=>"",
			'code'=>""
		));
	}

	$xmlTemplate = "<?xml version=\"1.0\" encoding=\"utf-8\"?>
		<API3G>
			<CompanyToken>!CompanyToken!</CompanyToken>
			<Request>createToken</Request>
			<Transaction>
				<PaymentAmount>!PaymentAmount!</PaymentAmount>
				<PaymentCurrency>!PaymentCurrency!</PaymentCurrency>
				<CompanyRef>!CompanyRef!</CompanyRef>
				<RedirectURL>!RedirectURL!</RedirectURL>
				<BackURL>!BackURL!</BackURL>
				<DeclinedURL>!DeclinedURL!</DeclinedURL>
				<CompanyRefUnique>0</CompanyRefUnique>
				<customerFirstName>!first_name!</customerFirstName>
				<customerLastName>!last_name!</customerLastName>
				<customerEmail>!email!</customerEmail>
				<customerPhone>!phone!</customerPhone>
				<customerAddress>!address!</customerAddress>
				<customerCity>!city!</customerCity>
				<customerZip>!code!</customerZip>
			</Transaction>
			<Services>
				<Service>
					<ServiceType>!ServiceType!</ServiceType>
						<ServiceDescription>!ServiceDescription!</ServiceDescription>
						<ServiceDate>!ServiceDate!</ServiceDate>
				</Service>
			</Services>
		</API3G>
	";

	$tokenURL = "https://secure.3gdirectpay.com/API/v6/";

	$xmlSend = showpage($xmlItems,$xmlTemplate);
	$xmlResult = directPayXMLPost($tokenURL,$xmlSend);

	if($xmlResult === false) {
		redirectTo(" /reservation.php?1007+error");
		die();
	}

	$results = directPayXMLParse($xmlResult);

	// We have no data
	if(!array_key_exists("RESULT",$results) || !isset($results['RESULT'][0])) {
		redirectTo(" /reservation.php?1007+error");
		die();
	}

	// We have data, but not a success
	if($results['RESULT'][0] != "000") {
		$resultExplanation = isset($results['RESULTEXPLANATION']) && isset($results['RESULTEXPLANATION'][0]) ? $results['RESULTEXPLANATION'][0] : "";
		redirectTo(" /reservation.php?1007+error+" . $resultExplanation);
		die();
	}

	$token = $results['TRANSTOKEN'][0];

	$items['form_id'] = "3gdirectpay_payment_form";
	$items['action'] = "https://secure.3gdirectpay.com/payv2.php?ID=$token";

	$pg_account['form'] = showpage($items,$html);
	$pg_account['submit'] = "directpay_payment_submit();";

	return $pg_account;
}
