<?php

require_once(__DIR__ . "/../../db.rv_payment_gateway.php");
require_once(__DIR__ . "/../../db.pg_acc_obj_data.php");
require_once(__DIR__ . "/../../functions.persona.php");

function crdbInit($pg_account) {
	global $lDB;

	$html = join("",file(__DIR__ . "/crdb.htm"));

	$merchantId = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Merchant_Id");
	$hashValue = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Hash_Value");
	$accessCode = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Access_Code");

	$back_url = $GLOBALS['http']."$_SERVER[SERVER_NAME]/payment_gateway/crdb/back.php";

	// Keys must be in ascending order for secure hash to work

	$url = [
		'vpc_AccessCode'=>$accessCode,
		'vpc_Amount'=>round($pg_account['amount']*100, 0),			// make sure there's no decimal places, to avoid strange minute decimals
		'vpc_Command'=>"pay",
		'vpc_Currency'=>$pg_account['pg_acc_currency_code'],
		'vpc_Locale'=>'en',
		'vpc_MerchTxnRef'=>$pg_account['reference'] . "-" . $_SESSION['rv_payment_gateway_id'], // unique to avoid duplicates
		'vpc_Merchant'=>$merchantId,
		'vpc_OrderInfo'=>$pg_account['reference'],
		'vpc_ReturnURL'=>$back_url,
		'vpc_Version'=>"1",
	];

	$pairs = [];
	foreach($url as $key=>$value) {
		$pairs[] = $key . "=" . $value;
	}
	$pairs = join("&",$pairs);

	$url['vpc_SecureHash'] = strtoupper(hash_hmac('SHA256', $pairs, pack("H*", $hashValue)));
	$url['vpc_SecureHashType'] = 'SHA256';

	$items['form_id'] = "crdb_payment_form";
	$items['action'] = $pg_account['pg_type_api_url'] . "?" . http_build_query($url);

	$pg_account['form'] = showpage($items,$html);
	$pg_account['submit'] = "crdb_payment_submit();";

	return $pg_account;
}

function crdbProcessError($message) {
	return array(
		'id'=>"",
		'status'=>DB_RV_PAYMENT_GATEWAY_ERROR,
		'amount'=>0,
		'message'=>$message,
		'log'=>$message
	);
}

function crdbProcessReply($pg_account) {
	$data = json_decode($_POST['crdbReply'],true);

	if($data === null) {
		return crdbProcessError("Invalid reply from payment gateway");
	}

	$merchantId = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Merchant_Id");
	$hashValue = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Hash_Value");
	$accessCode = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Access_Code");

	$check = $data;
	$pairs = [];
	unset($check['vpc_SecureHash']);
	unset($check['vpc_SecureHashType']);
	foreach($check as $key=>$value) {
		$pairs[] = $key . "=" . $value;
	}
	unset($check);

	$pairs = join("&",$pairs);
	$hash = strtoupper(hash_hmac('SHA256', $pairs, pack("H*", $hashValue)));
	unset($pairs);

	if($data['vpc_SecureHash'] !== $hash || $data['vpc_Merchant'] !== $merchantId) {
		return crdbProcessError("Unable to validate reply from payment gateway");
	}

	$amount = $data['vpc_Amount'] ?? 0;
	$amount = db_round($amount / 100);
	$message = $data['vpc_Message'] ?? "Unknown error";
	$transactionId = $data['vpc_MerchTxnRef'] ?? "";

	$code = $data['vpc_TxnResponseCode'] ?? "1";
	switch($code) {
	case "0": // transaction successful
		$status = DB_RV_PAYMENT_GATEWAY_SUCCESS;
		break;
	case "1": // transaction could not be processed
	case "7": // payment server processing error
	case "A": // transaction aborted
	default: // response unknown
		$status = DB_RV_PAYMENT_GATEWAY_ERROR;
		break;
	case "2": // contact issuing bank
	case "3": // no reply from bank
	case "4": // expired card
	case "5": // insufficient credit
	case "6": // bank system error
	case "8": // transaction type not supported
	case "9": // bank declined transaction
	case "B": // transaction blocked
	case "C": // transaction cancelled
	case "D": // transaction deferred
	case "E": // refer to card issuer
	case "F": // 3d secure authentication failed
	case "I": // card security code failed
	case "L": // shopping transaction locked
	case "N": // cardholder not enrolled in 3d secure
	case "P": // transaction is pending
	case "R": // retry limit exceeded
	case "T": // address verification failed
	case "U": // card security code failed
	case "V": // address verification and card security code failed
		$status = DB_RV_PAYMENT_GATEWAY_DECLINED;
		break;
	}

	$log = ""; // TODO
	foreach($data as $key=>$value) {
		if($key == "vpc_SecureHash" || $key == "vpc_SecureHashType") {
			continue;
		}
		if(trim($value) != "") {
			$log .= preg_replace("/(.)([A-Z][a-z])/","$1 $2",preg_replace("/^vpc_/","",$key)) . ": " . $value . "\n";
		}
	}

	return array(
		'id'=>$transactionId,
		'status'=>$status,
		'amount'=>$amount,
		'message'=>$message,
		'log'=>$log
	);

	/* 
	 * Example reply data
		[vpc_3DSECI] => 05
		[vpc_3DSXID] => 93ljLfIupFTx3YmIhPV18o1gvsU=
		[vpc_3DSenrolled] => Y
		[vpc_3DSstatus] => Y
		[vpc_AVSResultCode] => Unsupported
		[vpc_AcqAVSRespCode] => Unsupported
		[vpc_AcqCSCRespCode] => M
		[vpc_AcqResponseCode] => 00
		[vpc_Amount] => 4056
		[vpc_AuthorizeId] => 026572
		[vpc_BatchNo] => 20190823
		[vpc_CSCResultCode] => M
		[vpc_Card] => VC
		[vpc_CardNum] => xxxxxxxxxxxx0002
		[vpc_Command] => pay
		[vpc_Currency] => USD
		[vpc_Locale] => en
		[vpc_MerchTxnRef] => RS5
		[vpc_Merchant] => CARDCENTRE01
		[vpc_Message] => Approved
		[vpc_OrderInfo] => RS5
		[vpc_ReceiptNo] => 923601572719
		[vpc_SecureHash] => 697AA115DB1650956E1C80C375222FA8A6CF20465E582BC888F3803CADB80F74
		[vpc_SecureHashType] => SHA256
		[vpc_TransactionNo] => 2050002286
		[vpc_TxnResponseCode] => 0
		[vpc_VerSecurityLevel] => 05
		[vpc_VerStatus] => Y
		[vpc_VerToken] => gIGCg4SFhoeIiYqLjI2Oj5CRkpM=
		[vpc_VerType] => 3DS
		[vpc_Version] => 1
		[controller] => MaglLegacyApplication\Controller\Legacy
		[action] => index
		[script] => /payment_gateway/crdb/back.php
	 */
}
