<?php

require_once(__DIR__ . "/../../db.rv_payment_gateway.php");
require_once(__DIR__ . "/../../db.pg_acc_obj_data.php");
require_once(__DIR__ . "/../../functions.persona.php");

function mobipaidInit($pg_account) {
    global $lDB;

    // Initialize keys to prevent undefined index notices
    $pg_account['form'] = '';
    $pg_account['submit'] = '';

    // Load the HTML template
    $html = join("", file(__DIR__ . "/mobipaid.htm"));

    // Fetch necessary data
    $accessCode = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'], "Access_Code");
    $merchantEmail = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'], "Merchant_Email");
    $merchantPhone = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'], "Merchant_Phone");
    $back_url = $GLOBALS['http'] . $_SERVER['SERVER_NAME'] . "/payment_gateway/mobipaid/back.php";
    $redirect_url = $GLOBALS['http'] . $_SERVER['SERVER_NAME'] . "/payment_gateway/mobipaid/redirect.php";

    // Compulsory merchant contact details
    $email = isset($merchantEmail) ? $merchantEmail : "support@resrequest.com";
    $mobile_number = isset($merchantPhone) ? $merchantPhone : "+27317622729";

    // Prepare the data for the API request
    $data = array(
        "request_methods" => ["WEB"],
        "reference_number" => $pg_account['reference'] . "-" . $_SESSION['rv_payment_gateway_id'],
        "email" => $email,
        "mobile_number" => $mobile_number,
        "redirect_url" => $redirect_url,
        "response_url" => $back_url,
        "fixed_amount" => true,
        "currency" => $pg_account['pg_acc_currency_code'],
        "amount" => floatval($pg_account['amount']),
        "payment_methods" => ["APPLE_PAY", "GOOGLE_PAY", "NEDBANK_EFT"]
    );

    // Convert data to JSON
    $jsonData = json_encode($data);

    // Initialize cURL
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => $pg_account['pg_type_api_url']."v2/payment-requests",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => $jsonData,
        CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json",
            "Authorization: Bearer " . $accessCode
        ),
    ));

    // Execute the cURL request
    $response = curl_exec($curl);
    $http_status = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($curl);
    curl_close($curl);

    // Log the response and potential errors
    error_log("MobiPaid API Response: " . print_r($response, true));
    error_log("HTTP Status Code: " . $http_status);
    if ($curl_error) {
        error_log("cURL Error: " . $curl_error);
    }

    // Handle the response
    $response_data = json_decode($response, true);

    if (isset($response_data['short_url'])) {
        $items['form_id'] = "mobipaid_payment_form";
        $items['action'] = $response_data['short_url'];

        // Render the form with the updated action URL
        $pg_account['form'] = showpage($items, $html);
        $pg_account['submit'] = "mobipaid_payment_submit();";
    } else {
        $pg_account['error'] = isset($response_data['message']) ? $response_data['message'] : 'Unknown error occurred';
        echo json_encode(array("status" => "error", "message" => $pg_account['error']));
    }

    return $pg_account;
}

function mobipaidProcessReply($data) {
    // Log the decoded data for debugging
    error_log("Decoded response data in mobipaidProcessReply: " . print_r($data, true));

    if ($data === null) {
        return mobipaidProcessError("Invalid reply from payment gateway");
    }

    $result = isset($data['result']) ? $data['result'] : 'NOK';

    // Log the actual value of $result
    error_log("Actual value of result: " . $result);

    $amount = floatval(isset($data['amount']) ? $data['amount'] : 0);
    $transaction_id = isset($data['transaction_id']) ? $data['transaction_id'] : '';
    $result_code = isset($data['result_code']) ? $data['result_code'] : "";
    $result_description = isset($data['result_description']) ? $data['result_description'] : "Unknown error";
    $message = $result_code . "  " . $result_description;

    // Update status based on result
    $status = DB_RV_PAYMENT_GATEWAY_ERROR;

    if ($result === "ACK") {
        $status = DB_RV_PAYMENT_GATEWAY_SUCCESS;
    } elseif ($result === "NOK") {
        $status = DB_RV_PAYMENT_GATEWAY_DECLINED;
    }

    $log = "";
    foreach ($data as $key => $value) {
        if (trim($value) != "") {
            $log .= preg_replace("/(.)([A-Z][a-z])/", "$1 $2", $key) . ": " . $value . "\n";
        }
    }

    return array(
        'id' => $transaction_id,
        'status' => $status,
        'amount' => $amount,
        'message' => $message,
        'log' => $log
    );
}

function mobipaidProcessError($message) {
    return array(
        'id' => "",
        'status' => DB_RV_PAYMENT_GATEWAY_ERROR,
        'amount' => 0,
        'message' => $message,
        'log' => $message
    );
}
