<?php

require_once(__DIR__ . "/db.rv_payment_gateway.php");
require_once(__DIR__ . "/db.pg_acc_obj_data.php");

function paygateProcessReply($pg_account) {
	global $lDB;

	$idCheck = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"PayGateEA_Id");
	$key = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"PayGateEA_Key");


	if(!isset($_POST['PAYGATE_ID'])) {
		$error = true;
		$message = "Transaction cancelled";
		$log .= "\nError: Transaction cancelled";
		$transactionId = "";
		$amount = 0;
	} else {
		$id = $_POST['PAYGATE_ID'];
		$reference = $_POST['REFERENCE'];
		$statusExt = $_POST['TRANSACTION_STATUS'];
		$resultCode = $_POST['RESULT_CODE'];
		$auth = $_POST['AUTH_CODE'];
		$amount = $_POST['AMOUNT'];
		$resultDesc = $_POST['RESULT_DESC'];
		$transactionId = $_POST['TRANSACTION_ID'];
		$risk = $_POST['RISK_INDICATOR'];
		$checksum = $_POST['CHECKSUM'];

		$log = "Transaction Id: $transactionId
	Result code: $resultCode
	Result description: $resultDesc
	Authorisation code: $auth
	Risk indicator: $risk";

		$message = $resultDesc;

		$error = false;
		$errorMessage = "";

		if($id != $idCheck) {
			$error = true;
			$message = "Security check failure";
			$log .= "\nError: Mismatch on PayGate Id";
		}

		if($reference != $pg_account['reference']) {
			$error = true;
			$message = "Security check failure";
			$log .= "\nError: Mismatch on reservation number";
}

		if($amount != $pg_account['amount']) {
			$error = true;
			$message = "Security check failure";
			$log .= "\nError: Mismatch on amount";
		}

		$checksumStr = "$id|$reference|$statusExt|$resultCode|$auth|$amount|$resultDesc|$transactionId|$risk|$key";
		if($checksum != md5($checksumStr)) {
			$error = true;
			$message = "Security check failure";
			$log .= "\nError: Mismatch on checksum";
		}

	}

	if($error) {
		$status = DB_RV_PAYMENT_GATEWAY_ERROR;
	} else {
		if($auth != "NO") {
			$status = DB_RV_PAYMENT_GATEWAY_SUCCESS;
		} else {
			if($resultCode == "990028") {
				$status = DB_RV_PAYMENT_GATEWAY_DECLINED;
			} else {
				$status = DB_RV_PAYMENT_GATEWAY_ERROR;
			}
		}
	}

	return array(
		'id'=>$transactionId,
		'status'=>$status,
		'amount'=>$amount,
		'message'=>$message,
		'log'=>$log
	);
}
