<?php

require_once(__DIR__ . "/../../db.rv_payment_gateway.php");
require_once(__DIR__ . "/../../db.pg_acc_obj_data.php");

function payGateConfig($pg_account) {
	$config = [
		'payGateId' => db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'], 'PayGate_Id'),
		'payGateEncryptionKey' => db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'], 'PayGate_Encryption_Key'),

		'reference' => $pg_account['reference'],
		'gatewayAmount' => str_replace('.', '', $pg_account['amount']),
		'currencyCode' => $pg_account['pg_acc_currency_code'],
		'returnUrl' => $GLOBALS['http'] . "{$_SERVER['SERVER_NAME']}/payment_gateway/paygate-payweb-3/back.php",
		'locale' => 'en-ZA',
		'country' => 'ZAF',
		'email' => '',

		'initiateUrl' => 'https://secure.paygate.co.za/payweb3/initiate.trans',
		'redirectUrl' => 'https://secure.paygate.co.za/payweb3/process.trans',
		'queryUrl' => 'https://secure.paygate.co.za/payweb3/query.trans',
		'verifyPeer' => true
	];

	return $config;
}

function payGatePayWeb3Init($pg_account) {
	$config = payGateConfig($pg_account);
	$tranDate = date('Y-m-d H:i');

	$postFields = [
		'PAYGATE_ID' => $config['payGateId'],
		'REFERENCE' => $config['reference'],
		'AMOUNT' => $config['gatewayAmount'],
		'CURRENCY' => $config['currencyCode'],
		'RETURN_URL' => $config['returnUrl'],
		'TRANSACTION_DATE' => $tranDate,
		'LOCALE' => $config['locale'],
		'COUNTRY' => $config['country'],
		'EMAIL' => $config['email'],
	];

	$checksum = md5(implode('', $postFields) . $config['payGateEncryptionKey']);

	$postFields['CHECKSUM'] = $checksum;

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $config['initiateUrl']);
	curl_setopt($ch, CURLOPT_NOBODY, false);
	curl_setopt($ch, CURLOPT_REFERER, $_SERVER['HTTP_HOST']);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postFields));
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $config['verifyPeer']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_FAILONERROR, true);

	parse_str(curl_exec($ch), $response);
	
	curl_close($ch);

	/* 

		Example error: ERROR=DATA_CHK
		
		Example success: PAYGATE_ID=10011072130&PAY_REQUEST_ID=F8431AD0-5BFB-AB61-6624-D23FF22115C4&REFERENCE=asd&CHECKSUM=855c6c69dae8eb2d078a44023de1e8df, referer: http://p1.vagrant/reservation.php?299++WB1000

	*/
	
	if(
		!is_array($response)
		|| !array_key_exists('PAY_REQUEST_ID', $response)
	) {
		redirectTo('/reservation.php?1007+error');
		die();
	}

	$items = [
		'payRequestId' => $response['PAY_REQUEST_ID'],
		'checksum' => $response['CHECKSUM'],
		'redirectUrl' => $config['redirectUrl'],
		'returnUrl' => $config['returnUrl']
	];

	$html = join('' ,file(__DIR__ . '/../../payment_gateway/paygate-payweb-3/paygate-payweb-3.htm'));
	$pg_account['form'] = showpage($items, $html);

	return $pg_account;
}

function payGatePayWeb3ProcessReply($pg_account) {
	$config = payGateConfig($pg_account);
	$data = $_POST;

	if (empty($data) || !array_key_exists('PAY_REQUEST_ID', $data)) {
		return payGatePayWeb3ProcessError('Invalid reply from payment gateway');
	}

	$postFields = [
		'PAYGATE_ID' => $config['payGateId'],
		'PAY_REQUEST_ID' => $data['PAY_REQUEST_ID'],
		'REFERENCE' => $config['reference']
	];
	
	$checksum = md5(implode('', $postFields) . $config['payGateEncryptionKey']);
	
	$postFields['CHECKSUM'] = $checksum;
	
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $config['queryUrl']);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($ch, CURLOPT_NOBODY, false);
	curl_setopt($ch, CURLOPT_REFERER, $_SERVER['HTTP_HOST']);
	curl_setopt($ch, CURLOPT_POST, true);
	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postFields));

	parse_str(curl_exec($ch), $response);

	curl_close($ch);

	/*

		Example error: ERROR=DATA_CHK

		Example success: PAYGATE_ID=10011072130&PAY_REQUEST_ID=9AE44927-059F-5823-32C9-A0968CAA450C&REFERENCE=asd&TRANSACTION_STATUS=1&RESULT_CODE=990017&AUTH_CODE=9I8E2I&CURRENCY=USD&AMOUNT=12300&RESULT_DESC=Auth+Done&TRANSACTION_ID=496124911&RISK_INDICATOR=AP&PAY_METHOD=CC&PAY_METHOD_DETAIL=Visa&CHECKSUM=d6092721ef33753c6357dd824918e37d
	
	*/

	if (
		!is_array($response)
		|| !array_key_exists('RESULT_CODE',$response)
	) {
		return payGatePayWeb3ProcessError('Invalid reply from payment gateway');
	}

	$id = $response['PAYGATE_ID'];
	$reference = $response['REFERENCE'];
	$statusExt = $response['TRANSACTION_STATUS'] ?? '';
	$resultCode = $response['RESULT_CODE'];
	$auth = $response['AUTH_CODE'];
	$currency = $response['CURRENCY'];
	$amount = $response['AMOUNT'];
	$resultDesc = $response['RESULT_DESC'];
	$transactionId = $response['TRANSACTION_ID'];
	$risk = $response['RISK_INDICATOR'];
	$payMethod = $response['PAY_METHOD'] ?? '';
	$payMethodDetail = $response['PAY_METHOD_DETAIL'] ?? '';
	$checksum = $response['CHECKSUM'];

	if ($resultCode != '990017') {
		return payGatePayWeb3ProcessError($resultDesc);
	}

	$log = "Transaction id: {$transactionId}
Result code: {$resultCode}
Result description: {$resultDesc}
Transaction status: {$statusExt}
Authorisation code: {$auth}
Currency: {$currency}
Risk indicator: {$risk}
Pay method: {$payMethod}
Pay method detail: {$payMethodDetail}";

	$message = $resultDesc;

	$error = false;
	if ($id != $config['payGateId']) {
		$error = true;
		$message = 'Security check failure`';
		$log .= "\nError: Mismatch on PayGate Id";
	}

	if ($reference != $config['reference']) {
		$error = true;
		$message = 'Security check failure';
		$log .= "\nError: Mismatch on reference number";
	}

	if ($amount != str_replace('.', '', $config['gatewayAmount'])) {
		$error = true;
		$message = 'Security check failure';
		$log .= "\nError: Mismatch on amount";
	}

	$checksumData = $response;
	unset($checksumData['CHECKSUM']);

	$checksum = md5(implode('', $checksumData) . $config['payGateEncryptionKey']);
	$checksumCompare = $response['CHECKSUM'];

	if ($checksum != $checksumCompare) {
		$error = true;
		$message = 'Security check failure';
		$log .= "\nError: Mismatch on checksum";
	}

	if ($error) {
		$status = DB_RV_PAYMENT_GATEWAY_ERROR;
	} else {
		switch ($statusExt) {
		case 0: // Not done
			$status = DB_RV_PAYMENT_GATEWAY_ERROR;
			break;
		case 1:
			$status = DB_RV_PAYMENT_GATEWAY_SUCCESS;
			break;
		case 2:
			$status = DB_RV_PAYMENT_GATEWAY_DECLINED;
			break;
		default:
			$status = DB_RV_PAYMENT_GATEWAY_DECLINED;
			break;
		}
	}

	if ($status == DB_RV_PAYMENT_GATEWAY_SUCCESS) {
		$amount = $amount / 100;
	} else {
		$amount = 0;
	}

	return [
		'id' => $transactionId,
		'status' => $status,
		'amount' => $amount,
		'message' => $message,
		'log' => $log
	];
}

function payGatePayWeb3ProcessError($message) {
	return array(
		'id' => '',
		'status' => DB_RV_PAYMENT_GATEWAY_ERROR,
		'amount' => 0,
		'message' => $message,
		'log' => $message
	);
}
