<?php

require_once(__DIR__ . "/../../db.rv_payment_gateway.php");
require_once(__DIR__ . "/../../db.pg_acc_obj_data.php");

function paygateProcessReply($pg_account) {
	global $lDB;

	$idCheck = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"PayGate_Id");
	$key = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"PayGate_Key");

	$id = $_POST['PAYGATE_ID'];
	$reference = $_POST['REFERENCE'];
	$statusExt = $_POST['TRANSACTION_STATUS'];
	$resultCode = $_POST['RESULT_CODE'];
	$auth = $_POST['AUTH_CODE'];
	$amount = $_POST['AMOUNT'];
	$resultDesc = $_POST['RESULT_DESC'];
	$transactionId = $_POST['TRANSACTION_ID'];
	$risk = $_POST['RISK_INDICATOR'];
	$checksum = $_POST['CHECKSUM'];

	$log = "Transaction id: $transactionId
Result code: $resultCode
Result description: $resultDesc
Authorisation code: $auth
Risk indicator: $risk";

	$message = $resultDesc;

	$error = false;
	$errorMessage = "";

	if($id != $idCheck) {
		$error = true;
		$message = "Security check failure";
		$log .= "\nError: Mismatch on PayGate Id";
	}

	if($reference != $pg_account['reference']) {
		$error = true;
		$message = "Security check failure";
		$log .= "\nError: Mismatch on reference number";
	}

	if($amount != str_replace(".","",$pg_account['amount'])) {
		$error = true;
		$message = "Security check failure";
		$log .= "\nError: Mismatch on amount";
	}

	if(empty($risk)) {
		$checksumStr = "$id|$reference|$statusExt|$resultCode|$auth|$amount|$resultDesc|$transactionId|$key";
	} else {
		$checksumStr = "$id|$reference|$statusExt|$resultCode|$auth|$amount|$resultDesc|$transactionId|$risk|$key";
	}
	if($checksum != md5($checksumStr)) {
		$error = true;
		$message = "Security check failure";
		$log .= "\nError: Mismatch on checksum";
	}

	if($error) {
		$status = DB_RV_PAYMENT_GATEWAY_ERROR;
	} else {
		switch($statusExt) {
		case 0: // Not done
			$status = DB_RV_PAYMENT_GATEWAY_ERROR;
			break;
		case 1:
			$status = DB_RV_PAYMENT_GATEWAY_SUCCESS;
			break;
		case 2:
			$status = DB_RV_PAYMENT_GATEWAY_DECLINED;
			break;
		}
	}

	if($status == DB_RV_PAYMENT_GATEWAY_SUCCESS) {
		$amount = $amount / 100;
	} else {
		$amount = 0;
	}

	return array(
		'id'=>$transactionId,
		'status'=>$status,
		'amount'=>$amount,
		'message'=>$message,
		'log'=>$log
	);
}
