<?php

require_once(__DIR__ . "/../../db.rv_payment_gateway.php");
require_once(__DIR__ . "/../../db.pg_acc_obj_data.php");

function peachConfig($pg_account) {
	$baseUrl = $pg_account['pg_type_api_url'];
	$verifyPeer = true;
	// Uncomment to enable sandbox/testing
	//$baseUrl = "https://test.oppwa.com";
	//$verifyPeer = false;

	return [$baseUrl, $verifyPeer];
}

function peachCardInit($pg_account) {
	list($baseUrl, $verifyPeer) = peachConfig($pg_account);

	$authToken = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Auth_Token");
	$channelId = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Channel_Id");

	// Our merchantTransactionId can now only be max 16 characters long, consisting of non-alphanumeric characters
	// So we strip out non-alphanumeric characters from the reference, and the payment gateway ID,
	// Then concatenate them, but trimming the reference so that both together are max 16 characters
	$reference = preg_replace( '/[\W]/', '', $pg_account['reference']);
	$PgId = preg_replace( '/[\W]/', '', $_SESSION['rv_payment_gateway_id']);
	$merchantTransactionId = substr($reference, 0, (16 - (strlen($PgId)) )) . $PgId;
	$merchantTransactionId = substr($merchantTransactionId, 0, 16);		// Make double-sure we don't exceed 16 characters

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $baseUrl . "/v1/checkouts");
	curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $authToken"]);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
		'entityId'=>$channelId,
		'amount'=>$pg_account['amount'],
		'currency'=>$pg_account['pg_acc_currency_code'],
		'paymentType'=>"DB",
		'merchantTransactionId'=>$merchantTransactionId
	]));
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $verifyPeer);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$response = json_decode(curl_exec($ch),true);
	curl_close($ch);

	if(
		!is_array($response)
		|| !array_key_exists('result',$response)
		|| !array_key_exists('code',$response['result'])
		|| $response['result']['code'] !== "000.200.100"
		|| !array_key_exists('id',$response)
	) {
		redirectTo("/reservation.php?1007+error");
		die();
	}

	$html = join("",file(__DIR__ . "/peach-card.htm"));

	/* 

		Example error: {"result":{"code":"200.300.404","description":"invalid or missing parameter","parameterErrors":[{"name":"0","value":"paymentType=DB","message":"is not an allowed parameter"}]},"buildNumber":"0b662de043e6bf56c3a1e69d19d6da7e75f93eab@2020-02-04 14:10:09 +0000","timestamp":"2020-02-06 14:08:08+0000","ndc":"F6A5F4B3CC21F4998B059B2110742A69.uat01-vm-tx02"}
		
		Example success: {"result":{"code":"000.200.100","description":"successfully created checkout"},"buildNumber":"0b662de043e6bf56c3a1e69d19d6da7e75f93eab@2020-02-04 14:10:09 +0000","timestamp":"2020-02-06 14:08:51+0000","ndc":"69E5DCEDCBC48A5CFD2093CDE5C5F1B4.uat01-vm-tx02","id":"69E5DCEDCBC48A5CFD2093CDE5C5F1B4.uat01-vm-tx02"}

	*/

	$items = [
		'base_url'=>$baseUrl,
		'checkout_id'=>$response['id'],
		'return_url'=>$GLOBALS['http']."$_SERVER[SERVER_NAME]/payment_gateway/peach-card/back.php"
	];

	$pg_account['form'] = showpage($items,$html);
	$pg_account['submit'] = "";

	return $pg_account;
}

function peachProcessError($message) {
	return array(
		'id'=>"",
		'status'=>DB_RV_PAYMENT_GATEWAY_ERROR,
		'amount'=>0,
		'message'=>$message,
		'log'=>$message
	);
}

function peachFormatLog($data, $indent=0) {
	$log = "";
	foreach($data as $key=>$value) {
		$key = ucfirst(str_replace("_"," ",preg_replace("/([A-Z][a-z])/"," $1", $key)));
		if(is_array($value)) {
			$value = "\n" . peachFormatLog($value, $indent + 1);
		}
		$log .= str_repeat("  ", $indent) . "$key: $value\n";
	}

	return $log;
}

function peachCardProcessReply($pg_account) {
	$data = json_decode($_POST['peachReply']??"",true);

	if($data === null || !array_key_exists("id",$data)) {
		return peachProcessError("Invalid reply from payment gateway");
	}

	list($baseUrl, $verifyPeer) = peachConfig($pg_account);

	$authToken = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Auth_Token");
	$channelId = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Channel_Id");

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $baseUrl . "/v1/checkouts/" . $data['id'] . "/payment?entityId=" . $channelId);
	curl_setopt($ch, CURLOPT_HTTPHEADER, ["Authorization: Bearer $authToken"]);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, $verifyPeer);// this should be set to true in production
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$response = json_decode(curl_exec($ch),true);
	curl_close($ch);

	if(
		!is_array($response)
		|| !array_key_exists('result',$response)
	) {
		return peachProcessError("Invalid reply from payment gateway");
	}

	$code = $response['result']['code'] ?? "";
	$message = $response['result']['description'] ?? "Invalid reply from payment gateway";

	if(!preg_match("/^(000\.000\.|000\.100\.1|000\.[36])/", $code)) {
		return peachProcessError($message);
	}

	$id = $response['id'];
	$amount = $response['amount'];

	$log = peachFormatLog($response);

	/*
		Example error: {"result":{"code":"200.300.404","description":"invalid or missing parameter","parameterErrors":[{"name":"entityId","value":"8ac7a4c76c846a39016c8524be8b0249","message":"is not an allowed parameter"}]},"buildNumber":"0b662de043e6bf56c3a1e69d19d6da7e75f93eab@2020-02-04 14:10:09 +0000","timestamp":"2020-02-06 14:48:46+0000","ndc":"8ac7a4c76c846a39016c8524be8b0249_98ebc7e57f1d49a3b8ed4962a81eaa16"}

		Example success:  {"id":"8ac7a4a170190f6b01701afffaec0da4","paymentType":"DB","paymentBrand":"VISA","amount":"6300.00","currency":"ZAR","descriptor":"ResRequest 3DS 4032.3279.9323","result":{"code":"000.100.110","description":"Request successfully processed in 'Merchant in Integrator Test Mode'"},"card":{"bin":"411111","binCountry":"US","last4Digits":"1111","holder":"J Doe","expiryMonth":"10","expiryYear":"2020"},"customer":{"ip":"165.165.129.3","ipCountry":"ZA"},"threeDSecure":{"eci":"05","verificationId":"AAACAgSRBklmQCFgMpEGAAAAAAA=","xid":"CAACCVVUlwCXUyhQNlSXAAAAAAA=","version":"","dsTransactionId":"","acsTransactionId":"","paRes":"pares"},"customParameters":{"SHOPPER_EndToEndIdentity":"54377c5df9b78392c27cb6c9980d4247d85633ec63e6035aace587968e9b5dfa","CTPE_DESCRIPTOR_TEMPLATE":"${INVOICE_ID} ${CHANNEL_NAME} ${SHORT_ID}"},"risk":{"score":"100"},"buildNumber":"0b662de043e6bf56c3a1e69d19d6da7e75f93eab@2020-02-04 14:10:09 +0000","timestamp":"2020-02-06 14:55:58+0000","ndc":"4AC9D6B6C9AE88CEA9063950FF3F7ED8.uat01-vm-tx03"}
	*/

	return array(
		'id'=>$id,
		'status'=>DB_RV_PAYMENT_GATEWAY_SUCCESS,
		'amount'=>$amount,
		'message'=>$message,
		'log'=>$log
	);
}
