<?php

require_once(__DIR__ . "/../../db.rv_payment_gateway.php");
require_once(__DIR__ . "/../../db.pg_acc_obj_data.php");

function pesapalProcessReply($pg_account) {
	$id = $_SERVER['argv'][1];
	$reference = $_SERVER['argv'][2];

	$key = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Pesapal_Key");
	$secret = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Pesapal_Secret");

	// Uncomment for demo mode
	// Phone number to use: 701100100
	//$pg_account['pg_type_api_url'] = "https://demo.pesapal.com/api/";

	$token = $params = NULL;
	$consumer = new OAuthConsumer($key, $secret);
	$signature_method = new OAuthSignatureMethod_HMAC_SHA1();
	$request = OAuthRequest::from_consumer_and_token($consumer, $token, "GET", $pg_account['pg_type_api_url'] . "querypaymentstatus", $params);
	$request->set_parameter("pesapal_merchant_reference", $reference);
	$request->set_parameter("pesapal_transaction_tracking_id",$id);
	$request->sign_request($signature_method, $consumer, $token);
 
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $request);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_HEADER, 1);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
	if(defined('CURL_PROXY_REQUIRED')) if (CURL_PROXY_REQUIRED == 'True')
	{
		$proxy_tunnel_flag = (defined('CURL_PROXY_TUNNEL_FLAG') && strtoupper(CURL_PROXY_TUNNEL_FLAG) == 'FALSE') ? false : true;
		curl_setopt ($ch, CURLOPT_HTTPPROXYTUNNEL, $proxy_tunnel_flag);
		curl_setopt ($ch, CURLOPT_PROXYTYPE, CURLPROXY_HTTP);
		curl_setopt ($ch, CURLOPT_PROXY, CURL_PROXY_SERVER_DETAILS);
	}

	$response = curl_exec($ch);
	$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
	curl_close ($ch);

	//transaction status
	$elements = preg_split("/=/",substr($response, $header_size));
	$raw_status = $elements[1];

	switch($raw_status) {
	case "COMPLETED":
		$status = DB_RV_PAYMENT_GATEWAY_SUCCESS;
		$message = "Payment successful";
		break;
	case "PENDING": // Waiting for confirmation - this should never happen for ResRequest usage
		$message = "Payment pending, please contact us to check if your payment went through";
		$status = DB_RV_PAYMENT_GATEWAY_ERROR;
		break;
	case "FAILED":  // Payment failed 
	case "INVALID": // Invalid paramgTeters - this should never happen
	default:
		$message = "Payment failed. You may try again or use one of the other options available below.";
		$status = DB_RV_PAYMENT_GATEWAY_ERROR;
		break;
	}

	return array(
		'id'=>$id,
		'status'=>$status,
		'amount'=>$pg_account['amount'],
		'message'=>$message,
		'log'=>"Id: $id\nReference: $reference\nStatus: $raw_status"
	);
}

function getCurrencySymbol($currencyId) {
	return $GLOBALS['lDB']->get("
		SELECT
			rf_currency_symbol
		FROM
			rf_currency
		WHERE
			rf_currency_ix = '" . $currencyId . "'
	",4);
}