<?php

require_once(__DIR__ . "/../../payment_gateway/pesapal/oauth.php");
require_once(__DIR__ . "/../../payment_gateway/pesapal/pesapal_api.func.php");

$xml = join("",file(__DIR__ . "/../../payment_gateway/pesapal/pesapal.xml"));
$html =join("",file(__DIR__ . "/../../payment_gateway/pesapal/pesapal.html")); 

$key = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Pesapal_Key");
$secret = db_pg_acc_obj_data_get_by_name($pg_account['pg_account_ix'],"Pesapal_Secret");

$return_url = $GLOBALS['http']."$_SERVER[SERVER_NAME]/payment_gateway/pesapal/redirect.php";

$items = [
	'amount'=>$pg_account['amount'],
	'description'=>sanitise("Reservation with " . $GLOBALS['principal_name']),
	'type'=>"MERCHANT",
	'reference'=>sanitise($pg_account['reference']),
	'first_name'=>"",
	'last_name'=>"",
	'email'=>"support@resrequest.com",
	'phone'=>"",
	'currency'=>getCurrencySymbol($pg_account['rf_currency_id'])
];

function sanitise($text) {
	return trim(preg_replace('/ +/', ' ', preg_replace('/[^A-Za-z0-9 ]/', ' ', urldecode(html_entity_decode(strip_tags($text))))));
}

/*
$items = array_map(function($value) {
	$value = htmlentities($value,ENT_COMPAT | ENT_XML1);
},$items);
*/

// Uncomment for demo mode
// Phone number to use: 701100100
//$pg_account['pg_type_api_url'] = "https://demo.pesapal.com/api/";

$token = $params = null;
$signature_method = new OAuthSignatureMethod_HMAC_SHA1();
$consumer = new OAuthConsumer($key, $secret);
$action = OAuthRequest::from_consumer_and_token($consumer, $token, "GET", $pg_account['pg_type_api_url'] . "PostPesapalDirectOrderV4", $params);
$action->set_parameter("oauth_callback", $return_url);
$action->set_parameter("pesapal_request_data", htmlentities(showpage($items,$xml)));
$action->sign_request($signature_method, $consumer, $token);

$pg_account['form'] = showpage([
	'form_id'=>"pesapal_payment_form",
	'action'=>$action
],$html);
$pg_account['submit'] = "pesapal_payment_submit();";
$pg_account['process'] = "pesapalProcessReply";

