<?php

use MaglLegacyApplication\Application\MaglLegacy;

$application = MaglLegacy::getInstance()->getApplication();
$serviceManager = $application->getServiceManager();

// -====================================================================-
//  Uncomment the line below and the other two at the end of the file to
//  enable timing functionality. Function addTime() may then be used to
//  add additional timing points.
// -====================================================================-
//require_once(__DIR__ . "/functions.timing.php");
//addTime("Start (reservation.php)");
$GLOBALS['tagList'] = array();

// -===========-
//  Start TIMER
// -===========-
$stimer = explode( ' ', microtime() );
$stimer = $stimer[1] + $stimer[0];

// -================================-
//  Prevent caching of dynamic pages
// -================================-
$today = gmdate("D, d M Y H:i:s") . " GMT";        // Current date and time in RFC 1123 date format
header('Expires: -1');                 // Immediate expiry
header('Last-Modified: ' . $today);          // Must be current timestamp for IE dialup users
header('Pragma: no-cache');               // HTTP/1.0 header
header('Cache-Control: no-cache, no-store, must-revalidate');  // HTTP/1.1 header (see RFC 2616)
header("Cache-Control: post-check=0, pre-check=0", false);  // Neither post-check nor pre-check exist in the RFC
                        // (Specific to IE5+, may default to 0?) - db

// -======================================-
//  Require Critical Classes and Functions
// -======================================-
//
require_once(__DIR__ . '/class.form.php');              // Form Generation Class # used on every php page
require_once(__DIR__ . '/class.mysqldb.php');           // MySQL DB Class  # obvious
require_once(__DIR__ . '/class.mysqlfield.php');           // MySQL DB Fields (column) Class
                        // allows automatic db interaction for the forms
require_once(__DIR__ . '/class.mysqltable.php');           // MySQL Table Class
                        // allows automatic db interaction for the forms
require_once(__DIR__ . '/functions.template.php');
require_once(__DIR__ . '/functions.cache.php');
require_once(__DIR__ . '/functions.system.php');
require_once(__DIR__ . '/functions.php');
require_once(__DIR__ . '/functions.reservation.php');
require_once(__DIR__ . '/inc.setup.php');               // Database Connection, customised setup and config file
require_once(__DIR__ . '/ac_logon.php');             // Access Control Results
require_once(__DIR__ . '/inc.globalarrays.php');           // Globally required arrays (e.g. array of all properties)
require_once(__DIR__ . '/inc.debug.php');               // Debug class to send debug messages to popup window

// -==========================-
//  Error Handling
// -==========================-
require_once(__DIR__ . '/functions.error.php');               // Functions for intercepting and handling php errors

set_error_handler("errorHandler");
register_shutdown_function("fatalErrorHandler");

$enterpriseSetup = $application->getServiceManager()->get('Resrequest\Setup\Service\Enterprise');
$authenticateService = $application->getServiceManager()->get('Resrequest\Authentication\Service\Authenticate');

global $job, $sc_group_id;
$job = isset($_SERVER['argv'][0])?$_SERVER['argv'][0]:"";

// Disallowed environment
if (
	!$authenticateService->canAccessEnvironment($sc_group_id) 
	&& $job != 4000 
	&& !empty($_SESSION['loggedIn'])
	&& $_SESSION['loggedIn'] === true 
	&& !empty($_COOKIE['rrq_token'])
) {
	$userDetails = $authenticateService->getUserById($_SESSION['userid']);
	$userName = $userDetails['pr_user_name'];
	$authenticateService->logout($userName);
	redirectTo("/reservation.php?4000+" . $sc_group_id);
	die();
}

// Inactive environment
if (
	!isEnvironmentActive()
	&& $job != 4000 
	&& !empty($_SESSION['loggedIn'])
	&& $_SESSION['loggedIn'] === true 
	&& !empty($_COOKIE['rrq_token'])
) {
	$userDetails = $authenticateService->getUserById($_SESSION['userid']);
	$userName = $userDetails['pr_user_name'];
	$authenticateService->logout($userName);
	redirectTo("/reservation.php?4000+" . $sc_group_id . "+inactive");
	die();
}

//  If the users did a 'back' or 'forward' request, process it
$direction = "";
if (array_key_exists("goforward",$_POST) && $_POST['goforward'] == "true") {
	$direction = "forward";
} elseif (array_key_exists('goback',$_POST) && $_POST['goback'] == "true") {
	$direction = "back";
}
historyNavigate($direction);

global $isPopup;
$isPopup = true;
$GLOBALS['bypassAddCheck'] = false;

// -=======================================-
//  Close the Session during job processing
// -=======================================-
session_write_close();

if ($job == "") {
   $job = $defaultJob;
}

global $domain, $userid;

# Same thing, if we don't have an additional argument supplied, we populate it with the last specified record
$record = "";
$record2 = "";
if (sizeof($_SERVER['argv']) > 1 && $_SERVER['argv'][1] != "") {
   $record = $_SERVER['argv'][1];
}
if (sizeof($_SERVER['argv']) > 2) {
   $record2 = $_SERVER['argv'][2];
}
$GLOBALS['record'] = $record;
// Get some default values
// =======================
# In order for us to display relevant information to and about the user we gather intelligence from db first
$username = $lDB->get("select pr_user_name from pr_user where pr_user_id = '$userid'",4);
$GLOBALS['username'] = $username;
$securitygroup = (integer) $sc_group_id;
$ceilingnum = (integer) $sc_grp_avail_limit;
if (gettype($securitygroup) != "integer") { $securitygroup = (integer) "0"; }
if (gettype($ceilingnum) != "integer") { $ceilingnum = (integer) "0"; }

# Get Contact (user) details
$sql = "select pr_name_first, pr_name_last, pr_email from pr_persona where pr_persona_ix = '$userid'";
$temp3 = $lDB->get($sql,1);
$firstname = $temp3['pr_name_first'];
$GLOBALS['firstname'] = $firstname;
$lastnameA = $temp3['pr_name_last'];
$GLOBALS['lastname'] = $lastnameA;
$email = $temp3['pr_email'];

$faxnumber = $lDB->get("SELECT pr_phone_number FROM pr_phone
            WHERE pr_persona_id = '$userid' AND rf_phone_type_id = 'RS1'",4);
$defaultnumber = $lDB->get("SELECT pr_phone_number FROM pr_phone
            WHERE pr_persona_id = '$userid' AND pr_default_yn = '1'",4);

#####################################################
# Get contact (user) address details
#####################################################
$userDetails = array();
$userDetails = getAddress($userid);

$pr_corr_addr_line1 = $userDetails['pr_corr_addr_line1'];
$pr_corr_addr_line2 = $userDetails['pr_corr_addr_line2'];
$pr_corr_addr_line3 = $userDetails['pr_corr_addr_line3'];
$pr_email = $userDetails['pr_email'];
$pr_corr_city = $userDetails['pr_corr_city'];
$rf_country_name = $userDetails['rf_country_name'];
$pr_corr_post_code = $userDetails['pr_corr_post_code'];
#####################################################

// If you are a primary server environment
if ($rf_db_env_type_ind == "2")
{
   // Use the latest successful transfer time initiated by the Reservations Office
   $sql="SELECT
            tc_trf_time_close
         FROM
            tc_transfer
         WHERE
            tc_transfer_db = '$dbcode'
         AND
            sc_transfer_id IN ('52','1033','1054')
         ORDER BY
            tc_trf_time_close DESC
         LIMIT
            1";
   $lastupdate = $lDB->get($sql,4);

   // If you (are the webserver and the master), or  (you sync via replication) use NOW();
   if ($data_synch_mthd == "2" || ($dbcode[0] == "W" && isMasterDB()))
   {
      $lastupdate = date("Y-m-d H:i:s");
   }
}
else
{
   // Use the latest successful transfer time initiated by your property
   $sql="SELECT
            tc_trf_time_close
         FROM
            tc_transfer
         WHERE
            tc_transfer_db = '".$dbcode."'
         AND
            sc_transfer_id IN ('52','1033','1054')
         ORDER BY
            tc_trf_time_close DESC
         LIMIT
            1";
   $lastupdate =$lDB->get($sql,4);
}
if(empty($lastupdate)) {
	$lastupdate = "0000-00-00 00:00:00";
}

$GLOBALS['lastupdate'] = $lastupdate;
$GLOBALS['dbcode'] = $dbcode;

// This class *must* be included before the session is opened!
require_once(__DIR__ . '/PDF/pdf.php');

// Get the last updated time in a seperate variable
$dateTime = explode(" ",$lastupdate);
$date = date("Y-m-d");
$time = date("H:i:s");

# DEBUG - Some of this data is alread retrieved in inc.censys.php
#         This should be cleaned up and not duplicated.

# Get Reservations Office ID
$sql = "select rf_res_office_id from rf_default where rf_default_id = 1";
$temp = $lDB->get($sql,1);
$rf_res_office_id = $temp[0];
// Get email address of reservations office
$sql = "SELECT
      /*0*/ pr_email,
      /*1*/ pr_corr_addr_line1,
      /*2*/ pr_corr_addr_line2,
      /*3*/ pr_corr_addr_line3,
      /*4*/ pr_corr_city,
      /*5*/ pr_corr_post_code
   FROM
      pr_persona
   WHERE
      pr_persona_ix = '$rf_res_office_id'";
$temp2 = $lDB->get($sql,1);
$principal_email = $temp2[0];
$principal_addr1 = $temp2[1];
$principal_addr2 = $temp2[2];
$principal_addr3 = $temp2[3];
$principal_city = $temp2[4];
$principal_postcode = $temp2[5];
// Get phone numbers
$sql = "select pr_phone_number from pr_phone where pr_persona_id = '$rf_res_office_id' AND pr_default_yn = '1'";
$temp2 = $lDB->get($sql,1);
$principal_phone = $temp2[0];
$sql = "select pr_phone_number from pr_phone where pr_persona_id = '$rf_res_office_id' AND rf_phone_type_id = 'RS1'";
$temp2 = $lDB->get($sql,1);
$principal_fax = $temp2[0];

$temp = array();

#Check if we must filter occupancy calendar results to single agent
$GLOBALS['temp']['isPublic'] = "0";
if ($GLOBALS['pubGroupID'] == $securitygroup) {
   $GLOBALS['temp']['isPublic'] = "1";
}
$GLOBALS['temp']['AgnLink'] = "0";
if ($GLOBALS['pr_agent_link'] != "0") {
   $GLOBALS['temp']['AgnLink'] = "1";
}
$GLOBALS['temp']['BizLink'] = "0";
if ($GLOBALS['pr_business_link'] != "0") {
   $GLOBALS['temp']['BizLink'] = "1";
}
if($GLOBALS['temp']['isPublic'] == "0" && $GLOBALS['temp']['BizLink'] == "0" && $GLOBALS['temp']['AgnLink'] == "1"){
   $filterOccCalByAgent = "1";
} else {
   $filterOccCalByAgent = "0";
}

# Now we setup this global 'temp' array which will be parsed later and populate the page's final output string
$temp['SecurityGroup'] = "var SecurityGroup = \"".rawurlencode($securitygroup)."\";\n";
$temp['CeilingNum'] = "var CeilingNum = \"".rawurlencode($ceilingnum)."\";\n";
$temp['FirstName'] = "var FirstName = \"".rawurlencode($firstname)."\";\n";
$temp['firstN'] = $firstname;
$temp['LastName'] = "var LastName = \"".rawurlencode($lastnameA)."\";\n";
$temp['lastN'] = $lastnameA;
$temp['UserName'] = "var UserName = \"".rawurlencode($username)."\";\n";
$temp['username'] = $username;
$lastupdateArray = explode(" ",$lastupdate);
$temp['LastUpdate'] = "var LastUpdate = \"".chng_date($lastupdateArray[0],"-")." ".$dateTime[1]."\";\n";
$temp['LastUpdateDash'] = "var LastUpdateDash = \"".$lastupdate."\";\n";
$temp['genDateVal'] = "var genDateVal = \"".chng_date($date,"-")." ".$time."\";\n";
$temp['PrincipalID'] = "var PrincipalID = \"".$principal_id."\";\n";
$temp['PrincipalName1'] = "var PrincipalName = \"".rawurlencode($principal_name)."\";\n";
$temp['PrincipalEmail'] = "var PrincipalEmail = \"".rawurlencode($principal_email)."\";\n";
$temp['PrincipalPhone'] = "var PrincipalPhone = \"".rawurlencode($principal_phone)."\";\n";
$temp['PrincipalAddr1'] = "var PrincipalAddr1 = \"".rawurlencode($principal_addr1)."\";\n";
$temp['PrincipalAddr2'] = "var PrincipalAddr2 = \"".rawurlencode($principal_addr2)."\";\n";
$temp['PrincipalAddr3'] = "var PrincipalAddr3 = \"".rawurlencode($principal_addr3)."\";\n";
$temp['PrincipalCity'] = "var PrincipalCity = \"".rawurlencode($principal_city)."\";\n";
$temp['PrincipalPostcode'] = "var PrincipalPostcode = \"".rawurlencode($principal_postcode)."\";\n";
$temp['PrincipalFax'] = "var PrincipalFax = \"".rawurlencode($principal_fax)."\";\n";
$temp['CensysEmail'] = "var CensysEmail = \"".rawurlencode($censys_email)."\";\n";
$temp['Server'] = "var Server = \"".$GLOBALS['http'].$server."\";\n";
$temp['Domain'] = "var Domain = \"".$domain."\";\n";
$temp['Email'] = "var Email = \"".rawurlencode($pr_email)."\";\n";
$temp['Fax'] = "var Fax = \"".rawurlencode($faxnumber)."\";\n";
$temp['PhoneNumber'] = "var PhoneNumber = \"".rawurlencode($defaultnumber)."\";\n";
$temp['pr_corr_addr_line1'] = "var Addr1 = \"".rawurlencode($pr_corr_addr_line1)."\";\n";
$temp['pr_corr_addr_line2'] = "var Addr2 = \"".rawurlencode($pr_corr_addr_line2)."\";\n";
$temp['pr_corr_addr_line3'] = "var Addr2 = \"".rawurlencode($pr_corr_addr_line3)."\";\n";
$temp['pr_corr_city'] = "var City = \"".rawurlencode($pr_corr_city)."\";\n";
$temp['rf_country_name'] = "var Country = \"".rawurlencode($rf_country_name)."\";\n";
$temp['pr_corr_post_code'] = "var PostCode = \"".rawurlencode($pr_corr_post_code)."\";\n";
$temp['cn_prn_custom_yn'] = "var customYn = \"".$custom_yn."\";\n";
$temp['AgentFilterID'] = "var AgentFilterID = \"".$GLOBALS['pr_agent_link']."\";\n";
$temp['filterOccCalByAgent'] = "var filterOccCalByAgent = \"".$filterOccCalByAgent."\";\n";

if($system != "demo") {
	if(file_exists("$GLOBALS[images_dir_on_disk]/$principal_id/top_clientlogo.gif")) {
		$temp['logoURL'] = $GLOBALS['http'].$GLOBALS['images_dir']."/".$principal_id."/top_clientlogo.gif";
		$temp['LogoSrc'] = "var LogoSrc = \"".$GLOBALS['http'].$GLOBALS['images_dir']."/".$principal_id."/top_clientlogo.gif\";\n";
	} else {
		$temp['logoURL'] = "//resource/Resrequest/Application/public/img/1x1.gif";
		$temp['LogoSrc'] = "var LogoSrc = \"/resource/Resrequest/Application/public/img/1x1.gif\";\n";
	}
} else {
	$temp['logoURL'] = $GLOBALS['http'].$GLOBALS['images_dir']."/demo/top_clientlogo.gif";
	$temp['LogoSrc'] = "var LogoSrc = \"".$GLOBALS['http'].$GLOBALS['images_dir']."/demo/top_clientlogo.gif\";\n";
}
$temp['systemVersionRaw'] = $systemVersion;
$temp['systemVersion'] = "var systemVersion = \"$systemVersion\";\n";
$temp['dbVersion'] = "var dbVersion = \"".$GLOBALS['dbVersion']."\";\n";
$temp['System'] = "var System = \"$system\";\n";

$temp['archiveServer'] = $client.".".$server;

if($archive === false) {
	$temp['logOffLabel'] = "Logoff";
	$temp['logOffAction'] = "logOff()";
} else {
	$temp['logOffLabel'] = "Close";
	$temp['logOffAction'] = "window.close()";
}

$chartContainerService = $serviceManager->get("Resrequest\Application\Chart\ChartContainer");
// Needs to be 1 or 0 because it gets replaced as a string.
$dashboardsAllowed = $chartContainerService->hasDashboardsAccess() ? 1 : 0;

// Access Control Override (setting this in each form will take precedence over this default)
$temp['pgJobs'] = "<input type=\"hidden\" name=\"pgJobNew\" value=\"1\">\n";
$temp['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobOpen\" value=\"1\">\n";
$temp['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobEdit\" value=\"1\">\n";
$temp['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobDelete\" value=\"1\">\n";
$temp['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobSave\" value=\"1\">\n";
$temp['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobSaveclose\" value=\"1\">\n";
// Instantiate Required Form Objects (datasets)
// ============================================

/* Form objects are the corner stone of this engine.
 * They allow nested areas where we can write and
 * execute custom script logic without breaking
 * the system.  However, we do not access 'pages'
 * by their formid's but rather by jobid, which
 * is explained a little more lower down.
 */

// Get some output
// ===============

/* Now before we skip into the output bit, something
 * more important is happening right below this bit.
 * The eplay function is what ties the whole engine together,
 * so quickly skip down to it
 */

 /* *light elevator music* */

/* Ok now that you're back, this piece of code allows
 * us to include the top toolbar and menu from the html page.
 * It reads the file into memory, places it inside the
 * global 'temp' array which will be parsed just now.
 * Checkout the showpage function in inc.function.php for more.
 */

# Prepare string to echo in place of top.php
$topfile = __DIR__ . "/../../../public/html/top_contents.htm";
if ($userid == $anonUserID) {
	require_once(__DIR__ . '/functions.imageset.php');
	if (isV3Imageset($principal_id)) {
		// Light (as opposed to heavy) public top_contents, without HTML, only necessary JS, if it's a V3+ imageset
		$topfile = __DIR__ . "/../../../public/html/public_top_contents_v3_imageset.htm";
	} else {
		$topfile = __DIR__ . "/../../../public/html/public_top_contents.htm";
	}
}

# generate random login seed
$alpha = array(
   "a","A","b","B","c","C","d","D","e","E","f","F","g","G","h","H","i","I","j","J","k","K","l","L","m","M",
   "n","N","o","O","p","P","q","Q","r","R","s","S","t","T","u","U","v","V","w","W","x","X","y","Y","z","Z",
   "0","1","2","3","4","5","6","7","8","9"
);
$sql = "SELECT pr_web_addr FROM pr_persona WHERE pr_persona_ix = '$PrincID'";
$temp3 = $GLOBALS['lDB']->get($sql,1);
$sysUrl = strpos($temp3[0], 'http') === false ? "http://".$temp3[0] : $temp3[0];
$chpass = "";
if (!isMasterDB() && $GLOBALS['tempCPC'] == "1") {
   $chpass = " style=\"display:none\"";
}

$hideReqRec = "";
if (!checkJob(650) || $userStatusId < "2") {
   $hideReqRec = "visibility:hidden;";
}

$reqCount = $lDB->get("
	SELECT
		COUNT(DISTINCT(rv_reservation.rv_reservation_ix))
	FROM
		rv_reservation
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
	WHERE
		(
			rv_reservation.rv_consultant_id IS NULL
			OR rv_reservation.rv_consultant_id IN ('','0')
		)
		AND rv_reservation.rf_reservation_status_id != '25'
		AND rv_reservation.rf_reservation_status_id != '15'
		AND (
			rv_reservation.rf_reservation_status_id < '40'
			OR rv_reservation.rf_reservation_status_id = '95'
		)
		AND rv_reservation.rf_reservation_status_id IN ('0', '20', '30', '90')
		AND rv_reservation_item.rv_reservation_item_ix IS NOT NULL
",4);

$waitlistCount = $lDB->get("
	SELECT
		COUNT(DISTINCT(rv_reservation.rv_reservation_ix))
	FROM 
		rv_reservation
		INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
	WHERE
		rv_reservation.rf_reservation_status_id = '10'
",4);

$totalModReqCount = $lDB->get("
    SELECT COUNT(*)
    FROM rv_reservation
    WHERE rv_mod_request_yn = 1
", 4);

$totalModCount = $lDB->get("
    SELECT COUNT(*)
    FROM rv_reservation
    WHERE rv_mod_yn = 1
", 4);

$modReqCount = $totalModReqCount + $totalModCount;

require_once "db.notifications.php";
$notifications = db_notifications_get_count();
$notificationCount = $notifications['count'];
$notificationPopupAllowed = $notifications['showPopup'];
if (
    ( isset($_SESSION['lastNotificationPopup']) && $_SESSION['lastNotificationPopup'] == $notifications['sessionId'] ) ||
    !$notifications['showPopup']
) {
    // The notification popup has already been shown for these notifications
    // OR user has turned off the popup
    $notificationPopupShow = false;
} else {
    // Change in notifications, the notification popup must be shown
    $notificationPopupShow = true;
    $_SESSION['lastNotificationPopup'] = $notifications['sessionId'];
}

if(array_key_exists("lastResArray",$_SESSION) && is_array($_SESSION['lastResArray'])) {
	$lastResIdArray = $_SESSION['lastResArray'];
} else {
	$lastResIdArray = array();
}
$lastResJobArray = array();
$lastResNameArray = array();
foreach($lastResIdArray as $resKey=>$resId) {
	if(canEditReservation($resId)) {
		$lastResJobArray[$resKey] = "2";
	} else {
		$lastResJobArray[$resKey] = "0";
	}
	$resName = $lDB->get("SELECT rv_res_name FROM rv_reservation WHERE rv_reservation_ix = '$resId'",4);
	$lastResNameArray[$resKey] = t_encodeOverlib($resName);
}
$lastResIdArrayJs = "";
$lastResJobArrayJs = "";
$lastResNameArrayJs = "";
if(sizeof($lastResIdArray) > 0) {
	$lastResIdArrayJs = "'" . join("','",$lastResIdArray) . "'";
	$lastResJobArrayJs = "'" . join("','",$lastResJobArray) . "'";
	$lastResNameArrayJs = "'" . join("','",$lastResNameArray) . "'";
}

if(array_key_exists("lastContactArray",$_SESSION) && is_array($_SESSION['lastContactArray'])) {
	$lastContactIdArray = $_SESSION['lastContactArray'];
} else {
	$lastContactIdArray = array();
}
$lastContactJobArray = array();
$lastContactNameArray = array();
foreach($lastContactIdArray as $contactKey=>$contactId) {
	if(canEditContact($contactId)) {
		$lastContactJobArray[$contactKey] = "45";	// edit mode
	} else {
		$lastContactJobArray[$contactKey] = "47";	// view mode
	}
	$contactName = trim($lDB->get("SELECT CONCAT(pr_name_first, ' ', pr_name_last) FROM pr_persona WHERE pr_persona_ix = '$contactId'",4));
	if(strlen($contactName) > 24) {
		$contactName = substr($contactName,0,24) . "...";
	}
	$lastContactNameArray[$contactKey] = t_encodeOverlib($contactName);
}
$lastContactIdArrayJs = "";
$lastContactJobArrayJs = "";
$lastContactNameArrayJs = "";
if(sizeof($lastContactIdArray) > 0) {
	$lastContactIdArrayJs = "'" . join("','",$lastContactIdArray) . "'";
	$lastContactJobArrayJs = "'" . join("','",$lastContactJobArray) . "'";
	$lastContactNameArrayJs = "'" . join("','",$lastContactNameArray) . "'";
}


if(isset($GLOBALS['jobLevelArray'][248]) && $GLOBALS['jobLevelArray'][248] > 0) {
	$allowQuickSearch = "1";
} else {
	$allowQuickSearch = "0";
}

$autoCheck = $GLOBALS['lDB']->get("SELECT rf_db_trf_auto_yn FROM rf_database WHERE rf_db_code = '$GLOBALS[dbcode]'",4);
$refreshTransfer = "";
if($autoCheck == "2") {
	$refreshTransfer = "refreshTransfer();";
}

$reportURL = isset($_SESSION['reportURL']) ? $_SESSION['reportURL'] : "";
$reportProfile = isset($_SESSION['reportProfile']) ? $_SESSION['reportProfile'] : "";

$TOP_CONTENTS = str_replace("!menu_system!",$menu_system,Join("",File($topfile)));
$TOP_CONTENTS = str_replace("!sysUrl!",$sysUrl,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!chpass!",$chpass,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!reqCount!",$reqCount,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!waitlistCount!",$waitlistCount,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!modReqCount!",$modReqCount,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!notificationCount!",$notificationCount,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!notificationPopupShow!",$notificationPopupShow,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!notificationPopupAllowed!",$notificationPopupAllowed,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!hideReqRec!",$hideReqRec,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!reportJob!",substr($reportURL,16,strpos($reportURL,"+")-16),$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!reportURL!",$reportURL,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!reportProfile!",$reportProfile,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!lastResJobArray!",$lastResJobArrayJs,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!lastResIdArray!",$lastResIdArrayJs,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!lastResNameArray!",$lastResNameArrayJs,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!lastContactJobArray!",$lastContactJobArrayJs,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!lastContactIdArray!",$lastContactIdArrayJs,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!lastContactNameArray!",$lastContactNameArrayJs,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!censysEmail!",$censys_email,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!allowQuickSearch!",$allowQuickSearch,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!refreshTransfer!",$refreshTransfer,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!userName!",$username,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!princName!",$principal_name,$TOP_CONTENTS);
$TOP_CONTENTS = str_replace("!dashboardsAllowed!",$dashboardsAllowed,$TOP_CONTENTS);
$globalCSS = "
	<link rel=\"stylesheet\" href=\"".$GLOBALS['http'].$GLOBALS['images_dir']."/$principal_id/styles/global.css\" type=\"text/css\" />
";

require_once(__DIR__ . '/functions.imageset.php');
if (isV3Imageset($principal_id)) {
	$globalCSS = "";		// Do not include imageset CSS if it's a V3+ imageset
	$TOP_CONTENTS = str_replace("!v3Imageset!", 'true', $TOP_CONTENTS);
} else {
	$TOP_CONTENTS = str_replace("!v3Imageset!", 'false', $TOP_CONTENTS);
}

$TOP_CONTENTS = str_replace("!globalCSS!",$globalCSS,$TOP_CONTENTS);

// Force password change if needed
if($job != 527 && $job != 528 && isset($_SESSION['require_password_change']) && $_SESSION['require_password_change'] !== false) {
	header("Location: reservation.php?527+1");
	die();
}

$GLOBALS['temp']['dbstatus'] = "slave";
if (isMasterDB("1")) {
   $GLOBALS['temp']['dbstatus'] = "master";
}
$GLOBALS['temp']['dbcode'] = $dbcode;
$GLOBALS['temp']['timezone'] = date("e");
$GLOBALS['temp']['currenttime'] = date("H:i:s");

$timezone_offset = date('P')[0].((substr(date("P"), 1, 2) * 60) + substr(date("P"), 5, 2));
$GLOBALS['temp']['timezone_offset'] = $timezone_offset;

$GLOBALS['temp']['top_contents_bottom_bar_style'] = "headerBottomBarNormal";
$GLOBALS['temp']['top_contents_logo_circle'] = "#c9252f";
$GLOBALS['temp']['top_contents_hide_on_archive'] = "";
$GLOBALS['temp']['top_contents_spacer_size'] = "5%";
$GLOBALS['temp']['archive_click'] = "";
$GLOBALS['temp']['archive_image'] = "/resource/Resrequest/Application/public/img/icon_archive_inactive.gif";
$GLOBALS['temp']['archive_class'] = "collapse";
$archiveMessage = "";
if($archive !== false) {
	$GLOBALS['temp']['top_contents_bottom_bar_style'] = "headerBottomBarArchive";
	$GLOBALS['temp']['top_contents_logo_circle'] = "#808080";
	$GLOBALS['temp']['top_contents_hide_on_archive'] = "collapse";
	$GLOBALS['temp']['top_contents_spacer_size'] = "15%";
	$GLOBALS['temp']['archive_image'] = "/resource/Resrequest/Application/public/img/icon_archive_used.gif";
	$GLOBALS['temp']['archive_class'] = "";
	$archiveMessage = "Already accessing an archive.";
} else {
	if($allowArchive) {
		$archiveCount = $lDB->get("SELECT COUNT(*) FROM rf_archive",4);
		$GLOBALS['temp']['archive_class'] = "";
		if($archiveCount > 0) {
			$GLOBALS['temp']['archive_image'] = "/resource/Resrequest/Application/public/img/icon_archive_active.gif";
			$GLOBALS['temp']['archive_click'] = "openPopup('reservation.php?1023',600,300);";
			$archiveMessage = "Click here to view archives.";
		} else {
			$archiveMessage = "No archives available.";
		}
	} else {
		$archiveMessage = "Access to archives denied.";
	}
}
if(!empty($archiveMessage)) {
	$GLOBALS['temp']['archive_mouseover'] = "overlib('".t_encodeOverlib($archiveMessage)."');";
} else {
	$GLOBALS['temp']['archive_mouseover'] = "";
}


if (!isMasterDB()) {
   // Access Control Override (setting this in each form will take precedence over this default)
   $temp['pgJobs'] = "<input type=\"hidden\" name=\"pgJobNew\" value=\"0\">\n";
   $temp['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobOpen\" value=\"0\">\n";
   $temp['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobEdit\" value=\"0\">\n";
   $temp['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobDelete\" value=\"0\">\n";
   $temp['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobSave\" value=\"0\">\n";
   $temp['pgJobs'] .= "<input type=\"hidden\" name=\"pgJobSaveclose\" value=\"0\">\n";
}
$GLOBALS['temp']['lastUpdate'] = "collapse printCollapse";
if(checkjob(126)){
	$GLOBALS['temp']['lastUpdate'] = "";
}
$temp['TOP_CONTENTS'] = showpage($temp,$TOP_CONTENTS);
$GLOBALS['tagList']['TOP_CONTENTS'] = $temp['TOP_CONTENTS'];

# This actually executes the eplay function below, but also runs it through the showpage function
$HTML = showpage(ac_control($lDB,$job));

# Here we just add the critical .js file to each page dynamically instead of going about editing every .htm file
$string = "<script src=\"/resource/Resrequest/Application/public/include/js/system.js\" language=\"javascript\"></script>";
$add = $string."<script type=\"text/javascript\">\n!SecurityGroup!!CeilingNum!!FirstName!!LastName!!UserName!!LastUpdate!!LastUpdateDash!!genDateVal!!Server!!Domain!!PrincipalID!!PrincipalName1!!PrincipalEmail!!PrincipalPhone!!PrincipalFax!!PrincipalAddr1!!PrincipalAddr2!!PrincipalAddr3!!PrincipalCity!!PrincipalPostcode!!CensysEmail!!Email!!Fax!!PhoneNumber!!pr_corr_addr_line1!!pr_corr_addr_line2!!pr_corr_addr_line3!!pr_corr_city!!rf_country_name!!pr_corr_post_code!!filterOccCalByAgent!!cn_prn_custom_yn!!AgentFilterID!!LogoSrc!!systemVersion!!dbVersion!!System!\nvar systemActive = true;\n</script>\n";
$add .= "<link rel=\"shortcut icon\" href=\"/img/favicon.png\" type=\"image/vnd.microsoft.icon\">\n<link rel=\"icon\" href=\"/img/favicon.png\" type=\"image/vnd.microsoft.icon\">\n";
$HTML = str_replace($string,$add,$HTML);

# Here we add the standard events used by 'events.js' - note that the body tag must be lowercase and empty
$HTML = str_replace("<body>","<body onload=\"return windowOnLoad(event);\" onunload=\"return windowOnUnload(event);\" onclick=\"return windowOnClick(event);\" ondblclick=\"return windowOnDblClick(event);\" onmousedown=\"return windowOnMouseDown(event);\" onmouseup=\"return windowOnMouseUp(event);\" onmouseover=\"return windowOnMouseOver(event);\" onmousemove=\"return windowOnMouseMove(event);\" onmouseout=\"return windowOnMouseOut(event);\" onkeypress=\"return windowOnKeyPress(event);\" onkeydown=\"return windowOnKeyDown(event);\" onkeyup=\"return windowOnKeyUp(event);\" onresize=\"return windowOnResize(event);\" onhelp=\"return windowOnHelp(event);\" onscroll=\"return windowOnScroll(event);\">",$HTML);

# Google Analytics code
$analytics = getAnalytics();
if($analytics) {
	$HTML = applyAnalytics($HTML,$analytics);
}

# The Job ID
# All the forms involved (.php files)
# And the HTML files of the involved forms
$pageidstring = "<!-- Page Identifier Snippet\n";
$pageidstring .= "Job: ".sprintf("%4d",$job)."\n";
foreach ($cords as $corda) {
   $temp1 = explode(":",$corda);
   if (strpos($temp1[0],",") !== false) {
      $temp2 = explode(",",$temp1[0]);
      $action = $temp2[0];
      $mode = $temp2[1];
   } else {
      $action = $temp1[0];
      $mode = "0";
   }
   $formid = $temp1[1];
   $show = $temp1[2];
   $formthing = "form".$formid;
   $formhtml = basename($GLOBALS[$formthing]->HTML);
   $outputstring = "Form: ".sprintf("%3d",$formid)." | PHP: ".sprintf("%-16s","init.".$formthing.".php")." | HTML: ".$formhtml." \n";
   $pageidstring .= $outputstring;
}
$pageidstring .= "End Page Identifier Snippet -->\n";

# Put the html through the new template parser
if (sizeof($GLOBALS['tagList']) > 0) {
   $HTML = tpParse($GLOBALS['tagList'],$HTML);
}

# Now that we have a good "HTML" output, we need to push the global temp array through it and parse the last tags.
# When this is done we just echo the output, and the whole process is complete.
$temp = array_merge($temp, $GLOBALS['temp']);
$htmlOutput = str_replace("<html>","<html>\n$pageidstring",showpage($temp,$HTML,""));

# Uncomment to enable error handling tests
//errorHandlingTest(false,1); // Run a single non-fatal test
//errorHandlingTest(); // Run all non-fatal tests
//errorHandlingTest(true,4); // Run fatal error test with undefined function
//errorHandlingTest(true,5); // Run fatal error test with memory exhaustion
global $errors;

# Inject error message if any errors were intercepted
if (sizeof($errors) > 0) {
	$htmlOutput = errorHandlerShowBanner($htmlOutput);
}

//Added To Prevent .css and .js caching
$htmlOutput = appendSystemVersion($htmlOutput, $systemVersion);

echo $htmlOutput;

//  End TIMER
//  ---------
$etimer = explode( ' ', microtime() );
$etimer = $etimer[1] + $etimer[0];
if ($showScriptSpeed) {
	if ($showScriptSpeedLoc == "screen"){
		echo "<center>";
		printf( "Script timer: <b>%f</b> seconds.", ($etimer-$stimer) );
		echo '</center>';
	}else{
		echo "<!-- ";
		printf( "Script timer: <b>%f</b> seconds.", ($etimer-$stimer) );
		echo " -->";
	}
}
//  ---------

if (extension_loaded('newrelic')) { // To ensure that agent is available
    newrelic_end_transaction(); //stop recording any previous transaction, and push data to new relic daemon
}

// -=======================================-
//  Reopen the Session after job processing
// -=======================================-
session_restart();

historyTrim();

// ac_control - check security and launch eplay function accordingly
// =================================================================

function ac_control ($db,$job) {
	# Does the user have access to this job?
	if (!in_array($job,$GLOBALS['JobArray'])) {
		$job = "999";
	}

	# Is the licence valid?
	if($GLOBALS['checkLicence']) {
		checkLicence();
		if($GLOBALS['licenceInfo']['valid'] == false) {
			$job = "998";
		}
	}
	# For the whole system, set the global arg equal to the job (in case a new job has been assigned)
	$_SERVER['argv'][0] = $job;
	$GLOBALS['job'] = $job;
	return eplay($db,$job);
}

// eplay - setup and execute jobs
// ==============================

/* Ok! This is the function that ties it all together.  Basically it's the whole 'job' concept.
 * In order for us to access a 'page' we have to know quite a few things.  This is too much data
 * to pass via GET, so the 'jobid' is simply a translation layer that looks up the id and starts
 * off the process with pre-defined values.  This produces results like:
 * "Reservation details in edit mode, with a reservation item listing display" = Jobid 2.
 * This is done by specifying in series which forms will be used inside this 'page' and also in
 * what view mode they will be (List/Add/Edit/Display/Delete).  This view mode is passed onto the
 * form object which then produces output correspondingly, disabling inputs etc.
 */

function eplay ($db,$job) {
	global $cords;
	global $lDB;

	if($lDB->get("SELECT COUNT(sc_job_id) FROM sc_job WHERE sc_job_id = '$job'",4) != "1") {
		$job = "999";
	}

	# Get the coordinate codes from the database
	$sql = "SELECT sc_job_cords FROM sc_job WHERE sc_job_id = '$job'";
	$tempz = $lDB->get($sql,1);

	# For the whole system, set the global arg equal to the job (in c_ase a new job has been assigned)
	$_SERVER['argv'][0] = $job;
	$GLOBALS['job'] = $job;

	// include function libraries for this module
	$path = __DIR__;
	$path = str_replace("\\","/",$path);

	$dp = opendir($path);
	$funcList = $lDB->get("
		SELECT
			sc_function.sc_function_id
		FROM
			sc_fun_job
			INNER JOIN sc_function ON sc_function.sc_function_id = sc_fun_job.sc_function_id
		WHERE
			sc_fun_job.sc_job_id = '$job'
	",3);
	while(($fileName = readdir($dp)) !== false) {
		// Check that this filename starts right and ends in ".php";
		for ($z=0;$z<sizeof($funcList);$z++) {
			$modFuncName = "inc.func_".$funcList[$z]."_";
			$charLen = strlen($modFuncName);
			$key = substr($fileName,0,$charLen);
			if ($key == $modFuncName && substr($fileName,-4,4) == ".php") {
				require_once(__DIR__ . "/" . $fileName);
			}
		}
	}

	# Generate our coordinate array from the values returned
	$cords = array();
	if (strpos($tempz[0],'","') !== false) {
		$cordArray = explode('","',$tempz[0]);
		$mmax = sizeof($cordArray);
		for ($m=0;$m<$mmax;$m++) {
			array_push($cords,str_replace('"',"",$cordArray[$m]));
		}
	} else {
		array_push($cords,str_replace('"',"",$tempz[0]));
	}

	# Execute our coordinates!
	return blowfish($db,$cords);
}
//addTime("End (reservation.php)");
//outputTime();
