<?php
$GLOBALS['systemName'] = "";			// This is for debugging purposes
$GLOBALS['sessionTimeoutDefault'] = 1800;	// In seconds, 30 minutes
$GLOBALS['initialRetryOpen'] = 10;
$GLOBALS['dbHost'] = "";

require_once(__DIR__ . "/../../class.mysqldb.php");
require_once(__DIR__ . "/../../inc.ixfields.php");
require_once(__DIR__ . "/../../functions.php");
require_once(__DIR__ . "/../../functions.system.php");
require_once(__DIR__ . "/../../db.rv_phone.php");
require_once(__DIR__ . "/../../db.rv_extra.php");

$GLOBALS['debugEcho'] = true;
$GLOBALS['enableIXfields'] = "1";
$GLOBALS['incrementSequence'] = 1;    // Activate sequencing
$GLOBALS['trTables'] = array();
$GLOBALS['flagChngs'] = "0";
$GLOBALS['debug'] = "0";
$GLOBALS['isWebServer'] = isset($GLOBALS['isWebServer']) ? $GLOBALS['isWebServer'] : false;
$GLOBALS['dbUpgradeInProcess'] = isset($GLOBALS['dbUpgradeInProcess']) ? $GLOBALS['dbUpgradeInProcess'] : false;
$GLOBALS['userid'] = isset($GLOBALS['userid']) ? $GLOBALS['userid'] : "";

// Connect to the censys table an get the principal id
$cDB = new MySQLDB("censys","root","",$GLOBALS['dbHost']);
if($GLOBALS['systemName'] != "") {
	$principalWhere = "WHERE cn_prn_name_short = '$GLOBALS[systemName]'";
} else {
	$principalWhere = "WHERE cn_prn_name_short != 'demo' AND cn_prn_name_short != 'test'";
}

$principalId = $cDB->get("SELECT cn_principal_id FROM cn_principal $principalWhere",4);

// Get the DB id
$databaseId = $cDB->get("SELECT cn_prn_db_me_id FROM cn_principal $principalWhere",4);
if($databaseId == "0" || $databaseId == "") {
	$databaseId = $cDB->get("SELECT cn_sys_db_me_id FROM cn_system",4);
}


$lDB = new MySQLDB("cn_live_".str_pad($principalId,4,"0",STR_PAD_LEFT),"root","",$GLOBALS['dbHost']);

// Get the Database code
$dbInfo = $lDB->get("
	SELECT
		rf_db_code,
		rf_db_description,
		rf_db_pos_frequency,
		rf_db_pos_folder,
		rf_db_time_zone
	FROM
		rf_database
	WHERE
		rf_database_id = '$databaseId'
",1);
$GLOBALS['dbcode'] = $dbInfo['rf_db_code'];
$GLOBALS['sleepTime'] = $dbInfo['rf_db_pos_frequency'];	// Amount of time between transaction polling

$GLOBALS['POS_DIR'] = $dbInfo['rf_db_pos_folder'];					// Path to the POS transactions
if(empty($GLOBALS['POS_DIR'])) {
	die("ERROR: POS directory empty!");
}

if(substr($GLOBALS['POS_DIR'],-1,1) != "/" && substr($GLOBALS['POS_DIR'],-1,1) != "\\") {
	if(strpos($GLOBALS['POS_DIR'],"\\") !== false) {
		$GLOBALS['POS_DIR'] .= "\\";
	} else {
		$GLOBALS['POS_DIR'] .= "/";
	}
}

if(!is_dir($GLOBALS['POS_DIR'])) {
	die("ERROR: POS directory '$GLOBALS[POS_DIR]' not found!");
}

set_timezone($dbInfo['rf_db_time_zone']);

$GLOBALS['propertyList'] = $lDB->get("SELECT pr_business_id FROM rf_db_business WHERE rf_db_code = '$GLOBALS[dbcode]'",3);

$GLOBALS['isPropServer'] = false;
$rf_db_env_type_ind = $lDB->get("select rf_db_env_type_ind from rf_database where rf_db_code = '$GLOBALS[dbcode]'",4);

if ($rf_db_env_type_ind == "4") $GLOBALS['isPropServer'] = true;

$GLOBALS['POS_NAME'] = "Casio";

require_once(__DIR__ . '/../common/functions.pos.php');

require_once(__DIR__ . "/../../functions.system.php");

#$GLOBALS['POS_FILENAME'] = "c:/UKSVR/idc.txt";
#$GLOBALS['POS_FILENAME'] = "idc.txt";
#$GLOBALS['POS_FILENAME'] = "hotel.log";
$GLOBALS['POS_FILENAME'] = $GLOBALS['POS_DIR'] . "hotel.log";
$GLOBALS['POS_FILENAME_TEMP'] = $GLOBALS['POS_FILENAME'] . ".rtmp";
#$GLOBALS['ROOM_FILENAME'] = "roomgst.txt";
$GLOBALS['ROOM_FILENAME'] = $GLOBALS['POS_DIR'] . "ROOMGST.TXT";


/* IDC data format */
#$GLOBALS['dataFormat'] = array(
#	/* 00 -> 01 */ 'ecr'=>array(0,2),
#	/* 02 -> 03 */ 'type'=>array(2,2),
#	/* 04 -> 04 */ 'space'=>array(4,1),
#	/* 05 -> 06 */ 'subtype'=>array(5,2),
#	/* 07 -> 10 */ 'file'=>array(7,4),
#	/* 11 -> 18 */ 'record'=>array(11,8),
#	/* 19 -> 22 */ 'exchange_record'=>array(19,4),
#	/* 23 -> 32 */ 'exchange_rate'=>array(23,10),
#	/* 33 -> 42 */ 'entry'=>array(33,10),
#	/* 43 -> 52 */ 'amount'=>array(43,10),
#	/* 53 -> 62 */ 'change_amount'=>array(53,10),
#	/* 63 -> 64 */ 'finalise_type'=>array(63,2),
#	/* 65 -> 80 */ 'room'=>array(65,16),
#	/* 81 -> 82 */ 'guest'=>array(81,2)
#);

/* hotel.log format
 * ----------------
 *
 * Each array line specified the start position
 * followed by the length
 * optionally followed by the type if not int
 *
 */

$GLOBALS['dataFormat'] = array(
	/* 000 -> 015 */ 'room'=>array(0,16),
	/* 016 -> 017 */ 'guest'=>array(16,2),
	/* 018 -> 019 */ 'open_status'=>array(18,2),
	/* 020 -> 041 */ 'reserved_a'=>array(20,22),
	/* 042 -> 051 */ 'check_number'=>array(42,12),
	/* 052 -> 055 */ 'reserved_b'=>array(52,4),
	/* 056 -> 057 */ 'mode'=>array(56,2),
	/* 058 -> 061 */ 'clerk'=>array(58,4),
	/* 062 -> 067 */ 'ecr'=>array(62,6),
	/* 068 -> 073 */ 'transaction'=>array(68,6),
	/* 074 -> 079 */ 'date'=>array(74,6,"date"),
	/* 080 -> 083 */ 'time'=>array(80,4,"time"),
	/* 084 -> 123 */ 'reserved_c'=>array(84,40),
	/* 124 -> 133 */ 'customers'=>array(124,10),
	/* 134 -> 139 */ 'table'=>array(134,6),
	/* 140 -> 143 */ 'reserved_d'=>array(140,4),
	/* 144 -> 153 */ 'items'=>array(144,10,"quantity"),
	/* 154 -> 163 */ 'reserved_e'=>array(154,10),
	/* 164 -> 173 */ 'subtotal'=>array(164,10),
	/* 174 -> 183 */ 'subtotal_total'=>array(174,10),
	/* 184 -> 193 */ 'nett'=>array(184,10,"currency"),
	/* 194 -> 203 */ 'subtotal_md'=>array(194,10),
	/* 204 -> 213 */ 'gross'=>array(204,10,"currency"),
	/* 214 -> 233 */ 'reserved_f'=>array(214,20),
	/* 234 -> 243 */ 'taxable_amount_1'=>array(234,10),
	/* 244 -> 253 */ 'taxable_amount_2'=>array(244,10),
	/* 254 -> 263 */ 'taxable_amount_3'=>array(254,10),
	/* 264 -> 273 */ 'taxable_amount_4'=>array(264,10),
	/* 274 -> 283 */ 'reserved_g'=>array(274,10),
	/* 284 -> 293 */ 'tax_amount_1'=>array(284,10),
	/* 294 -> 303 */ 'tax_amount_2'=>array(294,10),
	/* 304 -> 313 */ 'tax_amount_3'=>array(304,10),
	/* 314 -> 323 */ 'tax_amount_4'=>array(314,10),
	/* 324 -> 333 */ 'category_0'=>array(324,10,"currency"),
	/* 334 -> 343 */ 'category_1'=>array(334,10,"currency"),
	/* 344 -> 353 */ 'category_2'=>array(344,10,"currency"),
	/* 354 -> 363 */ 'category_3'=>array(354,10,"currency"),
	/* 364 -> 373 */ 'category_4'=>array(364,10,"currency"),
	/* 374 -> 383 */ 'category_5'=>array(374,10,"currency"),
	/* 384 -> 393 */ 'category_6'=>array(384,10,"currency"),
	/* 394 -> 403 */ 'category_7'=>array(394,10,"currency"),
	/* 404 -> 453 */ 'reserved_h'=>array(404,50)
);

while(1) {
	$rooms = getRoomData($propertyList);

	// Process the transaction file (if any)
	if(file_exists($GLOBALS['POS_FILENAME_TEMP'])) {
		$transactionFile = fopen($GLOBALS['POS_FILENAME_TEMP'],"r");
		$transactionCount = 0;
		$totalCount = 0;
		while (!feof($transactionFile)) {
			$transactionLine = trim(fgets($transactionFile));

			if(strlen($transactionLine) > 0) {
				posLog("Incoming posting with contents:\n$transactionLine","raw");
				$transaction = decodeLine($transactionLine);
				$result = processLine($transaction,$rooms);
				if($result) {
					$transactionCount++;
				}
				$totalCount++;
			}
		}
		fclose($transactionFile);		
		unlink($GLOBALS['POS_FILENAME_TEMP']);
		print date("Y-m-d h:i:s").": Imported $transactionCount out of $totalCount records.\n";
	}

	// Try to get a transaction file
	$retryOpen = 0;
	while($retryOpen < $GLOBALS['initialRetryOpen'] && file_exists($GLOBALS['POS_FILENAME']) && !file_exists($GLOBALS['POS_FILENAME_TEMP'])) {
		if(!@rename($GLOBALS['POS_FILENAME'],$GLOBALS['POS_FILENAME_TEMP'])) {
			$retryOpen++;
			sleep(1); // wait a little
		}
	}

	generateRooms($rooms);
	//print_r($rooms);
	
	// Any session flushing code
	if($sessionTimeout < 0) {
		$sessionTimeout = $GLOBALS['sessionTimeoutDefault'];
		posLog("Polling for transactions in '$GLOBALS[POS_FILENAME]' every $GLOBALS[sleepTime] second".($GLOBALS['sleepTime']>1?"s":""));
	}

	// Wait until it's time for the next interation.
	sleep($GLOBALS['sleepTime']);
	$sessionTimeout -= $GLOBALS['sleepTime'];
}

function getRoomData($propertyList) {
	global $lDB;

	// Get room data
	$today = date("Y-m-d");

	$roomList = $lDB->get("
		SELECT
			ac_accomm_room.ac_accomm_room_ix,
			rv_reservation_item.rv_reservation_id,
			rv_res_item_group.rv_res_item_group_ix,
			ac_accomm_type.ac_accomm_type_ix
		FROM
			rv_res_item_group
			INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
		WHERE
			rv_reservation_item.rv_item_date_arrive <= '$today'
			/*AND rv_reservation_item.rv_item_date_depart >= '$today'*/
			AND rv_grp_status_ind = '5'
			AND ac_accomm_type.pr_business_id IN ('".join("','",$propertyList)."')
	",2);
	$rooms = array();
	foreach($roomList as $roomInfo) {
		$roomId = $roomInfo['ac_accomm_room_ix'];
		$roomName = $lDB->get("SELECT ac_desc FROM ac_accomm_room WHERE ac_accomm_room_ix = '$roomId'",4);
		preg_match("/(\d+)/",$roomName,$matches);
		$roomNumber = trim($matches[1]);
		if(empty($roomNumber)) { // revert to full names if no number is found
			$roomNumber = $room['name'];
		}
		$guestArray = $lDB->get("
			SELECT
				trim(concat(trim(pr_persona.pr_name_first),concat(' ',pr_persona.pr_name_last))) as pr_name,
				pr_persona.pr_persona_ix
			FROM
				rv_res_item_guest
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
				INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
			WHERE
				rv_reservation_item.rv_item_date_arrive <= '$today'
				/*AND rv_reservation_item.rv_item_date_depart >= '$today'*/
				AND rv_grp_status_ind = '5'
				AND rv_res_item_group.ac_accomm_room_id = '$roomId'
			ORDER BY
				pr_persona.pr_name_last, pr_persona.pr_name_first
		",2);
		$guests = array(
			array(
				'count'=>1,
				'name'=>"Cash",
				'id'=>"",
				'groupId'=>$roomInfo['rv_res_item_group_ix']
			)
		);
		$guestCount = 2;
		foreach($guestArray as $guest) {
			array_push($guests,array(
				'count'=>$guestCount,
				'name'=>$guest['pr_name'],
				'id'=>$guest['pr_persona_ix'],
				'groupId'=>$roomInfo['rv_res_item_group_ix']
			));
			$guestCount++;
		}

		array_push($rooms,array(
			'id'=>$roomId,
			'name'=>$roomName,
			'number'=>$roomNumber,
			'resId'=>$roomInfo['rv_reservation_id'],
			'guests'=>$guests,
			'ac_accomm_type_id'=>$roomInfo['ac_accomm_type_ix']
		));
	}	

	return $rooms;
}

function decodeLine($transactionLine) {
	global $dataFormat;

	$transaction = array();
	foreach($dataFormat as $key=>$item) {
		$value = substr($transactionLine,$item[0],$item[1]);
		$item[2] = isset($item[2]) ? $item[2] : "";
		switch($item[2]) {
		case "string":
			break;
		case "currency":
			$value = number_format(intval($value) / 100,2,".","");
			break;
		case "date":
			$dateArray = array("20".substr($value,0,2),substr($value,2,2),substr($value,4,2));
			$value = $dateArray[0] . "-" . $dateArray[1] . "-" . $dateArray[2];
			break;
		case "time":
			$timeArray = array(substr($value,0,2),substr($value,2,2));
			$value = $timeArray[0] . ":" . $timeArray[1];
			break;
		case "quantity":
			$value = number_format(intval($value) / 10000,4,".","");
			break;
		default:
			$value = intval($value);
			break;
		}
		$transaction[$key] = $value;
	}
	return $transaction;
}	

function processLine($transaction,$rooms) {
	global $lDB;

	posLog("Looking for room '$transaction[room]'");

	$found = false;
	foreach($rooms as $room) {
		if($room['number'] == $transaction['room']) {
			$ac_accomm_type_id = $room['ac_accomm_type_id'];
			$found = true;
			break;
		}
	}
	if(!$found) {
		posLog("ERROR: Room not found");
		return false;
	}

	
	$found = false;
	foreach($room['guests'] as $guest) {
		if($transaction['guest'] == $guest['count']) {
			$found = true;
			break;
		}
	}
	if(!$found) {
		posLog("ERROR: Guest not found");
		return false;
	}

	$propertyId = $lDB->get("
		SELECT
			ac_accomm_type.pr_business_id
		FROM
			ac_accomm_room
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
		WHERE
			ac_accomm_room.ac_accomm_room_ix = '$room[id]'
	",4);

	$billingPropertyId = "";
	$currId = $propertyId;
	while($currId != "0" && trim($currId) != "" && $billingPropertyId == "") {
		$checkBilling = $lDB->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		if($checkBilling == "1") {
			$billingPropertyId = $currId;
		}
		$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
		$currId = $parentId;
	}
	if($billingPropertyId == "") {
		posLog("ERROR: There is no billing entity setup in ResRequest for this posting [$arr[revenueCentre]]. Please contact your system administrator.");
		return false;
	}

	$homeCurrencyId = $lDB->get("SELECT pr_bus_prop_curr_id FROM pr_business WHERE pr_business_id = '$propertyId'",4);
	if($homeCurrencyId == "0" || trim($homeCurrencyId) == "") {
		posLog("ERROR: There is no property currency setup in ResRequest for this posting [$arr[revenueCentre]]. Please contact your system administrator.");
		return false;
	}

	$processed = 0;
	for($category=0;$category<8;$category++) {
		$POSExtra = getPOSExtra($transaction['ecr'], $category);
		if($POSExtra === false) {
			posLog("ERROR: Unknown Register '$transaction[ecr]'");
			return false;
		}
		
		$noteTemplate = $lDB->get("
			SELECT
				ac_ext_note,
				ac_ext_note_internal
			FROM
				ac_extra
			WHERE
				ac_extra_ix = '$POSExtra[ac_extra_id]'
		",1);

		$note = trim($noteTemplate['ac_ext_note']);
		$memo = trim($noteTemplate['ac_ext_note_internal']);

		if($memo != "") {
			$memo .= "\n\n";
		}
		$memo .= "Transaction: $transaction[transaction]
Category: $category

Date: $transaction[date]
Time: $transaction[time]

ECR: $transaction[ecr]
Clerk: $transaction[clerk]
Table: $transaction[table]
Room: $transaction[room]
Guest: $transaction[guest]

Open status: $transaction[open_status]
Check number: $transaction[check_number]

Items: $transaction[items]
Customers: $transaction[customers]
";

		$taxID = $lDB->get("
			SELECT
				ac_extra.rf_tax_id,
				ac_extra.rf_tax_ind
			FROM
				ac_extra
			WHERE
				ac_extra.ac_extra_ix = '".$POSExtra['ac_extra_id']."'
		",1);

		$taxTotal = $transaction['category_'.$category];
		if($taxTotal != "0.00") {
			// Check for refunds or negative amounts
			if($transaction['mode'] == "2" || $transaction['mode'] == "3") {
				$taxTotal = $taxTotal * -1;
			}

			$taxPerc = taxPercentage($taxID['rf_tax_id'], $taxID['rf_tax_ind']);
			$extraId = db_rv_extra_insert(
					$room['resId'], $POSExtra['ac_extra_id'], $propertyId, 1, date("Y-m-d"),$taxTotal/*charge*/, 
					0, $taxPerc /*tax*/, 0, 0, $note, $memo, $guest['groupId'], $homeCurrencyId /* currency */, $homeCurrencyId /* inv curr */,
					'1', false,$billingPropertyId,'','',0,0,'',$transaction['transaction'],0,0,$POSExtra['ac_pos_ix']
			);
			db_rv_extra_tax_insert($extraId, $taxID['rf_tax_ind'], $taxID['rf_tax_id']);
			verify_extra($extraId);

			$folioId = db_fn_folio_insert_extra($extraId, $guest['groupId'],$guest['id'], false);
			db_rv_extra_set_folio($extraId, $folioId);
			$processed++;
		}
	}
	if($processed > 0) {
		return true;
	} else {
		return false;
	}
}

function generateRooms($rooms) {
	$roomString = "";
	$roomTemplate = preg_replace("/(\n)|(\r\n)/","\r\n",join("",file(__DIR__ . "/roomgst_template.txt")));
	foreach($rooms as $room) {
		foreach($room['guests'] as $guest) {
			$display = str_pad(preg_replace("/(\d)/","0$1",$room['number']) . "0b" . str_pad($guest['count'],2,"0",STR_PAD_LEFT),20,"0f",STR_PAD_LEFT);
			$roomArray = array(
				'display'=>$display,
				'room_number_raw'=>$room['number'],
				'room_number'=>str_pad($room['number'],16,"0",STR_PAD_LEFT),
				'guest_number_raw'=>$guest['count'],
				'guest_number'=>str_pad($guest['count'],2,"0",STR_PAD_LEFT),
				'guest_name'=>str_pad(substr($guest['name'],0,12),12),
				'room_number_charge'=>str_pad(substr(preg_replace("/(\d)/","_$1",$room['number']),0,8),8),
				'guest_name_charge'=>str_pad(substr(strtoupper($guest['name']),0,21),21)
				
			);
			$roomString .= showpage($roomArray,$roomTemplate);
		}
	}
	posWriteAndRename($GLOBALS['ROOM_FILENAME'],$roomString,true);
}
