<?php
$GLOBALS['systemName'] = "";			// This is for debugging purposes
$GLOBALS['sessionTimeoutDefault'] = 1800;	// In seconds, 30 minutes
$GLOBALS['initialRetryOpen'] = 10;
$GLOBALS['dbHost'] = "";

require_once(__DIR__ . "/../../class.mysqldb.php");
require_once(__DIR__ . "/../../inc.ixfields.php");
require_once(__DIR__ . "/../../functions.php");
require_once(__DIR__ . "/../../db.rv_phone.php");
require_once(__DIR__ . "/../../db.rv_extra.php");

$GLOBALS['debugEcho'] = true;
$GLOBALS['enableIXfields'] = "1";
$GLOBALS['incrementSequence'] = 1;    // Activate sequencing
$GLOBALS['trTables'] = array();
$GLOBALS['flagChngs'] = "0";
$GLOBALS['debug'] = "0";
$GLOBALS['isWebServer'] = isset($GLOBALS['isWebServer']) ? $GLOBALS['isWebServer'] : false;
$GLOBALS['dbUpgradeInProcess'] = isset($GLOBALS['dbUpgradeInProcess']) ? $GLOBALS['dbUpgradeInProcess'] : false;
$GLOBALS['userid'] = isset($GLOBALS['userid']) ? $GLOBALS['userid'] : "";

// Connect to the censys table an get the principal id
$cDB = new MySQLDB("censys","root","",$GLOBALS['dbHost']);
if($GLOBALS['systemName'] != "") {
	$principalWhere = "WHERE cn_prn_name_short = '$GLOBALS[systemName]'";
} else {
	$principalWhere = "WHERE cn_prn_name_short != 'demo' AND cn_prn_name_short != 'test'";
}

$principalId = $cDB->get("SELECT cn_principal_id FROM cn_principal $principalWhere",4);

// Get the DB id
$databaseId = $cDB->get("SELECT cn_prn_db_me_id FROM cn_principal $principalWhere",4);
if($databaseId == "0" || $databaseId == "") {
	$databaseId = $cDB->get("SELECT cn_sys_db_me_id FROM cn_system",4);
}


$lDB = new MySQLDB("cn_live_".str_pad($principalId,4,"0",STR_PAD_LEFT),"root","",$GLOBALS['dbHost']);

// Get the Database code
$dbInfo = $lDB->get("
	SELECT
		rf_db_code,
		rf_db_description,
		rf_db_phone_filename,
		rf_db_phone_frequency,
		rf_db_phone_ignore,
		rf_db_phone_ignore_dept,
		rf_db_time_zone
	FROM
		rf_database
	WHERE
		rf_database_id = '$databaseId'
",1);
$GLOBALS['dbcode'] = $dbInfo['rf_db_code'];
$GLOBALS['sleepTime'] = $dbInfo['rf_db_phone_frequency'];				// Amount of time between transaction polling
$GLOBALS['PHONE_FILENAME'] = $dbInfo['rf_db_phone_filename'];					// Path to the Phone transactions
$GLOBALS['PHONE_FILENAME_TEMP'] = $GLOBALS['PHONE_FILENAME'] . ".rtmp";					// Path to the temporary transaction file (in progress)
if(trim($dbInfo['rf_db_phone_ignore']) != "") {
	$GLOBALS['ignoreList'] = preg_split("/[,:;|]/",$dbInfo['rf_db_phone_ignore']);
} else {
	$GLOBALS['ignoreList'] = array();
}
if(trim($dbInfo['rf_db_phone_ignore_dept']) != "") {
	$GLOBALS['ignoreDeptList'] = preg_split("/[,:;|]/",$dbInfo['rf_db_phone_ignore_dept']);
} else {
	$GLOBALS['ignoreDeptList'] = array();
}

set_timezone($dbInfo['rf_db_time_zone']);

$GLOBALS['propertyList'] = $lDB->get("SELECT pr_business_id FROM rf_db_business WHERE rf_db_code = '$GLOBALS[dbcode]'",3);

$GLOBALS['isPropServer'] = false;
$rf_db_env_type_ind = $lDB->get("select rf_db_env_type_ind from rf_database where rf_db_code = '$GLOBALS[dbcode]'",4);

if ($rf_db_env_type_ind == "4") $GLOBALS['isPropServer'] = true;


global $lDB;

$GLOBALS['phonePostFmt'] = array(
	'type'=>2,				//0
	'number'=>16,			//1
	'accountCode'=>8,		//2
	'ringTime'=>6,			//3
	'department'=>5,		//4
	'exchangeLine'=>5,		//5
	'extensionNumber'=>5,	//6
	'blank'=>5,				//7
	'dateTime'=>10,			//8
	'time'=>5,				//9
	'duration'=>8,			//10
	'cost'=>10				//11
);

echo "\n\nResrequest Phone Integration Service\n";
echo date("Y-m-d h:i:s")."\n";
echo " * Detecting settings:\n";
echo "     . ClientID    - $principalId\n";
echo "     . DatabaseID  - $databaseId\n";
echo "     . Environment - $dbInfo[rf_db_description]\n";
echo " * Accepting Transactions for the following property codes: " . join(", ",$propertyList) . "\n";
echo " * Ignoring extensions: " . join(", ",$GLOBALS['ignoreList'])."\n";
echo " * Ignoring departments: " . join(", ",$GLOBALS['ignoreDeptList'])."\n";

//echo "\nPolling for transactions in '$GLOBALS[PHONE_FILENAME]' every $GLOBALS[sleepTime] second".($GLOBALS['sleepTime']>1?"s":"")."\n";

$sessionTimeout = -1;

while(1) {
	// Process the transaction file (if any)
	if(file_exists($GLOBALS['PHONE_FILENAME_TEMP'])) {
		$transactionFile = fopen($GLOBALS['PHONE_FILENAME_TEMP'],"r");
		$transactionCount = 0;
		$totalCount = 0;
		while (!feof($transactionFile)) {
			$transactionLine = trim(fgets($transactionFile));

			if(strlen($transactionLine) > 0) {
				// Split the line
				$transactionArray = explode(",",$transactionLine);
				$transactionArray[0] = str_replace("?","",$transactionArray[0]); //remove the preceding ?
				$transactionArray[10] = str_replace(";","",$transactionArray[10]); //remove the trailing ;
				foreach($transactionArray as $transactionKey=>$transactionItem) {
					$transactionArray[$transactionKey] = trim($transactionArray[$transactionKey]);
				}


				// Add required extra/phone entry
				if(processTransaction($transactionArray)) {
					$transactionCount++;
				}
				$totalCount++;
			}
		}
		fclose($transactionFile);		
		unlink($GLOBALS['PHONE_FILENAME_TEMP']);
		print date("Y-m-d h:i:s").": Imported $transactionCount out of $totalCount records.\n";
	}

	// Try to get a transaction file
	$retryOpen = 0;
	while($retryOpen < $GLOBALS['initialRetryOpen'] && file_exists($GLOBALS['PHONE_FILENAME']) && !file_exists($GLOBALS['PHONE_FILENAME_TEMP'])) {
		if(!@rename($GLOBALS['PHONE_FILENAME'],$GLOBALS['PHONE_FILENAME_TEMP'])) {
			$retryOpen++;
			sleep(1); // wait a little
		}
	}
	
	// Any session flushing code
	if($sessionTimeout < 0) {
		$sessionTimeout = $GLOBALS['sessionTimeoutDefault'];
		echo "\n".date("Y-m-d h:i:s").": Polling for transactions in '$GLOBALS[PHONE_FILENAME]' every $GLOBALS[sleepTime] second".($GLOBALS['sleepTime']>1?"s":"")."\n";
	}

	// Wait until it's time for the next interation.
	sleep($sleepTime);
	$sessionTimeout -= $sleepTime;
}

function processTransaction($transactionArray) {
	global $lDB;

	$today = date("Y-m-d");

	$rv_phone_type = $transactionArray[0];
	$rv_phone_num = $transactionArray[1];
	$rv_phone_dept = $transactionArray[4];
	$rv_phone_extn = $transactionArray[6];
	$rv_phone_date = $transactionArray[8] . " " . $transactionArray[9];
	$rv_phone_dur = $transactionArray[10];
	$rv_phone_cost = $transactionArray[11];
	
	if($rv_phone_cost == 0) {
		echo date("Y-m-d h:i:s").": Ignoring record due to zero cost.\n";
		return false;
	}
	if(in_array($rv_phone_extn,$GLOBALS['ignoreList'])) {
		echo date("Y-m-d h:i:s").": Ignoring record due to extension: $rv_phone_extn\n";
		return false;
	}
	if(in_array($rv_phone_dept,$GLOBALS['ignoreDeptList'])) {
		echo date("Y-m-d h:i:s").": Ignoring record due to department: $rv_phone_dept\n";
		return false;
	}
//	print("db_rv_phone_insert($rv_phone_type, $rv_phone_num, $rv_phone_dept, $rv_phone_extn, $rv_phone_date, $rv_phone_dur, $rv_phone_cost);\n");

	$rv_phone_id = db_rv_phone_insert($rv_phone_type, $rv_phone_num, $rv_phone_dept, $rv_phone_extn, $rv_phone_date, $rv_phone_dur, $rv_phone_cost);

	//Look up extension.
	$extCheck = $GLOBALS['lDB']->get("
		SELECT
			COUNT(rf_phone_extn_ix)
		FROM
			rf_phone_extn
		WHERE
			rf_phone_extn_db = '$GLOBALS[dbcode]'
			AND rf_phone_extn_id = '$rv_phone_extn'
	",4);
	if($extCheck > 0) {
		$extInfo = $GLOBALS['lDB']->get("
			SELECT
				ac_extra_id,
				ac_accomm_room_id
			FROM
				rf_phone_extn
			WHERE
				rf_phone_extn_db = '$GLOBALS[dbcode]'
				AND rf_phone_extn_id = '$rv_phone_extn'
		",1);
		
		$extraCheck = $GLOBALS['lDB']->get("
			SELECT
				COUNT(ac_extra_ix)
			FROM
				ac_extra
			WHERE
				ac_inactive_yn = '0'
				AND ac_extra_ix = '$extInfo[ac_extra_id]'
		",4);

		$roomCheck = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_reservation_item.rv_item_date_arrive <= '$today'
				AND rv_reservation_item.rv_item_date_depart >= '$today'
				AND ac_accomm_room_id = '$extInfo[ac_accomm_room_id]'
				AND rv_grp_status_ind = '5'
		",4);
		

		if($extraCheck > 0 && $roomCheck > 0) {
			$resInfo = $GLOBALS['lDB']->get("
				SELECT
					rv_reservation_item.rv_reservation_id,
					rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id
				FROM
					rv_res_item_group
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				WHERE
					rv_reservation_item.rv_item_date_arrive <= '$today'
					AND rv_reservation_item.rv_item_date_depart >= '$today'
					AND ac_accomm_room_id = '$extInfo[ac_accomm_room_id]'
					AND rv_grp_status_ind = '5'
			",1);
			$guestId = $GLOBALS['lDB']->get("
				SELECT
					rv_res_item_guest.pr_guest_id
				FROM
					rv_res_item_guest
					INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
					INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
				WHERE
					rv_res_item_group.rv_res_item_group_ix = '$resInfo[rv_res_item_group_id]'
					AND pr_guest.pr_guest_primary_yn = '1'
			",4);
			if(trim($guestId) == "" || $guestId == "0") {
				$guestId = $GLOBALS['lDB']->get("
					SELECT
						rv_res_item_guest.pr_guest_id
					FROM
						rv_res_item_guest
						INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
						INNER JOIN pr_guest ON pr_guest.pr_guest_id = rv_res_item_guest.pr_guest_id
					WHERE
						rv_res_item_group.rv_res_item_group_ix = '$resInfo[rv_res_item_group_id]'
						AND pr_guest.pr_guest_primary_yn <> '1'
				",4);
				if(trim($guestId) == "" || $guestId == "0") {
					$guestId = false;
				}
			}

			$propertyId = $lDB->get("
				SELECT
					ac_accomm_type.pr_business_id
				FROM
					ac_accomm_room
					INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
				WHERE
					ac_accomm_room.ac_accomm_room_ix = '$extInfo[ac_accomm_room_id]'
			",4);
			$roomName = $lDB->get("
				SELECT
					ac_accomm_room.ac_desc
				FROM
					ac_accomm_room
				WHERE
					ac_accomm_room.ac_accomm_room_ix = '$extInfo[ac_accomm_room_id]'
			",4);
			$extraCurrencyId = $GLOBALS['lDB']->get("SELECT rf_currency_id FROM ac_extra WHERE ac_extra_ix = '$extInfo[ac_extra_id]'",4);
			if($extraCurrencyId == "0" || trim($extraCurrencyId) == "") {
				print(date("Y-m-d h:i:s").": There is no currency set for the chosen extra. This telephone record will not be automatically allocated. Please contact your system administrator.\n");
				return true;
			}

			$phoneDateArray = preg_split("/\s+/",trim($rv_phone_date));
			$phoneDate = $phoneDateArray[0];
			$phoneDateFmt = chng_date($phoneDate,"-");
			$phoneTime = $phoneDateArray[1];
			
			$note = "Type: $rv_phone_type
Number: $rv_phone_num
Extension: $rv_phone_extn (Room: $roomName)
Date: $phoneDateFmt
Time start: $phoneTime
Duration: $rv_phone_dur
";
			$memo = "Department: $rv_phone_dept";

			$taxID = $lDB->get("
				SELECT
					ac_extra.rf_tax_id,
					ac_extra.rf_tax_ind
				FROM
					ac_extra
				WHERE
					ac_extra.ac_extra_ix = '".$extInfo['ac_extra_id']."'
			",1);

			$billingPropertyId = "";
			$currId = $propertyId;
			while($currId != "0" && trim($currId) != "" && $billingPropertyId == "") {
				$checkBilling = $lDB->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
				if($checkBilling == "1") {
					$billingPropertyId = $currId;
				}
				$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
				$currId = $parentId;
			}
			if($billingPropertyId == "") {
				print(date("Y-m-d h:i:s").": There is no billing unit for the property at which this call was made. This telephone record will not be automatically allocated. Please contact your system administrator.\n");
				return true;
			}

			$taxPerc = taxPercentage($taxID['rf_tax_id'], $taxID['rf_tax_ind']);

			$extraId = db_rv_extra_insert($resInfo['rv_reservation_id'], $extInfo['ac_extra_id'], $propertyId, 1, $phoneDate,$rv_phone_cost/*charge*/, 0, $taxPerc /*tax*/, 0, 0, $note, $memo, $resInfo['rv_res_item_group_id'], $extraCurrencyId /* currency */, $extraCurrencyId /* inv curr */, '1', false,$billingPropertyId,'','',0,0,'','',0,0,false,$rv_phone_id);
			db_rv_extra_tax_insert($extraId, $taxID['rf_tax_ind'], $taxID['rf_tax_id']);
			verify_extra($extraId);
			
			$folioId = db_fn_folio_insert_extra($extraId, $resInfo['rv_res_item_group_id'],$guestId,false);
			db_rv_extra_set_folio($extraId, $folioId);						
			db_rv_phone_set_extra($rv_phone_id,$extraId);
		}
			
	}
	return true;
	
}
