<?php
$GLOBALS['systemName'] = "";			// This is for debugging purposes
$GLOBALS['sessionTimeoutDefault'] = 1800;	// In seconds, 30 minutes
$GLOBALS['dbHost'] = "";

require_once(__DIR__ . "/../../class.mysqldb.php");
require_once(__DIR__ . "/../../inc.ixfields.php");
require_once(__DIR__ . "/../../functions.php");
require_once(__DIR__ . "/../../db.rv_extra.php");

$GLOBALS['debugEcho'] = true;
$GLOBALS['enableIXfields'] = "1";
$GLOBALS['incrementSequence'] = 1;    // Activate sequencing
$GLOBALS['trTables'] = array();
$GLOBALS['flagChngs'] = "0";
$GLOBALS['debug'] = "0";
$GLOBALS['isWebServer'] = isset($GLOBALS['isWebServer']) ? $GLOBALS['isWebServer'] : false;
$GLOBALS['dbUpgradeInProcess'] = isset($GLOBALS['dbUpgradeInProcess']) ? $GLOBALS['dbUpgradeInProcess'] : false;
$GLOBALS['userid'] = isset($GLOBALS['userid']) ? $GLOBALS['userid'] : "";

$GLOBALS['POS_NAME'] = "PowerTill";

require_once(__DIR__ . '/../common/functions.pos.php');

define("FORMAT_CURRENCY",1);

$GLOBALS['roomPostFmt'] = array(
	'roomNum'=>16,
	'guestName'=>16,
	'guestLineNum'=>1,
	'billNum'=>4,
	'billAmount'=>10,
	'cashierNum'=>3,
	'waiterNum'=>3,
	'revenueCentre'=>2,
	'servingPeriod'=>2,
	'sequenceNum'=>4,
	'coverCount'=>4
);

// Only for ResRequest protocol
$GLOBALS['roomItemPostFmt'] = array(
	'pluItemNumber'=>array('length'=>16,'label'=>"Item #"),
	'salesGroup'=>array('length'=>3,'label'=>"Group"),
	'quantity'=>array('length'=>9,'label'=>"Quantity"),
	'price'=>array('length'=>12,'label'=>"Price",'format'=>FORMAT_CURRENCY),
	'pluItemDescription'=>array('length'=>35,'label'=>"Description"),
	'pluItemSize'=>array('length'=>10,'label'=>"Size")
);

$GLOBALS['tranFmt'] = array(
	'type',
	'number',
	'name',
	'qty',
	'gross',
	'tax1',
	'tax2',
	'tax3',
	'discount1',
	'discount2',
	'discount3',
	'discount4',
	'discount5',
	'discount6',
	'id', // sequence number
	'date',
	'time',
	'account',
	'clerk',
	'register'
);

$GLOBALS['POS_TRAN_FILENAME'] = "TranSales.csa";
$GLOBALS['POS_TRAN_FILENAME_FULL'] = $GLOBALS['POS_DIR'] . $GLOBALS['POS_TRAN_FILENAME'];

if(!file_exists("$GLOBALS[POS_DIR]PowrM270.irc")) {
	$controlFile = fopen("$GLOBALS[POS_DIR]PowrM270.irc","w");
	fclose($controlFile);
}

posLog("Polling for transactions in '$GLOBALS[POS_DIR]' every $GLOBALS[sleepTime] second".($GLOBALS['sleepTime']>1?"s":""));

while(1) {
	if ($handle = opendir($GLOBALS['POS_DIR'])) {
    	while (false !== ($file = readdir($handle))) { 
        	if (preg_match("/^InqSnd(\d+)\.csa$/i",$file,$matches)) { 
            	$inquiryFile = fopen("$GLOBALS[POS_DIR]$file","r");
				$inquiryNumber = $matches[1];
				$sequenceNumber = substr($inquiryNumber,-4,4);
				$raw = fgets($inquiryFile);
				posLog("Incoming room inquiry $file found with contents:\n$raw","raw");
				$roomNumber = trim($raw);
				$roomNumber = ltrim($roomNumber, '0');		// strip any leading zeros
				fclose($inquiryFile);
				roomInquiry($roomNumber, $inquiryNumber);
				unlink("$GLOBALS[POS_DIR]$file");
	        }

			if (preg_match("/^PstSnd(\d+)\.csa$/i",$file,$matches)) {
				$postFile = fopen("$GLOBALS[POS_DIR]$file","r");
				$postNumber = $matches[1];
				$postLine1 = fgets($postFile);
				$postLine2 = fgets($postFile);
				$postItemLines = array();
				while (!feof($postFile)) {
					$line = fgets($postFile);
					if (trim($line) != "<EOF>" ) {
						$postItemLines[] = $line;
					}
				}
				fclose($postFile);
				$log = "Incoming post request $file found with contents:\n$postLine1";
				if(!empty($postLine2)) {
					$log .= "\n$postLine2";
				}
				if(sizeof($postItemLines) > 0) {
					$log .= "\n" . join("\n",$postItemLines);
				}
				posLog($log,"raw");
				unset($log);
				roomPost($postLine1,$postLine2,$postNumber,$postItemLines);	
				unlink("$GLOBALS[POS_DIR]$file");
			}

			if ($file == $GLOBALS['POS_TRAN_FILENAME']) {
				// Try to get a transaction file
				$retryOpen = 0;
				while(
					$retryOpen < $GLOBALS['initialRetryOpen']
					&& file_exists($GLOBALS['POS_TRAN_FILENAME_FULL'])
					&& !file_exists($GLOBALS['POS_TRAN_FILENAME_FULL'].'.rrtmp')
				) {
					if(!@rename($GLOBALS['POS_TRAN_FILENAME_FULL'],$GLOBALS['POS_TRAN_FILENAME_FULL'].'.rrtmp')) {
						$retryOpen++;
						sleep(1); // wait a little
					}
				}
			}

			if ($file == $GLOBALS['POS_TRAN_FILENAME'] . '.rrtmp') {
				$tranFile = fopen($GLOBALS['POS_TRAN_FILENAME_FULL'].'.rrtmp',"r");
				$transactions = array();
				while (!feof($tranFile)) {
					$raw = fgets($tranFile);
					posLog("Incoming cash sales posting $file found with contents:\n$raw","raw");
					$line = str_getcsv($raw);
					if(sizeof($line) < sizeof($GLOBALS['tranFmt'])) {
						continue;
					}
					$transactionItem = array();
					foreach($GLOBALS['tranFmt'] as $count=>$name) {
						$transactionItem[$name] = $line[$count];
					}
					$id = $transactionItem['id'];
					if(!array_key_exists($id, $transactions)) {
						$transactions[$id] = array();
					}
					$transactions[$id][] = $transactionItem;
				}
				cashPost($transactions);

				fclose($tranFile);
				unlink($GLOBALS['POS_TRAN_FILENAME_FULL'].'.rrtmp');
			}
    	}
	    closedir($handle); 
	}
	if($sessionTimeout < 0) {
		posLog(" * Checking for any requests older than ".date("Y-m-d H:i:s",time()-$GLOBALS['sessionTimeoutDefault']));
		$removeList = $lDB->get("
			SELECT
				zp_session_id
			FROM
				zp_session
			WHERE
				zp_session_time < '".date("Y-m-d H:i:s",time()-$GLOBALS['sessionTimeoutDefault'])."'
		",3);
		foreach($removeList as $item) {
			$lDB->put("DELETE FROM zp_session_guest WHERE zp_session_id = '$item'");
			$lDB->put("DELETE FROM zp_session WHERE zp_session_id = '$item'");
		}	
		if(sizeof($removeList) > 0) {
			posLog("    . Removing ".sizeof($removeList)." item".(sizeof($removeList) > 1?"s":""));
		} else {
			posLog("    . No items found");
		}
		
		$sessionTimeout = $GLOBALS['sessionTimeoutDefault'];
		posLog("Polling for transactions in '$GLOBALS[POS_DIR]' every $GLOBALS[sleepTime] second".($GLOBALS['sleepTime']>1?"s":""));
	}
	sleep($sleepTime);
	$sessionTimeout -= $sleepTime;
}

function roomInquiry($roomNumber, $inquiryNumber) {
	global $lDB;
	global $propertyList;

	$sequenceNum = substr($inquiryNumber,-4,4);
	$today = date("Y-m-d");
	$guestString = "";

	// Check if the requested room exists
	$roomId = $lDB->get("
		SELECT
			ac_accomm_room_ix
		FROM
			ac_accomm_room
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
		WHERE
			ac_accomm_type.pr_business_id IN ('".join("','",$propertyList)."')
			AND ac_accomm_room.ac_desc = '$roomNumber'
		ORDER BY
			ac_accomm_type.ac_accomm_type_inactive_yn,
			ac_accomm_room.ac_accomm_room_inactive_yn
	",4);
	posLog("Found room '$roomId'","debug");

	if($roomId == "" || $roomId =="0") {
		$guestString = "INVALID ROOM";
		posLog("Invalid room","debug");
	}

	posLog(" * Responding to guest list request for room $roomNumber [$roomId]");

	// Check if the room is checked in
	if($guestString == "") {
		$roomCheck = $lDB->get("
			SELECT
				COUNT(*)
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_reservation_item.rv_item_date_arrive <= '$today'
				AND rv_reservation_item.rv_item_date_depart >= '$today'
				AND ac_accomm_room_id = '$roomId'
				AND rv_grp_status_ind = '5'
		",4);
		posLog("Found $roomCheck groups checked into room","debug");
		if($roomCheck < 1) {
			$guestString = "ROOM VACANT";
			posLog("Room vacant","debug");
		}
	}

	// Look up guests in the room
	if($guestString == "") {
		$guestArray = $lDB->get("
			SELECT
				trim(concat(trim(pr_persona.pr_name_first),concat(' ',pr_persona.pr_name_last))) as pr_name,
				pr_persona.pr_persona_ix
			FROM
				rv_res_item_guest
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			WHERE
				rv_reservation_item.rv_item_date_arrive <= '$today'
				AND rv_reservation_item.rv_item_date_depart >= '$today'
				AND rv_grp_status_ind = '5'
				AND rv_res_item_group.ac_accomm_room_id = '$roomId'
			ORDER BY
				pr_persona.pr_name_last, pr_persona.pr_name_first
		",2);
		posLog("Found " . sizeof($guestArray) . " guests in room","debug");
			
		$resInfo = $lDB->get("
			SELECT
				rv_reservation_item.rv_reservation_id,
				rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id
			FROM
				rv_res_item_group
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_reservation_item.rv_item_date_arrive <= '$today'
				AND rv_reservation_item.rv_item_date_depart >= '$today'
				AND ac_accomm_room_id = '$roomId'
				AND rv_grp_status_ind = '5'
		",1);

		// Remove any existing session for this sequence number (transaction)
		$zp_session_id = $lDB->get("
			SELECT
				zp_session_id
			FROM
				zp_session
			WHERE
				zp_session_code = '".$lDB->escape($sequenceNum)."'
		",4);
		if(!empty($zp_session_id)) {
			posLog("Removing existing session for sequence number $sequenceNum","debug");
			$lDB->put("DELETE FROM zp_session_guest WHERE zp_session_id = '".$lDB->escape($zp_session_id)."'");
			$lDB->put("DELETE FROM zp_session WHERE zp_session_id = '".$lDB->escape($zp_session_id)."'");
		}

		$lDB->put("
			INSERT INTO zp_session (zp_session_code,zp_session_time,zp_session_time_tz,rv_reservation_id,rv_res_item_group_id) VALUES ('$sequenceNum','".date("Y-m-d H:i:s")."','".date("e")."','$resInfo[rv_reservation_id]','$resInfo[rv_res_item_group_id]')
		");
		$zp_session_id = $lDB->insert_id;
		$guestString = "Cash            ";
		$guestCount = 1;
		foreach($guestArray as $item) {
			if($guestCount < 8) {
				if(strlen($item['pr_name']) == 16) {
					$guestString .= $item['pr_name'];
				} elseif(strlen($item['pr_name']) < 16) {
					$guestString .= str_pad($item['pr_name'],16);
				} else { // > 16
					$guestString .= substr($item['pr_name'],0,16);
				}
				$lDB->put("INSERT INTO zp_session_guest (zp_session_id, pr_guest_id) VALUES ('$zp_session_id','$item[pr_persona_ix]')");
			}
			$guestCount++;
		}
		
	}

	posWriteAndRename("$GLOBALS[POS_DIR]InqRsp$inquiryNumber.csa","$guestString\r\n");
	posLog("Polling for transactions in '$GLOBALS[POS_DIR]' every $GLOBALS[sleepTime] second".($GLOBALS['sleepTime']>1?"s":""));
}


function roomPost($postLine1, $postLine2, $postNumber, array $postItemLines=array()) {
	global $lDB;
	global $propertyList;
	global $roomPostFmt;
	global $roomItemPostFmt;

	$roomNumber = trim(substr($postLine1,0,16));
	$guestName = trim(substr($postLine1,16,16));
	$responseFilename = "$GLOBALS[POS_DIR]PstRsp$postNumber.csa";
	$responseString = "01                 2".$roomNumber."/".$guestName."\r\n";
	$roomNumber = ltrim($roomNumber, '0');		// strip any leading zeros for use by RR
	
	$currPos = 0;
	$arr = array();
	foreach($roomPostFmt as $key=>$item) {
		$arr[$key] = substr($postLine1,$currPos,$item);
		$currPos += $item;
	}

	$arr2 = array();
	for($count = 0; $count < (strlen($postLine2)/10); $count++) {
		$arr2[$count] = substr($postLine2,$count*10,10);
	}

	$total = $arr['billAmount'];
	$taxTotal = $arr2[7];
	$zeroTotal = $total - $taxTotal;
	fixAmtDisplay($total);
	fixAmtDisplay($taxTotal);
	fixAmtDisplay($zeroTotal);
	$arr['roomNum'] = ltrim($arr['roomNum'], '0');

	$today = date("Y-m-d");
	
	$roomId = $lDB->get("
		SELECT
			ac_accomm_room_ix
		FROM
			ac_accomm_room
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
		WHERE
			ac_accomm_type.pr_business_id IN ('".join("','",$propertyList)."')
			AND ac_accomm_room.ac_desc = '$arr[roomNum]'
		ORDER BY
			ac_accomm_type.ac_accomm_type_inactive_yn,
			ac_accomm_room.ac_accomm_room_inactive_yn
	",4);

	list($ac_accomm_type_id, $propertyId) = $lDB->get("
		SELECT
			ac_accomm_type.ac_accomm_type_ix,
			ac_accomm_type.pr_business_id
		FROM
			ac_accomm_room
			INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
		WHERE
			ac_accomm_room.ac_accomm_room_ix = '$roomId'
	",1);

	if(trim($arr['guestLineNum']) == "1") {
		$guestInfo = array();
		$guestInfo = $lDB->get("
			SELECT
				NULL AS pr_persona_ix,
				zp_session.rv_reservation_id,
				zp_session.rv_res_item_group_id,
				zp_session.zp_session_id
			FROM
				zp_session
			WHERE
				zp_session.zp_session_code = '$arr[sequenceNum]'
		",1);
	} else {
		$guestInfo = $lDB->get("
			SELECT
				pr_persona.pr_persona_ix,
				zp_session.rv_reservation_id,
				zp_session.rv_res_item_group_id,
				zp_session.zp_session_id
			FROM
				zp_session
				LEFT JOIN zp_session_guest ON zp_session_guest.zp_session_id = zp_session.zp_session_id
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = zp_session_guest.pr_guest_id
			WHERE
				zp_session.zp_session_code = '$arr[sequenceNum]'
			ORDER BY
				pr_persona.pr_name_last, pr_persona.pr_name_first
			LIMIT ".($arr['guestLineNum']-2).",1
		",1);
	}

	if(trim($guestInfo['rv_reservation_id']) == "" || $guestInfo['rv_reservation_id'] == "0") {
		posWriteAndRename($responseFilename,"01                 2/Session has expired, please start the Charge To Room procedure again.\r\n");
		return;
	}
	
	$billingPropertyId = "";
	$currId = $propertyId;
	while($currId != "0" && trim($currId) != "" && $billingPropertyId == "") {
		$checkBilling = $lDB->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
		if($checkBilling == "1") {
			$billingPropertyId = $currId;
		}
		$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
		$currId = $parentId;
	}
	if($billingPropertyId == "") {
		posWriteAndRename($responseFilename,"01                 2/There is no billing entity setup in ResRequest for this posting [$arr[revenueCentre]]. Please contact your system administrator.\r\n");
		return;
	}

	$homeCurrencyId = $lDB->get("SELECT pr_bus_prop_curr_id FROM pr_business WHERE pr_business_id = '$propertyId'",4);
	if($homeCurrencyId == "0" || trim($homeCurrencyId) == "") {
		posWriteAndRename($responseFilename,"01                 2/There is no property currency setup in ResRequest for this posting [$arr[revenueCentre]]. Please contact your system administrator.\r\n");
		return;
	}

	if(!hasPOSExtraMappings($arr['revenueCentre'])) {
		$totalMappings = 1;
		$hasMappings = false;
		posLog("Mapping disabled","debug");
	} else {
		$totalMappings = 4;
		$hasMappings = true;
		posLog("Mapping enabled","debug");
	}

	$POSExtras = array();
	for($count = 0; $count < $totalMappings; $count++) {
		$category = $count+1;
		$POSExtras[$count] = getPOSExtra($arr['revenueCentre'], $category);
		if($POSExtras[$count] === false) {
			posWriteAndRename($responseFilename,"01                 2/There is no extra setup in ResRequest for this posting [$arr[revenueCentre]]. Please contact your system administrator.\r\n");
			return;
		}
	}
	
	posLog(" * Responding to billing request for room ".trim($arr['roomNum'])." [$roomId]");

	$billNum = trim($arr['billNum']);
	$cashierNum = trim($arr['cashierNum']);
	$waiterNum = trim($arr['waiterNum']);
	$revenueCentre = trim($arr['revenueCentre']);
	$servingPeriod = trim($arr['servingPeriod']);
	$sequenceNum = trim($arr['sequenceNum']);
	$coverCount = trim($arr['coverCount']);
	$discountTotal = trim($arr2[4]);
	$tipTotal = trim($arr2[5]);
	$entertainmentTotal = trim($arr2[6]);
	$memoAdd = "Bill No: $billNum
Cashier No: $cashierNum
Waiter No: $waiterNum
Revenue Centre: $revenueCentre
Serving Period: $servingPeriod
Sequence No: $sequenceNum
Cover Count: $coverCount
Discount Total: $discountTotal
Tip Total: $tipTotal
Entertainment Total: $entertainmentTotal";

	foreach($POSExtras as $id=>$POSExtra) {
		$noteTemplate = $lDB->get("
			SELECT
				ac_ext_note,
				ac_ext_note_internal
			FROM
				ac_extra
			WHERE
				ac_extra_ix = '$POSExtra[ac_extra_id]'
		",1);

		$note = trim($noteTemplate['ac_ext_note']);
		$memo = trim($noteTemplate['ac_ext_note_internal']);

		if($memo != "") {
			$memo .= "\n\n";
		}
		$memo .= $memoAdd;

		if(!$hasMappings && count($postItemLines) > 0) {
			$counter = 1;
			$memo .= "\r";
			foreach($postItemLines as $postItemLine) {
				if (strlen(trim($postItemLine)) > 0) {
					$currPos = 0;
					$arr = array();
					$priceFormat = $roomItemPostFmt['price']['format'];
					foreach($roomItemPostFmt as $key=>$item) {
						$arr[$key] = substr($postItemLine,$currPos,$item['length']);
						$currPos += $item['length'];
					}
					$quantity = trim($arr['quantity']);
					$pluItemDescription = trim($arr['pluItemDescription']);
					$price = formatDisplay($arr['price'], $priceFormat);
					fixAmtDisplay($price);
					$pluItemNumber = trim((int)$arr['pluItemNumber']);
					if ($quantity > 0) {
						$memo .= "\r\nItem $counter: $quantity x $pluItemDescription @ $price ($pluItemNumber)";
						$counter += 1;
					} else {
						$memo .= "\r\n\t\t  $pluItemDescription ($pluItemNumber)";
					}
				}
			}
		}

		$taxID = $lDB->get("
			SELECT
				ac_extra.rf_tax_id,
				ac_extra.rf_tax_ind
			FROM
				ac_extra
			WHERE
				ac_extra.ac_extra_ix = '".$POSExtra['ac_extra_id']."'
		",1);

		// If there is a taxable amount
		if($hasMappings) {
			$taxTotal = $arr2[$id];
			posLog("Total for category " . ($id+1) . " is $taxTotal","debug");
		}
		if($taxTotal != "0.00") {
			$taxPerc = taxPercentage($taxID['rf_tax_id'], $taxID['rf_tax_ind']);
			$extraId = db_rv_extra_insert($guestInfo['rv_reservation_id'], $POSExtra['ac_extra_id'], $propertyId, 1, date("Y-m-d"),$taxTotal/*charge*/, 0, $taxPerc /*tax*/, 0, 0,
				$note, $memo, $guestInfo['rv_res_item_group_id'], $homeCurrencyId /* currency */, $homeCurrencyId /* inv curr */, '1', false,$billingPropertyId,'','',0,0,'','',0,0,$POSExtra['ac_pos_ix']);
			db_rv_extra_tax_insert($extraId, $taxID['rf_tax_ind'], $taxID['rf_tax_id']);
			verify_extra($extraId);

			$folioId = db_fn_folio_insert_extra($extraId, $guestInfo['rv_res_item_group_id'],$guestInfo['pr_persona_ix'], false);
			db_rv_extra_set_folio($extraId, $folioId);
		}

		// If there is a zero rated amount (only when not using mappings)
		if(!$hasMappings && $zeroTotal != "0.00") {
			$taxPerc = taxPercentage($taxID['rf_tax_id'], $taxID['rf_tax_ind']);
			$extraId = db_rv_extra_insert($guestInfo['rv_reservation_id'], $POSExtra['ac_extra_id'], $propertyId, 1, date("Y-m-d"),$zeroTotal/*charge*/, 0, $taxPerc /*tax*/, 0, 0,
				$note, $memo, $guestInfo['rv_res_item_group_id'], $homeCurrencyId /* currency */, $homeCurrencyId /* inv curr */, '1', false,$billingPropertyId,'','',0,0,'','',0,0,$POSExtra['ac_pos_ix']);
			db_rv_extra_tax_insert($extraId, $taxID['rf_tax_ind'], $taxID['rf_tax_id']);
			verify_extra($extraId);

			$folioId = db_fn_folio_insert_extra($extraId, $guestInfo['rv_res_item_group_id'],$guestInfo['pr_persona_ix'], false);
			db_rv_extra_set_folio($extraId, $folioId);
		}
	}
	posWriteAndRename($responseFilename,$responseString);

	$lDB->put("DELETE FROM zp_session_guest WHERE zp_session_id = '$guestInfo[zp_session_id]'");
	$lDB->put("DELETE FROM zp_session WHERE zp_session_id = '$guestInfo[zp_session_id]'");
	posLog("Polling for transactions in '$GLOBALS[POS_DIR]' every $GLOBALS[sleepTime] second".($GLOBALS['sleepTime']>1?"s":""));
}

function cashPost($transactions) {
	global $lDB;
	global $cashReservations;

	posLog("Processing cash transactions");

	// Reset cash reservation cache
	$cashReservations = array();

	// Filter out transactions billed to a room
	$transactions = array_filter($transactions, function($items) {
		$foundTender = false;
		$foundRoomNumber = false;
		$foundRoomTender = false;
		foreach($items as $item) {
			if($item['type'] == "T" && $item['number'] != '99') {
				$foundTender = true;
			}
			if($item['type'] == "A" && $item['number'] == '4') {
				$foundRoomNumber = true;
			}
			if($item['type'] == "T" && $item['number'] == '15') {
				$foundRoomTender = true;
			}
		}
		$foundRoom = $foundRoomNumber && $foundRoomTender;
		return $foundTender && !$foundRoom;
	});

	// Get totals
	$transactions = array_map(function($items) {
		$transaction = false;
		foreach($items as $item) {
			if($item['type'] == "T" && $item['number'] != '99') {
				$dateArray = explode('/', $item['date']);
				$revenueCentre = substr($item['register'],1,2);
				$register = substr($item['register'],3,2);
				$transaction = array(
					'id'=>$item['id'],
					'date'=>$dateArray[2] . "-" . $dateArray[1] . "-" . $dateArray[0],
					'time'=>$item['time'],
					'clerk'=>$item['clerk'],
					'revenue_centre'=>$revenueCentre,
					'register'=>$register,
					'discount1'=>0,
					'discount2'=>0,
					'discount3'=>0,
					'discount4'=>0,
					'discount5'=>0,
					'discount6'=>0,
				);
				for($count = 1; $count <= 6; $count++) {
					$transaction['discount' . $count] += $item['discount' . $count];
				}
				// Every tender line contains the full total per discount group
				// so exit the loop as soon as one is found.
				break;
			}
		}
		return $transaction;
	},$transactions);

	posLog("Found " . sizeof($transactions) . " cash transactions");

	$extraCount = 0;
	foreach($transactions as $transaction) {
		$folioId = false;
		$memoAdd = "Time: $transaction[time]
Revenue Centre: $transaction[revenue_centre]
Register: $transaction[register]
Clerk: $transaction[clerk]
Sequence No: $transaction[id]";
		for($category = 1; $category <= 4; $category++) {
			$POSExtra = getPOSExtra($transaction['revenue_centre'], $category);
			$total = $transaction['discount' . $category];

			// Ignore categories with no value
			if($total == 0) {
				continue;
			}

			if($POSExtra === false) {
				posLog("Extra mapping not found ($transaction[revenue_centre])","error");
				continue;
			}
			$noteTemplate = $lDB->get("
				SELECT
					ac_ext_note,
					ac_ext_note_internal
				FROM
					ac_extra
				WHERE
					ac_extra_ix = '$POSExtra[ac_extra_id]'
			",1);

			$note = trim($noteTemplate['ac_ext_note']);
			$memo = trim($noteTemplate['ac_ext_note_internal']);

			if($memo != "") {
				$memo .= "\n\n";
			}
			$memo .= $memoAdd;

			// Find reservation for sale based on date
			try {
				$rv_reservation_id = getCashReservation($POSExtra['ac_pos_ix'],$transaction['date']);
			} catch(Exception $e) {
				posLog("Error on cash reservation: " . $e->getMessage(), "error");
				$rv_reservation_id = false;
			}

			if(!$rv_reservation_id) { // Unable to process
				continue;
			}

			$newFolio = false;
			$ac_cash_folio_ind = $lDB->get("SELECT ac_cash_folio_ind FROM ac_pos WHERE ac_pos_ix = '" . $lDB->escape($POSExtra['ac_pos_ix']) . "'",4);
			if($ac_cash_folio_ind == 2) {
				$newFolio = true;
			}

			$propertyId = $lDB->get("
				SELECT
					rv_reservation_item.pr_business_id
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item.rv_reservation_id = '" . $lDB->escape($rv_reservation_id) . "'
				LIMIT 1
			",4);
			if(empty($propertyId)) {
				posLog("Unable to determine property to use on reservation $rv_reservation_id","error");
				continue;
			}

			$billingPropertyId = "";
			$currId = $propertyId;
			while($currId != "0" && trim($currId) != "" && $billingPropertyId == "") {
				$checkBilling = $lDB->get("SELECT pr_bus_billing_prop_yn FROM pr_business WHERE pr_business_id = '$currId'",4);
				if($checkBilling == "1") {
					$billingPropertyId = $currId;
				}
				$parentId = $lDB->get("SELECT pr_business_parent FROM pr_business WHERE pr_business_id = '$currId'",4);
				$currId = $parentId;
			}
			if(empty($billingPropertyId)) {
				posLog("Unable to determine billing entity to use for property $propertyId on reservation $rv_reservation_id","error");
				continue;
			}

			$homeCurrencyId = trim($lDB->get("SELECT pr_bus_prop_curr_id FROM pr_business WHERE pr_business_id = '$propertyId'",4));
			if(empty($homeCurrencyId)) {
				posLog("Unable to determine property currency for property $propertyId on reservation $rv_reservation_id","error");
				continue;
			}

			$tax = $lDB->get("
				SELECT
					ac_extra.rf_tax_id,
					ac_extra.rf_tax_ind
				FROM
					ac_extra
				WHERE
					ac_extra.ac_extra_ix = '".$POSExtra['ac_extra_id']."'
			",1);
			if($tax === false) {
				posLog("Unable to determine tax setup for extra " . $POSExtra['ac_extra_id'] . " on reservation $rv_reservation_id","error");
				continue;
			}

			$taxPerc = taxPercentage($tax['rf_tax_id'], $tax['rf_tax_ind']);

			$extraId = db_rv_extra_insert(
				$rv_reservation_id,
				$POSExtra['ac_extra_id'],
				$propertyId,
				1, // rv_extra_units
				$transaction['date'],
				$total,
				0, // discount
				$taxPerc,
				0, // comm rec
				0, // comm pay
				$note, // note
				$memo, // memo
				"", // rv_res_item_group_id
				$homeCurrencyId, // rf_currency_id
				$homeCurrencyId, // rv_extra_inv_curr_id,
				1, // rv_extra_exch_rate
				false, // rv_extra_exch_expiry
				$billingPropertyId,
				'', // eta
				'', // etd
				0, // adults
				0, // children
				'', // depart
				'', // rv_extra_ref
				0, // rv_extra_supplier_conf_yn
				0, // pr_supplier_id
				$POSExtra['ac_pos_ix']
			);

			db_rv_extra_tax_insert($extraId, $tax['rf_tax_ind'], $tax['rf_tax_id']);
			verify_extra($extraId);
			
			if($folioId === false) {
				$folioId = db_fn_folio_insert_extra($extraId, false, false, $newFolio);
			}
			db_rv_extra_set_folio($extraId, $folioId);
				
			$extraCount++;
		}
	}
	posLog("Created $extraCount extras");
}


function formatDisplay($value, $type) {
	switch ($type) {
		case FORMAT_CURRENCY:
			$value = (double)($value/100); // Set the cents decimal place
			return $value;
			break;
		default:
			return $value;
			break;
	}
}

