<?php
require_once(__DIR__ . '/functions.php');

global $dataset;

switch($_POST['action']) {
case "getprogress":
	echo json_encode(array(
		'output'=>file_get_contents(__DIR__."/output.txt")
	));
	break;
case "updateAgents":
	$versionDir = "../.."; // Override the location to look for the .ver file
	require_once(__DIR__ . '/../../class.mysqldb.php');			// MySQL DB Class  # obvious
	require_once(__DIR__ . '/../../functions.system.php');
	require_once(__DIR__ . '/../../functions.php');
	require_once(__DIR__ . '/../../inc.setup.php');				// Database Connection, customised setup and config file
	require_once(__DIR__ . '/../../ac_logon.php');					// Access Control Results
	global $lDB;

	$userid = $_SESSION['userid']; // User ID (includes DBCode) to reference user information

	$agents_html = "";

	if ($_POST['rateTypes'] == "all") {

		// Complete agent list
		$active_agents = $lDB->get("
			SELECT
				pr_persona.pr_name_last,
				pr_persona.pr_persona_ix
			FROM
				pr_agent
				INNER JOIN pr_persona ON pr_agent.pr_agent_id = pr_persona.pr_persona_ix
			WHERE
				pr_agent.pr_agent_inactive_yn = 0
			ORDER BY
				pr_persona.pr_name_last
		",2);

		$agents_with_rate_types = $lDB->get("
			SELECT
				pr_agent_rate.pr_agent_id
			FROM
				pr_agent_rate
		",3);

		foreach ($active_agents as $agent){
			if (isset($_SESSION['repop']['input_agents']) && in_array($agent['pr_persona_ix'], $_SESSION['repop']['input_agents'])) {
				$selected = "selected";
			} else {
				$selected = "";
			}
			$style = !in_array($agent['pr_persona_ix'], $agents_with_rate_types) ? " style='color: #AA0503;'" : "";

			$agents_html .= "<option $style $selected value=\"".$agent['pr_persona_ix']."\">".$agent['pr_name_last']."</option>";
		}

	} else {

		// Filtered agent list
		$agents = $lDB->get("
			SELECT
				DISTINCT pr_persona.pr_name_last,
				pr_persona.pr_persona_ix
			FROM
				pr_agent_rate
				INNER JOIN pr_persona ON pr_agent_rate.pr_agent_id = pr_persona.pr_persona_ix
			WHERE
				pr_agent_rate.rt_rate_type_id IN ('".join("','",$_POST['rateTypes'])."')
			ORDER BY
				pr_persona.pr_name_last
		",2);

		if (!empty($agents)) {
			foreach ($agents as $agent){
				$agents_html .= "<option value=\"".$agent['pr_persona_ix']."\">".$agent['pr_name_last']."</option>";
			}
		}

	}

	echo $agents_html;
	break;
case "reset":
	$versionDir = "../.."; // Override the location to look for the .ver file
	require_once(__DIR__ . '/../../class.mysqldb.php');			// MySQL DB Class  # obvious
	require_once(__DIR__ . '/../../functions.system.php');
	require_once(__DIR__ . '/../../functions.php');
	require_once(__DIR__ . '/../../inc.setup.php');				// Database Connection, customised setup and config file
	require_once(__DIR__ . '/../../ac_logon.php');					// Access Control Results

	$_SESSION['repop'] = array();
	break;
}
