<?php

if (!function_exists('json_encode')) {
	function json_encode($a=false) {
		if (is_null($a)) return 'null';
		if ($a === false) return 'false';
		if ($a === true) return 'true';
		if (is_scalar($a)) {
			if (is_float($a)) {
				// Always use "." for floats.
				return floatval(str_replace(",", ".", strval($a)));
			}
			if (is_string($a)) {
				static $jsonReplaces = array(array("\\", "/", "\n", "\t", "\r", "\b", "\f", '"'), array('\\\\', '\\/', '\\n', '\\t', '\\r', '\\b', '\\f', '\"'));
				return '"' . str_replace($jsonReplaces[0], $jsonReplaces[1], $a) . '"';
			} else {
				return $a;
			}
		}
		$isList = true;
		for ($i = 0, reset($a); $i < count($a); $i++, next($a)) {
			if (key($a) !== $i) {
				$isList = false;
				break;
			}
		}
		$result = array();
		if ($isList) {
			foreach ($a as $v) $result[] = json_encode($v);
			return '[' . join(',', $result) . ']';
		} else {
			foreach ($a as $k => $v) $result[] = json_encode($k).':'.json_encode($v);
			return '{' . join(',', $result) . '}';
		}
	}
}

function createlogfile($filename){
	$handle = fopen(__DIR__ . "/" . $filename, 'w');

	fclose($handle);
}

function writelog($filename, $message){
	$timestamp = date("Y-m-d H:i:s");
	$handle = fopen(__DIR__ . "/" . $filename, 'a');
	fwrite($handle, "[$timestamp] ".$message ."\n");
	fclose($handle);

}

function flush_buffers(){ 
	ob_end_flush(); 
	ob_flush(); 
	flush(); 
	ob_start(); 
} 


function add_agent_rate_type(){

	global $lDB, $dataset, $dbcode;
	$count = 0;

	foreach ($dataset['agents'] as $pr_agent_rate_id){
		flush_buffers();
		$pr_agent_rate_default_yn = 0;
		$default_log_text = "";

		// Check if agent rate type already exists
		$rt_rate_type_id = $lDB->get("
			SELECT 
				pr_agent_rate_ix
			FROM 
				pr_agent_rate
			WHERE 
				pr_agent_id = '".$pr_agent_rate_id."'
				AND rt_rate_type_id = '".$dataset['input_add_rate_type_id']."'
		",4);

		// Agent does not currently have rate type
		if (empty($rt_rate_type_id)) {

			if (isset($dataset['input_default_rate_type']) && $dataset['input_default_rate_type']) {
				// Check if agent has a default rate type
				$pr_agent_rate_ix = $lDB->get("
					SELECT
						pr_agent_rate.pr_agent_rate_ix
					FROM
						pr_agent_rate
					WHERE
						pr_agent_rate.pr_agent_id = '".$pr_agent_rate_id."'
						AND pr_agent_rate.pr_agent_rate_default_yn = 1
				",4);

				// If a default rate type is set, unset it, as we're going to specify a new default next.
				if (!empty($pr_agent_rate_ix)) {
					$unset_default_rate_type = $lDB->put("
						UPDATE pr_agent_rate SET
							pr_agent_rate_default_yn = 0
						WHERE
							pr_agent_rate_ix = '".$pr_agent_rate_ix."'
					");
				}
				$pr_agent_rate_default_yn = 1;
				$default_log_text = " - Set as default";
			}

			$GLOBALS['lDB']->put("
				INSERT INTO pr_agent_rate (
					pr_agent_rate_db,
					pr_agent_id,
					rt_rate_type_id,
					pr_agent_rate_default_yn
				) VALUES (
					'$dbcode',
					'$pr_agent_rate_id',
					'".$dataset['input_add_rate_type_id']."',
					'".$pr_agent_rate_default_yn."'
				)
			");

			writelog("output.txt", "Rate: $pr_agent_rate_id - Added agent rate type".$default_log_text);
		} else {
			if (isset($dataset['input_default_rate_type']) && $dataset['input_default_rate_type']) {
				// Get current default rate
				$pr_agent_rate_ix = $lDB->get("
					SELECT
						pr_agent_rate.pr_agent_rate_ix,
						pr_agent_rate.rt_rate_type_id
					FROM
						pr_agent_rate
					WHERE
						pr_agent_rate.pr_agent_id = '".$pr_agent_rate_id."'
						AND pr_agent_rate.pr_agent_rate_default_yn = 1
				",1);

				if (!empty($pr_agent_rate_ix) && $pr_agent_rate_ix['rt_rate_type_id'] != $dataset['input_add_rate_type_id']) {
					// Another rate type is currently default
					$lDB->put("
						UPDATE pr_agent_rate SET
							pr_agent_rate_default_yn = 0
						WHERE
							pr_agent_rate_ix = '".$pr_agent_rate_ix['pr_agent_rate_ix']."'
					");
					$lDB->put("
						UPDATE
							pr_agent_rate
						SET
							pr_agent_rate_default_yn = 1
						WHERE
							pr_agent_rate.pr_agent_rate_ix = '".$rt_rate_type_id."'
					");
					$default_log_text = " - Set as default";
				} else if (!empty($pr_agent_rate_ix) && $pr_agent_rate_ix['rt_rate_type_id'] == $dataset['input_add_rate_type_id']) {
					// Rate type is currently default
					$default_log_text = " - Currently default";
				} else if (empty($pr_agent_rate_ix)) {
					// If no defaults, set new rate type as default
					$GLOBALS['lDB']->put("
						UPDATE
							pr_agent_rate
						SET
							pr_agent_rate_default_yn = 1
						WHERE
							pr_agent_rate.pr_agent_rate_ix = '".$rt_rate_type_id."'
					");
					$default_log_text = " - Set as default";
				}
			}
			writelog("output.txt", "Rate: $pr_agent_rate_id - New agent rate type already exists".$default_log_text);
		}
		$count++;
	}
			
}

	


function del_agent_rate_type(){

	global $lDB, $dataset;
	$count = 0;

	foreach ($dataset['agents'] as $pr_agent_rate_id){
		flush_buffers();
		$safe_to_delete = true;

		// Check if agent rate already exists
		$rt_rate_type_id = $lDB->get("
			SELECT 
				pr_agent_rate_ix
			FROM 
				pr_agent_rate
			WHERE 
				pr_agent_id = '".$pr_agent_rate_id."' AND rt_rate_type_id = '".$dataset['input_del_rate_type_id']."'
		",4);



		if (empty($rt_rate_type_id)){
			writelog("output.txt", "Rate: $pr_agent_rate_id - Agent rate type doesn't exist.  Cannot delete.");
		} else {
			if ($safe_to_delete === true){
				$list = $lDB->get("
					SELECT
						pr_agent_prop_ix
					FROM
						pr_agent_prop
					WHERE
						pr_agent_prop.pr_agent_id = '" . $lDB->escape($pr_agent_rate_id) . "'
						AND pr_agent_prop.rt_rate_type_id = '" . $lDB->escape($dataset['input_del_rate_type_id']) . "'
				",3);
				foreach($list as $item) {
					$lDB->put("
						DELETE FROM
							pr_agent_prop
						WHERE
							pr_agent_prop.pr_agent_prop_ix = '" . $lDB->escape($item) . "'
					");
				}

				// Delete the agent rate
				$lDB->put("
					DELETE FROM 
						pr_agent_rate
					WHERE 
						pr_agent_rate_ix = '$rt_rate_type_id'
				");

				writelog("output.txt", "Rate: $pr_agent_rate_id - Deleted agent rate type.");
			}
			
		}

		$count++;
	
	}

}
