<!DOCTYPE html>
<html lang="en">
	<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="">
	<meta name="author" content="">
	<!-- <link rel="shortcut icon" href="../../assets/ico/favicon.png"> -->

	<title>Agent Rate Type Tool</title>

	<!-- Bootstrap core CSS -->
	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/css/bootstrap.css" rel="stylesheet">

	<!-- Custom styles for this template -->
	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/css/agent_rate_type.css" rel="stylesheet">

	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/css/datepicker.css" rel="stylesheet">
	

	<!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!--[if lt IE 9]>
		<script src="../../assets/js/html5shiv.js"></script>
		<script src="../../assets/js/respond.min.js"></script>
	<![endif]-->
	</head>

	<body>

	<div class="navbar navbar-inverse navbar-fixed-top">
		<div class="container">
		<div class="navbar-header">
			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			</button>
			<a class="navbar-brand" href="#">Agent Rate Type Tool</a>
		</div>
		<div class="collapse navbar-collapse">
			<ul class="nav navbar-nav">
			<li class="active"><a href="index.php">Start</a></li>
			<li style="color:#ddd; padding-left:10px;">
				Principal: <?php echo $principal_name; ?><br>
				Logged in: <?php echo $user_name; ?>
			</li>
			<li><a href="login.php?logout">Log Out</a></li>
<!-- 			<li><a href="#about">About</a></li>
			<li><a href="#contact">Contact</a></li> -->
			</ul>
		</div><!--/.nav-collapse -->
		</div>
	</div>

	<div class="container">

		<h2>Summary</h2>
		<p class="lead">Please read this summary carefully before proceeding.  All changes are FINAL!</p>
		<br />

		<h3>You are about to change rates for <strong><?php echo count($_SESSION['rate_edit_data']['agents']) ?></strong> agents in total.</h3>
		<p>
			<strong>Agents: </strong><br>
			<ul>
				<li>
					<?php echo implode('</li><li>', $_SESSION['rate_edit_data']['agent_names']); ?>
				</li>
			</ul>
		</p>
		<hr>
		<?php
			if (isset($_SESSION['rate_edit_data']['input_flag_for_transfer']) && $_SESSION['rate_edit_data']['input_flag_for_transfer'] == 1){
				echo "<h3>Changes WILL be flagged for transfer.</h3><hr>";
			} else {
				echo "<h3>Changes will NOT be flagged for transfer.</h3><hr>";
			}
		?>

		<h3>Filtered agent rate types selected:</h3>
		<?php 
			if (isset($_SESSION['rate_edit_data']['input_rate_types']) && !empty($_SESSION['rate_edit_data']['input_rate_types'])) {
				$rate_types = $lDB->get("
					SELECT
						rt_rate_type.rt_rate_type_desc
					FROM
						rt_rate_type
					WHERE
						rt_rate_type.rt_rate_type_ix IN ('".join("','",$_SESSION['rate_edit_data']['input_rate_types'])."')
					ORDER BY
						rt_rate_type.rt_rate_type_desc ASC
				",3);

				echo "<ul>";
				foreach ($rate_types as $rate_type){
					echo "<li>".$rate_type."</li>";
				}
				echo "</ul>";
			} else {
				echo "No rate types used in filtering";
			}

			if (isset($_SESSION['rate_edit_data']['input_add_rate_type']) && $_SESSION['rate_edit_data']['input_add_rate_type'] == 1){
		?>
			<hr>
			<h3>A new rate type will be added to each filtered agent.</h3>
		<?php
			if (isset($_SESSION['rate_edit_data']['input_default_rate_type']) && $_SESSION['rate_edit_data']['input_default_rate_type'] == 1) {
		?>
			<p>This rate type will be set as the default.</p>
		<?php
			} else {
		?>
			<p>This rate type will NOT be set as the default, existing defaults will remain.</p>
		<?php
			}
		?>	
			<p>Rate : 
			<?php
				if (isset($_SESSION['rate_edit_data']['input_add_rate_type_id']) && $_SESSION['rate_edit_data']['input_add_rate_type_id'] != "") {
					$input_new_component_name = $lDB->get("
						SELECT
							rt_rate_type.rt_rate_type_desc
						FROM
							rt_rate_type
						WHERE 
							rt_rate_type.rt_rate_type_ix = '".$_SESSION['rate_edit_data']['input_add_rate_type_id']."'
					",4);
					echo $input_new_component_name;
				}
			?>
			</p>

		<?php		
			}

			if (isset($_SESSION['rate_edit_data']['input_del_rate_type']) && $_SESSION['rate_edit_data']['input_del_rate_type'] == 1) {
		?>
			<hr>
			<h3>A rate type will be deleted from each filtered agent.</h3>
			<p>Rate : 
			<?php
				if (isset($_SESSION['rate_edit_data']['input_del_rate_type_id']) && $_SESSION['rate_edit_data']['input_del_rate_type_id'] != "") {
					$input_del_rate_type_name = $lDB->get("
						SELECT
							rt_rate_type.rt_rate_type_desc
						FROM
							rt_rate_type
						WHERE 
							rt_rate_type.rt_rate_type_ix = '".$_SESSION['rate_edit_data']['input_del_rate_type_id']."'
					",4);
					echo $input_del_rate_type_name;
				}
			?>
			</p>
		<?php		
			}
		?>

	
		<br /><br />
		<button class="btn btn-lg btn-primary btn-warning" type="button" onclick="cancel();"><span class="glyphicon glyphicon-thumbs-down"></span> &nbsp; I've changed my mind!</button>
		<button class="btn btn-lg btn-primary btn-danger" type="button" onclick="execute();">This is correct, Let's go! &nbsp; <span class="glyphicon glyphicon-send"></span></button>

		<form method="POST" id="mainForm">
			<input value="2" name="action" type="hidden" />
		</form>

	</div><!-- /.container -->


	<!-- Bootstrap core JavaScript
	================================================== -->
	<!-- Placed at the end of the document so the pages load faster -->
	<script src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/js/jquery.js"></script>
	<script src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/js/bootstrap.min.js"></script>
	<script type="text/javascript" src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/js/bootstrap-datepicker.js"></script>
	<script>
		$(document).ready(function() {
		    $('.datepicker').datepicker({
				format: 'yyyy-mm-dd',
				weekStart: 1
			});
		});


		function execute(){
			$('#mainForm').submit();
		}

		function cancel(){
			window.location = window.location;
		}

	</script>
	</body>
</html>
