<?
	$_SESSION['rate_edit_data'] = array();
?>
<!DOCTYPE html>
<html lang="en">
	<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="description" content="">
	<meta name="author" content="">
	<!-- <link rel="shortcut icon" href="../../assets/ico/favicon.png"> -->

	<title>Agent Rate Type Tool</title>

	<!-- Bootstrap core CSS -->
	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/css/bootstrap.css" rel="stylesheet">

	<!-- Custom styles for this template -->
	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/css/agent_rate_type.css" rel="stylesheet">

	<link href="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/css/datepicker.css" rel="stylesheet">
	

	<!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
	<!--[if lt IE 9]>
		<script src="../../assets/js/html5shiv.js"></script>
		<script src="../../assets/js/respond.min.js"></script>
	<![endif]-->
	</head>

	<body>

	<div class="navbar navbar-inverse navbar-fixed-top">
		<div class="container">
		<div class="navbar-header">
			<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			<span class="icon-bar"></span>
			</button>
			<a class="navbar-brand" href="#">Agent Rate Type Tool</a>
		</div>
		<div class="collapse navbar-collapse">
			<ul class="nav navbar-nav">
			<li class="active"><a href="index.php">Start</a></li>
			<li style="color:#ddd; padding-left:10px;">
				Principal: <?php echo $principal_name; ?><br>
				Logged in: <?php echo $user_name; ?>
			</li>
			<li><a href="login.php?logout">Log Out</a></li>
<!-- 			<li><a href="#about">About</a></li>
			<li><a href="#contact">Contact</a></li> -->
			</ul>
		</div><!--/.nav-collapse -->
		</div>
	</div>

	<div class="container">

		<h1>Agent Rate Type Tool</h1>
		<p class="lead">Use this tool with caution. Changes made with this tool are FINAL!</p>
		<p class="lead">Have you made a backup?</p>
		
		<?php
			// Error log
			if (!empty($output_log)){
				foreach($output_log as $error){
					echo "<p class=\"error_text\">$error</p>";
				}	
			}

		?>

<?php
	// Setting checkboxes for re-population if coming back to start page
	$input_agents_by_rate_type_checked 	= (isset($_SESSION['repop']['input_agents_by_rate_type']) && $_SESSION['repop']['input_agents_by_rate_type'] == 1) ? 'checked="checked"' : "";
	$input_agents_by_rate_type_checked 	= (!isset($_SESSION['repop']['input_agents_by_rate_type'])) ? 'checked="checked"' : $input_agents_by_rate_type_checked;
	$input_agents_by_name_checked 		= (isset($_SESSION['repop']['input_agents_by_name']) && $_SESSION['repop']['input_agents_by_name'] == 1) ? 'checked="checked"' : "";
	$input_flag_for_transfer_checked 	= (isset($_SESSION['repop']['input_flag_for_transfer']) && $_SESSION['repop']['input_flag_for_transfer'] == 1) ? 'checked="checked"' : "";
	$input_flag_for_transfer_checked 	= (!isset($_SESSION['repop']['input_flag_for_transfer'])) ? 'checked="checked"' : $input_flag_for_transfer_checked;
	$input_add_rate_type_checked 		= (isset($_SESSION['repop']['input_add_rate_type']) && $_SESSION['repop']['input_add_rate_type'] == 1) ? 'checked="checked"' : "";
	$input_default_rate_type_checked 	= (isset($_SESSION['repop']['input_default_rate_type']) && $_SESSION['repop']['input_default_rate_type'] == 1) ? 'checked="checked"' : "";
	$input_del_rate_type_checked 		= (isset($_SESSION['repop']['input_del_rate_type']) && $_SESSION['repop']['input_del_rate_type'] == 1) ? 'checked="checked"' : "";
?>
		<form class="form-edits" method="POST" id="mainForm">
			<h3><input type="checkbox" value="1" id="input_agents_by_rate_type" name="input_agents_by_rate_type" <?php echo $input_agents_by_rate_type_checked; ?>> Select agents by rate type</h3>
			<p>Filter out the agents that you would like to make changes to. Select all agents that currently have the following rate types.</p>
			<p><strong>Note: </strong>All agents with ANY of the selected rate types will be affected.</p>
			<p><strong>Multiple selection: </strong>Hold down Ctrl to individually select more than one option. To select a range, click on the first item, hold Shift and click on the last item.</p>
			<div class="row">
				<div class="form-edits-row">
					<label for="input_rate_types">Rate types</label>
					<select class="form-control" id="input_rate_types" name="input_rate_types[]" size="15" multiple>
						<?php echo $rate_types_html; ?>
					</select>
				</div>
			</div>
			<hr>

			<h3><input type="checkbox" value="1" id="input_agents_by_name" name="input_agents_by_name" <?php echo $input_agents_by_name_checked; ?>> Select agents by name</h3>
			<p>Selecting the checkbox above will allow you to select agents that you would like to make changes to. If the rate filter is used above, only agents affected by the rates filter will be available for selection.</p>
			<p><strong>Multiple selection: </strong>Hold down Ctrl to individually select more than one option. To select a range, click on the first item, hold Shift and click on the last item.</p>
			<p><strong>Note: </strong>Names in <span style="color: #AA0503;">red</span> are active agents with no rate types linked.</p>
			
			<div class="row">
				<div id="input_agents_container" class="form-edits-row" style="position:relative;">
					<label for="input_agents">Agents</label>
					<select class="form-control" id="input_agents" name="input_agents[]" size="15" multiple>
						<?php echo $agents_html; ?>
					</select>
				</div>
			</div>
			<hr>

			<h3><input type="checkbox" value="1" id="input_flag_for_transfer" name="input_flag_for_transfer" <?php echo $input_flag_for_transfer_checked; ?>> Flag for transfer</h3>
			<p>Selecting the checkbox above will flag any changes made by this tool for data transfer.  If you do not enable this option, then a DB replace on all environments will be required.</p>
			<hr>

			<h3><input type="checkbox" value="1" id="input_add_rate_type" name="input_add_rate_type" <?php echo $input_add_rate_type_checked; ?>> Add new rate type</h3>
			<p>Selecting the checkbox above will add a new rate type to each of the filtered agents.</p>
			<div class="row">
				<div class="form-edits-row">
					<label for="input_add_rate_type_id">Rate types</label>
					<select class="form-control" id="input_add_rate_type_id" name="input_add_rate_type_id">
						<?php echo $rate_types_dropdown_add_html; ?>
					</select>
				</div>
				<div class="form-edits-row">
					Make this the default rate type? 
					<input type="checkbox" value="1" id="input_default_rate_type" name="input_default_rate_type" <?php echo $input_default_rate_type_checked; ?>>
					<br><strong>Note: </strong>This will replace the current default rate type, if set.
				</div>
			</div>
			<hr>

			<h3><input type="checkbox" value="1" id="input_del_rate_type" name="input_del_rate_type"<?php echo $input_del_rate_type_checked; ?>> Delete rate type</h3>
			<p>Selecting the checkbox above will delete an existing rate type from each of the filtered agents.</p>
			<div class="row">
				<div class="form-edits-row">
					<label for="input_del_rate_type_id">Rate types</label>
					<select class="form-control" id="input_del_rate_type_id" name="input_del_rate_type_id">
						<?php echo $rate_types_dropdown_del_html; ?>
					</select>
				</div>
			</div>

			<br />
			<input value="1" name="action" type="hidden" />
		</form>
		<button class="btn btn-lg btn-primary btn-warning" type="submit" onclick="stage();">Preview changes &nbsp; <span class="glyphicon glyphicon-eye-open"></span> <span class="glyphicon glyphicon-eye-open"></span></button>
		<button class="btn btn-lg btn-primary btn-danger" type="button" onclick="reset();">Reset form &nbsp; <span class="glyphicon glyphicon-repeat"></span></button>

	</div><!-- /.container -->


	<!-- Bootstrap core JavaScript
	================================================== -->
	<!-- Placed at the end of the document so the pages load faster -->
	<script src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/js/jquery.js"></script>
	<script src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/js/bootstrap.min.js"></script>
	<script type="text/javascript" src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/js/bootstrap-datepicker.js"></script>
	<script>
		$(document).ready(function() {
			$('.datepicker').datepicker({
				format: 'yyyy-mm-dd',
				weekStart: 1
			});


			$("#mainForm").on('submit',function(e){
				var errorCount = 0;

				var rate_types_select = $('#input_rate_types').filter(function(){
					return this.selectedIndex == -1;
				});

				var input_agents = $('#input_agents').filter(function(){
					return this.selectedIndex == -1;
				});
				
				if( ($('#input_agents_by_rate_type').prop('checked') == true && rate_types_select.length == 0) || 
					($('#input_agents_by_name').prop('checked') == true && input_agents.length == 0) )  {
					$(this)[0].submit(); // submit form if no error
				} else {
					alert("Insufficient rate filters");
					$('html, body').animate({ scrollTop: 0 }, 'slow');
				}

				e.preventDefault();
			});

			if ( $('#input_agents_by_rate_type').prop('checked') == false ) {
				$("#input_rate_types").attr('disabled', true);
			} else {
				$("#input_rate_types").attr('disabled', false);
			}

			if ( $('#input_agents_by_name').prop('checked') == false ) {
				$("#input_agents").attr('disabled', true);
			} else {
				$("#input_agents").attr('disabled', false);
			}

		});

		function stage(){
			$('#mainForm').submit();
		}


		$("#input_rate_types").change(function() {
			$("#input_agents").empty();
			$("#input_agents").attr('disabled', true);
			$("#input_agents_container").append('<div id="spinner_animated" style="position:absolute; top:110px; right:210px;"><img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/img/spinner_animated.gif"></div>');
			
			$.ajax({
				type: "POST",
				url: "ajax.php",
				data:{	'action': 'updateAgents',
						'rateTypes' : $("#input_rate_types").val()
				},
			}).done(function( result ) {
				if (result != "") {
					$("#input_agents").append(result);
					if ( $('#input_agents_by_name').prop('checked') == true ) {
						$("#input_agents").attr('disabled', false);
					}
				} else {
					$("#input_agents").append("<option value=\"\">No agents filtered</option>");
				}
				$("#spinner_animated").remove();
			});
		});


		$("#input_agents_by_rate_type").change(function() {
			if ( $('#input_agents_by_rate_type').prop('checked') == false ) {
				rateTypes = "all";
				$("#input_rate_types").attr('disabled', true);
			} else {
				rateTypes = $("#input_rate_types").val();
				$("#input_rate_types").attr('disabled', false);
			}

			$("#input_agents").empty();
			$("#input_agents").attr('disabled', true);
			$("#input_agents_container").append('<div id="spinner_animated" style="position:absolute; top:110px; right:210px;"><img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/agent_rate_types/img/spinner_animated.gif"></div>');

			$.ajax({
				type: "POST",
				url: "ajax.php",
				data:{	'action': 'updateAgents',
						'rateTypes' : rateTypes
				},
			}).done(function( result ) {
				if (result != "") {
					$("#input_agents").append(result);
					if ( $('#input_agents_by_name').prop('checked') == true ) {
						$("#input_agents").attr('disabled', false);
					}
				} else {
					$("#input_agents").append("<option value=\"\">No agents filtered</option>");
				}
				$("#spinner_animated").remove();
			});
		});


		$("#input_agents_by_name").change(function() {
			if ( $('#input_agents_by_name').prop('checked') == false ) {
				$("#input_agents").attr('disabled', true);
			} else {
				$("#input_agents").attr('disabled', false);
			}
		});


		function reset() {
			$.ajax({
				type: "POST",
				url: "ajax.php",
				data:{'action': 'reset'},
			}).done(function( result ) {
				if (result == "") {
					window.location = window.location;
				}
			});
		};


	</script>
	</body>
</html>
