<?php

/**
 * api.bridge.cache.php - API bridge caching calls
 */

require_once(__DIR__ . "/../../../class.queue.php");

$this->Register(array(
	'ca_stock_change'=>array(
		'doc'=>"When passed a valid username, password, principal id, accommodation type id and list of dates, clears the cache for those dates. Admin only.",
		'signature'=>array(
			array("struct","string","string","string","string","array"),
			array("struct","string","string","string","string","struct"),
			array("struct","struct","string","string","array"),
			array("struct","struct","string","string","struct")
		),
		'forceFunction'=>true,
		'noPrincipal'=>true
	),
	'ca_stock_clear'=>array(
		'doc'=>"When passed a valid username and password, clears all memory and database caches. Admin only.",
		'forceFunction'=>true,
		'noPrincipal'=>true
	),
));

function api_ca_stock_change($principal_id, $ac_accomm_type_id, $dates) {
	global $api_instance;
	if(!$api_instance->Admin) {
		return $api_instance->Error("Access denied for non-admin user.");
	}

	$queue = new Queue("bridge");
	$data = array(
		'principal_id'=>ltrim($principal_id,"0"),
		'ac_accomm_type_id'=>$ac_accomm_type_id,
		'dates'=>$dates
	);
	$result = $queue->create("stock_change",$data);

	if(empty($result)) {
		// TODO implement monitoring
		error_log("Error queueing stock change for principal " . $principal_id . ", accommodation type " . $ac_accomm_type_id . " for dates: " . join(", ",$dates));
		return $api_instance->Error("Error queueing stock change.");
	}
	return true;
}

function api_ca_stock_clear() {
	global $api_instance;
	global $lDB;

	if(!$api_instance->Admin) {
		return $api_instance->Error("Access denied for non-admin user.");
	}

	// Empty the database cache
	$lDB->put("DELETE FROM ca_stock");

	// Empty the memory cache
	$cache = new Cache();
	$cache->delete("*");

	return true;
}
