<?php

require_once(__DIR__ . "/../../api/class.api.abstract.php");
require_once(__DIR__ . "/class.request.php");
require_once(__DIR__ . "/class.multicall.query.php");
require_once(__DIR__ . "/class.multicall.complex.query.php");
require_once(__DIR__ . "/class.multicall.service.php");
require_once(__DIR__ . "/../../api/rpc/bridgerpc.php");

use Bridge\Multicall\Request;
use Bridge\Multicall\MulticallQuery;
use Bridge\Multicall\MulticallComplexQuery;
use Bridge\Multicall\MulticallService;
class Bridge extends APIAbstract
{
	public $User;
	public $Admin;
	public $Mode;
	public $Auth;
	public $External;
	public $isMulticall;
	public $multicallService;
	public $protocol;
	public $auditHeader = array();
	public $auditDetail = array();
	public $requestParameters;

	const AUDIT_CREATE = 1;
	const AUDIT_EDIT = 2;
	const AUDIT_DELETE = 3;

	public function __construct()
	{
		$this->Mode = "bridge";
		$this->BaseSignatures = array(
			array("struct","string","string","string"),
			array("struct","struct")
		);
		$this->isMulticall = false;
		$this->multicallService = new MulticallService($this);
    $this->requestParameters = [];
		global $config;
		$this->protocol = $config['protocol'];

		parent::__construct();
    $this->headers = ["Bridge-Origin: Bridge", "Bridge-Origin-Auth: ".$this->getHashCode()];

		$this->Errors['invalid_login']['message'] = "Invalid username or password or principal id.";
		include(__DIR__ ."/api/api.bridge.php");
		include(__DIR__ ."/api/api.bridge.cache.php");
		include(__DIR__ ."/api/api.bridge.stock.php");
	}

	protected function FixAuth($field) {
		if(!array_key_exists($field,$this->Auth)) {
			$this->Auth[$field] = "";
		}
	}

	protected function Authenticate() {
		global $lDB;

		// Ensure all authentication fields exist
		$authFields = array(
			'bridge_username',
			'bridge_password',
			'user_id',
			'link_id',
			'principal_id',
			'principal_username',
			'principal_password',
			'environment_code'
		);
		foreach($authFields as $field) {
			$this->FixAuth($field);
		}

		$check = $lDB->get("
			SELECT
				pr_user.pr_user_id,
				pr_user.pr_admin_yn
			FROM
				pr_user
			WHERE
				pr_user.pr_username = '".$lDB->escape(strtolower($this->Auth['bridge_username']))."'
				AND pr_user.pr_password = '".$lDB->escape(strtolower($this->Auth['bridge_password']))."'
		",2);

		if(sizeof($check) < 1) {
			// User not found
			return false;
		}

		$this->User = $check[0]['pr_user_id'];
		$this->Admin = ($check[0]['pr_admin_yn'] == "1"?true:false);

		// For bridge based calls, no further checks are needed
		if(!$this->External) {
			return true;
		}

		// Use first available matching principal for legacy mode
		if($this->Mode == "legacy") {
			return $this->CheckPrincipal();
		}

		// Check for a valid user
		if(!empty($this->Auth['user_id']) && !empty($this->Auth['principal_id'])) {
			return $this->CheckUser();
		}

		// Check for a valid link if specified
		if(!empty($this->Auth['link_id'])) {
			if(
				!empty($this->Auth['principal_id'])
				|| !empty($this->Auth['principal_username']) 
				|| !empty($this->Auth['principal_password'])
			) {
				return false;
			}
			return $this->CheckLink();
		}

		// Otherwise use the supplied details
		return $this->CheckAll();
	}

	public function LoadEnvironment()
	{
		$envCode = strtolower($this->Auth['environment_code']);
		if(preg_match("/^[a-vx-z][a-z]$/", $envCode)) { /* only two letter codes that do not start with w */
			$this->Auth['host_prefix'] = $envCode . ".";
		} else {
			$this->Auth['host_prefix'] = "";
		}
	}


	public function LoadLink($where) {
		global $lDB;

		$links = $lDB->get("
			SELECT
				pr_user_link_principal.pr_user_link_principal_id,
				pr_user_link_principal.pr_link_username,
				pr_user_link_principal.pr_link_password,
				pr_user_link_principal.pr_cache_yn,
				pr_user_link_principal.cn_principal_id
			FROM
				pr_user_link_principal 
				INNER JOIN pr_user_link ON pr_user_link.pr_user_link_id = pr_user_link_principal.pr_user_link_id
			WHERE
				pr_user_link.pr_user_id = '".$this->User."'
				AND pr_user_link.pr_inactive_yn = 0
				AND pr_user_link_principal.pr_inactive_yn = 0
				$where
			ORDER BY
				pr_user_link_principal.pr_user_link_principal_id
		",2);

		if(sizeof($links) < 1) {
			return false;
		}

		foreach($links as $link) {
			$found = false;
			if($link['cn_principal_id'] != "*" && $link['pr_link_username'] != "*") {
				if(!empty($this->Auth['link_id']) && empty($this->Auth['principal_id'])) {
					$this->Auth['principal_id'] = $link['cn_principal_id'];
				}

				if(
					$link['cn_principal_id'] == $this->Auth['principal_id']
					&& empty($this->Auth['principal_username'])
				) {
					$this->Auth['principal_username'] = $link['pr_link_username'];
					$this->Auth['principal_password'] = $link['pr_link_password'];
					$found = true;
				}
			} else {
				$foundPrincipal = false;
				if($link['cn_principal_id'] == "*") {
					$foundPrincipal = true;
				} elseif(
					!empty($this->Auth['principal_id'])
					&& $link['cn_principal_id'] == $this->Auth['principal_id']
				) {
					$foundPrincipal = true;
				}

				$foundUsername = false;
				if(
					$link['pr_link_username'] == "*"
					&& !empty($this->Auth['principal_password'])
				) {
					$foundUsername = true;
				} elseif(
					!empty($this->Auth['principal_username'])
					&& $link['pr_link_username'] == $this->Auth['principal_username']
				) {
					if(empty($this->Auth['principal_password'])) {
						$this->Auth['principal_password'] = $link['pr_link_password'];
					}
					$foundUsername = true;
				}

				if($foundPrincipal && $foundUsername) {
					$found = true;
				}
			}

			if($found) {
				$this->Auth['link_id'] = $link['pr_user_link_principal_id'];
				$this->Auth['cache'] = ($link['pr_cache_yn'] == "1"?true:false);
				$this->LoadEnvironment();
				return true;
			}
		}

		return false;
	}

	public function CheckAll() {
		global $lDB;

		$where = "
				AND (
					pr_user_link_principal.cn_principal_id = '*'
					OR pr_user_link_principal.cn_principal_id = '".$lDB->escape($this->Auth['principal_id'])."'
				)
		";
		if(empty($this->Auth['principal_username'])) {
			$where .= "
				AND pr_user_link_principal.pr_link_username <> '*'
				AND pr_user_link_principal.pr_link_username <> ''
			";
		} else {
			$where .= "
				AND (
					pr_user_link_principal.pr_link_username = '*'
					OR pr_user_link_principal.pr_link_username = '".$lDB->escape($this->Auth['principal_username'])."'
				)
			";
		}

		return $this->LoadLink($where);
	}

	public function CheckLink() {
		global $lDB;

		return $this->LoadLink("
				AND pr_user_link_principal.pr_user_link_principal_id = '".$lDB->escape($this->Auth['link_id'])."'
				AND pr_user_link_principal.cn_principal_id <> '*'
				AND pr_user_link_principal.pr_link_username <> '*'
		");
	}

	public function CheckPrincipal() {
		global $lDB;

		return $this->LoadLink("
				AND pr_user_link_principal.cn_principal_id = '".$lDB->escape($this->Auth['principal_id'])."'
				AND pr_user_link_principal.cn_principal_id <> '*'
				AND pr_user_link_principal.pr_link_username <> '*'
		");
	}

	/**
	 * Verifies that the bridge user exists and is linked to the correct bridge account. Also ensures that a valid
	 * link is available to the target principal.
	 */
	public function CheckUser() {
		global $lDB;

		return $this->LoadLink("
				AND pr_user_link.pr_user_link_id = '".$lDB->escape($this->Auth['user_id'])."'
				AND pr_user_link_principal.cn_principal_id = '".$lDB->escape($this->Auth['principal_id'])."'
				AND pr_user_link_principal.cn_principal_id <> '*'
				AND pr_user_link_principal.pr_link_username <> '*'
		");
	}

	public function LookupHost($client)
	{
		global $config;
		global $lDB;

		$lDB->name = $config['db']['client'];
		$lDB->select();
		$this->Auth['host'] = $this->Auth['host_prefix'] . $lDB->get("
			SELECT cn_prn_name_short FROM cn_principal WHERE cn_principal_id = '".str_pad($client,4,"0",STR_PAD_LEFT)."'
		",4);
		$lDB->name = $config['db']['bridge'];
		$lDB->select();
	}

	public function LogAccess()
	{
		global $lDB;

		$now = date("Y-m-d H:i:s");
		$lDB->put("
			INSERT INTO ca_user (
				pr_user_link_principal_id,
				cn_principal_id,
				pr_link_username,
				pr_link_password,
				ca_user_time
			) VALUES (
				'".$lDB->escape($this->Auth['link_id'])."',
				'".$lDB->escape($this->Auth['principal_id'])."',
				'".$lDB->escape($this->Auth['principal_username'])."',
				'".$lDB->escape($this->Auth['principal_password'])."',
				'".$lDB->escape($now)."'
			) ON DUPLICATE KEY UPDATE
				pr_link_password = '".$lDB->escape($this->Auth['principal_password'])."',
				ca_user_time = '".$lDB->escape($now)."'
		");
		$ca_user_id = $lDB->insert_id;

		// Look up key if it isn't returned due to no change in password or timestamp
		if(empty($ca_user_id)) {
			$ca_user_id = $lDB->get("
				SELECT
					ca_user.ca_user_id
				FROM
					ca_user
				WHERE
					ca_user.pr_user_link_principal_id = '".$lDB->escape($this->Auth['link_id'])."'
					AND ca_user.cn_principal_id = '".$lDB->escape($this->Auth['principal_id'])."'
					AND ca_user.pr_link_username = '".$lDB->escape($this->Auth['principal_username'])."'
			",4);
		}

		return $ca_user_id;
	}

	public function Wrapper($m="")
	{
		global $config;
		global $lDB;

		$this->method = $method = $m->method();
    $this->uniqueId = uniqid();

		if(!array_key_exists($method,$this->Map)) {
			$result = $this->StandardError("invalid_method_name");
			if ($this->isMulticall) {
				$this->multicallService->addResult($result);
      } else {
        $error = $this->Errors["invalid_method_name"];
        $this->log(
          $this->uniqueId,
          $this->bridgeUsername,
          $this->principalUsername,
          $this->principalId,
          $this->environmentCode,
          $this->method,
          self::CALL_TYPE_RESPONSE,
          [],
          "ERROR [{$error['code']}]: ".$error['message']
        );
      }
			return $result;
		}
		
		$this->External = false;
		if(!array_key_exists("no_principal",$this->Map[$method]) || !$this->Map[$method]['no_principal']) {
			$this->External = true;
		}

		$params = array();
		for($count=0; $count<$m->getNumParams(); $count++) {
			array_push($params,php_xmlrpc_decode($m->getParam($count)));
		}

		if(!is_array($params[0])) {
			$this->Mode = "legacy";
			$this->Auth = array(
				'bridge_username'=>addslashes(array_shift($params)),
				'bridge_password'=>addslashes(array_shift($params))
			);
			if($this->External) {
				$this->Auth['principal_id'] = ltrim(addslashes(array_shift($params)),"0");
			}
		} else {
			$this->Mode = "standard";
			$this->Auth = array_shift($params);
		}

		if(!$this->Authenticate()) {
			$result = $this->StandardError("invalid_login");
			if ($this->isMulticall) {
				$this->requestParameters[$method] = $params;
				$this->multicallService->addResult($result);
			}
			return $result;
		}
    $this->bridgeUsername = $this->Auth['bridge_username'] ?? "";
    $this->principalUsername = $this->Auth['principal_username'] ?? "";
    $this->environmentCode = $this->Auth['environment_code'] ?? "";
    $this->principalId = $this->Auth['principal_id'] ?? "";

		if($this->External) {
			$this->LookupHost($this->Auth['principal_id']);
			$this->Auth['ca_user_id'] = $this->LogAccess();
    } else {
      // Log internal bridge request
      $this->log(
        $this->uniqueId,
        $this->bridgeUsername,
        $this->principalUsername,
        $this->principalId,
        $this->environmentCode,
        $this->method,
        self::CALL_TYPE_REQUEST,
        $params
      );
    }

		if($this->Map[$method]['force_function']) {
			$result = call_user_func_array($this->Map[$method]['real_function'],$params);
			if ($this->isMulticall) {
				if (
					$result instanceof MulticallQuery
					|| $result instanceof MulticallComplexQuery
				) {
          $this->requestParameters[$method] = $params;
					$this->multicallService->addResult($result, $params);
				} else {
					if(!is_a($result, 'xmlrpcresp')) {
						$result = new xmlrpcresp(php_xmlrpc_encode($result));
					}

          $this->requestParameters[$method] = $params;
					$this->multicallService->addResult($result, $params);
				}
				
				return $this->StandardError("multicall_optimisation");
			}
		} else {
			$result = $this->Call($method,$params);

			if ($this->isMulticall) {
				// Necessary processing has already been done
				return $result;
			}
		}

		if($result === false) {
      $error = $this->Errors["invalid_method_return"];
      $this->log(
        $this->uniqueId,
        $this->bridgeUsername,
        $this->principalUsername,
        $this->principalId,
        $this->environmentCode,
        $this->method,
        self::CALL_TYPE_RESPONSE,
        [],
        "ERROR [{$error['code']}]: ".$error['message']
      );
			return $this->StandardError("invalid_method_return");
		}

		if(is_a($result, 'xmlrpcresp')) {
			return $result;
		} else {
      if (!$this->External) {
        // Log internal bridge response
        $this->log(
          $this->uniqueId,
          $this->bridgeUsername,
          $this->principalUsername,
          $this->principalId,
          $this->environmentCode,
          $this->method,
          self::CALL_TYPE_RESPONSE,
          $result
        );
      }
      $result = new xmlrpcresp(php_xmlrpc_encode($result));
			return $result;
		}
	}

	public function Call($method, $params) {
    if (!$this->isMulticall) {
      $this->requestParameters = $params;
    }
		array_unshift($params,$this->Auth['principal_password']);
		array_unshift($params,$this->Auth['principal_username']);
		return $this->RPC("JSON", $this->protocol . "://" . $this->Auth['host'] . "." . getLinkDomain() . "/api/",$method,$params);
	}

	protected function RPC($type, $url, $method, $data) {
		$clientClass = strtolower($type)."rpc_client";
		$messageClass = strtolower($type)."rpcmsg";

		if($data !== null) {
			if(is_array($data)) {
				foreach($data as $key=>$value) {
					$data[$key] = php_xmlrpc_encode($value);
				}
			} else {
				$data = array(php_xmlrpc_encode($data));
			}
		}

		$message = new $messageClass($method,$data);

		if ($this->isMulticall) {
      $this->requestParameters[$method] = array_slice($data, 2, count($data));
			$this->multicallService->addResult(new MulticallQuery(new Request($url, $message)));
      return $this->StandardError("multicall_optimisation");
		}

    $this->log(
      $this->uniqueId,
      $this->bridgeUsername,
      $this->principalUsername,
      $this->principalId,
      $this->environmentCode,
      $this->method,
      self::CALL_TYPE_REQUEST,
      $this->requestParameters
    );

		$client = new $clientClass($url);
		$client->return_type = 'phpvals';
    $client->setHeaders($this->headers);

		$resp = $client->send($message);
		if($resp->faultCode()) {
      // if not multicall_optimisation
      if ($resp->faultCode() != 805) {
        $this->log(
          $this->uniqueId,
          $this->bridgeUsername,
          $this->principalUsername,
          $this->principalId,
          $this->environmentCode,
          $this->method,
          self::CALL_TYPE_RESPONSE,
          [],
          "ERROR [{$resp->faultCode()}]: ".$resp->faultString()
        );
      }
			return $this->Error($resp->faultString(),$resp->faultCode());
		} else {
      $responseValue = $resp->value();
      $this->log(
        $this->uniqueId,
        $this->bridgeUsername,
        $this->principalUsername,
        $this->principalId,
        $this->environmentCode,
        $this->method,
        self::CALL_TYPE_RESPONSE,
        $responseValue
      );
			return $responseValue;
		}	
	}

	public function SetFunction($method,$function)
	{
		$this->Map[$method]['force_function'] = true;
		$this->Map[$method]['real_function'] = $function;
	}

	public function handleMulticall($server, $message)
	{
		$this->isMulticall = true;
		return $this->multicallService->service($server, $message);
	}

	public function generateRequest($method, $params)
	{
		array_unshift($params,$this->Auth['principal_password']);
		array_unshift($params,$this->Auth['principal_username']);

		if($params !== null) {
			if(is_array($params)) {
				foreach($params as $key=>$value) {
					$params[$key] = php_xmlrpc_encode($value);
				}
			} else {
				$params = array(php_xmlrpc_encode($params));
			}
		}

		$url = $this->protocol . "://" . $this->Auth['host'] . "." . getLinkDomain() . "/api/";
		return new Request($url, new jsonrpcmsg($method,$params));
	}

	public function auditCreate($pr_user_id, $ad_user_desc)
	{
		$this->auditHeader = array(
			'pr_user_id' => $pr_user_id,
			'ad_user_desc' => $ad_user_desc
		);
		$this->auditDetail = array();
	}

	public function auditAdd($ad_user_detail_value_from, $ad_user_detail_value_to, $ad_user_detail_action_desc, $ad_user_detail_action_ind)
	{
		$this->auditDetail[] = array(
			'ad_user_detail_value_from' => $ad_user_detail_value_from,
			'ad_user_detail_value_to' => $ad_user_detail_value_to,
			'ad_user_detail_action_desc' => $ad_user_detail_action_desc,
			'ad_user_detail_action_ind' => $ad_user_detail_action_ind
		);
	}

	public function auditSave()
	{
		global $lDB;
		
		$pr_user_id = !empty($this->auditHeader['pr_user_id']) ? $lDB->escape($this->auditHeader['pr_user_id']) : "null";
		$lDB->put("
			INSERT INTO ad_user (
				ad_user_desc,
				pr_user_id,
				ad_user_actioned_by_pr_user_id
			) VALUES (
				'" . $lDB->escape($this->auditHeader['ad_user_desc']) . "',
				" . $pr_user_id . ",
				" . $lDB->escape($this->User) . "
			);
		");
		$ad_user_id = $lDB->insert_id;

		foreach ($this->auditDetail as $auditDetail) {
			$lDB->put("
				INSERT INTO ad_user_detail (
					ad_user_detail_value_from,
					ad_user_detail_value_to,
					ad_user_detail_action_desc,
					ad_user_detail_action_ind,
					ad_user_id
				) VALUES (
					'" . $lDB->escape($auditDetail['ad_user_detail_value_from']) . "',
					'" . $lDB->escape($auditDetail['ad_user_detail_value_to']) . "',
					'" . $lDB->escape($auditDetail['ad_user_detail_action_desc']) . "',
					" . $lDB->escape($auditDetail['ad_user_detail_action_ind']) . ",
					" . $lDB->escape($ad_user_id) . "
				);
			");
		}

		$this->auditHeader = array();
		$this->auditDetail = array();
	}
}
