<?php

class Cache
{
	private $cache;
	private $connected;
	private $tomorrow;

	/**
	 * Constructor
	 * 
	 */
	public function __construct()
	{
		if(class_exists('Redis')) {
			$this->cache = new Redis;
			$this->connected = false;
		} else {
			$this->cache = false;
			$this->connected = true;
		}
		$this->tomorrow = false;
	}

	public function connect()
	{
		if($this->connected) {
			return true;
		}

		if($this->cache === false) {
			return false;
		}

		if(!$this->cache->connect('127.0.0.1')) {
			$this->cache = false;
			// TODO implement monitoring
			error_log("Unable to connect to Redis cache");
			return false;
		}

		$this->connected = true;
		return true;
	}

	private function prefix($key)
	{
		return "bridge_" . $key;
	}

	public function set($key, $value, $expire=0)
	{
		if(!$this->connect()) {
			return false;
		}

		$key = $this->prefix($key);
		try {
			if(!$this->cache->set($key, json_encode($value))) {
				return false;
			}

			if($expire == "tomorrow") {
				if($this->tomorrow === false) {
					$today = explode("-",date("Y-m-d"));
					$this->tomorrow = mktime(0, 0, 0, $today[1], $today[2] + 1, $today[0]);
				}
				$expire = $this->tomorrow;
			}

			if($expire != 0) {
				$this->cache->expireAt($key,$expire);
			}
		} catch (RedisException $e) {
			// TODO implement monitoring
			error_log("Unable to set key in Redis cache");
			return false;
		}

		return true;
	}

	public function get($key)
	{
		if(!$this->connect()) {
			return false;
		}

		try {
			$value = $this->cache->get($this->prefix($key));
		} catch (RedisException $e) {
			// TODO implement monitoring
			error_log("Unable to get key from Redis cache");
			return false;
		}

		if($value === false) {
			return false;
		} else {
			return json_decode($value,true);
		}
	}

	public function exists($key)
	{
		if(!$this->connect()) {
			return false;
		}
		try {
			return $this->cache->exists($this->prefix($key));
		} catch (RedisException $e) {
			// TODO implement monitoring
			error_log("Unable to check key in Redis cache");
			return false;
		}
	}

	public function delete($key)
	{
		$hasWildcard = (strpos($key,"*") !== false);
		if(!$this->connect()) {
			return false;
		}
		$key = $this->prefix($key);
		try {
			if(!$hasWildcard) {
				return $this->cache->delete($key);
			} else {
				$keys = $this->cache->keys($key);
				foreach($keys as $key) {
					$this->cache->delete($key);
				}
				return true;
			}
		} catch (RedisException $e) {
			// TODO implement monitoring
			error_log("Unable to delete key from Redis cache");
			return false;
		}
	}
}
