<?php

namespace Bridge\Multicall;

/**
 * One of more requests to principals which is then followed by some processing.
 */
class MulticallComplexQuery
{
    public $requests;       // The requests to be made to the server
    public $callback;       // The callback to run when the responses have returned
    public $data;           // Extra data to pass to the callback

    /**
     * Create a new complex query.
     *
     * @param array $requests The requests to be made.
     * @param callable $callback The callback to run when the responses have returned
     * @param any $data Data that should be passed to the callback
     */
    public function __construct($requests, $callback, $data = null)
    {
        $this->requests = $requests;
        $this->callback = $callback;
        $this->data = $data;
    }
}