<?php

class MySQLDB {

	function MySQLDB ($name,$login,$passwd,$host="localhost") {      # Constructor
		# set object variables
		$this->name = $name;
		$this->login = $login;
		$this->passwd = $passwd;
		$this->host = $host;

		$this->error = "";
		$this->conn = mysqli_connect($this->host,$this->login,$this->passwd);
		mysqli_set_charset($this->conn, 'utf8mb4');

		# set this db as the active one
		if ($name != "") {
			$this->select();
		}
	}

	function close() {
		return mysqli_close($this->conn);
	}


	function select () { # MySQL Select Database
		mysqli_select_db($this->conn,$this->name);
	}	

	function put($string,$debug=false)
	{
		if($debug) debug('$'."lDB->put(\"\n".$string."\n\");");

		mysqli_query($this->conn,$string);

		$error = mysqli_error($this->conn);
		if($debug) debug('$'."lDB error: $error");

		$this->insert_id = mysqli_insert_id($this->conn);
		if($debug) debug('$'."lDB insert id: $this->insert_id");

		if($error == "") {
			return true;
		} else {
			return false;
		}
	}

	function put_all($string,$debug=false)
	{
		$hasError = false;

		if($debug) debug('$'."lDB->put(\"\n".$string."\n\");");

		$result = mysqli_multi_query($this->conn,$string);
		if($result) {
			do {
				$error = mysqli_error($this->conn);
				if(!empty($error)) $hasError = true;
				if($debug && !empty($error)) debug('$'."lDB error: $error");
			} while(mysqli_next_result($this->conn));
		}
		$error = mysqli_error($this->conn);
		if(!empty($error)) $hasError = true;
		if($debug && !empty($error)) debug('$'."lDB error: $error");


		if(!$hasError) {
			return true;
		} else {
			return false;
		}
	}

	function get($string,$mode="1",$debug=false) { # MySQL Select
		$this->error = "";
		if($debug) {
			debug('$'."lDB->get(\"\n".$string."\n\",$mode,$debug);");
		}

		# get the values in
		$query = mysqli_query($this->conn,$string);
		$error = mysqli_error($this->conn);
		if($debug) { debug('$'."lDB error: $error"); }

		if($error == "") {
			# switch on get 'mode'
			switch ($mode) {
            case 0: # if mode 0, return result directly
				$result = $query;
				break;
			case 1: # if mode 1, return one row of result in multi-dimension array
				if(mysqli_num_rows($query) != "0") {
					$result = mysqli_fetch_array($query);
				} else {
					$result = false;
				}
				break;
			case 2: # if mode 2, return all rows in result in multi-dimension array
				$result = array();
				while($row = mysqli_fetch_array($query)) {
					array_push($result,$row);
				}
				break;           
			case 3: # if mode 3, return all rows' first column in single dimension array
				$result = array();
				while($row = mysqli_fetch_array($query)) {
					array_push($result,$row[0]);
				}
				break;            
			case 4: # if mode 4, return the first row's first column value
				if(mysqli_num_rows($query) != "0") {
					$row = mysqli_fetch_array($query);
					$result = $row[0];
				} else {
					$result = false;
				}
				break;            
			case 5: # if mode 2, return all rows in result in multi-dimension array
				$result = array();
				while($row = mysqli_fetch_row($query)) {
					array_push($result,$row);
				}
				break;
			case 6: # if mode 6, return all rows in result in multi-dimension with fields as keys only
				$result = array();
				while($row = mysqli_fetch_assoc($query)) {
					array_push($result,$row);
				}
				break;           
			}
			if($mode != 0) {
				mysqli_free_result($query);
			}
			return $result;
		}
	}

	function count($table,$field,$value,$check,$where="where",$debug=false) { # MySQL Count
		$this->error = "";
		# compile sql query from arguments
		$qry = "select count(*) from ";
		$qry .= $table;
		if ($where == "where") {
			$qry .= " ".$where." ";
			$qry .= $field;
			$qry .= " = '";
			$qry .= $value;
			$qry .= "'";
		} else {
			$qry .= $where;
		}

		# execute query
		$tmp = $this->get($qry,"1");
		if ($debug) {
			echo $qry."<br>\n".$tmp[0]." vs ".$check."<br>\n".mysqli_error($this->conn)."<br>\n";
		}

		# return true or false on check
		if ($tmp[0] == $check) {
			return True;
		} else {
			return False;
		}
	}

	function escape($value) {
		return mysqli_real_escape_string($this->conn,$value);
	}

	function escapeLike($value,$escapeWildcards=true) {
		$value = $this->escape($value);
		$value = $this->escape($value);
		if($escapeWildcards) {
			$value = addcslashes($value,'%_');
		}
		return $value;
	}

	function like($value,$wildcard='*',$escapeWildcards=true) {
		return str_replace($wildcard,'%',$this->escapeLike($value,$escapeWildcards));
	}

}
