/* RRDEV-751 - Stock caching - bridge */
DROP TABLE IF EXISTS ca_stock;
CREATE TABLE ca_stock (
	ac_accomm_type_id VARCHAR(13) NOT NULL,
	ca_stock_date DATE NOT NULL,
	ca_stock_amt INT(11) NOT NULL,
	ca_create_date DATE NOT NULL,
	pr_user_link_id INT(11) NOT NULL,
	PRIMARY KEY (ac_accomm_type_id, ca_stock_date, pr_user_link_id)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;

DELIMITER //
CREATE PROCEDURE alter_pr_user()
BEGIN
	SET @dbname := DATABASE();
	SET @exists := FALSE;

	SELECT IF(count(*) > 0, TRUE, FALSE) INTO @exists
	FROM information_schema.COLUMNS c
	WHERE
	c.TABLE_SCHEMA    = @dbname
	AND c.TABLE_NAME  = 'pr_user'
	AND c.COLUMN_NAME = 'pr_admin_yn';
	IF @exists = FALSE THEN
		ALTER TABLE pr_user ADD COLUMN pr_admin_yn TINYINT(1) NOT NULL DEFAULT 0 AFTER pr_password;
	END IF;
END;
//
DELIMITER ;
CALL alter_pr_user();
DROP PROCEDURE alter_pr_user;

DELETE FROM pr_user WHERE pr_username = 'censysad';
INSERT INTO pr_user (pr_name, pr_username, pr_password, pr_admin_yn)
	VALUES('ResRequest administrator', 'censysad', 'rSArkEJ4WhvxHK^9', 1);

DELIMITER //
CREATE PROCEDURE alter_pr_user_link()
BEGIN
	SET @dbname := DATABASE();
	SET @exists := FALSE;

	SELECT IF(count(*) > 0, TRUE, FALSE) INTO @exists
	FROM information_schema.COLUMNS c
	WHERE
	c.TABLE_SCHEMA    = @dbname
	AND c.TABLE_NAME  = 'pr_user_link'
	AND c.COLUMN_NAME = 'pr_cache_yn';
	IF @exists = FALSE THEN
		ALTER TABLE pr_user_link ADD COLUMN pr_cache_yn TINYINT(1) NOT NULL DEFAULT 0 AFTER cn_principal_id;
	END IF;
END;
//
DELIMITER ;
CALL alter_pr_user_link();
DROP PROCEDURE alter_pr_user_link;

/* RRDEV-868 Bridge multi-user enhancement */
ALTER TABLE pr_user_link CHANGE cn_principal_id cn_principal_id VARCHAR(4) NOT NULL DEFAULT '0';

DROP TABLE IF EXISTS ca_user;
CREATE TABLE ca_user (
	ca_user_id int(11) NOT NULL AUTO_INCREMENT,
	pr_user_link_id int(11),
	cn_principal_id varchar(4),
	pr_link_username varchar(25),
	pr_link_password varchar(50),
	ca_user_time timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
	PRIMARY KEY (ca_user_id),
	UNIQUE KEY (pr_user_link_id, cn_principal_id, pr_link_username)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;

DROP TABLE IF EXISTS ca_stock;
CREATE TABLE ca_stock (
	ac_accomm_type_id VARCHAR(13) NOT NULL,
	ca_stock_date DATE NOT NULL,
	ca_stock_amt INT(11) NOT NULL,
	ca_create_date DATE NOT NULL,
	ca_user_id INT(11),
	PRIMARY KEY (ac_accomm_type_id, ca_stock_date, ca_user_id)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;
