-- MySQL dump 10.15  Distrib 10.0.38-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: bridge_template
-- ------------------------------------------------------
-- Server version 10.0.38-MariaDB-0ubuntu0.16.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `acc_audit`
--

DROP TABLE IF EXISTS `acc_audit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `acc_audit` (
  `acc_audit_id` varchar(36) NOT NULL,
  `pr_user_id` int(11) NOT NULL,
  `pr_name` varchar(100) NOT NULL,
  `acc_audit_action` varchar(50) NOT NULL,
  `acc_audit_data` longtext NOT NULL,
  `neuro_user_id` varchar(36) NOT NULL,
  `neuro_user_name` varchar(64) NOT NULL,
  `acc_audit_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`acc_audit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_audit`
--

LOCK TABLES `acc_audit` WRITE;
/*!40000 ALTER TABLE `acc_audit` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_audit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_connection`
--

DROP TABLE IF EXISTS `acc_connection`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `acc_connection` (
  `acc_connection_id` varchar(36) NOT NULL,
  `pr_user_id` varchar(36) NOT NULL COMMENT 'pr_user ID',
  `acc_connection_int_ref` varchar(36) NOT NULL COMMENT 'Internal Reference (ie Helpspot number)',
  `acc_connection_note` longtext COMMENT 'Connection note',
  `acc_connection_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was created',
  `acc_connection_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was modified',
  PRIMARY KEY (`acc_connection_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_connection`
--

LOCK TABLES `acc_connection` WRITE;
/*!40000 ALTER TABLE `acc_connection` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_connection` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_connection_type`
--

DROP TABLE IF EXISTS `acc_connection_type`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `acc_connection_type` (
  `acc_connection_type_id` varchar(36) NOT NULL,
  `acc_connection_id` varchar(36) NOT NULL COMMENT 'Link to acc_connection',
  `acc_connection_type_role_id` varchar(36) NOT NULL COMMENT 'Link to acc_connection_type_role',
  `acc_connection_type_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was created',
  `acc_connection_type_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was modified',
  PRIMARY KEY (`acc_connection_type_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_connection_type`
--

LOCK TABLES `acc_connection_type` WRITE;
/*!40000 ALTER TABLE `acc_connection_type` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_connection_type` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_connection_type_role`
--

DROP TABLE IF EXISTS `acc_connection_type_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `acc_connection_type_role` (
  `acc_connection_type_role_id` varchar(36) NOT NULL,
  `acc_connection_type_role_name` varchar(36) NOT NULL COMMENT 'Account contact role name',
  `acc_connection_type_role_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was created',
  `acc_connection_type_role_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was modified',
  PRIMARY KEY (`acc_connection_type_role_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_connection_type_role`
--

LOCK TABLES `acc_connection_type_role` WRITE;
/*!40000 ALTER TABLE `acc_connection_type_role` DISABLE KEYS */;
INSERT INTO `acc_connection_type_role` VALUES ('2452415e-b5f5-11ea-9e55-0238f891fa5a','ResConnect Vendor Partner Programme','2020-06-24 10:31:46','2020-06-24 08:31:46'),('245242ee-b5f5-11ea-9e55-0238f891fa5a','Direct bookings - ResNova','2020-06-24 10:31:46','2020-06-24 08:31:46'),('2452435c-b5f5-11ea-9e55-0238f891fa5a','Direct bookings - Client website','2020-06-24 10:31:46','2020-06-24 08:31:46'),('245243a0-b5f5-11ea-9e55-0238f891fa5a','Guest Survey - eGuest Surv','2020-06-24 10:31:46','2020-06-24 08:31:46'),('24524400-b5f5-11ea-9e55-0238f891fa5a','Channel management - Expedia','2020-06-24 10:31:46','2020-06-24 08:31:46'),('2452446c-b5f5-11ea-9e55-0238f891fa5a','Channel management - Booking.com','2020-06-24 10:31:46','2020-06-24 08:31:46'),('245244d3-b5f5-11ea-9e55-0238f891fa5a','Channel management - Nightsbridge','2020-06-24 10:31:46','2020-06-24 08:31:46'),('24524515-b5f5-11ea-9e55-0238f891fa5a','Channel management - Siteminder','2020-06-24 10:31:46','2020-06-24 08:31:46'),('24524555-b5f5-11ea-9e55-0238f891fa5a','Channel management - Synxis','2020-06-24 10:31:46','2020-06-24 08:31:46'),('24524594-b5f5-11ea-9e55-0238f891fa5a','ResTrek','2020-06-24 10:31:46','2020-06-24 08:31:46'),('245245d5-b5f5-11ea-9e55-0238f891fa5a','Wetu','2020-06-24 10:31:46','2020-06-24 08:31:46'),('24524622-b5f5-11ea-9e55-0238f891fa5a','Travelogic','2020-06-24 10:31:46','2020-06-24 08:31:46'),('b1688659-cb55-11ea-99af-0238f891fa5a','POS - TallOrder','2020-07-21 15:25:49','2020-07-21 13:25:49');
/*!40000 ALTER TABLE `acc_connection_type_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_contact`
--

DROP TABLE IF EXISTS `acc_contact`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `acc_contact` (
  `acc_contact_id` varchar(36) NOT NULL,
  `acc_connection_id` varchar(36) NOT NULL COMMENT 'Link to acc_connection',
  `acc_contact_role_id` varchar(36) NOT NULL COMMENT 'Link to acc_contact_role',
  `acc_contact_name` varchar(50) NOT NULL COMMENT 'Account contact name',
  `acc_contact_email` varchar(50) DEFAULT NULL COMMENT 'Account contact email',
  `acc_contact_tel` varchar(50) DEFAULT NULL COMMENT 'Account contact telephone number',
  `acc_contact_note` longtext COMMENT 'Account contact note',
  `acc_contact_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was created',
  `acc_contact_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was modified',
  PRIMARY KEY (`acc_contact_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_contact`
--

LOCK TABLES `acc_contact` WRITE;
/*!40000 ALTER TABLE `acc_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `acc_contact` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `acc_contact_role`
--

DROP TABLE IF EXISTS `acc_contact_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `acc_contact_role` (
  `acc_contact_role_id` bigint(20) unsigned NOT NULL,
  `acc_contact_role_name` varchar(36) NOT NULL COMMENT 'Account contact role name',
  `acc_contact_role_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was created',
  `acc_contact_role_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was modified',
  PRIMARY KEY (`acc_contact_role_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acc_contact_role`
--

LOCK TABLES `acc_contact_role` WRITE;
/*!40000 ALTER TABLE `acc_contact_role` DISABLE KEYS */;
INSERT INTO `acc_contact_role` VALUES (26727193962872833,'Billing','2020-06-25 20:18:08','2020-06-25 18:18:08'),(26727193962872834,'Technical','2020-06-25 20:18:08','2020-06-25 18:18:08'),(26727193962872835,'Admin','2020-06-25 20:18:42','2020-06-25 18:18:42'),(26727193962872836,'Marketing','2020-06-25 20:18:42','2020-06-25 18:18:42');
/*!40000 ALTER TABLE `acc_contact_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ca_stock`
--

DROP TABLE IF EXISTS `ca_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ca_stock` (
  `ac_accomm_type_id` varchar(36) NOT NULL,
  `ca_stock_date` date NOT NULL,
  `ca_stock_amt` int(11) NOT NULL,
  `ca_create_date` date NOT NULL,
  `ca_user_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ac_accomm_type_id`,`ca_stock_date`,`ca_user_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ca_stock`
--

LOCK TABLES `ca_stock` WRITE;
/*!40000 ALTER TABLE `ca_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `ca_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ca_user`
--

DROP TABLE IF EXISTS `ca_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ca_user` (
  `ca_user_id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_user_link_principal_id` int(11) DEFAULT NULL,
  `cn_principal_id` varchar(4) DEFAULT NULL,
  `pr_link_username` varchar(25) DEFAULT NULL,
  `pr_link_password` varchar(50) DEFAULT NULL,
  `ca_user_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ca_user_id`),
  UNIQUE KEY `pr_user_link_id` (`pr_user_link_principal_id`,`cn_principal_id`,`pr_link_username`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ca_user`
--

LOCK TABLES `ca_user` WRITE;
/*!40000 ALTER TABLE `ca_user` DISABLE KEYS */;
/*!40000 ALTER TABLE `ca_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pr_user`
--

DROP TABLE IF EXISTS `pr_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pr_user` (
  `pr_user_id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_name` varchar(100) NOT NULL,
  `pr_username` varchar(100) NOT NULL,
  `pr_password` varchar(100) CHARACTER SET latin1 NOT NULL DEFAULT '',
  `pr_admin_yn` tinyint(1) NOT NULL DEFAULT '0',
  `ad_create_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`pr_user_id`)
) ENGINE=Aria AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=0 TRANSACTIONAL=0;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pr_user`
--

LOCK TABLES `pr_user` WRITE;
/*!40000 ALTER TABLE `pr_user` DISABLE KEYS */;
INSERT INTO `pr_user` VALUES (1,'ResRequest administrator','censysad','rSArkEJ4WhvxHK^9',1,'0000-00-00 00:00:00');
/*!40000 ALTER TABLE `pr_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pr_user_link`
--

DROP TABLE IF EXISTS `pr_user_link`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pr_user_link` (
  `pr_user_link_id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_user_id` int(11) NOT NULL DEFAULT '0',
  `ad_create_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pr_default_user_yn` tinyint(1) NOT NULL DEFAULT '0',
  `pr_name_first` varchar(50) NOT NULL,
  `pr_name_last` varchar(50) NOT NULL,
  PRIMARY KEY (`pr_user_link_id`)
) ENGINE=Aria AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=0 TRANSACTIONAL=0;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pr_user_link`
--

LOCK TABLES `pr_user_link` WRITE;
/*!40000 ALTER TABLE `pr_user_link` DISABLE KEYS */;
INSERT INTO `pr_user_link` VALUES (1,1,'0000-00-00 00:00:00',1,'default_user','default_user');
/*!40000 ALTER TABLE `pr_user_link` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pr_user_link_principal`
--

DROP TABLE IF EXISTS `pr_user_link_principal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pr_user_link_principal` (
  `pr_user_link_principal_id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_link_username` varchar(25) NOT NULL,
  `pr_link_password` varchar(25) NOT NULL,
  `cn_principal_id` varchar(4) NOT NULL,
  `pr_cache_yn` tinyint(1) NOT NULL DEFAULT '0',
  `pr_user_link_id` int(11) NOT NULL,
  `ad_create_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`pr_user_link_principal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pr_user_link_principal`
--

LOCK TABLES `pr_user_link_principal` WRITE;
/*!40000 ALTER TABLE `pr_user_link_principal` DISABLE KEYS */;
/*!40000 ALTER TABLE `pr_user_link_principal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rf_server`
--

DROP TABLE IF EXISTS `rf_server`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rf_server` (
  `rf_server_id` int(11) NOT NULL AUTO_INCREMENT,
  `rf_server_desc` varchar(50) NOT NULL DEFAULT '',
  `rf_server_suffix` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`rf_server_id`)
) ENGINE=Aria AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=0 TRANSACTIONAL=0;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rf_server`
--

LOCK TABLES `rf_server` WRITE;
/*!40000 ALTER TABLE `rf_server` DISABLE KEYS */;
INSERT INTO `rf_server` VALUES (1,'SA Server','resrequest.com'),(2,'US Server','us.resrequest.com');
/*!40000 ALTER TABLE `rf_server` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rf_system`
--

DROP TABLE IF EXISTS `rf_system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rf_system` (
  `rf_system_id` int(11) NOT NULL AUTO_INCREMENT,
  `rf_server_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`rf_system_id`)
) ENGINE=Aria AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 PAGE_CHECKSUM=0 TRANSACTIONAL=0;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rf_system`
--

LOCK TABLES `rf_system` WRITE;
/*!40000 ALTER TABLE `rf_system` DISABLE KEYS */;
INSERT INTO `rf_system` VALUES (1,1);
/*!40000 ALTER TABLE `rf_system` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'bridge_template'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2020-07-27 14:00:39
