CREATE TABLE `acc_audit` (
  `acc_audit_id` varchar(36) NOT NULL,
  `pr_user_id` int(11) NOT NULL,
  `pr_name` varchar(100) NOT NULL,
  `acc_audit_action` varchar(50) NOT NULL,
  `acc_audit_data` longtext NOT NULL,
  `neuro_user_id` varchar(36) NOT NULL,
  `neuro_user_name` varchar(64) NOT NULL,
  `acc_audit_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `acc_connection` (
  `acc_connection_id` varchar(36) NOT NULL,
  `pr_user_id` varchar(36) NOT NULL COMMENT 'pr_user ID',
  `acc_connection_int_ref` varchar(36) NOT NULL COMMENT 'Internal Reference (ie Helpspot number)',
  `acc_connection_note` longtext COMMENT 'Connection note',
  `acc_connection_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was created',
  `acc_connection_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was modified'
) ENGINE=Aria DEFAULT CHARSET=utf8mb4;

CREATE TABLE `acc_connection_type` (
  `acc_connection_type_id` varchar(36) NOT NULL,
  `acc_connection_id` varchar(36) NOT NULL COMMENT 'Link to acc_connection',
  `acc_connection_type_role_id` varchar(36) NOT NULL COMMENT 'Link to acc_connection_type_role',
  `acc_connection_type_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was created',
  `acc_connection_type_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was modified'
) ENGINE=Aria DEFAULT CHARSET=utf8mb4;

CREATE TABLE `acc_connection_type_role` (
  `acc_connection_type_role_id` varchar(36) NOT NULL,
  `acc_connection_type_role_name` varchar(36) NOT NULL COMMENT 'Account contact role name',
  `acc_connection_type_role_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was created',
  `acc_connection_type_role_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was modified'
) ENGINE=Aria DEFAULT CHARSET=utf8mb4;

INSERT INTO `acc_connection_type_role` (`acc_connection_type_role_id`, `acc_connection_type_role_name`, `acc_connection_type_role_create_time`, `acc_connection_type_role_modify_time`) VALUES
('2452415e-b5f5-11ea-9e55-0238f891fa5a', 'ResConnect Vendor Partner Programme', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('245242ee-b5f5-11ea-9e55-0238f891fa5a', 'Direct bookings - ResNova', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('2452435c-b5f5-11ea-9e55-0238f891fa5a', 'Direct bookings - Client website', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('245243a0-b5f5-11ea-9e55-0238f891fa5a', 'Guest Survey - eGuest Surv', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('24524400-b5f5-11ea-9e55-0238f891fa5a', 'Channel management - Expedia', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('2452446c-b5f5-11ea-9e55-0238f891fa5a', 'Channel management - Booking.com', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('245244d3-b5f5-11ea-9e55-0238f891fa5a', 'Channel management - Nightsbridge', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('24524515-b5f5-11ea-9e55-0238f891fa5a', 'Channel management - Siteminder', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('24524555-b5f5-11ea-9e55-0238f891fa5a', 'Channel management - Synxis', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('24524594-b5f5-11ea-9e55-0238f891fa5a', 'ResTrek', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('245245d5-b5f5-11ea-9e55-0238f891fa5a', 'Wetu', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('24524622-b5f5-11ea-9e55-0238f891fa5a', 'Travelogic', '2020-06-24 10:31:46', '2020-06-24 08:31:46'),
('b1688659-cb55-11ea-99af-0238f891fa5a', 'POS - TallOrder', '2020-07-21 15:25:49', '2020-07-21 13:25:49');

CREATE TABLE `acc_contact` (
  `acc_contact_id` varchar(36) NOT NULL,
  `acc_connection_id` varchar(36) NOT NULL COMMENT 'Link to acc_connection',
  `acc_contact_role_id` varchar(36) NOT NULL COMMENT 'Link to acc_contact_role',
  `acc_contact_name` varchar(50) NOT NULL COMMENT 'Account contact name',
  `acc_contact_email` varchar(50) DEFAULT NULL COMMENT 'Account contact email',
  `acc_contact_tel` varchar(50) DEFAULT NULL COMMENT 'Account contact telephone number',
  `acc_contact_note` longtext COMMENT 'Account contact note',
  `acc_contact_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was created',
  `acc_contact_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was modified'
) ENGINE=Aria DEFAULT CHARSET=utf8mb4;

CREATE TABLE `acc_contact_role` (
  `acc_contact_role_id` bigint(20) UNSIGNED NOT NULL,
  `acc_contact_role_name` varchar(36) NOT NULL COMMENT 'Account contact role name',
  `acc_contact_role_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was created',
  `acc_contact_role_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Timestamp of when record was modified'
) ENGINE=Aria DEFAULT CHARSET=utf8mb4;

INSERT INTO `acc_contact_role` (`acc_contact_role_id`, `acc_contact_role_name`, `acc_contact_role_create_time`, `acc_contact_role_modify_time`) VALUES
(26727193962872833, 'Billing', '2020-06-25 20:18:08', '2020-06-25 18:18:08'),
(26727193962872834, 'Technical', '2020-06-25 20:18:08', '2020-06-25 18:18:08'),
(26727193962872835, 'Admin', '2020-06-25 20:18:42', '2020-06-25 18:18:42'),
(26727193962872836, 'Marketing', '2020-06-25 20:18:42', '2020-06-25 18:18:42');

ALTER TABLE `acc_audit`
  ADD PRIMARY KEY (`acc_audit_id`);

ALTER TABLE `acc_connection`
  ADD PRIMARY KEY (`acc_connection_id`);

ALTER TABLE `acc_connection_type`
  ADD PRIMARY KEY (`acc_connection_type_id`);

ALTER TABLE `acc_connection_type_role`
  ADD PRIMARY KEY (`acc_connection_type_role_id`);

ALTER TABLE `acc_contact`
  ADD PRIMARY KEY (`acc_contact_id`);

ALTER TABLE `acc_contact_role`
  ADD PRIMARY KEY (`acc_contact_role_id`);