-- Migrate acc_connection to pr_user

ALTER TABLE `pr_user` ADD `pr_inactive_yn` TINYINT(1) NOT NULL DEFAULT '0' AFTER `pr_admin_yn`;
ALTER TABLE `pr_user` ADD `pr_user_note` LONGTEXT NOT NULL AFTER `pr_password`;
ALTER TABLE `pr_user` ADD `pr_user_reference` VARCHAR(36) NOT NULL AFTER `pr_user_note`;
ALTER TABLE `pr_user` ADD `ad_modify_date` timestamp on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP AFTER `ad_create_date`;

UPDATE
  pr_user
  LEFT JOIN acc_connection on acc_connection.pr_user_id = pr_user.pr_user_id
SET
  pr_user.pr_user_note = acc_connection.acc_connection_note,
  pr_user.pr_user_reference = acc_connection.acc_connection_int_ref,
  pr_user.ad_modify_date = pr_user.ad_create_date;

-- Update user pr_user_link and pr_user_link_principal tables

ALTER TABLE `pr_user_link` ADD `ad_modify_date` timestamp on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP AFTER `ad_create_date`;
UPDATE `pr_user_link` SET `ad_modify_date` = `ad_create_date`;
ALTER TABLE `pr_user_link` ADD `pr_inactive_yn` TINYINT(1) NOT NULL DEFAULT '0' AFTER `pr_name_last`;

ALTER TABLE `pr_user_link_principal` ADD `ad_modify_date` timestamp on update CURRENT_TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP AFTER `ad_create_date`;
UPDATE `pr_user_link_principal` SET `ad_modify_date` = `ad_create_date`;
ALTER TABLE `pr_user_link_principal` ADD `pr_inactive_yn` TINYINT(1) NOT NULL DEFAULT '0' AFTER `pr_user_link_id`;

-- Migrate acc_connection_type to pr_user_role

CREATE TABLE `pr_user_role` (
  `pr_user_role_id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_user_id` int(11) DEFAULT NULL,
  `sc_user_role_id` int(11) DEFAULT NULL,
  `pr_user_role_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`pr_user_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `sc_user_role` (
  `sc_user_role_id` int(11) NOT NULL AUTO_INCREMENT,
  `sc_user_role_name` varchar(36) DEFAULT NULL,
  `sc_user_role_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`sc_user_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

ALTER TABLE `sc_user_role` ADD `old_id` varchar(36) AFTER `sc_user_role_created`;

INSERT INTO sc_user_role (sc_user_role_name, old_id)
SELECT
    acc_connection_type_role_name, acc_connection_type_role_id
FROM
  acc_connection_type_role;

INSERT INTO pr_user_role (pr_user_id, sc_user_role_id)
SELECT
  pr_user.pr_user_id,
  sc_user_role.sc_user_role_id
FROM
  pr_user
  LEFT JOIN acc_connection on acc_connection.pr_user_id = pr_user.pr_user_id
  LEFT JOIN acc_connection_type on acc_connection_type.acc_connection_id = acc_connection.acc_connection_id
  LEFT JOIN sc_user_role on sc_user_role.old_id = acc_connection_type.acc_connection_type_role_id
WHERE
  sc_user_role.sc_user_role_id IS NOT NULL;

ALTER TABLE sc_user_role DROP old_id;

-- Migrate acc_contact

CREATE TABLE `pr_user_contact` (
  `pr_user_contact_id` int(11) NOT NULL AUTO_INCREMENT,
  `pr_user_id` int(11) DEFAULT NULL,
  `sc_contact_role_id` int(11) DEFAULT NULL,
  `pr_user_contact_name` varchar(50) NOT NULL,
  `pr_user_contact_email` varchar(50) DEFAULT NULL,
  `pr_user_contact_tel` varchar(50) DEFAULT NULL,
  `pr_user_contact_note` longtext,
  `pr_user_contact_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `pr_user_contact_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`pr_user_contact_id`)
) ENGINE=Aria DEFAULT CHARSET=utf8mb4;

CREATE TABLE `sc_contact_role` (
  `sc_contact_role_id` int(11) NOT NULL AUTO_INCREMENT,
  `sc_contact_role_name` varchar(36) DEFAULT NULL,
  `sc_contact_role_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`sc_contact_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

ALTER TABLE `sc_contact_role` ADD `old_id` varchar(36) AFTER `sc_contact_role_created`;

INSERT INTO sc_contact_role (sc_contact_role_name, old_id)
SELECT
    acc_contact_role_name, acc_contact_role_id
FROM
  acc_contact_role;

INSERT INTO pr_user_contact (
  pr_user_id,
  sc_contact_role_id,
  pr_user_contact_name,
  pr_user_contact_email,
  pr_user_contact_tel,
  pr_user_contact_note,
  pr_user_contact_create_time,
  pr_user_contact_modify_time
)
SELECT
  pr_user.pr_user_id,
  sc_contact_role.sc_contact_role_id,
  acc_contact.acc_contact_name,
  acc_contact.acc_contact_email,
  acc_contact.acc_contact_tel,
  acc_contact.acc_contact_note,
  acc_contact.acc_contact_create_time,
  acc_contact.acc_contact_modify_time
FROM
  pr_user
  LEFT JOIN acc_connection on acc_connection.pr_user_id = pr_user.pr_user_id
  LEFT JOIN acc_contact on acc_contact.acc_connection_id = acc_connection.acc_connection_id
  LEFT JOIN sc_contact_role on sc_contact_role.old_id = acc_contact.acc_contact_role_id
WHERE
  sc_contact_role.sc_contact_role_id IS NOT NULL;

ALTER TABLE sc_contact_role DROP old_id;

-- Create audit tables

CREATE TABLE `ad_user` (
  `ad_user_id` int(11) NOT NULL AUTO_INCREMENT,
  `ad_user_desc` text NOT NULL,
  `pr_user_id` int(11) DEFAULT NULL,
  `ad_user_actioned_by_pr_user_id` int(11) DEFAULT NULL,
  `ad_user_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`ad_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE `ad_user_detail` (
  `ad_user_detail_id` int(11) NOT NULL AUTO_INCREMENT,
  `ad_user_id` int(11) NOT NULL,
  `ad_user_detail_action_desc` text NOT NULL,
  `ad_user_detail_value_from` text NOT NULL,
  `ad_user_detail_value_to` text NOT NULL,
  `ad_user_detail_action_ind` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ad_user_detail_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Remove old tables
DROP TABLE acc_connection_type;
DROP TABLE acc_connection_type_role;
DROP TABLE acc_contact;
DROP TABLE acc_contact_role;
DROP TABLE acc_connection;
