<?php

function getLinkDomain() {
	global $config;
	global $lDB;

	$result = false;
	if(isset($_SERVER['SERVER_NAME'])) {
		foreach($config['link_domain']['overrides'] as $domain) {
			if(preg_match("/".$domain."$/",$_SERVER['SERVER_NAME'])) {
				$result = $domain;
			}
		}
	}

	if(empty($result)) {
		$result = trim($lDB->get("
			SELECT
				rf_server.rf_server_suffix
			FROM
				rf_system
				INNER JOIN rf_server ON rf_server.rf_server_id = rf_system.rf_server_id
			WHERE
				rf_system.rf_system_id = 1
		",4));
	}

	if(empty($result)) {
		$result = $config['link_domain']['default'];
	}

	return $result;
}

function debug($output, $level=0) {
	global $config;

	if(!$config['debug']['enabled']) return;
	if($config['debug']['level'] < $level) return;

	error_log(print_r($output,true));
}

function dateSubtract($date2, $date1,$extra="0") {
   $s = strtotime($date2)-strtotime($date1);
   $d = round($s/86400);
   return (string) $d;
}

function dateRanges($dates) {
	sort($dates);
	$ranges = array();
	$new = true;
	$count = 0;
	$expectedDate = false;
	foreach($dates as $date) {
		if(!$new && $expectedDate != $date) {
			$new = true;
			$count++;
		}

		$expectedDate = date("Y-m-d", strtotime($date . " +1 day"));

		if($new) {
			$ranges[$count] = array(
				'start_date'=>$date,
				'end_date'=>$date
			);
			$new = false;
		} else {
			$ranges[$count]['end_date'] = $date;
		}
	}
	return $ranges;
}
