<?php

require_once(__DIR__ . '/../../../class.queue.php');
require_once(__DIR__ . '/../../../worker/functions.worker.php');
require_once(__DIR__ . '/../class.mysql.php');

require_once(__DIR__ . '/../inc.config.php');

log_message("Starting stock worker");

$queue = new Queue("bridge");
$queue->watch("stock_change");


while($job = $queue->next()) {
	$lDB = new MySQLDB($config['db']['bridge'],$config['db']['username'],$config['db']['password']);

	$lastWeek = date("Y-m-d H:i:s",strtotime("-1 week"));
	$users = $lDB->get("
		SELECT
			ca_user_id
		FROM
			ca_user
			INNER JOIN pr_user_link ON pr_user_link.pr_user_link_id = ca_user.pr_user_link_id
		WHERE
			ca_user.cn_principal_id = '".$lDB->escape($job['principal_id'])."'
			AND pr_user_link.pr_cache_yn = '1'
			AND ca_user.ca_user_time >= '$lastWeek'
	",3);
	$lDB->close();
	unset($lDB);

	log_message("Found ".sizeof($users)." users");
	foreach($users as $user) {
		$data = array(
			'ca_user_id'=>$user,
			'ac_accomm_type_id'=>$job['ac_accomm_type_id'],
			'dates'=>$job['dates']
		);
		$result = $queue->create("stock_change_user",$data);
		if(empty($result)) {
			// TODO implement monitoring
			error_log("Error queueing bridge stock user change for " . $user . ", principal " . $job['principal_id'] . ", accommodation type " . $job['ac_accomm_type_id'] . " for dates: " . join(", ",$job['dates']));
			$queue->release(5);
			continue;
		}
	}

	$queue->delete();
}
