<?php

require_once(__DIR__ . '/../../../class.queue.php');
require_once(__DIR__ . '/../../../class.rpc.php');
require_once(__DIR__ . '/../../../worker/functions.worker.php');
require_once(__DIR__ . '/../class.cache.php');
require_once(__DIR__ . '/../class.mysql.php');
require_once(__DIR__ . '/../functions.bridge.php');

require_once(__DIR__ . '/../inc.config.php');

chdir("../api");
require_once(__DIR__ . '/../class.bridge.php');

global $config;
global $lDB;

log_message("Starting stock change user worker");

$queue = new Queue("bridge");
$queue->watch("stock_change_user");

$bridge = new Bridge();

while($job = $queue->next()) {
	$today = date("Y-m-d");

	$lDB = new MySQLDB($config['db']['bridge'],$config['db']['username'],$config['db']['password']);

	$user = $lDB->get("
		SELECT
			pr_user_link.pr_user_id,
			pr_user_link.pr_user_link_id,
			ca_user.cn_principal_id,
			ca_user.pr_link_username,
			ca_user.pr_link_password,
			pr_user_link.pr_cache_yn
		FROM
			ca_user
			INNER JOIN pr_user_link ON pr_user_link.pr_user_link_id = ca_user.pr_user_link_id
		WHERE
			ca_user.ca_user_id = '".$job['ca_user_id']."'
	",1);

	$lDB->put("
		DELETE FROM
			ca_stock
		WHERE
			ca_stock.ca_user_id = '".$lDB->escape($job['ca_user_id'])."'
			AND ca_stock.ac_accomm_type_id = '".$lDB->escape($job['ac_accomm_type_id'])."'
			AND ca_stock.ca_create_date = '$today'
			AND ca_stock.ca_stock_date IN ('".join("','",$job['dates'])."')
	");

	$cache = new Cache();
	$prefix = join("_",array(
		"stock",
		$today,
		$job['ca_user_id'],
		$job['ac_accomm_type_id']
	));
	foreach($job['dates'] as $date) {
		$cache->delete($prefix . "_" . $date);
	}

	$ranges = dateRanges($job['dates']);

	$bridge->User = $user['pr_user_id'];
	$bridge->Admin = true;
	$bridge->Auth = array(
		'ca_user_id'=>$job['ca_user_id'],
		'link_id'=>$user['pr_user_link_id'],
		'principal_id'=>$user['cn_principal_id'],
		'principal_username'=>$user['pr_link_username'],
		'principal_password'=>$user['pr_link_password'],
		'cache'=>($user['pr_cache_yn'] == "1"?true:false)
	);
	$bridge->LookupHost($user['cn_principal_id']);
	foreach($ranges as $range) {
		$result = api_bridge_ac_get_stock($job['ac_accomm_type_id'], $range['start_date'], $range['end_date']);
	}

	$lDB->close();
	unset($lDB);

	log_message("Cache refreshed for pr_user_id " . $user['pr_user_id'] . ", ca_user_id " . $job['ca_user_id'] . ", principal " . $user['cn_principal_id'] . ", user " . $user['pr_link_username'] . ", ac_accomm_type_id " . $job['ac_accomm_type_id']);

	$queue->delete();
}
