/******************************
* Internal functions          *
******************************/

$(document).ready(function() {
	$('[data-toggle="datepicker"]').datepicker({
		format: 'yyyy-mm-dd',
		autoHide: true
	  });
});

function folioRegenerate(actionIt) {
	$("#folioStatus").hide();
	$("#folioSpinner").show();
	$("#folioCheckButton").attr("disabled", "disabled");
	$("#folioRegenerateButton").attr("disabled", "disabled");

	var data = {};
	data['action'] = 'regenerateGetReservationList';
	data['startDate'] = $('#folioStartDate').val();
	data['endDate'] = $('#folioEndDate').val();
	data['dateBasedOn'] = $('#folioDateBasedOn').val();
	data['status'] = [];
	if ($("#folioStatusConfirmed").is(":checked")) {
		data['status'].push("30");
	}
	if ($("#folioStatusProvisional").is(":checked")) {
		data['status'].push("20");
	}
	if ($("#folioStatusQuotation").is(":checked")) {
		data['status'].push("0");
	}
	if ($("#folioStatusWaitlisted").is(":checked")) {
		data['status'].push("10");
	}
	if ($("#folioStatusCancelled").is(":checked")) {
		data['status'].push("90");
	}

	if ($("#folioStartDate").val() != "" && $("#folioEndDate").val() != "") {
		var dStart = new Date($("#folioStartDate").val());
		var dEnd = new Date($("#folioEndDate").val());
		if (dStart.getTime() > dEnd.getTime()) {
			$("#folioSpinner").hide();
			$("#folioCheckButton").removeAttr('disabled');
			alert("The start date can not be later than the end date");
			return;			
		}
	}

	if (data['status'].length == 0) {
		$("#folioSpinner").hide();
		$("#folioCheckButton").removeAttr('disabled');
		alert("Select at least one status");
		return;
	}

	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: data
	})
	.done(function( result ) {
		result = JSON.parse(result);
		var data = [];
		$.each( result, function( index, value ){
			numberOfRes = index;
			data.push(value);
		});
		if (numberOfRes > 0) {
			numberOfRes++;
		}
		completedRes = 0;
		$("#folioSpinner").hide();
		$("#folioStatus").show();
		if (numberOfRes > 0) {
			$("#folioStatusText").html("<div>" + numberOfRes + " reservations to be regenerated</div>");
		} else {
			$("#folioStatusText").html("<div>No qualifying reservations found, please adjust your criteria</div>");
		}

		if (actionIt != undefined && actionIt) {
			startTime = new Date();
			folioRegenerateAction(data);
		} else {
			$("#folioCheckButton").removeAttr('disabled');
			if (numberOfRes > 0) {
				$("#folioRegenerateButton").removeAttr('disabled');
			}
		}
	});
}

var startTime = new Date();
var numberOfRes = 0;
var completedRes = 0;

function folioRegenerateAction(reservations) {
	if (reservations.length > 0) {
		var data = {};
		data['action'] = 'folioRegenerateReservation';
		data['resId'] = reservations.shift();
		
		$.ajax({
			method: "POST",
			url: "ajax.php",
			data: data
		})
		.done(function( resultRes ) {
			completedRes++;
			var progressPercentage = Math.ceil((100/numberOfRes)*completedRes);
			$("#folioProgressbar").val(progressPercentage);
			var endTime = new Date();
			var diff = endTime.getTime() - startTime.getTime();
			$("#folioProgressText").html("Completed: " + progressPercentage + "%<br>Time: " + secondsToHms(Math.floor(diff / 1000)));
			folioRegenerateAction(reservations);
		});
	} else {
		$("#folioCheckButton").removeAttr('disabled');
		$("#folioRegenerateButton").removeAttr('disabled');
	}
}

function paymentRegenerate(actionIt) {
	$("#paymentSpinner").show();
	$("#paymentCheckButton").attr("disabled", "disabled");
	$("#paymentRegenerateButton").attr("disabled", "disabled");

	var data = {};
	data['action'] = 'regenerateGetReservationList';
	data['startDate'] = $('#paymentStartDate').val();
	data['dateBasedOn'] = $('#paymentDateBasedOn').val();
	data['paymentFuture'] = $('#paymentFuture').val();
	data['status'] = [];
	if ($("#paymentStatusConfirmed").is(":checked")) {
		data['status'].push("30");
	}
	if ($("#paymentStatusProvisional").is(":checked")) {
		data['status'].push("20");
	}
	if ($("#paymentStatusQuotation").is(":checked")) {
		data['status'].push("0");
	}
	if ($("#paymentStatusWaitlisted").is(":checked")) {
		data['status'].push("10");
	}
	if ($("#paymentStatusCancelled").is(":checked")) {
		data['status'].push("90");
	}

	if (data['status'].length == 0) {
		$("#paymentSpinner").hide();
		$("#paymentCheckButton").removeAttr('disabled');
		alert("Select at least one status");
		return;
	}

	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: data
	})
	.done(function( result ) {
		result = JSON.parse(result);
		
		var numberOfRes = 0;
		var completedRes = 0;
		$.each( result, function( index, value ){
			numberOfRes = index;
		});
		if (numberOfRes > 0) {
			numberOfRes++;
		}
		
		$("#paymentSpinner").hide();
		$("#paymentStatus").show();
		if (numberOfRes > 0) {
			$("#paymentStatusText").html("<div>" + numberOfRes + " reservations to be regenerated</div>");
		} else {
			$("#paymentStatusText").html("<div>No qualifying reservations found, please adjust your criteria</div>");
		}

		if (actionIt != undefined && actionIt) {
			var startTime = new Date();
			$.each( result, function( index, value ){
				numberOfRes = index;
				numberOfRes++;
				var data = {};
				data['action'] = 'paymentRegenerateReservation';
				data['resId'] = value;
				data['paymentFuture'] = $('#paymentFuture').val();

				$.ajax({
					method: "POST",
					url: "ajax.php",
					data: data
				})
				.done(function( resultRes ) {
					completedRes++;
					var progressPercentage = Math.ceil((100/numberOfRes)*completedRes);
					$("#paymentProgressbar").val(progressPercentage);
					var endTime = new Date();
					var diff = endTime.getTime() - startTime.getTime();
					$("#paymentProgressText").html("Completed: " + progressPercentage + "%<br>Time: " + secondsToHms(Math.floor(diff / 1000)));
				});
			});
		} else {
			$("#paymentCheckButton").removeAttr('disabled');
			if (numberOfRes > 0) {
				$("#paymentRegenerateButton").removeAttr('disabled');
			}
		}
	});
}

function itineraryRegenerate(actionIt) {
	$("#itinerarySpinner").show();
	$("#itineraryCheckButton").attr("disabled", "disabled");
	$("#itineraryRegenerateButton").attr("disabled", "disabled");

	var data = {};
	data['action'] = 'regenerateGetReservationList';
	data['startDate'] = $('#itineraryStartDate').val();
	data['dateBasedOn'] = $('#itineraryDateBasedOn').val();
		data['status'] = [];
	if ($("#itineraryStatusConfirmed").is(":checked")) {
		data['status'].push("30");
	}
	if ($("#itineraryStatusProvisional").is(":checked")) {
		data['status'].push("20");
	}
	if ($("#itineraryStatusQuotation").is(":checked")) {
		data['status'].push("0");
	}
	if ($("#itineraryStatusWaitlisted").is(":checked")) {
		data['status'].push("10");
	}
	if ($("#itineraryStatusCancelled").is(":checked")) {
		data['status'].push("90");
	}

	if (data['status'].length == 0) {
		$("#itinerarySpinner").hide();
		$("#itineraryCheckButton").removeAttr('disabled');
		alert("Select at least one status");
		return;
	}

	$.ajax({
		method: "POST",
		url: "ajax.php",
		data: data
	})
	.done(function( result ) {
		result = JSON.parse(result);
		var numberOfRes = 0;
		var completedRes = 0;
		$.each( result, function( index, value ){
			numberOfRes = index;
		});
		if (numberOfRes > 0) {
			numberOfRes++;
		}

		$("#itinerarySpinner").hide();
		$("#itineraryStatus").show();
		if (numberOfRes > 0) {
			$("#itineraryStatusText").html("<div>" + numberOfRes + " reservations to be regenerated</div>");
		} else {
			$("#itineraryStatusText").html("<div>No qualifying reservations found, please adjust your criteria</div>");
		}

		if (actionIt != undefined && actionIt) {
			var startTime = new Date();
			$.each( result, function( index, value ){
				numberOfRes = index;
				numberOfRes++;
				var data = {};
				data['action'] = 'itineraryRegenerateReservation';
				data['resId'] = value;

				$.ajax({
					method: "POST",
					url: "ajax.php",
					data: data
				})
				.done(function( resultRes ) {
					completedRes++;
					var progressPercentage = Math.ceil((100/numberOfRes)*completedRes);
					$("#itineraryProgressbar").val(progressPercentage);
					var endTime = new Date();
					var diff = endTime.getTime() - startTime.getTime();
					$("#itineraryProgressText").html("Completed: " + progressPercentage + "%<br>Time: " + secondsToHms(Math.floor(diff / 1000)));
				});
			});
		} else {
			$("#itineraryCheckButton").removeAttr('disabled');
			if (numberOfRes > 0) {
				$("#itineraryRegenerateButton").removeAttr('disabled');
			}
		}
	});
}

function secondsToHms(d) {
    d = Number(d);
	var hours = ('0' + Math.floor(d / 3600)).slice(-2);
	var minutes = ('0' + Math.floor(d % 3600 / 60)).slice(-2);
	var seconds = ('0' + Math.floor(d % 3600 % 60)).slice(-2);
    return hours + ":" + minutes + ":" + seconds; 
}

function validateDate(dateField) {
	var date = $("#" + dateField).val();

	if (date == "") {
		return true;
	}
	
	var d = new Date(date);
	if (isNaN(d.getTime())) {
		$("#" + dateField).val("");
		return false;
	}

	var year = d.getFullYear();
	var month = ('0' + (d.getMonth()+1)).slice(-2);
	var day = ('0' + d.getDate()).slice(-2);

	$("#" + dateField).val(year + '-' + month + '-' + day);	
	return true;
}