<?php

 /**
  * class.regenerate.php - Regenerate
  */

class Regenerate{

    private $data = array();
    private $stagingDir = "staging";
    private $packageDir = "package";
    private $applicationDir = "resrequest";
    private $logDir = "logs";

    public function __construct($data){
        $this->data = $data;
        require_once(__DIR__ . '/../../class.mysqldb.php');           // MySQL DB Class  # obvious
        require_once(__DIR__ . '/../../class.mysqldb.php');           // MySQL DB Class  # obvious
        require_once(__DIR__ . '/../../functions.system.php');
        require_once(__DIR__ . '/../../functions.php');
        require_once(__DIR__ . '/../../inc.setup.php');               // Database Connection, customised setup and config file
        require_once(__DIR__ . '/../../ac_logon.php');             // Access Control Results
        require_once(__DIR__ . '/../../functions.transfer.common.php');
        require_once(__DIR__ . '/../../db.rv_reservation.php');
        require_once(__DIR__ . '/../../functions.financial.php');
    }

    public function regenerateGetReservationList() {
        $where = "1";
        switch ($this->data['dateBasedOn']) {
            case "reservationCreation":
                $whereField = "rv_reservation.rv_date_recorded";
                break;
            case "reservationArrival":
                $whereField = "rv_reservation.rv_date_arrive";
                break;
            case "reservationDeparture":
                $whereField = "rv_reservation.rv_date_depart";
                break;
        }

        if (!empty($this->data['startDate'])) {
            $where .= " AND " . $whereField . " >= '" . $this->data['startDate'] . "'";
        }

        if (!empty($this->data['endDate'])) {
            $where .= " AND " . $whereField . " <= '" . $this->data['endDate'] . "'";
        }

        $where .= " AND rv_reservation.rf_reservation_status_id IN (" . join(', ', $this->data['status']) . ")";

        $reservations = $GLOBALS['lDB']->get("
            SELECT
                rv_reservation.rv_reservation_ix
            FROM
                fn_folio
                LEFT JOIN rv_reservation ON rv_reservation.rv_reservation_ix = fn_folio.rv_reservation_id
            WHERE
                " . $where . "
                AND (
                    fn_folio.fn_invoice_id IS NULL
                    OR fn_folio.fn_invoice_id = ''
                )
                AND fn_folio.fn_folio_amount != fn_folio.fn_folio_amt_paid
        ",3);

        $reservations = array_unique($reservations);
        $reservations = array_values($reservations);

        return json_encode($reservations);
    }

    public function folioRegenerateReservation() {
        regenBilling($this->data['resId']);
		ammendReservation($this->data['resId'], "Regenerate costs");
		ammendReservation($this->data['resId'], "Update payment plan");
        return $this->data['resId'];
    }

    public function itineraryRegenerateReservation() {
        regenReservation($this->data['resId']);
        ammendReservation($this->data['resId'],"Regenerate All Itineraries");
        specialAutoApply($this->data['resId']);
        return $this->data['resId'];
    }

    public function paymentRegenerateReservation() {
        $processPast = $this->data['paymentFuture'] == "paymentFutureAndPast" ? true : false;
        $this->genPaymentPlanTool($this->data['resId'], "", array(), $processPast);
        ammendReservation($this->data['resId'],"Update payment plan");
        return $this->data['resId'];
    }

    function genPaymentPlanTool($rvReservationId, $ac_pay_plan_id="", $fnFolioList=array(), $processPast=false) {
        global $lDB;

        // This function is copied from Enterprise code for use in this tool.
        // It has been modified slightly to optionally skip the checking for past dates.
        // This will allow this function to regenerate payment plans for past reservations as well
        
        # Step1: Initialise - obtain reservation details: base dates & res amount
    
        // Obtain reservation dates
        $resDates = $lDB->get("
            SELECT
                rv_reservation.rv_confirmation_date,
                rv_reservation.rv_prov_date,
                rv_reservation.rv_date_recorded,
                rv_reservation.rv_commission_deduct_yn
            FROM
                rv_reservation
            WHERE
                rv_reservation.rv_reservation_ix='$rvReservationId'
        ",1);
    
        // Obtain earliest arrival date
        $arriveDate = $lDB->get("
            SELECT
                rv_reservation_item.rv_item_date_arrive
            FROM
                rv_reservation_item
            WHERE
                rv_reservation_item.rv_reservation_id='$rvReservationId'
            ORDER BY
                rv_reservation_item.rv_item_date_arrive
            LIMIT 1
        ",1);
    
        // Obtain latest departure date
        $departDate = $lDB->get("
            SELECT
                rv_reservation_item.rv_item_date_depart
            FROM
                rv_reservation_item
            WHERE
                rv_reservation_item.rv_reservation_id='$rvReservationId'
            ORDER BY
                rv_reservation_item.rv_item_date_depart DESC
            LIMIT 1
        ",1);
    
        // Set up base date 2 (reservation date)
        if ($resDates['rv_confirmation_date'] > 0) {
            $base2 = $resDates['rv_confirmation_date'];
        } else if ($resDates['rv_prov_date'] > 0) {
            $base2 = $resDates['rv_prov_date'];
        } else {
            $base2 = $resDates['rv_date_recorded'];
        }
    
        // Set up Base date 4 (arrival) and base date 6 (departure)
        $base4 = $arriveDate[0];
        $base6 = $departDate[0];
    
        // Obtain full reservation payment amount
        if (sizeof($fnFolioList) > 0) {
            // find out how the totals are populated... from component level (sigh).
            // IDEA! Just sum the totals for the just created invoice / folios that relate to this DB! YEAH!
            $resAmt = $lDB->get("SELECT SUM(fn_folio_amount) FROM fn_folio WHERE fn_folio_ix IN ('".join("','",$fnFolioList)."')",4);
        } else {
            //$resAmt = getDisplayResTotals($rvReservationId);
            $resDB = $lDB->get("SELECT rv_reservation_db FROM rv_reservation WHERE rv_reservation_ix = '$rvReservationId'",4);
            $resEnv = $lDB->get("SELECT rf_db_env_type_ind FROM rf_database WHERE rf_db_code = '$resDB'",4);
            $invCurr = $lDB->get("SELECT rv_invoice_currency_id FROM rv_reservation WHERE rv_reservation_ix = '$rvReservationId'",4);
            $resAmt = $lDB->get("
                SELECT 
                    SUM(fn_folio_amount)
                FROM
                    fn_folio
                    INNER JOIN rf_database ON fn_folio.fn_folio_db = rf_database.rf_db_code
                WHERE
                    rf_database.rf_db_env_type_ind = '$resEnv'
                    AND fn_folio.rv_reservation_id='$rvReservationId'        
                    AND fn_folio.rf_currency_id = '$invCurr'
            ",4);
        }
    
        # Step 2: Derive payment dates and amounts
    
        // Obtain payment plan template
    
        // If the chosen payment plan is not found, get it off the reservation...
        if(!db_ac_pay_plan_exists($ac_pay_plan_id)) {
            $ac_pay_plan_id = $lDB->get("SELECT ac_pay_plan_id FROM rv_reservation WHERE rv_reservation_ix = '$rvReservationId'",4);
        }
    
        // ...if it is still not found, use the default
        if(!db_ac_pay_plan_exists($ac_pay_plan_id)) {
            $ac_pay_plan_id = $lDB->get("SELECT ac_pay_plan_id FROM rf_default",4);
        }
    
        // ..if it is still not found, return
        if(!db_ac_pay_plan_exists($ac_pay_plan_id)) {
            return false;
        }
    
        $pr_agent_id = $lDB->get("SELECT rv_agent_id FROM rv_reservation WHERE rv_reservation_ix = '$rvReservationId'",4);
        if(!empty($pr_agent_id)) {
            $agent = $lDB->get("
                SELECT
                    ac_pay_final_base,
                    ac_pay_final_days
                FROM
                    pr_agent
                WHERE
                    pr_agent_id = '$pr_agent_id'
            ",1);
            if($agent['ac_pay_final_base'] != "2") {
                $agent = false;
            }
        } else {
            $agent = false;
        }
        
        $payItems = $lDB->get("
            SELECT
                ac_pay_item.ac_pay_base,
                ac_pay_item.ac_pay_days,
                ac_pay_item.ac_pay_final_base,
                ac_pay_item.ac_pay_final_days,
                ac_pay_item.ac_pay_final_agent_override_yn,
                ac_pay_item.ac_pay_amount_ind,
                ac_pay_item.ac_pay_amount
            FROM
                ac_pay_item
            WHERE
                ac_pay_item.ac_pay_plan_id='$ac_pay_plan_id'
            ORDER BY
                ac_pay_item.ac_pay_amount_ind
        ",2);
    
        if(sizeof($payItems) < 1) {
            return false;
        }
    
        $today = date("Y-m-d");
        $percResAmt = $resAmt;
        // Set up actual pay dates
        $newPayItems = array();
        foreach($payItems as $item) {
            switch($item['ac_pay_base']) {
            case 2:
                $payDate = $base2;
                break;
            case 4:
                $payDate = $base4;
                break;
            case 6:
            default:
                $payDate = $base6;
                break;
            }
    
            // Apply date offset
            $payDateArray = explode("-",$payDate);
            $payDate = date("Y-m-d",mktime(0,0,0,$payDateArray[1],$payDateArray[2] + $item['ac_pay_days'],$payDateArray[0]));
    
            if($item['ac_pay_final_base'] == "2") {
                if($agent && $item['ac_pay_final_agent_override_yn'] == "1") {
                    $item['ac_pay_final_days'] = $agent['ac_pay_final_days'];
                }
                $payDateArray = explode("-",$payDate);
                if($item['ac_pay_final_days'] < 1) {
                    $monthOffset = 1;
                } else {
                    $monthOffset = 0;
                }
                $newPayDate = date("Y-m-d",mktime(0,0,0,$payDateArray[1]+$monthOffset,$item['ac_pay_final_days'],$payDateArray[0]));
                if($newPayDate < $payDate) {
                    $newPayDate = date("Y-m-d",mktime(0,0,0,$payDateArray[1]+$monthOffset+1,$item['ac_pay_final_days'],$payDateArray[0]));              
                }
                $payDate = $newPayDate;
            }
    
            if (!$processPast) {
                // Check that pay date is not in the past
                if($payDate < $today) {
                    $payDate = $today;
                }
            }
    
            $item['payDate'] = $payDate;
    
            // Calculate payment amount
            if($item['ac_pay_amount_ind'] == "2") {
                $item['payAmt'] = $item['ac_pay_amount'];
                $percResAmt -= $item['ac_pay_amount'];
            } else {
                $item['payAmt'] = $percResAmt * $item['ac_pay_amount'] / 100;
            }
            fixAmtDisplay($item['payAmt']);
    
            // Consolidate payments allocated to the same day into one entry
            if(!array_key_exists($payDate,$newPayItems)) {
                $newPayItems[$payDate] = $item;
            } else {
                $newPayItems[$payDate]['payAmt'] += $item['payAmt'];
            }
        }
        ksort($newPayItems);
    
        // Verify we don't lose a cent in the rounding.
        $total = "0.00";
        foreach($newPayItems as $item) {
            $total += $item['payAmt'];
            $last = $item['payDate'];
        }
        if($resAmt != $total) {
            $diff = $resAmt - $total;
            $newPayItems[$last]['payAmt'] = $newPayItems[$last]['payAmt'] + $diff;
        }
    
    
        # Step 3: Delete existing payment plan
        if (!$lDB->count("rv_pay_plan_item","rv_reservation_id",$rvReservationId,"0")) {
            $list = $lDB->get("SELECT rv_pay_plan_item.rv_pay_plan_item_ix as rv_pay_plan_item_id FROM rv_pay_plan_item WHERE rv_reservation_id = '$rvReservationId'",3);
            foreach($list as $item) {
                $lDB->put("DELETE FROM rv_pay_plan_item WHERE rv_pay_plan_item.rv_pay_plan_item_ix = '".$item."'");
            }
        }
        
        // Create payment plan entries
        foreach($newPayItems as $item) {
            $lDB->put("
                INSERT INTO rv_pay_plan_item (
                    rv_pay_plan_item_db,
                    rv_reservation_id,
                    rv_pay_plan_date,
                    rv_pay_plan_amount
                ) VALUES (
                    '$GLOBALS[dbcode]',
                    '$rvReservationId',
                    '$item[payDate]',
                    '$item[payAmt]'
                )
            ");
            $rv_pay_plan_item_ix = $lDB->insert_id;
            $lDB->put("UPDATE rv_reservation SET ac_pay_plan_id = '$ac_pay_plan_id' WHERE rv_reservation_ix = '$rvReservationId'");
        }
    
        return $newPayItems;
    }
}