<?php
    if (!isset($_SESSION['userName']) || strtolower($_SESSION['userName']) != 'censysad') {
        header('Location: /utils/');
        exit;
    }
	include("header.php");
?>

<div class="uk-container uk-padding-large-bottom">


    <ul id="tabsPrincipal" class="uk-child-width-expand uk-margin-top uk-margin-bottom" uk-tab uk-switcher>
        <li class="uk-active"><a href="#">Folios</a></li>
        <li class=""><a href="#">Itineraries</a></li>
        <li class=""><a href="#">Payment Plans</a></li>
    </ul>

	<ul class="uk-switcher uk-margin">
		<li class="uk-open">
			<div class="uk-text-large uk-margin-bottom">Folios</div>
            <div>This action will remove existing accommodation costs and payment plans, replacing them with new calculations (overrides will not be removed). This will only affect folios which have no payment/s against them.</div>
            <div class="uk-margin-top uk-margin-bottom"><strong>NOTE: This action is extremely intensive, and may take a long time to perform.</strong></div>

            <div uk-grid>
                <div class="uk-width-1-2">
                    <label class="uk-form-label" for="folioStartDate">Start date: (leave empty for earliest)</label>
                    <input class="uk-input" id="folioStartDate" type="text" placeholder="Start date" onchange="validateDate('folioStartDate');" data-toggle="datepicker">
                </div>
                <div class="uk-width-1-2">
                    <label class="uk-form-label" for="folioEndDate">End date: (leave empty for future)</label>
                    <input class="uk-input" id="folioEndDate" type="text" placeholder="End date" onchange="validateDate('folioEndDate');" data-toggle="datepicker">
                </div>
                <div class="uk-width-1-2">
                    <label class="uk-form-label" for="folioDateBasedOn">
                        Start and end dates based on:
                    </label>
                    <select class="uk-select" id="folioDateBasedOn">
                        <option value="reservationCreation">Reservation Creation</option>
                        <option value="reservationArrival">Reservation Arrival</option>
                        <option value="reservationDeparture">Reservation Departure</option>
                    </select>
                </div>
                <div class="uk-width-1-2">
                    <div>Statuses:</div>
                    <div><label><input id="folioStatusConfirmed" class="uk-checkbox" type="checkbox" checked> Confirmed</label></div>
                    <div><label><input id="folioStatusProvisional" class="uk-checkbox" type="checkbox" checked> Provisional</label></div>
                    <div><label><input id="folioStatusQuotation" class="uk-checkbox" type="checkbox" checked> Quotation</label></div>
                    <div><label><input id="folioStatusWaitlisted" class="uk-checkbox" type="checkbox"> Waitlisted</label></div>
                    <div><label><input id="folioStatusCancelled" class="uk-checkbox" type="checkbox"> Cancelled</label></div>
                </div>
            </div>
            <button id="folioCheckButton" class="uk-button uk-button-primary uk-margin-top uk-margin-bottom" type="button" onclick="folioRegenerate(false);">Check number of reservations</button>
            <button id="folioRegenerateButton" class="uk-button uk-button-primary uk-margin-top uk-margin-bottom" type="button" onclick="folioRegenerate(true);" disabled>Regenerate</button>

            <div id="folioSpinner" style="display: none; margin-left: 140px;">
                <div uk-spinner></div>
            </div>
            <div id="folioStatus" style="display: none;">
                <span id="folioStatusText"></span>
                <div id="folioProgressText"></div>
                <progress id="folioProgressbar" class="uk-progress" value="0" max="100"></progress>
            </div>
		</li>
		<li>
			<div class="uk-text-large">Itineraries</div>
            <div>This action will remove existing accommodation costs, replacing them with new calculations (overrides will not be removed). This will only affect folios which have not been invoiced.</div>
            <div></div>
            <div class="uk-margin-top uk-margin-bottom"><strong>NOTE: This action is extremely intensive, and may take a long time to perform.</strong></div>

            <div uk-grid>
                <div class="uk-width-1-3">
                    <label class="uk-form-label" for="itineraryStartDate">Start date:</label>
                    <input class="uk-input" id="itineraryStartDate" type="text" placeholder="Start date" onchange="validateDate('itineraryStartDate');" data-toggle="datepicker">
                </div>
                <div class="uk-width-1-3">
                    <label class="uk-form-label" for="itineraryDateBasedOn">
                        Start date based on:
                    </label>
                    <select class="uk-select" id="itineraryDateBasedOn">
                        <option value="reservationCreation">Reservation Creation</option>
                        <option value="reservationArrival">Reservation Arrival</option>
                        <option value="reservationDeparture">Reservation Departure</option>
                    </select>
                </div>
                <div class="uk-width-1-3">
                    <div>Statuses:</div>
                    <div><label><input id="itineraryStatusConfirmed" class="uk-checkbox" type="checkbox" checked> Confirmed</label></div>
                    <div><label><input id="itineraryStatusProvisional" class="uk-checkbox" type="checkbox" checked> Provisional</label></div>
                    <div><label><input id="itineraryStatusQuotation" class="uk-checkbox" type="checkbox" checked> Quotation</label></div>
                    <div><label><input id="itineraryStatusWaitlisted" class="uk-checkbox" type="checkbox"> Waitlisted</label></div>
                    <div><label><input id="itineraryStatusCancelled" class="uk-checkbox" type="checkbox"> Cancelled</label></div>
                </div>
            </div>
            <button id="itineraryCheckButton" class="uk-button uk-button-primary uk-margin-top uk-margin-bottom" type="button" onclick="itineraryRegenerate(false);">Check number of reservations</button>
            <button id="itineraryRegenerateButton" class="uk-button uk-button-primary uk-margin-top uk-margin-bottom" type="button" onclick="itineraryRegenerate(true);" disabled>Regenerate</button>

            <div id="itinerarySpinner" style="display: none; margin-left: 140px;">
                <div uk-spinner></div>
            </div>
            <div id="itineraryStatus" style="display: none;">
                <span id="itineraryStatusText"></span>
                <div id="itineraryProgressText"></div>
                <progress id="itineraryProgressbar" class="uk-progress" value="0" max="100"></progress>
            </div>
		</li>
		<li>
			<div class="uk-text-large">Payment Plans</div>
            <div>This action will regenerate existing reservation payment plans, replacing them with new calculations. This will only affect outstanding payment amounts.</div>
            <div class="uk-margin-top uk-margin-bottom"><strong>NOTE: This action is extremely intensive, and may take a long time to perform.</strong></div>

            <div uk-grid>
                <div class="uk-width-1-2">
                    <label class="uk-form-label" for="paymentStartDate">Start date:</label>
                    <input class="uk-input" id="paymentStartDate" type="text" placeholder="Start date" onchange="validateDate('paymentStartDate');" data-toggle="datepicker">
                </div>
                <div class="uk-width-1-2">
                    <label class="uk-form-label" for="paymentDateBasedOn">
                        Start date based on:
                    </label>
                    <select class="uk-select" id="paymentDateBasedOn">
                        <option value="reservationCreation">Reservation Creation</option>
                        <option value="reservationArrival">Reservation Arrival</option>
                        <option value="reservationDeparture">Reservation Departure</option>
                    </select>
                </div>
                <div class="uk-width-1-2">
                    <label class="uk-form-label" for="paymentFuture">
                        Payment plans:
                    </label>
                    <select class="uk-select" id="paymentFuture">
                        <option value="paymentFutureOnly">Future plans only</option>
                        <option value="paymentFutureAndPast">Past and future plans</option>
                    </select>
                </div>
                <div class="uk-width-1-2">
                    <div>Statuses:</div>
                    <div><label><input id="paymentStatusConfirmed" class="uk-checkbox" type="checkbox" checked> Confirmed</label></div>
                    <div><label><input id="paymentStatusProvisional" class="uk-checkbox" type="checkbox" checked> Provisional</label></div>
                    <div><label><input id="paymentStatusQuotation" class="uk-checkbox" type="checkbox" checked> Quotation</label></div>
                    <div><label><input id="paymentStatusWaitlisted" class="uk-checkbox" type="checkbox"> Waitlisted</label></div>
                    <div><label><input id="paymentStatusCancelled" class="uk-checkbox" type="checkbox"> Cancelled</label></div>
                </div>
            </div>
            <button id="paymentCheckButton" class="uk-button uk-button-primary uk-margin-top uk-margin-bottom" type="button" onclick="paymentRegenerate(false);">Check number of reservations</button>
            <button id="paymentRegenerateButton" class="uk-button uk-button-primary uk-margin-top uk-margin-bottom" type="button" onclick="paymentRegenerate(true);" disabled>Regenerate</button>

            <div id="paymentSpinner" style="display: none; margin-left: 140px;">
                <div uk-spinner></div>
            </div>
            <div id="paymentStatus" style="display: none;">
                <span id="paymentStatusText"></span>
                <div id="paymentProgressText"></div>
                <progress id="paymentProgressbar" class="uk-progress" value="0" max="100"></progress>
            </div>
		</li>
	</ul>

</div>