<?php
require_once(__DIR__ . "/../../functions.php");
session_init();

require_once(__DIR__ . "/../../class.mysqldb.php");
require_once(__DIR__ . "/../../inc.ixfields.php");
require_once(__DIR__ . "/../../functions.php");
require_once(__DIR__ . "/../../db.rv_extra.php");


$GLOBALS['debugEcho'] = true;
$GLOBALS['debug'] = 0;
$GLOBALS['enableIXfields'] = "1";
$GLOBALS['incrementSequence'] = 1;    // Activate sequencing
$GLOBALS['flagChngs'] = "1";
$GLOBALS['flagDels'] = "1";
$GLOBALS['dbUpgradeInProcess'] = false;

function printHeader() {
?>
<html>
<head>
	<title>CC setup</title>
	<script src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/cc_setup/prototype.js" type="text/javascript" language="javascript"></script>
	<script src="/resource/Resrequest/Application/public/include/js/system.js" type="text/javascript" language="javascript"></script>
	<script src="/resource/Resrequest/Application/public/include/js/ajax.js" type="text/javascript" language="javascript"></script>
</head>
	<body onload="startup();">
<script language="javascript">
var startupList = new Array();

function addStartup(aItem) {
	startupList[startupList.length] = aItem;
}

function startup() {
	var count;

	for(count=0; count<startupList.length; count++) {
		startupList[count]();
	}
}

function selIndex(objectId) {
   return $(objectId).options[$(objectId).selectedIndex].index;
}

function selValue(objectId) {
   return $(objectId).options[$(objectId).selectedIndex].value;
}

function selLabel(objectId) {
   return $(objectId).options[$(objectId).selectedIndex].innerHTML;
}

function getBrowserVersion(){
   // convert all characters to lowercase to simplify testing
   var agt=navigator.userAgent.toLowerCase();

   // *** BROWSER VERSION ***
   // Note: On IE5, these return 4, so use is_ie5up to detect IE5.
   var is_major = parseInt(navigator.appVersion);
   var is_minor = parseFloat(navigator.appVersion);

   var is_ie     = ((agt.indexOf("msie") != -1) && (agt.indexOf("opera") == -1));
   var is_ie3    = (is_ie && (is_major < 4));
   var is_ie4    = (is_ie && (is_major == 4) && (agt.indexOf("msie 4")!=-1) );
   var is_ie5    = (is_ie && (is_major == 4) && (agt.indexOf("msie 5.0")!=-1) );
   var is_ie5_5up =(is_ie && !is_ie3 && !is_ie4 && !is_ie5);

   if(!is_ie){
      return "nav";
   }

   if(is_ie5_5up){
      return true;
   }else{
      return false;
   }
}

var browserVersion = getBrowserVersion();

function mainReply(rReady, rResult) {
	$("btnMenu").show();
	if(rReady) {
		$("mainSpan").innerHTML = rResult.stripScripts();
		installScript(rResult.extractScripts());
		waitHide();
	}
}

function menuGoto(gTo) {
	var lNames = new Array();
	var lValues = new Array();
	waitStartup();
	aRequestReset();
	aRequestPost(gTo+".php", mainReply, lNames, lValues);
}


function installScript( script )
{
    if (!script)
        return;
    //  Internet Explorer has a funky execScript method that makes this easy
    if (window.execScript)
        window.execScript( script );
    else
        window.setTimeout( script, 0 );
}


</script>
<style>
	* {
		font-family: arial, helvetica;
		/*font-variant: small-caps;*/
		font-weight: normal;
		font-size: 14px;
		background-color: #e0ffe0;
		color: black;
	}
	h1 {
		font-size: 22px;
		font-weight: bolder;
		text-decoration: underline overline;
	}
	h2 {
		font-size: 16px;
		font-weight: bold;
	}
	textarea {
		font-family: monospace;
		background-color: #ffffff;
	}
	select,option {
		background-color: #ffffff;
	}
	.dbLink {
		display: block;
		border: 1px dotted black;
		padding: 5px;
		margin: -1px;
		width: 400px;
	}
	.textbox {
		display: block;
		border: 2px inset;
		background-color: white;
		margin: 1px;
		padding: 2px;
		color: #808080;
	}
	input,textarea,select {
		border-color: #80ff80;
	}
	input[type="button"] {
		background-color: #80ff80;
	}
	pre,input[type="text"],input[type="password"] {
		background-color: #ffffff;
	}
	.fixinput {
		width: 200px;
	}

	.fixedTable {
		table-layout: fixed;
	}

	.waitIcon {
		position: absolute;
		top: 0;
		left: 0;
		z-index: 10;
		background-color: black;
		border: 4px solid #80ff80;
	}

	.hide {
		display: none;
	}
</style>

<table border=0 cellspacing=0 cellpadding=0>
<tr>
	<td valign=middle><img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/cc_setup/injection.jpg" style="width:100px; height:100px; border-width:2; border-color: #000000; border-style: solid;"></td>
	<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
	<td valign=middle><h1>CC setup</h1></td>
</tr>
</table>
<br>
<?php	
}

function printMainStart() {
	echo '<span id="mainSpan">';
}

function printMainEnd() {
	echo '</span>';
}


function printFooter() {
?>
</body>
</html>
<?php
}

function printLogout() {
?>
<table border=0 cellpadding=1 cellspacing=1>
<tr>
	<td><input type="button" value="Menu" onclick="loadMenu();" id="btnMenu"></td>
	<td><input type="button" value="Logout" onclick="processLogout();"></td>
</tr>
</table>
<script language="javascript">
function processLogout() {
	var pNames = new Array();
	var pValues = new Array();
	aRequestReset();
	aRequestPost("logout.php", logoutReply, pNames, pValues);	
}

function logoutReply(rReady, rResult) {
	if(rReady) {
		window.location = "index.php";
	}
}

function loadMenu() {
	var lNames = new Array();
	var lValues = new Array();
	aRequestReset();
	aRequestPost("menu.php", mainReply, lNames, lValues);
	waitStartup();
}
</script>	
<?php	
}

function printLogin() {
?>
<span id="loginSpan">
<table border=0 cellpadding=1 cellspacing=1>
<tr>
	<td>Password</td>
	<td><input type="password" value="" id="loginPassword" onkeypress="return loginKeyPress(event);">
</tr>
<tr>
	<td><input type="button" value="Login" onclick="processLogin();"></td>
</tr>
</table>
<script language="javascript">
function processLogin() {
	var pNames = new Array("loginPassword");
	var pValues = new Array($("loginPassword").value);
	aRequestReset();
	aRequestPost("login.php", loginReply, pNames, pValues);	
	waitStartup();
}

function loginReply(rReady, rResult) {
	if(rReady) {
		if(rResult == "yes") {
			window.location = "index.php";
		} else {
			alert("Invalid login");
			waitHide();
		}
	}
}

function loginKeyPress(e) {
	if(!e) { e = event; }

	if(e.keyCode == 13) {
		processLogin();
	}
}

</script>
</span>
<?php
}

function printWait() {
?>
<div id="waitSpan" class="waitIcon">
	<table width="100%" height="100%">
	<tr>
		<td align="center" valign="middle" style="background-color:black;"><img src="/resource/Resrequest/Application/src/Resrequest/legacy/utils/cc_setup/ajax-loader.gif"></td>
	</tr>
	</table>
<script language="javascript">
function waitStartup() {
	if(browserVersion == "nav") {
		var waitWidth = window.innerWidth * 0.3;
		var waitHeight = window.innerHeight * 0.3;
		var waitLeft = window.innerWidth / 2 - waitWidth / 2;
		var waitTop = window.innerHeight / 2 - waitHeight / 2;
	} else {
		var waitWidth = document.body.offsetWidth * 0.3;
		var waitHeight = document.body.offsetHeight * 0.3;
		var waitLeft = document.body.offsetWidth / 2 - waitWidth / 2;
		var waitTop = document.body.offsetHeight / 2 - waitHeight / 2;
	}

	$("waitSpan").style.width = waitWidth;;
	$("waitSpan").style.height = waitHeight;

	$("waitSpan").style.left = waitLeft;
	$("waitSpan").style.top = waitTop;

	$("waitSpan").className = "waitIcon";
}
waitStartup();

function waitHide() {
	$("waitSpan").className = "hide";
}
addStartup(waitHide);
</script>
</div>
<?php
}

function checkLogin() {
	if(!$_SESSION['loggedInAutoCc']) {
		redirectTo(" index.php");
		die();		
	}
}

function connectDB() {
	// Connect to the censys table an get the principal id
	$cDB = new MySQLDB("censys","root","",$_SESSION['dbHost']);
	$prnInfo = $cDB->get("
		SELECT
			cn_principal_id,
			cn_prn_name,
			cn_prn_name_short,
			cn_prn_db_me_id
		FROM
			cn_principal
		WHERE
			cn_prn_name_short = '$_SESSION[dbClient]'
	",1);

	// Get the DB id
	$databaseId = $prnInfo['cn_prn_db_me_id'];
	if($databaseId == "0" || $databaseId == "") {
		$prnInfo['cn_prn_db_me_id'] =  $cDB->get("SELECT cn_sys_db_me_id FROM cn_system",4);
	}

	$GLOBALS['lDB'] = new MySQLDB("cn_live_".str_pad($prnInfo['cn_principal_id'],4,"0",STR_PAD_LEFT),"root","",$_SESSION['dbHost']);

	$GLOBALS['dbcode'] = $GLOBALS['lDB']->get("SELECT rf_db_code FROM rf_database WHERE rf_database_id = '$prnInfo[cn_prn_db_me_id]'",4);

	$GLOBALS['isWebServer'] = false;
	if ($GLOBALS['dbcode'][0] == "W") {
	   $GLOBALS['isWebServer'] = true;
	}

	$GLOBALS['trTables'] = $GLOBALS['lDB']->get("SELECT tc_table_name FROM tc_table",3);	

	return $prnInfo;
}

function addTags($aValues,$aHTML) {
	$keys = array_keys($aValues);
	$newKeys = array();
	foreach($keys as $item) {
		array_push($newKeys,"!$item!");
	}
	return str_replace($newKeys,$aValues,$aHTML);
}

function getHTML($gFilename) {
	$sectionArray = preg_split("/\|\|(\w*?)\|\|/",join("\n",file(__DIR__ . "/" . $gFilename)),-1,PREG_SPLIT_DELIM_CAPTURE);
	$htmlArray = array();
	for($count=0; $count < floor(sizeof($sectionArray)/2); $count++) {
		$htmlArray[$sectionArray[($count*2)+1]] = trim($sectionArray[$count*2]);
	}
	return $htmlArray;
}
