<?php

require_once(__DIR__ . "/functions.php");
require_once(__DIR__ . "/../../db.pf_object.php");
require_once(__DIR__ . "/../../db.pf_option.php");
require_once(__DIR__ . "/../../db.pf_field.php");

checkLogin();

$prnInfo = connectDB();

global $lDB;

$docObj = db_pf_object_by_name("email_document");
$proformaObj = db_pf_object_by_name("email_proforma");
$invoiceObj = db_pf_object_by_name("email_invoice");

if(isset($_POST['action']) && $_POST['action'] == "add") {
	$pf_level_link_id = false;
	if($_POST['pf_level_ind'] == 5) {
		$pf_level_link_id = $_POST['pf_level_env'];
	}
	if($_POST['pf_level_ind'] == 7) {
		$pf_level_link_id = $_POST['pf_level_user'];
	}
	$pf_option_id = db_pf_option_insert($_POST['pf_object_id'],$_POST['pf_email'],"",$_POST['pf_level_ind'],$pf_level_link_id,true);
	db_pf_field_insert($pf_option_id,"email_address",$_POST['pf_email']);
}

if(isset($_POST['action']) && $_POST['action'] == "delete") {
	db_pf_option_delete($_POST['pf_option_id']);
}

$HTML = getHTML("setup.htm");

$ccList = $lDB->get("
	SELECT
		pf_option.pf_option_ix,
		pf_option.pf_object_id,
		pf_level_ind,
		pf_level_link_id
	FROM
		pf_option
	WHERE
		pf_option.pf_object_id IN ('$docObj','$proformaObj','$invoiceObj')
",2);
$rows = "";

foreach($ccList as $item) {
	$item['pf_action'] = addTags(array('pf_option_id'=>$item['pf_option_ix']),$HTML['delete_button']);
	$item['pf_level_env'] = "n/a";
	$item['pf_level_user'] = "n/a";
	switch($item['pf_object_id']) {
	case $docObj:
		$item['pf_object_desc'] = "Reservation summary document";
		break;
	case $proformaObj:
		$item['pf_object_desc'] = "Proforma (folio) document";
		break;
	case $invoiceObj:
		$item['pf_object_desc'] = "Invoice document";
		break;
	}
	switch($item['pf_level_ind']) {
	case 1:
		$item['pf_level_desc'] = "System";
		break;
	case 3:
		$item['pf_level_desc'] = "Global";
		break;
	case 5:
		$item['pf_level_desc'] = "Environment";
		$item['pf_level_env'] = $item['pf_level_link_id'];
		break;
	case 7:
		$item['pf_level_desc'] = "User";
		$user = $lDB->get("SELECT pr_name_last,pr_name_first FROM pr_persona WHERE pr_persona_ix = '$item[pf_level_link_id]'",1);
		$item['pf_level_user'] = trim($user['pr_name_last'] . ", " . $user['pr_name_first']);
		break;
	}
	$item['pf_email'] = db_pf_field_by_name($item['pf_option_ix'],"email_address");
	$rows .= addTags($item,$HTML['row']);
}

$envList = $lDB->get("
	SELECT
		rf_database.rf_db_code,
		rf_database.rf_db_description
	FROM
		rf_database
	ORDER BY
		rf_db_code
",2);
$envOptions = "";
foreach($envList as $item) {
	$envOptions .= "
		<option value=\"$item[rf_db_code]\">$item[rf_db_code]: $item[rf_db_description]</option>
	";
}

$userList = $lDB->get("
	SELECT
		pr_persona.pr_persona_ix,
		pr_persona.pr_name_last,
		pr_persona.pr_name_first
	FROM
		pr_user
		INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_user.pr_user_id
	ORDER BY
		pr_persona.pr_name_last,
		pr_persona.pr_name_first
",2);
$userOptions = "";
foreach($userList as $item) {
	$pr_name = "$item[pr_name_last], $item[pr_name_first]";
	$userOptions .= "
		<option value=\"$item[pr_persona_ix]\">$pr_name</option>
	";
}

$rows .= addTags(array(
	'pf_object_desc'=>addTags(array('doc'=>$docObj,'folio'=>$proformaObj,'invoice'=>$invoiceObj),$HTML['object_select']),
	'pf_level_desc'=>$HTML['level_select'],
	'pf_level_env'=>addTags(array('env_options'=>$envOptions),$HTML['env_select']),
	'pf_level_user'=>addTags(array('user_options'=>$userOptions),$HTML['user_select']),
	'pf_email'=>$HTML['email_input'],
	'pf_action'=>$HTML['add_button']
),$HTML['row']);

$content = addTags(array('rows'=>$rows),$HTML['table']);

if(!isset($_POST['action']) || $_POST['action'] == "") {
	echo addTags(array('content'=>$content,'script'=>$HTML['script']),$HTML['container']);
} else {
	echo $content;
}
