<?php


function respondJson($output, $responseCode=200)
{
    header('Content-Type: application/json');
    http_response_code($responseCode);
    echo json_encode($output);
}

function respondWithError($errorCode, $errorMessage)
{
    http_response_code($errorCode);
    $error = [
        'error' => $errorMessage
    ];
    respondJson($error, $errorCode);
}

function handleGetDiagnosis()
{
    $invalidInvoices = getInvalidInvoiceTransactions();
    $invalidPayments = getInvalidPaymentTransactions();
    $invalidDeposits = getInvalidDepositTransactions();
    $itemlessDepositReversals = getItemlessDepositReversalTransactions();
    $wrongValueDepositReversals = getWrongValueDepositReversalTransactions();
    $missingDepositReversals = getMissingDepositReversalTransactions();
    $itemlessVoidedInvoices = getItemlessVoidedInvoiceTransactions();
    $wrongValueVoidedInvoices = getWrongValueVoidedInvoiceTransactions();
    $itemlessVoidedDepositReversals = getItemlessVoidedDepositReversalTransactions();
    $wrongValueVoidedDepositReversals = getWrongValueVoidedDepositReversalTransactions();

    $allTransactions = array_merge(
        $invalidInvoices,
        $invalidPayments,
        $invalidDeposits,
        $itemlessDepositReversals,
        $wrongValueDepositReversals,
        $missingDepositReversals,
        $itemlessVoidedInvoices,
        $wrongValueVoidedInvoices,
        $itemlessVoidedDepositReversals,
        $wrongValueVoidedDepositReversals
    );

    $report = diagnosisReport(
        $invalidInvoices,
        $invalidPayments,
        $invalidDeposits,
        $itemlessDepositReversals,
        $wrongValueDepositReversals,
        $missingDepositReversals,
        $itemlessVoidedInvoices,
        $wrongValueVoidedInvoices,
        $itemlessVoidedDepositReversals,
        $wrongValueVoidedDepositReversals
    );

    $fileName = logDiagnosis($report);
    respondJson(['diagnosis_file' => $fileName]);
}

function handleFixIssues()
{
    $invalidInvoices = getInvalidInvoiceTransactions();
    $invalidPayments = getInvalidPaymentTransactions();
    $invalidDeposits = getInvalidDepositTransactions();
    $itemlessDepositReversals = getItemlessDepositReversalTransactions();
    $wrongValueDepositReversals = getWrongValueDepositReversalTransactions();
    $missingDepositReversals = getMissingDepositReversalTransactions();
    $itemlessVoidedInvoices = getItemlessVoidedInvoiceTransactions();
    $wrongValueVoidedInvoices = getWrongValueVoidedInvoiceTransactions();
    $itemlessVoidedDepositReversals = getItemlessVoidedDepositReversalTransactions();
    $wrongValueVoidedDepositReversals = getWrongValueVoidedDepositReversalTransactions();

    $report = diagnosisReport(
        $invalidInvoices,
        $invalidPayments,
        $invalidDeposits,
        $itemlessDepositReversals,
        $wrongValueDepositReversals,
        $missingDepositReversals,
        $itemlessVoidedInvoices,
        $wrongValueVoidedInvoices,
        $itemlessVoidedDepositReversals,
        $wrongValueVoidedDepositReversals
    );

    $diagnosisFile = logDiagnosis($report);

    foreach ($invalidPayments as $fn_tran_id) {
        fixInvalidPaymentTransaction($fn_tran_id);
    }

    foreach ($invalidDeposits as $fn_tran_id) {
        fixInvalidDepositTransaction($fn_tran_id);
    }

    foreach ($invalidInvoices as $fn_tran_id) {
        fixInvalidInvoiceTransaction($fn_tran_id);
    }

    foreach ($itemlessDepositReversals as $fn_tran_id) {
        fixItemlessDepositReversalTransaction($fn_tran_id);
    }

    foreach ($wrongValueDepositReversals as $fn_tran_id) {
        fixWrongValueDepositReversalTransaction($fn_tran_id);
    }

    $missingReversals = [];
    foreach ($missingDepositReversals as $fn_tran_id) {
        array_push(
            $missingReversals,
            fixMissingDepositReversalTransaction($fn_tran_id)
        );
    }
    $missingDepositReversals = $missingReversals;
    unset($missingReversals);

    foreach ($itemlessVoidedInvoices as $fn_tran_id) {
        fixItemlessVoidedInvoiceTransaction($fn_tran_id);
    }

    foreach ($wrongValueVoidedInvoices as $fn_tran_id) {
        fixWrongValueVoidedInvoiceTransaction($fn_tran_id);
    }

    foreach ($itemlessVoidedDepositReversals as $fn_tran_id) {
        fixItemlessVoidedDepositReversalTransaction($fn_tran_id);
    }

    foreach ($wrongValueVoidedDepositReversals as $fn_tran_id) {
        fixWrongValueVoidedDepositReversalTransaction($fn_tran_id);
    }

    $allTransactions = array_merge(
        $invalidInvoices,
        $invalidPayments,
        $invalidDeposits,
        $itemlessDepositReversals,
        $wrongValueDepositReversals,
        $missingDepositReversals,
        $itemlessVoidedInvoices,
        $wrongValueVoidedInvoices,
        $itemlessVoidedDepositReversals,
        $wrongValueVoidedDepositReversals
    );

    $note = '_fix_see_HS_226534';
    if (count($allTransactions) > 0) {
        addNoteToBatches($allTransactions, $note);
    }

    $tranReport = tranExportReport($allTransactions);
    $tranReportFile = createTransactionExportFile($tranReport);
    $tranItemReport = tranItemExportReport($allTransactions);
    $tranItemReportFile = createTransactionItemExportFile($tranItemReport);

    respondJson([
        'diagnosis_file' => $diagnosisFile,
        'transaction_export_file' => $tranReportFile,
        'transaction_item_export_file' => $tranItemReportFile
    ]);
}

function handleDownload($fileName)
{
    if (file_exists(__DIR__ . "/$fileName")) {
        header("Content-type: text/csv");
        header("Content-disposition: attachment; filename = $fileName");
        readfile(__DIR__ . "/$fileName");
    } else {
        respondWithError(404, 'The file requested does not exist');
    }
}

function logDiagnosis($diagnosis)
{
    $principal_id = $GLOBALS['principal_id'];
    $fileName = "[$principal_id]" .'_' . date('Y-m-d_H:i:s') . '.log';
    $logFileName =  __DIR__ . '/logs/' . $fileName;
    $fh = @fopen($logFileName, 'a');
    $output = "===========================================\n";
    $output .= date('Y-m-d H:i:s') . " [$principal_id] childless_tran results:\n\n";

    $count = count($diagnosis['batched_invalid_invoices']);
    $output .= "Batched Invalid Invoices ($count):\n";
    foreach ($diagnosis['batched_invalid_invoices'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['unbatched_invalid_invoices']);
    $output .= "Unbatched Invalid Invoices ($count):\n";
    foreach ($diagnosis['unbatched_invalid_invoices'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['batched_invalid_payments']);
    $output .= "Batched Invalid Payments ($count):\n";
    foreach ($diagnosis['batched_invalid_payments'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['unbatched_invalid_payments']);
    $output .= "Unbatched Invalid Payments ($count):\n";
    foreach ($diagnosis['unbatched_invalid_payments'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['batched_invalid_deposits']);
    $output .= "Batched Invalid Deposits ($count):\n";
    foreach ($diagnosis['batched_invalid_deposits'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['unbatched_invalid_deposits']);
    $output .= "Unbatched Invalid Deposits ($count):\n";
    foreach ($diagnosis['unbatched_invalid_deposits'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['batched_itemless_deposit_reversals']);
    $output .= "Batched Itemless Deposit Reversals ($count):\n";
    foreach ($diagnosis['batched_itemless_deposit_reversals'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['unbatched_itemless_deposit_reversals']);
    $output .= "Unbatched Itemless Deposit Reversals ($count):\n";
    foreach ($diagnosis['unbatched_itemless_deposit_reversals'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['batched_wrong_value_deposit_reversals']);
    $output .= "Batched Wrong Value Deposit Reversals ($count):\n";
    foreach ($diagnosis['batched_wrong_value_deposit_reversals'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['unbatched_wrong_value_deposit_reversals']);
    $output .= "Unbatched Wrong Value Deposit Reversals ($count):\n";
    foreach ($diagnosis['unbatched_wrong_value_deposit_reversals'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['unbatched_missing_deposit_reversals']);
    $output .= "Unbatched Missing Deposit Reversals ($count):\n";
    foreach ($diagnosis['unbatched_missing_deposit_reversals'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['batched_itemless_voided_invoices']);
    $output .= "Batched Itemless Voided Invoices ($count):\n";
    foreach ($diagnosis['batched_itemless_voided_invoices'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['unbatched_itemless_voided_invoices']);
    $output .= "Unbatched Itemless Voided Invoices ($count):\n";
    foreach ($diagnosis['unbatched_itemless_voided_invoices'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['batched_wrong_value_voided_invoices']);
    $output .= "Batched Wrong Value Voided Invoices ($count):\n";
    foreach ($diagnosis['batched_wrong_value_voided_invoices'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['unbatched_wrong_value_voided_invoices']);
    $output .= "Unbatched Wrong Value Voided Invoices ($count):\n";
    foreach ($diagnosis['unbatched_wrong_value_voided_invoices'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['batched_itemless_voided_deposit_reversals']);
    $output .= "Batched Itemless Voided Deposit Reversals ($count):\n";
    foreach ($diagnosis['batched_itemless_voided_deposit_reversals'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['unbatched_itemless_voided_deposit_reversals']);
    $output .= "Unbatched Itemless Voided Deposit Reversals ($count):\n";
    foreach ($diagnosis['unbatched_itemless_voided_deposit_reversals'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['batched_wrong_value_voided_deposit_reversals']);
    $output .= "Batched Wrong Value Deposit Reversals ($count):\n";
    foreach ($diagnosis['batched_wrong_value_voided_deposit_reversals'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['unbatched_wrong_value_voided_deposit_reversals']);
    $output .= "Unbatched Wrong Value Deposit Reversals ($count):\n";
    foreach ($diagnosis['unbatched_wrong_value_voided_deposit_reversals'] as $transaction) {
        $output .= "Transaction id: " . $transaction['fn_tran_id'] . "\t";
        $output .= "Reservation id: " . $transaction['rv_reservation_id'] . "\t";
        $output .= "Batch id: " . $transaction['fn_batch_id'] . "\n";
    }
    $output .= "\n";

    $count = count($diagnosis['affected_batches']);
    $output .= "Affected Batches ($count):\n";
    foreach ($diagnosis['affected_batches'] as $transaction) {
        $output .= $transaction . "\n";
    }
    $output .= "\n";
    $output .= "===========================================\n\n";
    @fwrite($fh, $output);
    @flock($fh, LOCK_UN);
    @fclose($fh);

    return $fileName;
}

function createTransactionExportFile($export)
{
    $principal_id = $GLOBALS['principal_id'];
    $fileName = "[$principal_id]" .'_' . date('Y-m-d H:i:s') . '_tran.csv';
    $logFileName =  __DIR__ . '/logs/' . $fileName;
    $fh = @fopen($logFileName, 'a');
    @fwrite($fh, arrayToCsv($export));
    @flock($fh, LOCK_UN);
    @fclose($fh);
    return $fileName;
}

function createTransactionItemExportFile($export)
{
    $principal_id = $GLOBALS['principal_id'];
    $fileName = "[$principal_id]" .'_' . date('Y-m-d H:i:s') . '_tran_item.csv';
    $logFileName =  __DIR__ . '/logs/' . $fileName;
    $fh = @fopen($logFileName, 'a');
    @fwrite($fh, arrayToCsv($export));
    @flock($fh, LOCK_UN);
    @fclose($fh);
    return $fileName;
}

function arrayToCsv($data)
{
    $csvText = "";

    foreach ( $data as $csvLine ) {
        $first = true;
        
        foreach ( $csvLine as $csvItem ) {
            if ( !$first ) {
                $csvText .= ",";
            } else {
                $first = false;
            }
            $csvText .= "\"" . str_replace("\"","\"\"",$csvItem)."\"";
        }
        $csvText .= "\n";
    }

    return $csvText;
}