<?php

require_once(__DIR__ . '/api.functions.php');

$request = file_get_contents('php://input');
$input = json_decode($request, true);

if (!is_array($input)) {
    respondWithError(400, 'Bad request structure');
    return;
}

if (!array_key_exists('request', $input)) {
    respondWithError(400, "Required parameter 'request' is missing");
    return;
}

switch ($input['request']) {
    case 'get_diagnosis':
        handleGetDiagnosis();
        break;
    case 'fix_issues':
        handleFixIssues();
        break;
    case 'download':
        handleDownload($input['file']);
        break;
    default:
        respondWithError(400, 'Unknown request type');
        break;
}