<?php

function getInvalidInvoiceTransactions()
{
    global $lDB;

    $transactions = $lDB->get("
        SELECT
            fn_tran.fn_tran_ix
        FROM fn_tran
        LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
        WHERE (
            (SELECT COUNT(*) FROM fn_tran_item WHERE fn_tran_id = fn_tran.fn_tran_ix) = 1
            OR
            fn_tran.fn_tran_ix NOT IN (SELECT DISTINCT fn_tran_id FROM fn_tran_item)
        )
        AND fn_tran.fn_tran_link_ind = 40
        AND (
            fn_tran.fn_tran_contra_id IS NULL
            OR fn_tran.ad_create_date < contra_tran.ad_create_date
        )
        AND fn_tran.ad_create_date >= '2019-04-08';
    ", 3);

    return $transactions;
}

function getInvalidPaymentTransactions()
{
    global $lDB;

    $transactions = $lDB->get("
        SELECT
            fn_tran.fn_tran_ix
        FROM
            fn_tran
        WHERE (
            (SELECT COUNT(*) FROM fn_tran_item WHERE fn_tran_id = fn_tran.fn_tran_ix) = 1
            OR
            fn_tran.fn_tran_ix NOT IN (SELECT DISTINCT fn_tran_id FROM fn_tran_item)
        )
        AND fn_tran.fn_tran_link_ind = 10
        AND fn_tran.ad_create_date >= '2019-04-08';
    ", 3);

    return $transactions;
}

function getInvalidDepositTransactions()
{
    global $lDB;

    $transactions = $lDB->get("
        SELECT
            fn_tran.fn_tran_ix
        FROM
            fn_tran
        WHERE (
            (SELECT COUNT(*) FROM fn_tran_item WHERE fn_tran_id = fn_tran.fn_tran_ix) = 1
            OR
            fn_tran.fn_tran_ix NOT IN (SELECT DISTINCT fn_tran_id FROM fn_tran_item)
        )
        AND fn_tran.fn_tran_link_ind = 20
        AND fn_tran.ad_create_date >= '2019-04-08';
    ", 3);

    return $transactions;
}

function getItemlessDepositReversalTransactions()
{
    global $lDB;

    $transactions = $lDB->get("
        SELECT
            fn_tran.fn_tran_ix
        FROM
            fn_tran
        LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
        INNER JOIN fn_tran AS deposit_tran ON deposit_tran.fn_tran_link_id = fn_tran.fn_tran_link_id
        WHERE fn_tran.fn_tran_ix NOT IN (SELECT DISTINCT fn_tran_id FROM fn_tran_item)
        AND fn_tran.fn_tran_link_ind = 30
        AND deposit_tran.fn_tran_link_ind = 20
        AND (
            fn_tran.fn_tran_contra_id IS NULL
            OR fn_tran.ad_create_date < contra_tran.ad_create_date
        )
        AND fn_tran.ad_create_date >= '2019-04-08';
    ", 3);

    return $transactions;
}

function getWrongValueDepositReversalTransactions()
{
    global $lDB;

    $transactions = $lDB->get("
        SELECT
            fn_tran.fn_tran_ix
        FROM
            fn_tran
        LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
        INNER JOIN fn_tran AS deposit_tran ON deposit_tran.fn_tran_link_id = fn_tran.fn_tran_link_id
        WHERE (SELECT COUNT(*) FROM fn_tran_item WHERE fn_tran_id = fn_tran.fn_tran_ix) = 1
        AND fn_tran.fn_tran_link_ind = 30
        AND deposit_tran.fn_tran_link_ind = 20
        AND (
            fn_tran.fn_tran_contra_id IS NULL
            OR fn_tran.ad_create_date < contra_tran.ad_create_date
        )
        AND fn_tran.ad_create_date >= '2019-04-08';
    ", 3);

    return $transactions;
}

function getMissingDepositReversalTransactions()
{
    global $lDB;

    $transactions = $lDB->get("
        SELECT
            DISTINCT fn_tran.fn_tran_ix
        FROM
            fn_tran
        LEFT JOIN fn_tran AS reversal_tran ON reversal_tran.fn_tran_link_id = fn_tran.fn_tran_link_id AND reversal_tran.fn_tran_link_ind = 30
        LEFT JOIN fn_tran AS invoice_tran ON invoice_tran.fn_folio_id = fn_tran.fn_folio_id AND invoice_tran.fn_tran_link_ind = 40
        WHERE reversal_tran.fn_tran_ix IS NULL
        AND fn_tran.fn_tran_link_ind = 20
        AND invoice_tran.ad_create_date > fn_tran.ad_create_date
        AND invoice_tran.fn_tran_contra_id IS NULL
        AND fn_tran.ad_create_date >= '2019-04-08';
    ", 3);

    return $transactions;
}

function getItemlessVoidedInvoiceTransactions()
{
    global $lDB;

    $transactions = $lDB->get("
        SELECT
            fn_tran.fn_tran_ix
        FROM
            fn_tran
        LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
        WHERE fn_tran.fn_tran_ix NOT IN (SELECT DISTINCT fn_tran_id FROM fn_tran_item)
        AND fn_tran.fn_tran_link_ind = 40
        AND (
            fn_tran.fn_tran_contra_id IS NOT NULL
            AND fn_tran.ad_create_date > contra_tran.ad_create_date
        )
        AND fn_tran.ad_create_date >= '2019-04-08';
    ", 3);

    return $transactions;
}

function getWrongValueVoidedInvoiceTransactions()
{
    global $lDB;

    $transactions = $lDB->get("
        SELECT
            fn_tran.fn_tran_ix
        FROM
            fn_tran
        LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
        WHERE (SELECT COUNT(*) FROM fn_tran_item WHERE fn_tran_id = fn_tran.fn_tran_ix) = 1
        AND fn_tran.fn_tran_link_ind = 40
        AND (
            fn_tran.fn_tran_contra_id IS NOT NULL
            AND fn_tran.ad_create_date > contra_tran.ad_create_date
        )
        AND fn_tran.ad_create_date >= '2019-04-08';
    ", 3);

    return $transactions;
}

function getItemlessVoidedDepositReversalTransactions()
{
    global $lDB;

    $transactions = $lDB->get("
        SELECT
            fn_tran.fn_tran_ix
        FROM
            fn_tran
        LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
        INNER JOIN fn_tran AS deposit_tran ON deposit_tran.fn_tran_link_id = fn_tran.fn_tran_link_id
        WHERE fn_tran.fn_tran_ix NOT IN (SELECT DISTINCT fn_tran_id FROM fn_tran_item)
        AND fn_tran.fn_tran_link_ind = 30
        AND deposit_tran.fn_tran_link_ind = 20
        AND (
            fn_tran.fn_tran_contra_id IS NOT NULL
            AND fn_tran.ad_create_date > contra_tran.ad_create_date
        )
        AND fn_tran.ad_create_date >= '2019-04-08';
    ", 3);

    return $transactions;
}

function getWrongValueVoidedDepositReversalTransactions()
{
    global $lDB;

    $transactions = $lDB->get("
        SELECT
            fn_tran.fn_tran_ix
        FROM
            fn_tran
        LEFT JOIN fn_tran AS contra_tran ON contra_tran.fn_tran_ix = fn_tran.fn_tran_contra_id
        INNER JOIN fn_tran AS deposit_tran ON deposit_tran.fn_tran_link_id = fn_tran.fn_tran_link_id
        WHERE (SELECT COUNT(*) FROM fn_tran_item WHERE fn_tran_id = fn_tran.fn_tran_ix) = 1
        AND fn_tran.fn_tran_link_ind = 30
        AND deposit_tran.fn_tran_link_ind = 20
        AND (
            fn_tran.fn_tran_contra_id IS NOT NULL
            AND fn_tran.ad_create_date > contra_tran.ad_create_date
        )
        AND fn_tran.ad_create_date >= '2019-04-08';
    ", 3);

    return $transactions;
}