<?php

function fixInvalidInvoiceTransaction($fn_tran_id)
{
    db_fn_tran_fix_invoice($fn_tran_id);
}

function fixInvalidPaymentTransaction($fn_tran_id)
{
    db_fn_tran_fix_payment_or_deposit($fn_tran_id);
}

function fixInvalidDepositTransaction($fn_tran_id)
{
    db_fn_tran_fix_payment_or_deposit($fn_tran_id);
}

function fixItemlessDepositReversalTransaction($fn_tran_id)
{
    db_fn_tran_fix_deposit_reversal($fn_tran_id);
}

function fixWrongValueDepositReversalTransaction($fn_tran_id)
{
    db_fn_tran_fix_deposit_reversal($fn_tran_id);
}

function fixMissingDepositReversalTransaction($fn_tran_id)
{
    global $lDB;

    $tranItemNoteExists = $lDB->get("SELECT fn_tran_item_note FROM fn_tran_item LIMIT 1", 4);
    if ($lDB->error) {
        // fn_tran_item_note field does not exist in the database yet (7.17 backport check)
        $tranItemNoteExists = false;
        $fn_tran_item_note_field = '';		
    } else {
        $tranItemNoteExists = true;
        $fn_tran_item_note_field = 'fn_tran_item.fn_tran_item_note,';
    }

    $depositInfo = $lDB->get("
        SELECT
            fn_tran_item.fn_ledger_id,
            fn_tran_item.fn_tran_item_amt,
            fn_tran_item.fn_tran_item_amt_source,
            fn_tran.fn_tran_link_id,
            $fn_tran_item_note_field
            fn_tran.fn_tran_exch_rate
        FROM
            fn_tran_item
            INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
        WHERE
            fn_tran_item.fn_tran_id = '$fn_tran_id'
            AND fn_tran_item_type_ind = '".DB_FN_TRAN_ITEM_TYPE_DEPOSIT."'
    ",1);
    $fn_tran_id = db_fn_tran_insert(DB_FN_TRAN_LINK_REVERSAL,$depositInfo['fn_tran_link_id'],$depositInfo['fn_tran_exch_rate'],true);

    $fn_tran_item_amt_source = $depositInfo['fn_tran_item_amt_source'] * -1;
    $fn_tran_item_amt = $depositInfo['fn_tran_item_amt'] * -1;
    $fn_tran_item_note = '';
    if ($tranItemNoteExists) {
        $fn_tran_item_note = $depositInfo['fn_tran_item_note'];
    }
    db_fn_tran_item_insert($fn_tran_id,DB_FN_TRAN_ITEM_TYPE_DEPOSIT,$depositInfo['fn_ledger_id'],"","",$fn_tran_item_amt,$fn_tran_item_amt,$fn_tran_item_amt_source,$fn_tran_item_amt_source,false,false,false,$fn_tran_item_note);
    db_fn_tran_update_total($fn_tran_id);	
    return $fn_tran_id;
}

function fixItemlessVoidedInvoiceTransaction($fn_tran_id)
{
    db_fn_tran_fix_void($fn_tran_id);
}

function fixWrongValueVoidedInvoiceTransaction($fn_tran_id)
{
    db_fn_tran_fix_void($fn_tran_id);
}

function fixItemlessVoidedDepositReversalTransaction($fn_tran_id)
{
    db_fn_tran_fix_void($fn_tran_id);
}


function fixWrongValueVoidedDepositReversalTransaction($fn_tran_id)
{
    db_fn_tran_fix_void($fn_tran_id);
}

/*
 * Add missing fn_tran_item record for payment.
 */
function db_fn_tran_fix_payment_or_deposit($fn_tran_id)
{
    global $lDB;

    $tranData = $lDB->get("
        SELECT
            fn_tran_link_id,
            fn_tran_link_ind,
            fn_tran_exch_rate
        FROM fn_tran
        WHERE fn_tran_ix = '$fn_tran_id'
    ", 1);

    $paymentInfo = db_fn_tran_payment_lookup($tranData['fn_tran_link_id']);

    $isPayment = $tranData['fn_tran_link_ind'] == DB_FN_TRAN_LINK_PAYMENT;

    if ($isPayment) {
        $fn_tran_item_type_ind = DB_FN_TRAN_ITEM_TYPE_BANK;
        $fn_ledger_id = $paymentInfo['fn_ledger_id_account'];
    } else {
        $fn_tran_item_type_ind = DB_FN_TRAN_ITEM_TYPE_DEPOSIT;
        $fn_ledger_id = $paymentInfo['fn_ledger_id_deposit'];
    }

    $fn_tran_item_note = $paymentInfo['rv_pmnt_note'] . ';' . $paymentInfo['rv_pmnt_ref'];
    $fn_tran_item_amt_source = $paymentInfo['rv_payment_item_amt'];

    $fn_tran_exch_rate = $tranData['fn_tran_exch_rate'];
    if($fn_tran_exch_rate == "none") {
        $fn_tran_item_amt = $paymentInfo['rv_pay_item_amt_rec'];
        $fn_tran_exch_rate = 0;
    } else {
        if(trim($paymentInfo['fn_invoice_ix']) != "" && $paymentInfo['fn_invoice_ix'] != "0") {
            //$fn_tran_exch_rate = $fn_tran_exch_rate * $paymentInfo['fn_inv_exch_rate'];
        }
        $fn_tran_item_amt = $fn_tran_item_amt_source * $fn_tran_exch_rate;
    }
    
    if (!$isPayment) {
        // It's a deposit
        $fn_tran_item_amt_source *= -1;
        $fn_tran_item_amt *= -1;
    }

    db_fn_tran_item_insert($fn_tran_id, $fn_tran_item_type_ind, $fn_ledger_id, '', '', $fn_tran_item_amt, $fn_tran_item_amt, $fn_tran_item_amt_source, $fn_tran_item_amt_source, false, false, false, $fn_tran_item_note);
    db_fn_tran_update_total($fn_tran_id);
}

/*
 * Add missing fn_tran_item record for deposit reversal.
 */
function db_fn_tran_fix_deposit_reversal($fn_tran_id)
{
    global $lDB;

    $fn_tran_link_id = $lDB->get("
        SELECT
            fn_tran_link_id
        FROM fn_tran
        WHERE fn_tran.fn_tran_ix = '$fn_tran_id'
    ", 4);


    $depositInfo = $lDB->get("
        SELECT
            fn_tran_item.fn_ledger_id,
            fn_tran_item.fn_tran_item_amt,
            fn_tran_item.fn_tran_item_amt_source,
            fn_tran.fn_tran_exch_rate
        FROM
            fn_tran_item
        INNER JOIN fn_tran ON fn_tran.fn_tran_ix = fn_tran_item.fn_tran_id
        WHERE
            fn_tran.fn_tran_link_ind = '".DB_FN_TRAN_LINK_DEPOSIT."'
            AND fn_tran.fn_tran_link_id = '$fn_tran_link_id'
    ", 1);

    $fn_tran_item_amt_source = $depositInfo['fn_tran_item_amt_source'] * -1;
    $fn_tran_item_amt = $depositInfo['fn_tran_item_amt'] * -1;

    $fn_tran_item_id = $lDB->get("
        SELECT fn_tran_item_ix
        FROM fn_tran_item
        WHERE fn_tran_id = '$fn_tran_id'
    ", 4);

    if (!$fn_tran_item_id) {
        db_fn_tran_item_insert($fn_tran_id, DB_FN_TRAN_ITEM_TYPE_DEPOSIT, $depositInfo['fn_ledger_id'], "", "", $fn_tran_item_amt, $fn_tran_item_amt, $fn_tran_item_amt_source, $fn_tran_item_amt_source);
    } else {
        $lDB->put("
            UPDATE fn_tran_item
            SET
                fn_tran_item_amt_source = $fn_tran_item_amt_source,
                fn_tran_item_amt = $fn_tran_item_amt
            WHERE fn_tran_item_ix = '$fn_tran_item_id'
        ");
    }
    db_fn_tran_update_total($fn_tran_id);	
}

/*
 * Add missing fn_tran_item record for invoice. Returns true if the items were
 * properly inserted otherwise false.
 */
function db_fn_tran_fix_invoice($fn_tran_id)
{
    global $lDB;

    $fn_invoice_id = $lDB->get("
        SELECT fn_tran_link_id FROM fn_tran
        WHERE
            fn_tran_ix = '$fn_tran_id'
    ", 4);

    $invoiceInfo = $lDB->get("
        SELECT
            pr_business.pr_business_id,
            pr_business.pr_bus_post_inv_yn,
            pr_business.pr_bus_post_pmt_yn,
            pr_business.pr_bus_post_dep_yn,
            pr_business.pr_bus_post_clear_dtrs_yn,
            pr_business.pr_bus_ignore_past_pmt_yn,
            pr_business.pr_bus_post_tax_cost_ctr_yn
        FROM
            fn_invoice
            INNER JOIN fn_folio ON fn_folio.fn_folio_ix = fn_invoice.fn_folio_id
            INNER JOIN pr_business ON pr_business.pr_business_id = fn_folio.pr_business_id
        WHERE
            fn_invoice.fn_invoice_ix = '$fn_invoice_id'
    ", 1);	
    $fn_folio_id = $lDB->get("SELECT fn_folio_id FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'" , 4);
    $fn_inv_exch_rate = $lDB->get("SELECT fn_inv_exch_rate FROM fn_invoice WHERE fn_invoice_ix = '$fn_invoice_id'" , 4);
    if($invoiceInfo && $invoiceInfo['pr_bus_post_inv_yn'] == "1") {
        $taxPrecision = db_fn_option_data_by_name($invoiceInfo['pr_business_id'], "tax_precision");
        if($taxPrecision === false || !is_numeric($taxPrecision)) {
            $taxPrecision = 6;
        }

        $accommList = $lDB->get("
            SELECT
                rv_res_item_comp.rv_res_item_comp_ix,
                rv_res_item_comp.rv_item_comp_amt_payable,
                rv_res_item_comp.rv_item_comp_amt_tax,
                pr_business.fn_cost_centre_1_id as fn_cost_centre_1_id,
                ac_accomm_type.fn_cost_centre_id as fn_cost_centre_2_id_accomm,
                rt_component_inv.fn_cost_centre_2_id AS fn_cost_centre_2_id_component,
                rt_component_inv.fn_ledger_id,
                rt_component.rt_component_desc
            FROM
                rv_res_item_comp
                INNER JOIN rt_component ON rt_component.rt_component_ix = rv_res_item_comp.rt_component_id
                INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
                INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
                INNER JOIN pr_business ON pr_business.pr_business_id = rv_reservation_item.pr_business_id
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
                LEFT JOIN rt_component_inv ON rt_component_inv.rt_component_id = rv_res_item_comp.rt_component_id AND rt_component_inv.pr_business_id = fn_folio.pr_business_id
            WHERE
                rv_reservation_item.fn_folio_id = '$fn_folio_id'
        ", 2);

        $extraList = $lDB->get("
            SELECT DISTINCT
                rv_extra.rv_extra_amt_payable,
                rv_extra.rv_extra_tax_ind,
                rv_extra.rv_extra_ix AS extra_id,
                (
                    SELECT SUM(rv_extra_tax_amt)
                    FROM rv_extra_tax
                    WHERE rv_extra_tax.rv_extra_id = extra_id
                ) as rv_extra_amt_tax,
                pr_business.fn_cost_centre_1_id as property_cost_centre_1_id,
                pr_billing.fn_cost_centre_1_default_id,
                ac_extra_inv.fn_cost_centre_1_id AS extra_cost_centre_1_id,
                ac_extra_cat_inv.fn_cost_centre_1_id AS extra_cat_cost_centre_1_id,
                ac_extra_inv.fn_cost_centre_2_id as extra_cost_centre_2_id,
                ac_extra_cat_inv.fn_cost_centre_2_id AS extra_cat_cost_centre_2_id,
                rf_tax_inv.rf_tax_inv_ix,
                rf_tax_inv.fn_ledger_id as tax_ledger_id,
                ac_extra_inv.fn_ledger_id,
                ac_extra_cat_inv.fn_ledger_id AS extra_cat_ledger_id,
                ac_extra.ac_ext_desc
            FROM
                rv_extra
                LEFT JOIN rv_extra_tax ON rv_extra_tax.rv_extra_id = rv_extra.rv_extra_ix
                INNER JOIN ac_extra ON ac_extra.ac_extra_ix = rv_extra.ac_extra_id
                INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
                LEFT JOIN ac_extra_inv ON ac_extra_inv.ac_extra_id = rv_extra.ac_extra_id AND ac_extra_inv.pr_business_id = fn_folio.pr_business_id
                LEFT JOIN ac_extra_cat_inv ON ac_extra_cat_inv.ac_extra_category_id = ac_extra.ac_extra_category_id AND ac_extra_cat_inv.pr_business_id = fn_folio.pr_business_id
                LEFT JOIN rf_tax_inv ON 
                    rf_tax_inv.rf_tax_id = rv_extra.rf_tax_id
                    AND rf_tax_inv.rf_tax_ind = rv_extra.rv_extra_tax_ind
                    AND rf_tax_inv.pr_business_id = fn_folio.pr_business_id
                LEFT JOIN pr_business ON pr_business.pr_business_id = rv_extra.pr_business_id
                LEFT JOIN pr_business AS pr_billing ON pr_billing.pr_business_id = fn_folio.pr_business_id
            WHERE
                rv_extra.fn_folio_id = '$fn_folio_id'
        ", 2);

        $accommTotal = array();
        $taxTotal = array();
        $extraTotal = array();	
        foreach($accommList as $item) {
            $item['fn_cost_centre_2_id'] = $item['fn_cost_centre_2_id_accomm'];
            if(!empty($item['fn_cost_centre_2_id_component'])) {
                $item['fn_cost_centre_2_id'] = $item['fn_cost_centre_2_id_component'];
            }

            // Total
            $cc1 = trim($item['fn_cost_centre_1_id']);
            if($cc1 == "") { $cc1 = "AAAAA"; }
            $cc2 = trim($item['fn_cost_centre_2_id']);
            if($cc2 == "") { $cc2 = "BBBBB"; }
            $gl = trim($item['fn_ledger_id']);
            if($gl == "") { $gl = "CCCCC"; }
            $totalKey = $cc1.$cc2.$gl;
            
            if(!array_key_exists($totalKey,$accommTotal)) {
                $accommTotal[$totalKey] = array(
                    'fn_tran_item_amt'=>($item['rv_item_comp_amt_payable'] - $item['rv_item_comp_amt_tax']) * $fn_inv_exch_rate * -1,
                    'fn_tran_item_amt_incl'=>$item['rv_item_comp_amt_payable'] * $fn_inv_exch_rate * -1,
                    'fn_tran_item_amt_source'=>($item['rv_item_comp_amt_payable'] - $item['rv_item_comp_amt_tax']) * -1,
                    'fn_tran_item_amt_source_incl'=>$item['rv_item_comp_amt_payable'] * -1,
                    'fn_ledger_id'=>$item['fn_ledger_id'],
                    'fn_tran_cost_ctr1_id'=>$item['fn_cost_centre_1_id'],
                    'fn_tran_cost_ctr2_id'=>$item['fn_cost_centre_2_id'],
                    'rt_component_desc' => $item['rt_component_desc']
                );
            } else {
                $accommTotal[$totalKey]['fn_tran_item_amt'] += ($item['rv_item_comp_amt_payable'] - $item['rv_item_comp_amt_tax']) * $fn_inv_exch_rate * -1;
                $accommTotal[$totalKey]['fn_tran_item_amt_incl'] += $item['rv_item_comp_amt_payable'] * $fn_inv_exch_rate * -1;
                $accommTotal[$totalKey]['fn_tran_item_amt_source'] += ($item['rv_item_comp_amt_payable'] - $item['rv_item_comp_amt_tax']) * -1;
                $accommTotal[$totalKey]['fn_tran_item_amt_source_incl'] += $item['rv_item_comp_amt_payable'] * -1;
            }

            // Tax
            $accommTaxList = $lDB->get("
                SELECT
                    rv_res_item_comp_tax.rv_res_item_comp_tax_amt,
                    rf_tax_inv.rf_tax_inv_ix,
                    rf_tax_inv.fn_ledger_id
                FROM
                    rv_res_item_comp_tax
                    INNER JOIN rv_res_item_comp ON rv_res_item_comp.rv_res_item_comp_ix = rv_res_item_comp_tax.rv_res_item_comp_id
                    INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_comp.rv_reservation_item_id
                    INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_reservation_item.fn_folio_id
                    LEFT JOIN rf_tax_inv ON 
                        rf_tax_inv.rf_tax_id = rv_res_item_comp_tax.rf_tax_rate_id
                        AND rf_tax_inv.rf_tax_ind = 10
                        AND rf_tax_inv.pr_business_id = fn_folio.pr_business_id
                WHERE
                    rv_res_item_comp_tax.rv_res_item_comp_id = '$item[rv_res_item_comp_ix]'
            ",2);

            $accommTotal[$totalKey]['accommTaxList'] = $accommTaxList;

            foreach($accommTaxList as $taxItem) {
                if($invoiceInfo['pr_bus_post_tax_cost_ctr_yn'] == "1") {
                    $taxKey = $cc1.$cc2.$taxItem['fn_ledger_id'];
                    $taxCC1 = $item['fn_cost_centre_1_id'];
                    $taxCC2 = $item['fn_cost_centre_2_id'];
                } else {
                    $taxKey = $taxItem['fn_ledger_id'];
                    $taxCC1 = "";
                    $taxCC2 = "";
                }
                $taxItem['rv_res_item_comp_tax_amt'] = round($taxItem['rv_res_item_comp_tax_amt'],$taxPrecision);
                if(!array_key_exists($taxKey,$taxTotal)) {
                    $taxTotal[$taxKey] = array(
                        'fn_tran_item_amt'=>$taxItem['rv_res_item_comp_tax_amt'] * $fn_inv_exch_rate * -1,
                        'fn_tran_item_amt_source'=>$taxItem['rv_res_item_comp_tax_amt'] * -1,
                        'fn_ledger_id'=>$taxItem['fn_ledger_id'],
                        'fn_tran_cost_ctr1_id'=>$taxCC1,
                        'fn_tran_cost_ctr2_id'=>$taxCC2,
                        'rf_tax_inv_id'=>$taxItem['rf_tax_inv_ix']
                    );
                } else {
                    $taxTotal[$taxKey]['fn_tran_item_amt'] += $taxItem['rv_res_item_comp_tax_amt'] * $fn_inv_exch_rate * -1;
                    $taxTotal[$taxKey]['fn_tran_item_amt_source'] += $taxItem['rv_res_item_comp_tax_amt'] * -1;
                }
            }
        }

        foreach($extraList as $item) {
            // Extra
            if($item['extra_cost_centre_1_id'] != "0" && trim($item['extra_cost_centre_1_id']) != "") {
                $cc1 = $item['extra_cost_centre_1_id'];
            } else {
                if($item['extra_cat_cost_centre_1_id'] != "0" && trim($item['extra_cat_cost_centre_1_id']) != "") {
                    $cc1 = $item['extra_cat_cost_centre_1_id'];
                } else {
                    if($item['property_cost_centre_1_id'] != "0" && trim($item['property_cost_centre_1_id']) != "") {
                        $cc1 = $item['property_cost_centre_1_id'];
                    } else {
                        $cc1 = $item['fn_cost_centre_1_default_id'];
                    }
                }
            }
            $item['fn_cost_centre_1_id'] = $cc1;
            if(trim($item['extra_cost_centre_2_id']) == "") {
                $item['fn_cost_centre_2_id'] = $item['extra_cat_cost_centre_2_id'];
            } else {
                $item['fn_cost_centre_2_id'] = $item['extra_cost_centre_2_id'];
            }
            $cc1 = trim($cc1);
            if($cc1 == "") { $cc1 = "AAAAA"; }
            $cc2 = trim($item['fn_cost_centre_2_id']);
            if($cc2 == "") { $cc2 = "BBBBB"; }

            if(trim($item['fn_ledger_id']) == "") {
                $item['fn_ledger_id'] = $item['extra_cat_ledger_id'];
            }
            $gl = trim($item['fn_ledger_id']);
            if($gl == "") { $gl = "CCCCC"; }

            $tax = trim($item['rf_tax_inv_ix']);
            if($tax == "") { $tax = "DDDDD"; }

            $totalKey = $cc1.$cc2.$gl.$tax;

            if(!array_key_exists($totalKey,$extraTotal)) {
                $extraTotal[$totalKey] = array(
                    'fn_tran_item_amt'=>($item['rv_extra_amt_payable'] - $item['rv_extra_amt_tax']) * $fn_inv_exch_rate * -1,
                    'fn_tran_item_amt_incl'=>$item['rv_extra_amt_payable'] * $fn_inv_exch_rate * -1,
                    'fn_tran_item_amt_source'=>($item['rv_extra_amt_payable'] - $item['rv_extra_amt_tax']) * -1,
                    'fn_tran_item_amt_source_incl'=>$item['rv_extra_amt_payable'] * -1,
                    'fn_ledger_id'=>$item['fn_ledger_id'],
                    'fn_tran_cost_ctr1_id'=>$item['fn_cost_centre_1_id'],
                    'fn_tran_cost_ctr2_id'=>$item['fn_cost_centre_2_id'],
                    'rf_tax_inv_id'=>$item['rf_tax_inv_ix'],
                    'ac_ext_desc' => $item['ac_ext_desc']
                );
            } else {
                $extraTotal[$totalKey]['fn_tran_item_amt'] += ($item['rv_extra_amt_payable'] - $item['rv_extra_amt_tax']) * $fn_inv_exch_rate * -1;
                $extraTotal[$totalKey]['fn_tran_item_amt_incl'] += $item['rv_extra_amt_payable'] * $fn_inv_exch_rate * -1;
                $extraTotal[$totalKey]['fn_tran_item_amt_source'] += ($item['rv_extra_amt_payable'] - $item['rv_extra_amt_tax']) * -1;
                $extraTotal[$totalKey]['fn_tran_item_amt_source_incl'] += ($item['rv_extra_amt_payable']) * -1;
            }

            // Tax
            $taxRates = $lDB->get("
                SELECT DISTINCT
                    rv_extra_tax.rv_extra_tax_ix,
                    rv_extra_tax.rf_tax_rate_id,
                    rv_extra_tax.rv_extra_tax_perc,
                    rv_extra_tax.rv_extra_tax_amt,
                    rf_tax_rate.rf_tax_rate_desc,
                    rf_tax_inv.fn_ledger_id AS tax_ledger_id
                FROM
                    rv_extra
                    INNER JOIN fn_folio ON fn_folio.fn_folio_ix = rv_extra.fn_folio_id
                    LEFT JOIN rv_extra_tax on rv_extra_tax.rv_extra_id = rv_extra.rv_extra_ix
                    LEFT JOIN rf_tax_rate on rf_tax_rate.rf_tax_rate_ix = rv_extra_tax.rf_tax_rate_id
                    LEFT JOIN rf_tax_inv ON rf_tax_inv.rf_tax_id = rv_extra_tax.rf_tax_rate_id
                        AND rf_tax_inv.pr_business_id = fn_folio.pr_business_id
                WHERE
                    rv_extra.rv_extra_ix = '".$item['extra_id']."'
            ",2);

            foreach ($taxRates as $taxRate) {
                if($invoiceInfo['pr_bus_post_tax_cost_ctr_yn'] == "1") {
                    $taxKey = $cc1.$cc2.$taxRate['tax_ledger_id'];
                    $taxCC1 = $item['fn_cost_centre_1_id'];
                    $taxCC2 = $item['fn_cost_centre_2_id'];
                } else {
                    $taxKey = $taxRate['tax_ledger_id'];
                    $taxCC1 = "";
                    $taxCC2 = "";
                }
                $tax_amt = $taxRate['rv_extra_tax_amt'];

                if(!array_key_exists($taxKey,$taxTotal)) {
                    $taxTotal[$taxKey] = array(
                        'fn_tran_item_amt'=>$tax_amt * $fn_inv_exch_rate * -1,
                        'fn_tran_item_amt_source'=>$tax_amt * -1,
                        'fn_ledger_id'=>$taxRate['tax_ledger_id'],
                        'fn_tran_cost_ctr1_id'=>$taxCC1,
                        'fn_tran_cost_ctr2_id'=>$taxCC2,
                        'rf_tax_inv_id'=>$item['rf_tax_inv_ix']				
                    );
                } else {
                    $taxTotal[$taxKey]['fn_tran_item_amt'] += $tax_amt * $fn_inv_exch_rate * -1;
                    $taxTotal[$taxKey]['fn_tran_item_amt_source'] += $tax_amt * -1;
                }
            }
        }

        // Insert tax items
        foreach($taxTotal as $item) {
            if($item['fn_tran_item_amt'] != 0) {
                db_fn_tran_item_insert($fn_tran_id,DB_FN_TRAN_ITEM_TYPE_TAX,$item['fn_ledger_id'],"",$item['rf_tax_inv_id'],$item['fn_tran_item_amt'],$item['fn_tran_item_amt'],$item['fn_tran_item_amt_source'],$item['fn_tran_item_amt_source'],$item['fn_tran_cost_ctr1_id'],$item['fn_tran_cost_ctr2_id']);
            }
        }

        // Insert accomm items
        foreach($accommTotal as $item) {
            // Only populate tax if we're dealing with a single tax rate (not a tax group).
            if (count($accommTaxList) > 1){
                $tax_rate_inv_id = "";
            } else {
                $tax_rate_inv_id = $item['accommTaxList'][0]['rf_tax_inv_ix'];
            }
            if($item['fn_tran_item_amt'] != 0) {
                db_fn_tran_item_insert($fn_tran_id,DB_FN_TRAN_ITEM_TYPE_ACCOMM,$item['fn_ledger_id'],"",$tax_rate_inv_id,$item['fn_tran_item_amt'],$item['fn_tran_item_amt_incl'],$item['fn_tran_item_amt_source'],$item['fn_tran_item_amt_source_incl'],$item['fn_tran_cost_ctr1_id'],$item['fn_tran_cost_ctr2_id'], false, $item['rt_component_desc']);
            }
        }

        // Insert extra items
        foreach($extraTotal as $item) {
            if($item['fn_tran_item_amt'] != 0) {
                db_fn_tran_item_insert($fn_tran_id,DB_FN_TRAN_ITEM_TYPE_EXTRA,$item['fn_ledger_id'],"",$item['rf_tax_inv_id'],$item['fn_tran_item_amt'],$item['fn_tran_item_amt_incl'],$item['fn_tran_item_amt_source'],$item['fn_tran_item_amt_source_incl'],$item['fn_tran_cost_ctr1_id'],$item['fn_tran_cost_ctr2_id'], false, $item['ac_ext_desc']);
            }
        }

        db_fn_tran_update_total($fn_tran_id);
        return true;
    } else {
        // Insert a blank item row to not have a childless transaction record.
        db_fn_tran_item_insert($fn_tran_id, DB_FN_TRAN_ITEM_TYPE_EXTRA, '', '', '', 0, 0, 0, 0);
        return false;
    }
}

function db_fn_tran_fix_void($fn_tran_id)
{
    global $lDB;

    $tranData = $lDB->get("
        SELECT
            fn_tran_contra_id,
            fn_tran_amt_source
        FROM fn_tran
        WHERE fn_tran_ix = '$fn_tran_id'
    ", 1);
    $tranItemCount = $lDB->get("
        SELECT COUNT(*)
        FROM fn_tran_item
        WHERE fn_tran_id = '$fn_tran_id'
    ", 4);

    $fn_tran_contra_id = $tranData['fn_tran_contra_id'];

    // Remove any existing tran_items
    $lDB->put("DELETE FROM fn_tran_item WHERE fn_tran_id = '$fn_tran_id'");

    $tranItemNoteExists = $lDB->get("SELECT fn_tran_item_note FROM fn_tran_item LIMIT 1", 4);
    if ($lDB->error) {
        // fn_tran_item_note field does not exist in the database yet (7.17 backport check)
        $tranItemNoteExists = false;
        $fn_tran_item_note_field = '';		
    } else {
        $tranItemNoteExists = true;
        $fn_tran_item_note_field = 'fn_tran_item.fn_tran_item_note,';
    }

    $list = $lDB->get("
        SELECT
            fn_tran_item.fn_tran_item_type_ind,
            fn_tran_item.fn_ledger_id,
            fn_tran_item.fn_debtor_id,
            fn_tran_item.fn_tran_item_amt,
            fn_tran_item.fn_tran_item_amt_incl,
            fn_tran_item.fn_tran_item_amt_source,
            fn_tran_item.fn_tran_item_amt_source_incl,
            fn_tran_item.fn_tran_cost_ctr1_id,
            fn_tran_item.fn_tran_cost_ctr2_id,
            $fn_tran_item_note_field
            fn_tran_item.rf_tax_inv_id
        FROM
            fn_tran_item
        WHERE
            fn_tran_item.fn_tran_id = '$fn_tran_contra_id'
    ",2);

    foreach($list as $item) {
        $item['fn_tran_item_amt'] *= -1;
        $item['fn_tran_item_amt_source'] *= -1;
        $item['fn_tran_item_amt_incl'] *= -1;
        $item['fn_tran_item_amt_source_incl'] *= -1;
        $fn_tran_item_note = '';

        if ($tranItemNoteExists) {
            $fn_tran_item_note = $item['fn_tran_item_note'];
        }

        db_fn_tran_item_insert($fn_tran_id, $item['fn_tran_item_type_ind'], $item['fn_ledger_id'], $item['fn_debtor_id'], $item['rf_tax_inv_id'], $item['fn_tran_item_amt'], $item['fn_tran_item_amt_incl'], $item['fn_tran_item_amt_source'], $item['fn_tran_item_amt_source_incl'], $item['fn_tran_cost_ctr1_id'], $item['fn_tran_cost_ctr2_id'], false, $fn_tran_item_note);
    }

    db_fn_tran_update_total($fn_tran_id);
}